/*
 * Copyright (C) 2001 Advanced Software Engineering Limited.
 *
 * This file is part of the ChartDirector software. Usage of this file is
 * subjected to the ChartDirector license agreement. See the LICENSE.TXT
 * file that comes with the ChartDirector software release, or visit
 * Advanced Software Engineering's web site at www.advsofteng.com or 
 * email to support@advsofteng.com for information.
 *
 */
 
#ifndef AXIS_HDR
#define AXIS_HDR

#include "drawobj.h"

class BaseAxis
{
public :
	virtual TextBox *setLabelStyle(const char *font = 0, double fontSize = 8, 
		int fontColor = TextColor, double fontAngle = 0) = 0;
	virtual void setLabelGap(int d) = 0;
	
	virtual TextBox *setTitle(const char *text, const char *font = "arialbd.ttf", 
		double fontSize = 8, int fontColor = TextColor) = 0;
	virtual void setTitlePos(Alignment alignment, int titleGap = 6) = 0;
	
	virtual void setColors(int axisColor, int labelColor = TextColor, int titleColor = -1, 
		int tickColor = -1) = 0;

	virtual void setTickLength(int majorTickLen) = 0;
	virtual void setTickLength(int majorTickLen, int minorTickLen) = 0;

	virtual int getCoor(double v) const = 0;
	virtual int getLength() const = 0;
};

class XAxis : virtual public BaseAxis
{
public :
	virtual TextBox *setLabels(int noOfLabels, const char* const* text) = 0;
	virtual void setIndent(bool indent) = 0;
};


class Mark : virtual public TextStyle
{
public :
	virtual void setValue(double value) = 0;
	virtual void setMarkColor(int lineColor, int textColor = -1, int tickColor = -1) = 0;
	virtual void setLineWidth(int w) = 0;
};


class YAxis : virtual public BaseAxis
{
public :
	virtual Mark *addMark(double value, int lineColor, const char *text = 0,
		const char *font = 0, double fontSize = 8) = 0;
	virtual void addZone(double startValue, double endValue, int color) = 0;

	virtual void setLinearScale(double lowerLimit, double upperLimit, double tickInc = 0) = 0;
	virtual void setLogScale(double lowerLimit, double upperLimit, double tickInc = 0) = 0;
	virtual void setLogScale(bool logScale = true) = 0;
	virtual void setAutoScale(double topExtension = 0, double bottomExtension = 0) = 0;
	virtual void setTickDensity(int tickDensity) = 0;
	virtual void setTopMargin(int topMargin) = 0;

	virtual void setLabelFormat(const char *formatString) = 0;
};

#endif
