
#ifndef __DIR_H
#define __DIR_H

#ifndef __DEFS_H__
#include <defs.h>
#endif


#define WILDCARDS 0x01
#define EXTENSION 0x02
#define FILENAME  0x04
#define DIRECTORY 0x08
#define DRIVE     0x10

#define MAXDRIVE  3

#define _A_NORMAL   0x00        /* Normal file, no attributes */
#define _A_RDONLY   0x01        /* Read only attribute */
#define _A_HIDDEN   0x02        /* Hidden file */
#define _A_SYSTEM   0x04        /* System file */
#define _A_VOLID    0x08        /* Volume label */
#define _A_SUBDIR   0x10        /* Directory */
#define _A_ARCH     0x20        /* Archive */

#ifndef _FFBLK_DEF
#define _FFBLK_DEF
struct  ffblk   {
    unsigned char   ff_reserved[21];
    unsigned char   ff_attrib;            /* attribute byte for matched file */
    unsigned short  ff_ftime;           /* time of last write to file */
    unsigned short  ff_fdate;           /* date of last write to file */
    unsigned short  ff_size[2];           /* size of file */
    char            ff_name[13];         /* asciiz name of matched file */
    char	    ff_uu[256];
};
#endif

#define MAXPATH   260
#define MAXDIR    256
#define MAXFILE   256
#define MAXEXT    256

#ifdef __cplusplus
extern "C" {
#endif

int         RTL_NORM    chdir( const char  *__path );
int         RTL_NORM    findfirst( const char  *__path,
                                    struct ffblk  *__ffblk,
                                    int __attrib );
int         RTL_NORM    findnext( struct ffblk  *__ffblk );
void        RTL_NORM    fnmerge( char  *__path,
                                    const char  *__drive,
                                    const char  *__dir,
                                    const char  *__name,
                                    const char  *__ext );
int         RTL_NORM    fnsplit(const char  *__path,
                                    char  *__drive,
                                    char  *__dir,
                                    char  *__name,
                                    char  *__ext );
int         RTL_NORM    getcurdir( int __drive, char  *__directory );
char  *     RTL_NORM    getcwd( char  *__buf, int __buflen );
int         RTL_NORM    getdisk( void );
int         RTL_NORM    mkdir( const char  *__path );
char  *     RTL_NORM    mktemp( char  *__template );
int         RTL_NORM    rmdir( const char  *__path );
char  *     RTL_NORM    searchpath( const char  *__file );
int         RTL_NORM    setdisk( int __drive );

#ifdef __cplusplus
}
#endif


#endif  /* __DIR_H */