	;MASM MODE
	.386
	.model use32 small


include  prints.ase 
include  input.ase 
include  mtrap.ase 

DUMPLEN = 80h
	PUBLIC	dump
	PUBLIC  index
	.data
index	dd	0		; Default for next dump

	.code
;
; Dump one line
;
dumpline	PROC	
	push	edx
	push	ebx        		; EBX MUST be on second of stack
	push	ecx			; ECX MUST be on top of stack
	sub	eax,eax
	mov	al,bl  		; AL = lower byte of address
	and	al,15		; AL = lower nibble
	mov	ecx,16		; Total bytes to dump
	jz	short doline	; Go do hexdump if start of line = 0
	neg	al		; Else calculate number of bytes in line
	add	al,16		;
	movzx	Ecx,ax		; To ECX

doline:
	sub	[esp],ecx	; Decrement count which is on stack
	add	[esp+4],ecx	; Increment address which is on stack
	mov	al,16		; Get count of amount to space over
	sub	al,cl		;
	jz	short puthex	; Don't space over any, just put out hex

	push	ecx		; Else ecx = spacecount * 3
	mov	ecx,eax		;
	add	ecx,ecx		;
	add	ecx,eax		;
blanklp1:
	call	PrintSpace      ; Dump spaces
	loop	blanklp1	;
	pop	ecx

puthex:                         ; Save count and address for ASCII dump
	push	ecx		;
	push	esi		;
hexlp:
	call	PrintSpace	; Print a space
	mov	al,[esi]	; Get the byte
	inc	esi		; Increment the address pointer
	call	PrintByte	; Print byte in hex
	loop	hexlp		; Loop till done
	pop	esi		;
	pop	ecx		;

	call	PrintSpace	; Print two spaces to seperate ASCII dump
	call	PrintSpace	;

	sub	eax,eax		; Calculate amoun to space over
	mov	al,16		;
	sub	al,cl		;
	jz	short putascii	; None to space over, put ascii
	push	ecx		; ECX = space value
	mov	ecx,eax
blanklp2:
	call	PrintSpace	; Space over
	loop	blanklp2	;
	pop	ecx		;

putascii:
	mov	dl,[esi]	; Get char
	inc	esi		; Increment buffer
	call	PureChar
	loop	putascii
	pop	ecx		; Get count from stack
	pop	ebx		; Get address from stack
	pop	edx
	ret
dumpline	ENDP	
;
; Main DUMP routine
;
dump	PROC	
	mov	ecx,DUMPLEN	; Default amount to dump
	call	WadeSpace	; Wade to end of spaces
	jz	short atIndex	;
	call	ReadAddress	; Else read start address
	jc	dudone		; Quit on error
	call	WadeSpace	; Wade through spaces
	jz	short dodump	;
	call	ReadNumber	; Else read end offset
	jc	short dudone	;
	sub	eax,ebx		; Calculate length of dump
	mov	ecx,eax		;
	jmp	short dodump	; Go do dump
atIndex:
	mov	ebx,[index]	; Assume we want to dump from last index
dodump:
	
dumplp:
	call	ScanKey
	jnz	dusetadr
	push	ebx		;
	call	crlf
	pop	ebx		;
	mov	eax,ebx		;
	mov	esi,ebx
	and	eax,0fffffff0h  ; Address low nibble = 0
	call	PrintDword	; Print address
	call	dumpline	; Dump a line
	or	ecx,ecx		; Continue while count > 0
	jg	dumplp
dusetadr:		;
	mov	[index],ebx	; Save new index value
	clc			; No errors
dudone:
	ret
dump	ENDP	
END