
#include "winconst.h"
#include "lsctrl.h"

#define BACKUP_FILES 1
#define BACKUP_PROJECTS 2

#define DF_PROJECT 1
#define DF_ERROR 2
#define DF_WATCH 4
#define HF_PROJECT 0x10000
#define HF_ERROR 0x20000
#define HF_WATCH 0x40000

#define HELP_MSDN 0
#define HELP_SDK 1
#define HELP_SPECIFIED 2

typedef struct dwinfo {
	char dwTitle[260] ;
	char dwName[260] ;
	HWND dwHandle ;
	int dwLineNo ;
   int breakpointLine ;
   FILETIME time ;
} DWINFO ;

typedef struct dependslist {
	struct dependslist *next ;
	char name[256] ;
	char title[256] ;
	HTREEITEM treeHandle ;
	FILETIME timex ;
} DEPENDSLIST ;
typedef struct filelist {
	struct filelist *next ;
	char name[256] ;
	char title[256] ;
	char output[256] ;
	HTREEITEM treeHandle ;
	DEPENDSLIST *depends ;
	FILETIME timex ;
	FILETIME outputTimex ;
	char rebuild ;
} FILELIST ;

#define BF_DEBUGINFO  1
#define BF_MAPFILE    2
#define BF_COMPILEVIAASM 4
#define BF_BREAKWINMAIN 0x10000
#define BF_BREAKDLL 0x20000
#define BF_DEBUGEXCEPTION 0x40000
#define BF_DEBUGTOOLTIPS 0x80000
#define BF_CHOSENPROJECT 0x80000000

typedef struct projlist {
	struct projlist *next ;
	char name[256] ;
	char title[256] ;
	char outputPath[256] ;
	char includePath[256] ;
	FILELIST *files ;
	HTREEITEM treeHandle ;
	FILETIME timex ;
	enum { BT_CONSOLE, BT_WINDOWS, BT_DLL, BT_LIBRARY, BT_DOS } buildType ;
   unsigned buildFlags ;
   char cmdline[256] ;
	char rebuild ;
   char compileopts[256] ;
   char assembleopts[256] ;
   char linkopts[256] ;
   char libopts[256] ;
} PROJLIST ;

typedef struct {
	int id ;
	char *text ;
} POPUPMENUTEXT ;

typedef struct {
	int start,end ;
	int color ;
	int italic ;
} EDITATTRIBS ;

typedef struct _bkpt {
	struct _bkpt *next ;
	int 	address ;
	unsigned char tempVal ;
	int active ;
   int linenum ;
   char module[256] ;
} BREAKPOINT ;

typedef struct _threads {
	struct _threads *next ;
	HANDLE hThread ;
	DWORD idThread ;
	BREAKPOINT breakpoint ;
} THREAD ;

typedef struct dbg_info {
   unsigned char *info ;
   int size ;
   int base ;
} DEBUG_INFO ;

typedef struct dll_info {
   struct dll_info *next ;
   DEBUG_INFO *dbg_info ;
   int base ;
   char name[512] ;
   int fUnicode ;
   int breakpoint ;
   HANDLE hFile ;
} DLL_INFO ;

typedef struct {
	HANDLE hProcess ;
	DWORD idProcess ;
	THREAD *threads ;
	BREAKPOINT breakpoints ;
	int idTempBpThread ;
   DEBUG_INFO *dbg_info ;
   DLL_INFO *dll_info ;
   int ExitAddr ;
} PROCESS ;
enum DebugState { notDebugging, SteppingOut, SteppingOver, SteppingIn, StepInOut,
       FinishStepOut, Running, atBreakpoint, atException, Aborting, nullState  } ;

typedef struct varinfo {
   TCData watchhead ;
   HTREEITEM hTreeItem ;
   struct varinfo *subtype ; /* for substructures */
   struct varinfo *link ; /* for next link in structure */
   char *typetab ;
   int type ;
   int address ;
   int offset ;
   int pointer :1 ;
   int enumx : 1 ;
   int structure : 1;
   int unionx : 1 ;
   int bitfield : 1 ;
   int array : 1 ;
   int bitstart: 5 ;
   int bitlength : 5 ;
   int outofscope : 1 ;
   int placeholder : 1 ;
   int editable : 1 ;
   int arraysize ;
   int watchindex ;
   char membername[256] ;
   char value[256] ;
} VARINFO ;

typedef struct {
   VARINFO *info ;
   char *typetab ;
   char *symtab ;
   DEBUG_INFO *dbg_info ;
} WATCHINFO ;