#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <dos.h>
#include <time.h>

#include "langext.h"
#include "defines.h"
#include "types.h"
#include "subs.h"
#include "globals.h"
/*                                 LINKERIO.C                              */



/*+-------------------------------------------------------------------------+
  |                                                                         |
  |                           linker_error                                  |
  |                                                                         |
  +-------------------------------------------------------------------------+*/
void linker_error(int_16 severity, char_ptr format, ...)
BeginDeclarations
va_list                                argptr;
EndDeclarations
BeginCode
 If severity NotLessThan 0
  Then
   fprintf(stdout,"\nLinker Error (Severity %d)\n",severity);
  EndIf;
 va_start(argptr,format);
 vfprintf(stdout,format,argptr);
 If severity Exceeds 7
  Then
   end_linker(severity);
  Else
   return;
  EndIf;
EndCode

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |                            linker_message                               |
  |                                                                         |
  +-------------------------------------------------------------------------+*/
void linker_message(char_ptr format, ...)
BeginDeclarations
va_list                                argptr;
EndDeclarations
BeginCode
 va_start(argptr,format);
 vfprintf(stdout,format,argptr);
 return;
EndCode

/*+-------------------------------------------------------------------------+
  |                                                                         |
  |                                 print                                   |
  |                                                                         |
  +-------------------------------------------------------------------------+*/
void print(char_ptr format, ...)
BeginDeclarations
va_list                                argptr;
bit_16                                 len;
EndDeclarations
BeginCode
 va_start(argptr,format);
 vsprintf(CharPtr(object_file_element), format, argptr);
 len = strlen(CharPtr(object_file_element));
 If len IsZero
  Then
   return;
  EndIf;
 If object_file_element[len-1] Is '\n'
  Then
   object_file_element[len-1] = '\000';
   strcat(CharPtr(object_file_element), "\r\n");
   len++;
  EndIf;
 file_write(BytePtr(object_file_element), Bit_32(len));
 return;
EndCode
