
/*
 * Copyright (C) 1998 David Stes.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "fab.h"
#include <runarray.h> 
#include <assert.h> 

static BOOL leading = 1;

static void nl(void) { putchar('\n');leading=1; }

static void pchar(char c)
{
  if (c == ' ' && leading) return;
  if (c == '\n') {nl();printf(".br");nl();return;}
  leading=0;
  if (c == '.') {printf("\\&.");return;}
  if (c == '\'') {printf("\\&\'");return;}
  if (c == '\"') {printf("\\&\"");return;}
  putchar(c);
}

static void opencode(id a)
{
  switch([a emphasiscode]) {
    case ROMAN   : break;
    case BOLD    :
    case COURIER : printf(".B");nl();break;
    case ITALIC  : printf(".I");nl();break;
    default : break;
  }
}

static void pnroff(id t)
{
  unsigned p = 0;
  char *chars = [t str];
  unsigned size = [t size];
  id runArray = [t runs];

  [runArray coalesce];

  while (p < size) {
    int i,n;
    id attrs;
    unsigned q;
    attrs = [runArray at:p];
    n = [attrs size];
    q = p + [runArray runLengthAt:p];
    assert(q != p && q <= size);
    for(i=0;i<n;i++) opencode([attrs at:i]);
    for(;p<q;p++) pchar(chars[p]);
    nl();
  }
}

static void ptitle(id t)
{
  printf(".SH ");pnroff(t);
}

static void psubtitle(id t)
{
  printf(".SH ");pnroff(t);
}

static void psubsubtitle(id t)
{
  printf(".PP ");nl();pnroff(t);
}

static void pbegindot(id t)
{
  printf(".RS 3");nl();
}

static void penddot(id t)
{
  printf(".RE");nl();
}

static void pdot(id t)
{
  printf(".br");nl();printf("* ");pnroff(t);
}

static void pmethodproto(id t)
{
  printf(".RS 1");nl();
  pnroff(t);
  printf(".RE");nl();
}

static void pnote(id t)
{
  printf(".PP");nl();
  pnroff(t);
}

static void pdoc(id t)
{
  printf(".PP");nl();
  pnroff(t);
}

static void pexample(id t)
{
  printf(".RS 3");nl();nl();
  pnroff(t);
  printf(".RE");nl();
}

void writenroff(id paragraphs)
{
  int i,n = [paragraphs size];

  for(i=0;i<n;i++) {
    id p = [paragraphs at:i];
    char *style = [[p textStyle] name];
    id t = [p text];
    assert(style != NULL && style != NULL);
    if (!strcmp(style,"Title")) ptitle(t);
    else if (!strcmp(style,"Copyright")) { /* suppress */ }
    else if (!strcmp(style,"Subtitle")) psubtitle(t);
    else if (!strcmp(style,"Subsubtitle")) psubsubtitle(t);
    else if (!strcmp(style,"Dotbegin")) pbegindot(t); 
    else if (!strcmp(style,"Dotitem")) pdot(t);
    else if (!strcmp(style,"Dotend")) penddot(t);
    else if (!strcmp(style,"Methodname")) psubsubtitle(t);
    else if (!strcmp(style,"Methodproto")) pmethodproto(t);
    else if (!strcmp(style,"Example")) pexample(t);
    else if (!strcmp(style,"Note")) pnote(t);
    else if (!strcmp(style,"Seealso")) pnote(t);
    else if (!strcmp(style,"Doc")) pdoc(t);
    else { pnroff(t); }
  }
}

