VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{43E35CDB-0887-11D7-BF85-444553540000}#1.0#0"; "FOLDERVIEW.OCX"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "IC Folders View Sample"
   ClientHeight    =   7320
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   10605
   ForeColor       =   &H8000000F&
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7320
   ScaleWidth      =   10605
   StartUpPosition =   2  'CenterScreen
   Begin ICFolderView.FolderView FolderView1 
      Height          =   4845
      Left            =   60
      TabIndex        =   46
      Top             =   90
      Width           =   3375
      _ExtentX        =   5953
      _ExtentY        =   8546
      Tooltips        =   1
   End
   Begin MSComDlg.CommonDialog cDlg 
      Left            =   2760
      Top             =   5865
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame Frame1 
      Height          =   2070
      Left            =   8730
      TabIndex        =   40
      Top             =   5100
      Width           =   1800
      Begin VB.PictureBox picSmall 
         AutoRedraw      =   -1  'True
         Height          =   300
         Left            =   360
         ScaleHeight     =   16
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   16
         TabIndex        =   43
         Top             =   1095
         Width           =   300
      End
      Begin VB.PictureBox picLarge 
         AutoRedraw      =   -1  'True
         Height          =   540
         Left            =   855
         ScaleHeight     =   480
         ScaleWidth      =   480
         TabIndex        =   42
         Top             =   855
         Width           =   540
      End
      Begin VB.CommandButton cmdItemInfo 
         Caption         =   "Selected Item info"
         Height          =   375
         Left            =   135
         TabIndex        =   41
         ToolTipText     =   "Printed in the Debug window"
         Top             =   1575
         Width           =   1530
      End
      Begin VB.Label Label8 
         AutoSize        =   -1  'True
         Caption         =   "This info is printed in the debug window"
         Height          =   465
         Left            =   135
         TabIndex        =   44
         Top             =   225
         Width           =   1515
         WordWrap        =   -1  'True
      End
   End
   Begin VB.ComboBox cboTooltips 
      Height          =   315
      Left            =   3780
      Style           =   2  'Dropdown List
      TabIndex        =   34
      Top             =   6855
      Width           =   1500
   End
   Begin VB.Frame Frame3 
      Height          =   2070
      Left            =   5550
      TabIndex        =   27
      Top             =   5100
      Width           =   3075
      Begin VB.CommandButton cmdReset 
         Appearance      =   0  'Flat
         Caption         =   "Reset"
         Height          =   330
         Left            =   1095
         TabIndex        =   45
         Top             =   1635
         Width           =   1020
      End
      Begin VB.CheckBox Check 
         Caption         =   "BackScroll"
         Height          =   285
         Index           =   15
         Left            =   1800
         TabIndex        =   32
         Top             =   1230
         Width           =   1095
      End
      Begin VB.ComboBox cboBackground 
         Height          =   315
         Left            =   1380
         Style           =   2  'Dropdown List
         TabIndex        =   31
         Top             =   255
         Width           =   1380
      End
      Begin VB.CommandButton cmdBColor 
         Caption         =   "BackColor"
         Height          =   360
         Left            =   180
         TabIndex        =   30
         Top             =   720
         Width           =   1170
      End
      Begin VB.CommandButton cmdFColor 
         Caption         =   "ForeColor"
         Height          =   360
         Left            =   180
         TabIndex        =   29
         Top             =   1185
         Width           =   1170
      End
      Begin VB.CommandButton cmdPicture 
         Caption         =   "Picture"
         Height          =   360
         Left            =   1755
         TabIndex        =   28
         Top             =   705
         Width           =   1170
      End
      Begin VB.Label Label6 
         AutoSize        =   -1  'True
         Caption         =   "Background :"
         Height          =   195
         Left            =   345
         TabIndex        =   33
         Top             =   315
         Width           =   960
      End
   End
   Begin VB.CheckBox Check 
      Caption         =   "Can Delete"
      Height          =   285
      Index           =   14
      Left            =   3735
      TabIndex        =   26
      Top             =   3045
      Width           =   1590
   End
   Begin VB.CheckBox Check 
      Caption         =   "Label Edit"
      Height          =   285
      Index           =   13
      Left            =   3735
      TabIndex        =   25
      Top             =   2445
      Width           =   1590
   End
   Begin VB.Frame Frame2 
      Height          =   4935
      Left            =   5550
      TabIndex        =   22
      Top             =   -15
      Width           =   4995
      Begin VB.CheckBox Check4 
         Caption         =   "ItemDragOver"
         Height          =   255
         Left            =   3450
         TabIndex        =   39
         Top             =   4575
         Width           =   1425
      End
      Begin VB.CheckBox Check3 
         Caption         =   "HitTest"
         Height          =   255
         Left            =   3450
         TabIndex        =   38
         Top             =   4230
         Width           =   1425
      End
      Begin VB.CheckBox Check2 
         Caption         =   "MouseMove"
         Height          =   255
         Left            =   3450
         TabIndex        =   37
         Top             =   3900
         Width           =   1425
      End
      Begin VB.CheckBox Check1 
         Caption         =   "Event logging"
         Height          =   255
         Left            =   180
         TabIndex        =   36
         Top             =   3900
         Value           =   1  'Checked
         Width           =   1425
      End
      Begin VB.CommandButton cmdClear 
         Caption         =   "Clear"
         Height          =   360
         Left            =   435
         TabIndex        =   24
         Top             =   4380
         Width           =   840
      End
      Begin VB.TextBox txtEvents 
         Height          =   3585
         Left            =   120
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   23
         Top             =   195
         Width           =   4785
      End
   End
   Begin VB.ComboBox cboAppearance 
      Height          =   315
      Left            =   3780
      Style           =   2  'Dropdown List
      TabIndex        =   19
      Top             =   5355
      Width           =   1500
   End
   Begin VB.ComboBox cboBorderStyle 
      Height          =   315
      Left            =   3780
      Style           =   2  'Dropdown List
      TabIndex        =   18
      Top             =   6105
      Width           =   1500
   End
   Begin VB.CheckBox Check 
      Caption         =   "HasButtons"
      Height          =   285
      Index           =   0
      Left            =   3735
      TabIndex        =   15
      Top             =   45
      Value           =   1  'Checked
      Width           =   1275
   End
   Begin VB.CheckBox Check 
      Caption         =   "HasLines"
      Height          =   285
      Index           =   1
      Left            =   3735
      TabIndex        =   14
      Top             =   345
      Value           =   1  'Checked
      Width           =   1275
   End
   Begin VB.CheckBox Check 
      Caption         =   "HasLinesAtRoot"
      Height          =   285
      Index           =   2
      Left            =   3735
      TabIndex        =   13
      Top             =   645
      Value           =   1  'Checked
      Width           =   1620
   End
   Begin VB.CheckBox Check 
      Caption         =   "Checkboxes"
      Height          =   285
      Index           =   3
      Left            =   3735
      TabIndex        =   12
      Top             =   945
      Width           =   1635
   End
   Begin VB.CheckBox Check 
      Caption         =   "ShowFiles"
      Height          =   285
      Index           =   4
      Left            =   3735
      TabIndex        =   11
      Top             =   1395
      Width           =   1275
   End
   Begin VB.CheckBox Check 
      Caption         =   "ShowHidden"
      Height          =   285
      Index           =   5
      Left            =   3735
      TabIndex        =   10
      Top             =   1695
      Width           =   1275
   End
   Begin VB.CheckBox Check 
      Caption         =   "ShowObjects"
      Height          =   285
      Index           =   6
      Left            =   3735
      TabIndex        =   9
      Top             =   1995
      Value           =   1  'Checked
      Width           =   1275
   End
   Begin VB.CheckBox Check 
      Caption         =   "OverlayIcons"
      Height          =   285
      Index           =   7
      Left            =   3735
      TabIndex        =   8
      Top             =   3480
      Value           =   1  'Checked
      Width           =   1275
   End
   Begin VB.CheckBox Check 
      Caption         =   "AutoUpdate"
      Height          =   285
      Index           =   8
      Left            =   3735
      TabIndex        =   7
      Top             =   3780
      Value           =   1  'Checked
      Width           =   1245
   End
   Begin VB.CheckBox Check 
      Caption         =   "ValidateSelection"
      Height          =   285
      Index           =   9
      Left            =   3735
      TabIndex        =   6
      Top             =   4680
      Value           =   1  'Checked
      Width           =   1590
   End
   Begin VB.CommandButton cmdSetSelFolder 
      Appearance      =   0  'Flat
      Caption         =   "Set"
      Height          =   360
      Left            =   2655
      TabIndex        =   5
      Top             =   6480
      Width           =   780
   End
   Begin VB.TextBox txtSelectedFolder 
      Height          =   1155
      Left            =   60
      MultiLine       =   -1  'True
      TabIndex        =   4
      Top             =   6105
      Width           =   2460
   End
   Begin VB.ComboBox cboRoot 
      Height          =   315
      Left            =   60
      Style           =   2  'Dropdown List
      TabIndex        =   3
      Top             =   5355
      Width           =   3375
   End
   Begin VB.CheckBox Check 
      Caption         =   "Drag Drop"
      Height          =   285
      Index           =   10
      Left            =   3735
      TabIndex        =   2
      Top             =   2745
      Width           =   1530
   End
   Begin VB.CheckBox Check 
      Caption         =   "BoldSelected"
      Height          =   285
      Index           =   11
      Left            =   3735
      TabIndex        =   1
      Top             =   4380
      Value           =   1  'Checked
      Width           =   1440
   End
   Begin VB.CheckBox Check 
      Caption         =   "ClickedOnSelect"
      Height          =   285
      Index           =   12
      Left            =   3735
      TabIndex        =   0
      Top             =   4080
      Value           =   1  'Checked
      Width           =   1605
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Tooltips"
      Height          =   195
      Left            =   3780
      TabIndex        =   35
      Top             =   6570
      Width           =   555
   End
   Begin VB.Line Line3 
      BorderColor     =   &H80000014&
      X1              =   3900
      X2              =   5115
      Y1              =   3405
      Y2              =   3405
   End
   Begin VB.Line Line2 
      BorderColor     =   &H80000014&
      X1              =   4020
      X2              =   5235
      Y1              =   2355
      Y2              =   2355
   End
   Begin VB.Line Line1 
      BorderColor     =   &H80000014&
      X1              =   4005
      X2              =   5220
      Y1              =   1305
      Y2              =   1305
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Appearance"
      Height          =   195
      Left            =   3810
      TabIndex        =   21
      Top             =   5070
      Width           =   870
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "BorderStyle"
      Height          =   195
      Left            =   3810
      TabIndex        =   20
      Top             =   5835
      Width           =   810
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Root"
      Height          =   195
      Left            =   60
      TabIndex        =   17
      Top             =   5070
      Width           =   345
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "SelectedFolder"
      Height          =   195
      Left            =   60
      TabIndex        =   16
      Top             =   5835
      Width           =   1065
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Private Sub Form_Load()

    ' Fill the Root cboBox
    cboRoot.AddItem "fvrDESKTOP"
    cboRoot.AddItem "fvrPROGRAMS"
    cboRoot.AddItem "fvrCONTROLPANEL"
    cboRoot.AddItem "fvrPRINTERS"
    cboRoot.AddItem "fvrDOCUMENTS"
    cboRoot.AddItem "fvrFAVORITES"
    cboRoot.AddItem "fvrSTARTUP"
    cboRoot.AddItem "fvrRECENT"
    cboRoot.AddItem "fvrSENDTO"
    cboRoot.AddItem "fvrRECYCLED"
    cboRoot.AddItem "fvrSTARTMENU" '10
    cboRoot.AddItem "fvrDESKTOPDIR"
    cboRoot.AddItem "fvrMYCOMPUTER"
    cboRoot.AddItem "fvrNETWORK"
    cboRoot.AddItem "fvrNETHOOD"
    cboRoot.AddItem "fvrFONTS"
    cboRoot.AddItem "fvrSHELLNEW"
    cboRoot.AddItem "fvrCOMMONSTARTMENU"
    cboRoot.AddItem "fvrCOMMONPROGRAMS"
    cboRoot.AddItem "fvrCOMMONSTARTUP"
    cboRoot.AddItem "fvrCOMMONDESKTOPDIR"
    cboRoot.AddItem "fvrAPPDATA"
    cboRoot.AddItem "fvrPRINTHOOD" '22
    cboRoot.AddItem "fvrALTSTARTUP"
    cboRoot.AddItem "fvrCOMMONALTSTARTUP"
    cboRoot.AddItem "fvrCOMMONFAVORITES"
    cboRoot.AddItem "fvrINTERNETCACHE"
    cboRoot.AddItem "fvrCOOKIES"
    cboRoot.AddItem "fvrHISTORY"
    
    ' Show the current Root
    Select Case FolderView1.Root
        Case 0
            cboRoot.ListIndex = 0
        Case 2 To 11
            cboRoot.ListIndex = FolderView1.Root - 1
        Case 16 To 28
            cboRoot.ListIndex = FolderView1.Root - 5
        Case 29 To 34
            cboRoot.ListIndex = FolderView1.Root - 6
    End Select
    
    ' Fill the Appearance cboBox
    cboAppearance.AddItem "fvaFlat"
    cboAppearance.AddItem "fva3D"
    ' Show the current Appearance
    cboAppearance.ListIndex = FolderView1.Appearance

    ' Fill the BorderStyle cboBox
    cboBorderStyle.AddItem "fvbNone"
    cboBorderStyle.AddItem "fvbFixedSingle"
    ' Show the current BorderStyle
    cboBorderStyle.ListIndex = FolderView1.BorderStyle

    ' Fill the Appearance cboBox
    cboTooltips.AddItem "fvtNone"
    cboTooltips.AddItem "fvtName"
    cboTooltips.AddItem "fvtTag"
    ' Show the current Appearance
    cboTooltips.ListIndex = FolderView1.ToolTips

    ' Fill the Background cboBox
    cboBackground.AddItem "fvgNone"
    cboBackground.AddItem "fvgColor"
    cboBackground.AddItem "fvgPicture"
    ' Show the current Background
    cboBackground.ListIndex = FolderView1.Background
    
    If Not (FolderView1.SelectedFolder Is Nothing) Then
        ' Show the SelectedFolder's FullPath
        txtSelectedFolder = FolderView1.SelectedFolder
    End If

End Sub

' Sets the Root folder of the control
Private Sub cboRoot_Click()
    
    ' Set the Root folder of the control according the
    ' cboRoot selection.
    Select Case cboRoot.ListIndex
        Case 0
            FolderView1.Root = 0
        Case 1 To 10
            FolderView1.Root = (cboRoot.ListIndex + 1)
        Case 11 To 22
            FolderView1.Root = (cboRoot.ListIndex + 5)
        Case 23 To 28
            FolderView1.Root = (cboRoot.ListIndex + 6)
    End Select
    
    ' Give time to the control to initialize
    DoEvents

End Sub

' Sets the Appearance of the control
Private Sub cboAppearance_Click()
    
    FolderView1.Appearance = cboAppearance.ListIndex

End Sub

' Sets the BorderStyle of the control
Private Sub cboBorderStyle_Click()
    
    FolderView1.BorderStyle = cboBorderStyle.ListIndex

End Sub

' Sets the Tooltips of the control
Private Sub cboTooltips_Click()
    
    FolderView1.ToolTips = cboTooltips.ListIndex

End Sub

' Sets the BackGround style of the control
Private Sub cboBackground_Click()
    
    FolderView1.Background = cboBackground.ListIndex

End Sub

' Sets the BackColor of the control
Private Sub cmdBColor_Click()
    
    ' Show the Color dialog
    cDlg.ShowColor
    
    If cDlg.Color Then
        FolderView1.BackColor = cDlg.Color
    End If

End Sub

' Sets the ForeColor of the control
Private Sub cmdFColor_Click()

    ' Show the Color dialog
    cDlg.ShowColor
    
    If cDlg.Color Then
        FolderView1.ForeColor = cDlg.Color
    End If

End Sub

' Sets the Picture of the control
Private Sub cmdPicture_Click()

    cDlg.Filter = "All Pictures|*.bmp;*.gif;*.jpg;*.jpeg"
    
    ' Show the Open dialog
    cDlg.ShowOpen
    
    If Len(cDlg.FileName) > 0 Then
        Set FolderView1.Picture = LoadPicture(cDlg.FileName)
    End If

End Sub

' Resets colors to default and clears the Picture.
Private Sub cmdReset_Click()

    FolderView1.ForeColor = vbWindowText
    FolderView1.BackColor = vbWindowBackground
    Set FolderView1.Picture = Nothing

End Sub

' Sets the SelectedFolder
Private Sub cmdSetSelFolder_Click()

    ' Set the control's SelectedFolder to the txtSelectedFolder.text
    FolderView1.SelectedFolder = txtSelectedFolder

   ' Validate that the folder has been sucessfuly selected
    txtSelectedFolder = FolderView1.SelectedFolder ' .FullPath

End Sub

' Sets control's Properties
Private Sub Check_Click(Index As Integer)

    With FolderView1
        Select Case Index
            Case 0
                .HasButtons = Check(0)
            Case 1
                .HasLines = Check(1)
            Case 2
                .HasLinesAtRoot = Check(2)
            Case 3
                .CheckBoxes = Check(3)
            Case 4
                .ShowFiles = Check(4)
            Case 5
                .ShowHidden = Check(5)
            Case 6
                .ShowObjects = Check(6)
            Case 7
                .OverlayIcons = Check(7)
            Case 8
                .AutoUpdate = Check(8)
            Case 9
                .ValidateSelection = Check(9)
            Case 10
                .DragDrop = Check(10)
                ' Alert
                If Check(10) Then
                    Call MsgBox("Real Drag and Drop functionality has been enabled.", vbInformation, "Notice")
                End If
            Case 11
                .BoldSelected = Check(11)
            Case 12
                .ClickedOnSelect = Check(12)
            Case 13
                .LabelEdit = Check(13)
            Case 14
                .CanDelete = Check(14)
            Case 15
                .BackScroll = Check(15)
        End Select
    End With

End Sub

Private Sub txtEvents_Change()

    ' Reset the Textbox if more than 20K
    If Len(txtEvents) > 20000 Then txtEvents = vbNullString
    
    ' Force the Textbox to show the last drawn lines.
    txtEvents.SelStart = Len(txtEvents)

End Sub

' Resets the Log Textbox
Private Sub cmdClear_Click()

    ' Reset the Textbox
    txtEvents = vbNullString
    
End Sub

' Sets events' logging
Private Sub Check1_Click()

    If Check1 Then
        Check2.Enabled = True
        Check3.Enabled = True
        Check4.Enabled = True
        Else
        Check2 = vbUnchecked
        Check2.Enabled = False
        Check3 = vbUnchecked
        Check3.Enabled = False
        Check4 = vbUnchecked
        Check4.Enabled = False
    End If

End Sub

' Show information for the SelectedFolder item,
' printed in the Debug window.
Private Sub cmdItemInfo_Click()

  On Error Resume Next
  
    With FolderView1
        ' Hidden members
        ' -------------------------------------------
        Debug.Print "hItem " & .SelectedFolder.hItem
        Debug.Print "ItemID " & .SelectedFolder.ItemID
        Debug.Print "PIDL " & .SelectedFolder.PIDL
        Debug.Print "Attributes " & .SelectedFolder.Attributes
        ' -------------------------------------------
        
        Debug.Print "DisplayName " & .SelectedFolder.DisplayName
        Debug.Print "FullPath " & .SelectedFolder.FullPath
        
        Debug.Print "Checked " & .SelectedFolder.Checked
        Debug.Print "Expanded " & .SelectedFolder.Expanded
        Debug.Print "Selected " & .SelectedFolder.Selected
        
        Debug.Print "isFolder " & .SelectedFolder.isFolder
        Debug.Print "IsObject " & .SelectedFolder.IsObject
        Debug.Print "IsShortcut " & .SelectedFolder.IsShortcut
        Debug.Print "IsHidden " & .SelectedFolder.IsHidden
        Debug.Print "IsShared " & .SelectedFolder.IsShared
        Debug.Print "IsValid " & .SelectedFolder.IsValid
        
        Debug.Print "Siblings " & .SelectedFolder.Siblings
        Debug.Print "Children " & .SelectedFolder.Children

        If Not .SelectedFolder.Parent Is Nothing Then
           Debug.Print "Parent " & .SelectedFolder.Parent.DisplayName
        End If
        
        If Not .SelectedFolder.Child Is Nothing Then
           Debug.Print "Child " & .SelectedFolder.Child.DisplayName
        End If
        
        If Not .SelectedFolder.FirstSibling Is Nothing Then
           Debug.Print "FirstSibling " & .SelectedFolder.FirstSibling.DisplayName
        End If
        
        If Not .SelectedFolder.PrevSibling Is Nothing Then
           Debug.Print "PrevSibling " & .SelectedFolder.PrevSibling.DisplayName
        End If
        
        If Not .SelectedFolder.NextSibling Is Nothing Then
           Debug.Print "NextSibling " & .SelectedFolder.NextSibling.DisplayName
        End If
        
        If Not .SelectedFolder.LastSibling Is Nothing Then
           Debug.Print "LastSibling " & .SelectedFolder.LastSibling.DisplayName
        End If
       
        picSmall.Picture = .SelectedFolder.SmallIcon ' (fviOpenIcon Or fviSelected Or fviShortcutOverlay)
        picLarge.Picture = .SelectedFolder.LargeIcon ' (fviOpenIcon Or fviSelected Or fviShareOverlay)
    End With

End Sub



























' ####################### EVENTS ##########################


Private Sub FolderView1_GotFocus()

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "GotFocus" & vbCrLf

End Sub

Private Sub FolderView1_LostFocus()

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "LostFocus" & vbCrLf

End Sub

Private Sub FolderView1_MouseDown(Button As Integer, Shift As Integer, X As Long, Y As Long)

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "MouseDown (" & Button & ", " & Shift & ", " & X & ", " & Y & ")" & vbCrLf

End Sub

Private Sub FolderView1_MouseMove(Button As Integer, Shift As Integer, X As Long, Y As Long)
    
'  Dim lWhere As efvHitTest
    
    ' The HitTest method can be used here
'    If Not FolderView1.HitTest(X, Y, lWhere) Is Nothing Then
'        Debug.Print FolderView1.HitTest(X, Y, lWhere) & ", " & lWhere
'    End If
    
    ' If we wish MouseMove events logging
    If Check2 Then txtEvents = txtEvents & "MouseMove (" & Button & ", " & Shift & ", " & X & ", " & Y & ")" & vbCrLf

End Sub

Private Sub FolderView1_MouseUp(Button As Integer, Shift As Integer, X As Long, Y As Long)

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "MouseUp (" & Button & ", " & Shift & ", " & X & ", " & Y & ")" & vbCrLf

End Sub

Private Sub FolderView1_Click()

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "Click" & vbCrLf

End Sub

Private Sub FolderView1_DblClick()

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "DblClick" & vbCrLf

End Sub

Private Sub FolderView1_FolderClick(Folder As cFolder, Location As efvHitTest)

  Dim sWhere As String

    ' Get the clicked point from the Location flag
    Select Case Location
        Case fvhOnCheckBox
            sWhere = "OnCheckBox"
        Case fvhOnIcon
            sWhere = "OnIcon"
        Case fvhOnLabel
            sWhere = "OnLabel"
        ' If the FolderClick event is raised after an item has been
        ' selected by the Keyboard, the Location will return fvhOnItem.
        Case fvhOnItem
            sWhere = "OnItem"
    End Select

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "FolderClick (" & Folder.DisplayName & ", " & sWhere & ")" & vbCrLf

End Sub

Private Sub FolderView1_KeyDown(KeyCode As Integer, Shift As Integer)

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "KeyDown (" & KeyCode & ", " & Shift & ")" & vbCrLf

End Sub

Private Sub FolderView1_KeyPress(KeyAscii As Integer)
    
    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "KeyPress (" & KeyAscii & ")" & vbCrLf

End Sub

Private Sub FolderView1_KeyUp(KeyCode As Integer, Shift As Integer)

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "KeyUp (" & KeyCode & ", " & Shift & ")" & vbCrLf

End Sub

Private Sub FolderView1_HitTest(Folder As cFolder, Location As efvHitTest)

  Dim sWhere As String

    ' Get the HitTest point from the Location flag
    Select Case Location
        Case fvhOnIndent
            sWhere = "OnIndent"
        Case fvhOnButton
            sWhere = "OnButton"
        Case fvhOnCheckBox
            sWhere = "OnCheckBox"
        Case fvhOnIcon
            sWhere = "OnIcon"
        Case fvhOnLabel
            sWhere = "OnLabel"
        Case fvhOnRight
            sWhere = "OnRight"
    End Select

    ' If we wish HitTest events logging
    If Check3 Then txtEvents = txtEvents & "HitTest (" & Folder.FullPath & ", " & sWhere & ")" & vbCrLf

End Sub

Private Sub FolderView1_Collapsing(Cancel As Boolean, Folder As cFolder)

  On Error Resume Next

    ' The event can be canceled here
'    If UCase$(Folder.FullPath) = "C:\WINDOWS" Then Cancel = True
    
    ' If the event is canceled
    If Cancel Then
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "Collapsing (canceled)" & vbCrLf
        Else
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "Collapsing" & vbCrLf
    End If

End Sub

Private Sub FolderView1_Collapse(Folder As cFolder)

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "Collapse" & vbCrLf

End Sub

Private Sub FolderView1_Expanding(Cancel As Boolean, Folder As cFolder)

  On Error Resume Next

    ' The event can be canceled here
'    If UCase$(Folder.FullPath) = "C:\WINDOWS" Then Cancel = True
    
    ' If the event is canceled
    If Cancel Then
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "Expanding (canceled)" & vbCrLf
        Else
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "Expanding" & vbCrLf
    End If

End Sub

Private Sub FolderView1_Expand(Folder As cFolder)

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "Expand" & vbCrLf

End Sub

Private Sub FolderView1_SelChanging(Cancel As Boolean, Folder As cFolder)

  On Error Resume Next
    
    ' The event can be canceled here
'    If UCase$(Folder.FullPath) = "C:\WINDOWS" Then Cancel = True
    
    ' If the event is canceled
    If Cancel Then
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "SelChanging (canceled)" & vbCrLf
        Else
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "SelChanging" & vbCrLf
    End If

End Sub

Private Sub FolderView1_SelChanged(Folder As cFolder)

    ' Show the FullPath of the SelectedFolder
    txtSelectedFolder.Text = Folder.FullPath

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "SelChanged" & vbCrLf

End Sub

Private Sub FolderView1_HScroll()

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "HScroll" & vbCrLf

End Sub

Private Sub FolderView1_VScroll()

    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "VScroll" & vbCrLf

End Sub

Private Sub FolderView1_BeforeLabelEdit(Cancel As Boolean)
    
    ' Set (Cancel = True) to cancel label editing
    
    ' If the event is canceled
    If Cancel Then
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "BeforeLabelEdit (canceled)" & vbCrLf
        Else
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "BeforeLabelEdit" & vbCrLf
    End If

End Sub

Private Sub FolderView1_AfterLabelEdit(Cancel As Boolean, NewString As String)
    
    ' Set (Cancel = True) to not accept the new data
    
    ' If the event is canceled
    If Cancel Then
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "AfterLabelEdit (canceled)" & vbCrLf
        Else
        ' If we wish events logging
        If Check1 Then txtEvents = txtEvents & "AfterLabelEdit (" & NewString & ")" & vbCrLf
    End If

End Sub

' The srcItem is an array of string values with only one member.
Private Sub FolderView1_ItemStartDrag(srcItem As Variant, ByVal DragEffects As Long)
    
    ' If we wish events logging
    If Check1 Then
        ' The srcItem array contains only one member
        txtEvents = txtEvents & "ItemStartDrag (" & srcItem(0) & ", " & DragEffects & ")" & vbCrLf
    End If

End Sub

' The srcItem may contain more than one filepaths in an external drag operation.
' The dstItem may be Nothing.
Private Sub FolderView1_ItemDragOver(srcItem As Variant, dstItem As cFolder, ByVal Effect As Long, ByVal Button As Integer, ByVal Shift As Integer, ByVal X As Long, ByVal Y As Long)
            
  Dim iItemsCount As Long
  
    ' If we wish events logging
    If Check4 Then
        ' Get the number of dragged Items
        iItemsCount = UBound(srcItem) + 1
        ' If the destination Item has been set
        If Not (dstItem Is Nothing) Then
            ' If there are more than one dragged Items
            If iItemsCount > 1 Then
                txtEvents = txtEvents & "ItemDragOver (" & iItemsCount & " items, over " & dstItem.DisplayName & ", " & Effect & ")" & vbCrLf
                ' If there is only one dragged Item
                Else
                txtEvents = txtEvents & "ItemDragOver (" & srcItem(0) & " over " & dstItem.DisplayName & ", " & Effect & ")" & vbCrLf
            End If
            ' If the destination Item has not been set
            Else
            ' If there are more than one dragged Items
            If iItemsCount > 1 Then
                txtEvents = txtEvents & "ItemDragOver (" & iItemsCount & " items, over no drop target" & ", " & Effect & ")" & vbCrLf
                ' If there is only one dragged Item
                Else
                txtEvents = txtEvents & "ItemDragOver (" & srcItem(0) & " over no drop target" & ", " & Effect & ")" & vbCrLf
            End If
        End If
    End If

End Sub

' The dstItem can not be Nothing
Private Sub FolderView1_ItemDragDrop(srcItem As Variant, dstItem As cFolder, ByVal DropEffect As Long, Cancel As Integer)
            
  Dim iItemsCount As Long
    
    ' If we wish events logging
    If Check1 Then
        ' Get the number of dragged Items
        iItemsCount = UBound(srcItem) + 1
        ' If the destination Item has been set
        If Not (dstItem Is Nothing) Then
            ' The event can be canceled here
'           Cancel = 1
            ' If the event is canceled
            If Cancel > 0 Then
                txtEvents = txtEvents & "ItemDragDrop (canceled)" & vbCrLf
                ' If the event is not canceled
                Else
                ' If there are more than one dragged Items
                If iItemsCount > 1 Then
                    txtEvents = txtEvents & "ItemDragDrop (" & iItemsCount & " items, on " & dstItem.DisplayName & ", " & DropEffect & ")" & vbCrLf
                    ' If there is only one dragged Item
                    Else
                    txtEvents = txtEvents & "ItemDragDrop (" & srcItem(0) & " on " & dstItem.DisplayName & ", " & DropEffect & ")" & vbCrLf
                End If
            End If
        End If
    End If

End Sub

Private Sub FolderView1_ItemCompleteDrag(ByVal DropEffect As Long)

    ' If we wish events logging
    If Check1 Then
        txtEvents = txtEvents & "ItemCompleteDrag, " & DropEffect & vbCrLf
    End If

End Sub

Private Sub FolderView1_Update(EventID As efvUpdate, ByVal ValueA As String, ByVal ValueB As String)

  Dim sEvent As String
    
    Select Case EventID
        Case fvuItemRenamed
            sEvent = "fvuItemRenamed"
        Case fvuItemCreated
            sEvent = "fvuItemCreated"
        Case fvuItemRemoved
            sEvent = "fvuItemRemoved"
        Case fvuFolderRenamed
            sEvent = "fvuFolderRenamed"
        Case fvuFolderCreated
            sEvent = "fvuFolderCreated"
        Case fvuFolderRemoved
            sEvent = "fvuFolderRemoved"
        Case fvuMediaInserted
            sEvent = "fvuMediaInserted"
        Case fvuMediaRemoved
            sEvent = "fvuMediaRemoved"
        Case fvuDriveRemoved
            sEvent = "fvuDriveRemoved"
        Case fvuDriveAdded
            sEvent = "fvuDriveAdded"
        Case fvuNetworkShareAdded
            sEvent = "fvuNetworkShareAdded"
        Case fvuNetworkShareRemoved
            sEvent = "fvuNetworkShareRemoved"
        Case fvuAttributesChanged
            sEvent = "fvuAttributesChanged"
        Case fvuFolderContentsUpdated
            sEvent = "fvuFolderContentsUpdated"
        Case fvuItemContentsUpdated
            sEvent = "fvuItemContentsUpdated"
        Case fvuServerDisconnected
            sEvent = "fvuServerDisconnected"
        Case fvuImageUpdated
            sEvent = "fvuImageUpdated"
        Case fvuDriveIconAdded
            sEvent = "fvuDriveIconAdded"
        Case Else
            sEvent = vbNullString
    End Select
    
    ' If we wish events logging
    If Check1 Then txtEvents = txtEvents & "Update (" & sEvent & ", " & ValueA & ", " & ValueB & ")" & vbCrLf

End Sub

