#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <2D_World.h>
#include <2D_Sprite.h>
#include <2D_SpriteCache.h>
#include <CON_All.h>

#include "GameSprites.h"
#include "FPSCounter.h"

int initConsole(int& Width, int& Height, int& FullScreen, int& NoAccel, Screen* S)
{
  Width=320;
  Height=240;
  if (S->isModeAvailable(Width,Height)==0)
  {
    MessageBox(NULL,"Resolution 320x240 not supported.","ERROR",MB_OK);
    return -1;
  }
  FullScreen=0;
  NoAccel=1;
  setDebugLevel(3);
  enableDiagnostics();
  return 0;
}

ResourceStream *RS;
FPSCounter FPS;
World2D* W=NULL;
SpriteCache* SC=NULL;
Sprite* sprite;

int action(Console* C)
{
  Keyboard& K=*(C->getKeyboard());
  K.update();
  Screen& S=*C->getScreen();
  View2D view(&S, 0,0, S.getWidth()-1, S.getHeight()-1);
  static Vector2D pos(0,15);
  if (W==NULL)
  {
    W=new World2D();
    
    RS=newResourceStream("ufo.rsc");
    setDefaultResourceStream(RS); // System will release it when done.
    SC=new SpriteCache(*RS);
    W->add(new Player(SC,C));
    W->add(new UFO(SC));
  }

  S.clear(0);

  W->advance(getFrameTime());
  W->render(view);

  FPS.update(GetTickCount());
  S.beginDraw();
  S.printXY(10,5,0xffffffff,FPS.getFPSString());
  S.printXY(130,5,0xffffffff,"Left|Right|Space|F12");
  S.endDraw();
  S.flip();
  W->doDeletions();

  if (K[DIK_ESCAPE])
  {
    delete SC;
    delete W;
    return -1;
  }
  return 0;
}