/** \file UTIL_GenStreamBuf.h
    Generic stream buffer, used to implement custom iostreams.

Copyright (c) 1998-1999 by Amir Geva.
This file is part of the Photon Game Development library,
beta release version 0.25.
Permission is granted to use and copy this file for non-commercial use only.
Please contact the author concerning commercial usage.
Amir Geva makes no representations about the suitability of this software for any purpose.
It is provided "as is" without express or implied warranty.

*/
#ifndef H_UTIL_GENSTREAMBUF
#define H_UTIL_GENSTREAMBUF

#include <iostream.h>
#include <UTIL_Misc.h>

// Generic streambuf class.
// Subclass it and implement Read & Write to provide a specific behaviour.
// Override seekoff if you will require seek
class GenStreamBuf : public streambuf
{
public:
  GenStreamBuf(WriteMonitor* WM=NULL);
  ~GenStreamBuf();
  virtual int        overflow( int nCh = EOF );
  virtual int        underflow();
  virtual int        sync();
  virtual streambuf* setbuf(char *buf, int Size);
  virtual streampos  seekoff(streamoff Offset, ios::seek_dir Direction, int nMode = ios::in | ios::out);

  void setWriteMonitor(WriteMonitor* WM);
protected:
  // Reads upto len bytes from the input, returning the actual amount of bytes read.
  virtual int Read(char *buf, int len)=0;
  // Writes the buffer to the output, returning the actual amount of byte written.
  virtual int Write(char *buf, int len)=0;

  void updateWriteMonitor(int Bytes);

  WriteMonitor* m_WriteMonitor;
};

#endif // H_UTIL_GENSTREAMBUF