unit levcl_3a;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, Menus, LEVCL, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    LEdit1: TLEdit;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N2: TMenuItem;
    Find1: TMenuItem;
    FindNext1: TMenuItem;
    Replace1: TMenuItem;
    Settings1: TMenuItem;
    Font1: TMenuItem;
    AutoIndent1: TMenuItem;
    PaintBox1: TPaintBox;
    Bookmark1: TMenuItem;
    Set1: TMenuItem;
    GoTo1: TMenuItem;
    N3: TMenuItem;
    Highlight1: TMenuItem;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure SaveAs1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure FindNext1Click(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure AutoIndent1Click(Sender: TObject);
    procedure File1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure LEdit1NewFont(Sender: TObject);
    procedure LEdit1VertScroll(Sender: TObject);
    procedure LEdit1Change(Sender: TObject);
    procedure Set1Click(Sender: TObject);
    procedure GoTo1Click(Sender: TObject);
    procedure PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Highlight1Click(Sender: TObject);
  private
    { Private declarations }
    Units: Integer;
    MaxMark: Integer;
    Mark: Integer;
    Highlight: WordBool;
    procedure AdjustSettings;
    procedure SetDimensions;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.AdjustSettings;
var
  NewMark: Integer;
  MarkLine: LongInt;
begin
  MarkLine := LEdit1.GetBookmarkLine(0);
  MarkLine := MarkLine - LEdit1.FirstVisibleLine;
  if (MarkLine < 0) then NewMark := -1
    else if (MarkLine > MaxMark) then NewMark := -1
    else NewMark := MarkLine;
  if (NewMark <> Mark) then begin
    Mark := NewMark;
    PaintBox1.Invalidate;
  end;
end;

procedure TForm1.SetDimensions;
begin
  Units := LEdit1.UnitsVertical;
  if (Units <> 0) then begin
    MaxMark := (ClientHeight DIV Units) - 1;
    PaintBox1.Invalidate;
  end;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := LEdit1.CanClose;
end;

procedure TForm1.New1Click(Sender: TObject);
begin
  LEdit1.NewFile
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
  LEdit1.OpenFile
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
  LEdit1.SaveFile
end;

procedure TForm1.SaveAs1Click(Sender: TObject);
begin
  LEdit1.SaveFileAs
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Cut1Click(Sender: TObject);
begin
  LEdit1.CutToClipboard
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
  LEdit1.CopyToClipboard
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
  LEdit1.PasteFromClipboard;
end;

procedure TForm1.Find1Click(Sender: TObject);
begin
  LEdit1.ShowFindDialog;
end;

procedure TForm1.FindNext1Click(Sender: TObject);
begin
  LEdit1.FindNext
end;

procedure TForm1.Replace1Click(Sender: TObject);
begin
  LEdit1.ShowReplaceDialog
end;

procedure TForm1.Font1Click(Sender: TObject);
begin
  LEdit1.ShowFontDialog
end;

procedure TForm1.AutoIndent1Click(Sender: TObject);
begin
  LEdit1.AutoIndent := Not LEdit1.AutoIndent;
  AutoIndent1.Checked := LEdit1.AutoIndent
end;

procedure TForm1.File1Click(Sender: TObject);
begin
  Save1.Enabled := LEdit1.CanExecuteCommand(EC_FILESAVE);
  SaveAs1.Enabled := LEdit1.CanExecuteCommand(EC_FILESAVEAS);
end;

procedure TForm1.Edit1Click(Sender: TObject);
begin
  Find1.Enabled := LEdit1.CanExecuteCommand(EC_SEARCHFIND);
  FindNext1.Enabled := LEdit1.CanFindNext;
  Replace1.Enabled := LEdit1.CanExecuteCommand(EC_SEARCHREPLACE);
  Cut1.Enabled := LEdit1.CanExecuteCommand(EC_EDITCUT);
  Copy1.Enabled := LEdit1.CanExecuteCommand(EC_EDITCOPY);
  Paste1.Enabled := LEdit1.CanExecuteCommand(EC_EDITPASTE);
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
  with PaintBox1.Canvas do begin
    Pen.Color := LEdit1.BackColor;
    Brush.Color := LEdit1.BackColor;
    Rectangle(PaintBox1.Left,PaintBox1.Top,PaintBox1.Width,PaintBox1.Height);
    if Mark >= 0 then TextOut(0,Units * Mark,'->');
  end;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  SetDimensions;
end;

procedure TForm1.LEdit1NewFont(Sender: TObject);
begin
  SetDimensions;
  PaintBox1.Font := LEdit1.Font;
  PaintBox1.Font.Color := clRed;
end;

procedure TForm1.LEdit1VertScroll(Sender: TObject);
begin
  AdjustSettings;
end;

procedure TForm1.LEdit1Change(Sender: TObject);
begin
  AdjustSettings;
end;



procedure TForm1.Set1Click(Sender: TObject);
begin
  LEdit1.SetBookmarkOnCurrent;
  AdjustSettings;
end;

procedure TForm1.GoTo1Click(Sender: TObject);
begin
  LEdit1.FindBookmark;
end;

procedure TForm1.PaintBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  TheLine: LongInt;
begin
  TheLine := (Y DIV Units) + LEdit1.FirstVisibleLine;
  if (TheLine > LEdit1.LineCount) then MessageBeep(0) else begin
    LEdit1.SetBookmark(0,TheLine);
    LEdit1.FindBookmark;
  end;
end;

procedure TForm1.Highlight1Click(Sender: TObject);
begin
  Highlight := Not Highlight;
  Highlight1.Checked := Highlight;
  if (Highlight) then begin
    LEdit1.SetBookmarkBackColor(0,clRed);
    LEdit1.SetBookmarkForeColor(0,clYellow);
  end else begin
    LEdit1.RemoveBookmarkBackColor(0);
    LEdit1.RemoveBookmarkForeColor(0);
  end;
end;

end.
