// MiniFTP copyright 1997 Paul Gerhart pgerhart@voicenet.com
// View.h : interface of the CMiniFTPView class
//
/////////////////////////////////////////////////////////////////////////////

#include <winsock.h>


#define BUFSIZE 1024
#define REPTIME	1000

class CMiniFTPView : public CEditView
{
protected: // create from serialization only
	CMiniFTPView();
	DECLARE_DYNCREATE(CMiniFTPView)
public:
	SOCKET m_sktControl;
protected:
	CFont m_font;
	SOCKET m_sktListen;
	SOCKET m_sktData;
	int m_nState;
	BOOL m_bReplyReceived;
	BOOL m_bTimerOn;
	BOOL m_bBusy;
	BOOL m_bWaitingForTimeout;
	char m_szControlReplyBuffer[BUFSIZE+2];
	char m_szDataBuffer[BUFSIZE+2];
	int m_nRadioASCII;
	CString m_sIncomingPath; // to direcctory level
	CString m_sIncomingFilePath; // full path to the file
	CString m_sStoringFilePath;
	UINT m_uTimeout;
	BOOL m_bFileHasBeenReceived;
	BOOL m_bFileHasBeenSent;
	BOOL m_bReceivingFile;
	BOOL m_bSendingFile;
	FILE * m_pXferFilePointer;
	CStringList m_sCommandList;

// Attributes
public:
	CMiniFTPDoc* GetDocument();


// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMiniFTPView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL DestroyWindow();
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL
	afx_msg LONG OnWinsockEventControl(WPARAM wParam, LPARAM lParam);
	afx_msg LONG OnWinsockEventListen(WPARAM wParam, LPARAM lParam);
	afx_msg LONG OnWinsockEventData(WPARAM wParam, LPARAM lParam);

// Implementation
public:
	virtual ~CMiniFTPView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

public:
	BOOL UserCommand(CString sCommand);

protected:
	void Log (const char * szBuffer);  
	BOOL DoCommand(CString s);
	SOCKET ConnectOrBind(BOOL bBind, const char *name, const char *port);

	void StateMachine(void); 
	void MakeSafeState(BOOL bKillTimers);
	void DisplaySktRead( char * szBuffer );
	void ServiceIncomingFile(void); 
	void ServiceOutgoingFile(void); 
	void BurnIncomingData(void); 


// Generated message map functions
protected:
	//{{AFX_MSG(CMiniFTPView)
	afx_msg void OnConnect();
	afx_msg void OnCloseconn();
	afx_msg void OnClearview();
	afx_msg void OnUpdateCloseconn(CCmdUI* pCmdUI);
	afx_msg void OnUpdateConnect(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnFsettings();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in View.cpp
inline CMiniFTPDoc* CMiniFTPView::GetDocument()
   { return (CMiniFTPDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
