//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Paul Masters
//
// estoken.hpp
//
// This is used to coordinate the export and load-time patch up process for
// linking the articulation/motion data to objects.
//
//

#ifndef __ESTOKEN_HPP
#define __ESTOKEN_HPP   1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include "esdefs.h"
#include "xfile.hpp"

//
//
//                                Equates
//
//

#define ESCH_KEYFRAME_TOKEN_COUNT 53

//
//
//                               Structures
//
//

struct esch_token
{
    char name[ESCH_MAX_NAME];
    esch_limb_type type;
};

class EschTokenManager
{
protected:
    int token_count;
    esch_token *token_list;

public:
    EschTokenManager(){token_count = 0;token_list=0;};
    ~EschTokenManager();
    esch_error_codes load (char *filename);
    esch_error_codes load (XFParseIFF *iff);

    // find type and put matching name in _name
    void get_token_name (char *_name, esch_limb_type _type);

    // find _name and return matching type
    esch_limb_type get_token_type(char *_name);

    void str_to_upper (char *str);
};

//
//
//                                  Data
//
//

extern esch_token esch_token_list[ESCH_KEYFRAME_TOKEN_COUNT];

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - estoken.h 

