/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import stec.ss.ssBuffer;
import stec.ss.ssException;
import stec.ss.ssGenerator;
import stec.ss.ssStatementProcessor;
import stec.ss.ssSymbolTable;
import stec.ss.ssSystem;
import stec.ss.ssToken;

final class ssProgram {
    private static final String _ = "Copyright (c) 1997-1999 Manuel J. Goyenechea. All rights reserved.";
    protected ssSystem system;
    private ssSymbolTable symbolTable;
    private ssBuffer source;
    private ssBuffer object;
    private int mark;

    protected ssProgram(ssSystem ssSystem2) {
        this.system = ssSystem2;
        this.symbolTable = new ssSymbolTable();
        this.source = null;
        this.system.gCurrentLineNumber = 0;
        this.object = null;
    }

    protected ssProgram(ssSystem ssSystem2, ssBuffer ssBuffer2) throws ssException {
        this.system = ssSystem2;
        this.symbolTable = new ssSymbolTable();
        this.source = ssBuffer2;
        this.system.gCurrentLineNumber = 1;
        this.object = ssGenerator.generate(this);
        this.source = null;
    }

    protected ssProgram(ssSystem ssSystem2, byte[] byArray) throws ssException {
        this(ssSystem2, new ssBuffer(byArray));
    }

    protected ssProgram(ssSystem ssSystem2, String string) throws ssException {
        this(ssSystem2, new ssBuffer(string));
    }

    protected ssProgram(ssSystem ssSystem2, File file) throws ssException, Exception {
        this.system = ssSystem2;
        this.symbolTable = new ssSymbolTable();
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        this.source = ssProgram.read(bufferedInputStream);
        ((FilterInputStream)bufferedInputStream).close();
        fileInputStream.close();
        this.system.gCurrentLineNumber = 1;
        this.object = ssGenerator.generate(this);
        this.source = null;
    }

    protected ssProgram(ssSystem ssSystem2, BufferedInputStream bufferedInputStream) throws ssException {
        this(ssSystem2, ssProgram.read(bufferedInputStream));
    }

    protected final ssBuffer getSource() {
        return this.source;
    }

    protected final ssBuffer getObject() {
        return this.object;
    }

    protected final ssSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    protected static final ssBuffer read(BufferedInputStream bufferedInputStream) throws ssException {
        try {
            int n;
            ssBuffer ssBuffer2 = new ssBuffer();
            byte[] byArray = new byte[2048];
            while ((n = bufferedInputStream.read(byArray, 0, 2048)) != -1) {
                ssBuffer2.write(byArray, 0, n);
            }
            return ssBuffer2;
        }
        catch (Exception exception) {
            throw new ssException(exception.toString());
        }
    }

    protected final void run() throws ssException, Exception {
        this.object.reset(0);
        this.system.gCurrentLineNumber = 1;
        ssStatementProcessor ssStatementProcessor2 = new ssStatementProcessor(this.system);
        while (ssStatementProcessor2.processStatement() && !this.system.gExit) {
        }
        if (!this.system.gExit) {
            if (this.system.gProcessor != 3 && this.system.gInStatement) {
                throw new ssException(16, "end of file", "statement block");
            }
            if (this.system.gLoopHandler.inLoop()) {
                throw new ssException(16, "end of file", "loop block");
            }
            if (this.system.gLevel != 0) {
                throw new ssException(16, "end of file", "block statement");
            }
        }
    }

    protected final ssToken getNextToken() throws ssException {
        ssToken ssToken2;
        byte by = this.getNextByte();
        switch (by) {
            case 48: {
                ssToken2 = new ssToken(by, this.getNextDataBlock());
                break;
            }
            case 49: {
                ssToken2 = new ssToken(by, this.getNextSymbol());
                break;
            }
            case 51: {
                ssToken2 = new ssToken(by, this.getNextString());
                break;
            }
            case 50: {
                ssToken2 = new ssToken(by, this.getNextInteger());
                break;
            }
            case 52: {
                ssToken2 = new ssToken(by, this.getNextDouble());
                break;
            }
            case 116: {
                ssToken2 = new ssToken(by, this.getNextInteger());
                break;
            }
            default: {
                ssToken2 = new ssToken(by);
            }
        }
        this.mark = this.object.getIndex();
        return ssToken2;
    }

    protected final void incrementTokenOffset() {
        this.object.reset(this.mark);
    }

    protected final ssToken peekAtNextToken() throws ssException {
        this.object.mark();
        ssToken ssToken2 = this.getNextToken();
        this.mark = this.object.getIndex();
        this.object.reset();
        return ssToken2;
    }

    protected final String getNextDataBlock() throws ssException {
        try {
            return this.object.getString(this.getNextInteger());
        }
        catch (EOFException eOFException) {
            throw new ssException(12, "end of file", "Data Block");
        }
        catch (IOException iOException) {
            throw new ssException(iOException.toString());
        }
    }

    protected final String getNextSymbol() throws ssException {
        int n = this.getNextInteger();
        return this.symbolTable.get(n);
    }

    protected final String getNextString() throws ssException {
        try {
            return this.object.getString(this.getNextInteger());
        }
        catch (EOFException eOFException) {
            throw new ssException(12, "end of file", "String");
        }
        catch (IOException iOException) {
            throw new ssException(iOException.toString());
        }
    }

    protected final byte getNextByte() throws ssException {
        try {
            return this.object.readByte();
        }
        catch (EOFException eOFException) {
            return -1;
        }
        catch (IOException iOException) {
            throw new ssException(iOException.toString());
        }
    }

    protected final int getNextInteger() throws ssException {
        try {
            return this.object.readInt();
        }
        catch (EOFException eOFException) {
            throw new ssException(12, "end of file", "Integer");
        }
        catch (IOException iOException) {
            throw new ssException(iOException.toString());
        }
    }

    protected final double getNextDouble() throws ssException {
        try {
            return this.object.readDouble();
        }
        catch (EOFException eOFException) {
            throw new ssException(12, "end of file", "Double");
        }
        catch (IOException iOException) {
            throw new ssException(iOException.toString());
        }
    }

    protected final void save(String string) throws ssException, Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string) + this.system.objectExtension());
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        dataOutputStream.writeShort(255);
        dataOutputStream.writeInt(0x1000000);
        dataOutputStream.writeInt(this.system.gProcessor);
        dataOutputStream.writeInt(this.object.length());
        dataOutputStream.write(this.object.getBuffer(), 0, this.object.length());
        dataOutputStream.writeInt(this.symbolTable.count());
        int n = 0;
        while (n < this.symbolTable.count()) {
            String string2 = this.symbolTable.get(n);
            dataOutputStream.writeInt(string2.length());
            dataOutputStream.write(string2.getBytes(), 0, string2.length());
            ++n;
        }
        dataOutputStream.close();
        fileOutputStream.close();
    }

    protected final void load(String string) throws ssException, Exception {
        FileInputStream fileInputStream = new FileInputStream(String.valueOf(string) + this.system.objectExtension());
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        short s = dataInputStream.readShort();
        if (s != 255) {
            throw new ssException(8, "object id", String.valueOf(s));
        }
        int n = dataInputStream.readInt();
        if (n != 0x1000000) {
            throw new ssException(8, "object version", String.valueOf(n));
        }
        int n2 = dataInputStream.readInt();
        if (this.system.gProcessor == 3 ? n2 != 3 : n2 == 3) {
            throw new ssException(8, "processor", String.valueOf(this.system.gProcessor));
        }
        int n3 = dataInputStream.readInt();
        this.object = new ssBuffer(n3);
        this.object.setLength(n3);
        int n4 = dataInputStream.read(this.object.getBuffer(), 0, n3);
        if (n4 != n3) {
            throw new ssException(8, "object length != bytes read", String.valueOf(n3) + " != " + n4);
        }
        this.symbolTable.clear();
        ssBuffer ssBuffer2 = new ssBuffer();
        int n5 = dataInputStream.readInt();
        int n6 = 0;
        while (n6 < n5) {
            n3 = dataInputStream.readInt();
            ssBuffer2.clear();
            ssBuffer2.setLength(n3);
            n4 = dataInputStream.read(ssBuffer2.getBuffer(), 0, n3);
            if (n4 != n3) {
                throw new ssException(8, "symbol length != bytes read", String.valueOf(n3) + " != " + n4);
            }
            this.symbolTable.add(ssBuffer2.toString());
            ++n6;
        }
        dataInputStream.close();
        fileInputStream.close();
        this.system.gCurrentLineNumber = 1;
    }
}

