/*
**  CFTP.C
**
**  Synchronous FTP client
**  Win32 console program.
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "wil.h"
#include "str.h"

#ifdef WIN32
#define USE_INS HINSTANCE
#define USE_PTR PSTR
#else
#define USE_INS HANDLE
#define USE_PTR LPSTR
#endif

/* globals */

#define BS          8
#define LF         10
#define CR         13
#define ESC        27

/* Buffer sizes: "read BIG, write SMALL" */

#define MAX_BUF  2048
#define RX_BUF   MAX_BUF
#define TX_BUF   512

#define MAX_STR   128

#define HALF_SEC  500
#define ONE_SEC  1000
#define TWO_SEC  2000
#define FIVE_SEC 5000
#define TEN_SEC 10000

#define FTP_PORT   21

///#define FIRST_DATA_PORT   19111
///#define LAST_DATA_PORT    19999

static short Chan = 0;                /* channel ID [0,31] */
static short FirstDataPort;           /* first data port to use */
static short LastDataPort;            /* last data port to use */
static char Temp[MAX_STR+8];          /* temporary buffer */
static char CmdBuffer[MAX_STR];       /* console command buffer */
static char InBuffer[MAX_BUF];        /* socket buffer for input */
static SOCKET ControlSock = 0;        /* control socket */
static SOCKET ListenSock = 0;         /* listen socket */
static SOCKET DataSock = 0;           /* data socket */
static ULONG  MyHostAddr = 0;         /* address of local host */
static char   MyDottedAddr[17];       /* dotted notation of <MyHostAddr> */
static short DataPort;                /* data port number */
static int   FileHandle = 0;          /* file handle */
static char  Filename[256] = "\0";    /* filename buffer */
static long  RxBytes;                 /* # bytes received */
static long  TxBytes;                 /* # bytes transmitted */
static char  HostName[MAX_STR];       /* server name */
static LPSTR ServerPtr;
static LPSTR UserPtr;                 /* user login name */
static LPSTR PassPtr;                 /* user login password */
///static int   Want2Tx;                 /* bytes want to send */
static int   ModeIsAscii = TRUE;
static ULONG HostAddr = 0;            /* HOST IP address */

/* display error text */

static void DisplayError(int Code, LPSTR Msg)
{wsprintf((LPSTR)Temp, "ERROR %d:", Code);
 printf("%s",Temp);
 if(Msg) printf("%s",Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,50);
    printf("%s\n",Temp);
   }
}

/* accept data connection */

static int FtpAccept(void)
{
 DataSock = wilAccept(ListenSock,(long)ONE_SEC);
 if((int)DataSock<0)
   {DisplayError((int)DataSock, "Accept:");
    return FALSE;
   }
 printf("Connection is accepted\n");
 return TRUE;
}

/* set up listener socket */

static int FtpListen(void)
{int Code;
 /* set up listener socket */
 ListenSock = wilTcpSocket();
 if((int)ListenSock<=0)
    {DisplayError((int)ListenSock, "wilListen:");
     return FALSE;
    }
 /* bind port address to socket */
 printf("Binding %s to port %d\n",(LPSTR)MyDottedAddr, DataPort);
 Code = wilBind(ListenSock, MyHostAddr, DataPort);
 if(Code<0)
    {DisplayError((int)Code, "wilBind:");
     return FALSE;
    }
 /* listen for connection attempt */
 Code = wilListen(ListenSock,1);
 if(Code<0)
   {DisplayError(Code, "wilListen:");
    return FALSE;
   }
 return TRUE;
}

/* get any outstanding incoming data from control socket */

static void GetControlIncoming(void)
{int Code;
 if(ControlSock==0) return;
 /* any more control socket response ? */
 while(wilDataIsReady(ControlSock,0))
   {Code = wilReadString(ControlSock,(LPSTR)InBuffer,MAX_BUF);
    if(Code<=0) break;
    printf("%s",(LPSTR)InBuffer);
   }
}

/* find local socket address */

ULONG GetAddrFromSock(SOCKET Socket, LPSTR DottedAddr)
{ULONG HostAddr;
 /* get address from socket */
 HostAddr = wilLocalSockAddr(Socket);
 wsprintf((LPSTR)DottedAddr,"%1ld.%1ld.%1ld.%1ld",
                     0x000000ff & (HostAddr>>24),
                     0x000000ff & (HostAddr>>16),
                     0x000000ff & (HostAddr>>8),
                     0x000000ff & (HostAddr) );
 wsprintf((LPSTR)Temp,"LocalSockAddr = %s (%lx) ",
                    (LPSTR)DottedAddr, HostAddr);
 printf("%s\n",Temp);
 return HostAddr;
}

/* send command (w/o CRLF) to FTP server and get response */

int FtpCommand(LPSTR Command, int WaitTime)
{int Code;
 /* send FTP command */
 sprintf(Temp,"%s\r\n",Command);
 Code = wilWriteString(ControlSock,(LPSTR)Temp);
 if(Code<0)
    {DisplayError(Code, "wilWriteSting:");
     return Code;
    }
 /* get FTP response */
 while(1)
   {Sleep(0);
    Code = wilWaitLine(ControlSock,(LPSTR)InBuffer, MAX_BUF, WaitTime, 500);
    /* end of input ? */
    if(Code==WIL_EOF) return 1;
    /* error ? */
    if(Code<0)
      {DisplayError(Code,"Read3: ");
       return Code;
      }
    /* anything there ? */
    if(Code>0)
      {/* display buffer */
       printf("R: %s",InBuffer);
       /* extract response code */
       Code = (int) wilParseDecimal((LPSTR)InBuffer);
       /* done if this is last line of coded text */
       if( (Code == 3) || (InBuffer[3]==' ') ) return Code;
      }
   }
}

int ConnectToServer(void)
{int Code;
 /* get host name */
 if(wilIsDotted((LPSTR)HostName))
   {/* already have IP address */
    HostAddr = wilMakeAddr((LPSTR)HostName);
   }
 else
   {/* ask DNS for IP address */
    HostAddr = wilGetHostAddr((LPSTR)ServerPtr,0);
    if(HostAddr==0)
      {printf("Cannot get IP addess\n");
       return -1;
      }
    }
 printf("[%x]\n", HostAddr);
 /* create socket */
 printf("Creating socket\n");
 ControlSock = wilTcpSocket();
 if((int)ControlSock<0)
    {DisplayError(Code,"wilTcpSocket fails:");
     return (int)ControlSock;
    }
 /* attempt to connect to remote host */
 printf("Connecting to %s...", ServerPtr);
 Code = wilConnect(ControlSock,HostAddr,FTP_PORT);
 if(Code<0)
   {DisplayError(Code,"wilConnect fails:");
    return Code;
   }
 /* wait up to 30 seconds for connection */
 if(wilIsConnected(ControlSock,30000)) printf("OK.\n");
 else
   {DisplayError(Code, "Cannot CONNECT:");
    return Code;
   }
 /* get local address if don't already have it */
 ///if(MyHostAddr == 0)
 ///    MyHostAddr = GetAddrFromSock(ControlSock, (LPSTR)MyDottedAddr);
 /* we are now connected. log on to FTP server */
 printf("Logging onto server...\n");
 /* send user name */
 sprintf(Temp,"USER %s",UserPtr);
 Code = FtpCommand((LPSTR)Temp,100);
 if(Code<0) return Code;
 /* send password */
 sprintf(Temp,"PASS %s",PassPtr);
 Code = FtpCommand((LPSTR)Temp,100);
 if(Code<0) return Code;
 printf("Logged on and ready for commands\n");
 /* any more control socket response ? */
 GetControlIncoming();
 return 1;
}

int WriteToSocket(LPSTR Ptr, int Size)
{int Code;
 int Want2Tx = Size;
 /* check socket again */
 if(!wilIsConnected(DataSock,2000L))
    {DisplayError(0, "DataSock");
     return WIL_TIMED_OUT;
    }
 while(Want2Tx > 0)
   {Sleep(0);
    Code = wilWriteSocket(DataSock, Ptr, Want2Tx);
    if(Code==0) return 1;
    if(Code==WIL_EOF) return 1;
    if(Code<0)
      {DisplayError(Code, "DataWrite");
       return Code;
      }
    /* Code > 0 */
    Want2Tx -= Code;
    TxBytes += (long)Code;
    /* advance pointer */
    Ptr += Code;
    /* display transmitted bytes */
    printf("%d bytes.\r",TxBytes);
   }
 return 1;
}

void Help(void)
{printf("Commands are:\n");
 printf("    HELP : Get help\n");
 printf("    QUIT : Quit program\n");
 printf("   ASCII : Set ASCII mode\n");
 printf("  BINARY : Set BINARY mode\n");
 printf("    LIST : List files\n");
 printf("     CWD : Change directory\n");
 printf(" GET xxx : Get file xxx\n");
 printf(" PUT xxx : Put file xxx\n");
}

void main(int argc, char *argv[])
{int i, n, Code;
 int BufLen;
 /* check arguments */
 if(argc!=4)
   {printf("Usage: CFTP server user password \n");
    printf("   Eg: CFTP 10.0.0.1 mike mike\n");
    Help();
    exit(1);
   }
 strcpy(HostName, argv[1]);
 ServerPtr = (LPSTR) HostName;
 UserPtr = (LPSTR) argv[2];
 PassPtr = (LPSTR) argv[3];
 /* compute data port range [5-bit channel|4-bit clock|5-bit port range] */
 n = (int) 0x0f & (GetCurrentTime() >> 13);  // maps to [0,15]
 FirstDataPort = 0x4000 | (Chan<<9) | (n<<5);
 LastDataPort =  FirstDataPort | 0x1f;
 DataPort = FirstDataPort;
 ///printf("[%d|%x|%x]\n",n,FirstDataPort,LastDataPort);
 ///Sleep(5000);

 /* attach WINSOCK */
 printf("%s","Attaching WINSOCK...");
 Code = wilAttach();
 printf("OK\n");
 if(Code<0) DisplayError(Code,"wilAttach fails:");
 else
   {wilGetDescription((LPSTR)Temp, MAX_STR);
    printf(" Description: %s\n",Temp);
    wilGetMyHostName((LPSTR)Temp, MAX_STR);
    printf("My Host Name: %s\n",Temp);
    /* get 1st IP addresses */
    MyHostAddr = wilGetMyHostAddr(0);
    wilMakeDotted(MyHostAddr,(LPSTR)MyDottedAddr,17);
    printf("My Host Addr: %s\n",(LPSTR)MyDottedAddr);
   }
 *InBuffer = '\0';
 *Temp = '\0';
 *CmdBuffer = '\0';
 ///printf("Ready for CONNECT command\n");
 if(ConnectToServer()<0)
   {wilRelease();
    exit(1);
   }
 Sleep(200);
 /* ready for user commands */
 while(1)
     {/* any more control socket response ? */
      GetControlIncoming();
      printf(">");
      n = scanf("%s",CmdBuffer);
      printf("%d[%s]\n", n, CmdBuffer);
      /* force command to upper case */
      BufLen = (int)strlen(CmdBuffer);
      for(i=0;i<BufLen;i++) CmdBuffer[i] = toupper(CmdBuffer[i]);

      if(strcmp(CmdBuffer,"QUIT")==0)
        {/* QUIT */
         if(ControlSock)
           {wilWriteString(ControlSock,"QUIT\r\n");
            Sleep(250);
           }
         if(ControlSock) wilCloseSocket(ControlSock,500);
         if(ListenSock) wilCloseSocket(ListenSock,500);
         if(DataSock) wilCloseSocket(DataSock,500);
         wilRelease();
         break;
        }

      if(strcmp(CmdBuffer,"ASCII")==0)
         {printf("Setting ASCII mode\n");
          ModeIsAscii = TRUE;
          FtpCommand((LPSTR)"TYPE A",100);
          continue;
         }

      if(strcmp(CmdBuffer,"BINARY")==0)
         {printf("Setting BINARY mode\n");
          ModeIsAscii = FALSE;
          FtpCommand((LPSTR)"TYPE I",100);
          continue;
         }

      if(strcmp(CmdBuffer,"LIST")==0)
         {GetControlIncoming();
          /* transmit PORT command */
          if(++DataPort>LastDataPort) DataPort = FirstDataPort;
          sprintf(Temp,"PORT %s,%1d,%1d", (LPSTR)MyDottedAddr,
                      (DataPort>>8), (0x00ff&DataPort) );
          /* replace dots with commas in PORT command */
          for(i=5;i<=16;i++) if(Temp[i]=='.') Temp[i] = ',';
          Code = FtpCommand((LPSTR)Temp,100);
          if(Code<0) continue;

          /* PORT command was successful */
          if(!FtpListen()) break;

          /* ask server to send list of files */
          Code = FtpCommand((LPSTR)"LIST",500);
          if(Code<0) continue;

          /* wait for incoming on listener socket */
          if(wilDataIsReady(ListenSock,TEN_SEC))
             {/* accept connection [creates DataSock] */
              FtpAccept();
             }
          else
             {/* nothing on data socket yet */
              printf("Listener socket is silent . . .");
              wilCloseSocket(ListenSock,500);
              continue;
             }

          printf("Reading data from data socket...\n");
          /* data socket has data */
          while(1)
             {/* read next line from server */
              if(!wilDataIsReady(DataSock,1000)) break;
              Code = wilReadLine(DataSock,(LPSTR)InBuffer,MAX_BUF);
              if(Code<=0) break;
              /* display data just read */
              printf("%s",(LPSTR)InBuffer);
             }
          *InBuffer = '\0';
          printf("[END]");
          /* close listener & data socket */
          wilCloseSocket(DataSock,500); DataSock = 0;
          wilCloseSocket(ListenSock,500); ListenSock = 0;
          /* any more control socket response ? */
          GetControlIncoming();
          continue;
         }

      if(strcmp(CmdBuffer,"HELP")==0)
        {Help();
         continue;
        }

      if(strcmp(CmdBuffer,"GET")==0)
        {scanf("%s",CmdBuffer);
         strcpy(Filename, CmdBuffer);
         /* open file for write */
         FileHandle = _lcreat(Filename,0);
         if(FileHandle<0)
           {printf("Cannot create '%s'", Filename);
            continue;
           }
         printf("Saving to file '%s'\n", Filename);
         GetControlIncoming();
         /* send PORT command */
         if(++DataPort>LastDataPort) DataPort = FirstDataPort;
         sprintf(Temp,"PORT %s,%1d,%1d", (LPSTR)MyDottedAddr,
                      (DataPort>>8), (0x00ff&DataPort) );
         /* replace dots with commas in PORT command */
         for(i=5;i<=16;i++) if(Temp[i]=='.') Temp[i] = ',';
         Code = FtpCommand((LPSTR)Temp,100);
         if(Code<0) continue;

         /* PORT command was successful */
         if(!FtpListen()) break;

         /* ask server to send file */

         sprintf(Temp,"RETR %s",Filename);
         Code = FtpCommand((LPSTR)Temp,500);
         if(Code<0) continue;

         /* wait for incoming on listener socket */
         if(wilDataIsReady(ListenSock,TEN_SEC))
           {/* accept connection [creates DataSock] */
            FtpAccept();
           }
         else
           {/* nothing on data socket yet */
            printf("Listener socket is silent . . .");
            wilCloseSocket(ListenSock,500);
            continue;
           }
         /* get incoming data */
         while(1)
           {/* got incoming ? */
            if(!wilDataIsReady(DataSock,1000)) break;
            Code = wilReadSocket(DataSock,(LPSTR)InBuffer, MAX_BUF);
            if(Code==WIL_EOF)
              {/* no more data */
               printf("%d bytes received.\n", RxBytes);
               _lclose(FileHandle);
               /* close listener & data socket */
               wilCloseSocket(DataSock,500); DataSock = 0;
               wilCloseSocket(ListenSock,500); ListenSock = 0;
               /* any more control socket response ? */
               GetControlIncoming();
               break;
              }
            /* Code > 0, so count received bytes */
            RxBytes += (long)Code;
            printf("%d bytes\r",RxBytes);
            /* save buffer to disk */
            Code = _lwrite(FileHandle,(LPSTR)InBuffer,Code);
            if(Code<0)
              {printf("Error %d returned writing to %s",
                       Code, Filename);
               _lclose(FileHandle);
              }
           }
         continue;
        }

      if(strcmp(CmdBuffer,"PUT")==0)
        {scanf("%s",CmdBuffer);
         strcpy(Filename, CmdBuffer);
         /* open file for read */
         FileHandle = _lopen(Filename,OF_READ|OF_SHARE_DENY_WRITE);
         if(FileHandle<0)
           {printf("Cannot open '%s'", Filename);
            continue;
           }
         printf("Reading file '%s'\n", Filename);
         GetControlIncoming();

         /* send PORT command */
         if(++DataPort>LastDataPort) DataPort = FirstDataPort;
         sprintf(Temp,"PORT %s,%1d,%1d", (LPSTR)MyDottedAddr,
                      (DataPort>>8), (0x00ff&DataPort) );
         /* replace dots with commas in PORT command */
         for(i=5;i<=16;i++) if(Temp[i]=='.') Temp[i] = ',';
         Code = FtpCommand((LPSTR)Temp,100);
         if(Code<0) continue;

         /* PORT command was successful */
         if(!FtpListen()) break;

         /* ask server to store file */
         sprintf(Temp,"STOR %s",Filename);
         Code = FtpCommand((LPSTR)Temp,500);
         if(Code<0) continue;

         /* wait for incoming on listener socket */
         if(wilDataIsReady(ListenSock,TEN_SEC))
           {/* accept connection [creates DataSock] */
            FtpAccept();
           }
         else
           {/* nothing on data socket yet */
            printf("Listener socket is silent . . .");
            wilCloseSocket(ListenSock,500);
            continue;
           }

         while(1)
           {/* read from disk */
            Sleep(0);
            Code = _lread(FileHandle,(LPSTR)InBuffer,TX_BUF);
            if(Code<=0)
              {///printf("[EOF]\n");
               _lclose(FileHandle);
               printf("%ld bytes sent.\n", TxBytes);
               /* close listener & data socket */
               wilCloseSocket(DataSock,500); DataSock = 0;
               wilCloseSocket(ListenSock,500); ListenSock = 0;
               break;
              }
            /* Code>0: write to socket */
            if(WriteToSocket((LPSTR)InBuffer, Code)<0) break;
           }
         /* any more control socket response ? */
         GetControlIncoming();
         continue;
        }
      /* don't recognize commands */
      printf("Cannot recognize command %s\n", CmdBuffer);
      printf("Type HELP for help\n");
     }
}



