/* cons.c
**
** Windows 95/NT console mode I/O functions.
*/

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "cons.h"

/* return TRUE if user typed key */

int KeyPress(HANDLE Handle)
{DWORD NbrRead;
 INPUT_RECORD InputEvent;
 PeekConsoleInput(Handle,&InputEvent,1,&NbrRead);
 if(NbrRead==0) return FALSE;
 if( (InputEvent.EventType!=KEY_EVENT) ||
     (InputEvent.Event.KeyEvent.bKeyDown==FALSE) ||
     (InputEvent.Event.KeyEvent.uChar.AsciiChar==0) )
   {/* trash this event */
    ReadConsoleInput(Handle, &InputEvent, 1, &NbrRead);
    return FALSE;
   }
 /* character ready to read */
 return TRUE;
}

/* get input character */

char GetChar(HANDLE Handle)
{char TheChar = '\0';
 DWORD  BytesRead;
 ReadFile(Handle, &TheChar, 1, &BytesRead, 0);
 return TheChar;
}

/* write character to console */

void PutChar(HANDLE Handle, char TheChar)
{DWORD BytesWritten;
 WriteFile(Handle, &TheChar, 1, &BytesWritten, 0);
}

/* write string to console */

void PutString(HANDLE Handle, char *TheString)
{DWORD BytesWritten;
 WriteFile(Handle, TheString, strlen(TheString), &BytesWritten, 0);
}

/* write line to console */

void PutLine(HANDLE Handle, char *TheString)
{DWORD BytesWritten;
 WriteFile(Handle, TheString, strlen(TheString), &BytesWritten, 0);
 WriteFile(Handle, "\r\n", 2, &BytesWritten, 0);
}

 