/*
**  PING.C
**
**  Synchronous FTP client
**  Win32 console program.
*/

#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "wil.h"

#define MAX_STR 128

static char  Temp[128];

/* display error text */

static void DisplayError(int Code, LPSTR Msg)
{wsprintf((LPSTR)Temp, "ERROR %d:", Code);
 printf("%s",Temp);
 if(Msg) printf("%s",Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,50);
    printf("%s\n",Temp);
   }
}

void Help(void)
{printf("Usage: PING server\n");
 printf("   Eg: PING 10.0.0.1\n");
}

void main(int argc, char *argv[])
{int Code;
 ULONG AddrVal;
 LPSTR AddrPtr;
 USHORT TxSeq = 123;
 USHORT RxSeq;
 USHORT Port = 1234;
 DWORD TimeMark;
 /* check arguments */
 if(argc!=2)
   {Help();
    exit(1);
   }
 AddrPtr = (LPSTR) argv[1];
 if( ((*AddrPtr)<'0') ||((*AddrPtr)>'9') )
   {printf("Error: Must specify IP address\n");
    Help();
    exit(1);
   }
 AddrVal = wilMakeAddr(AddrPtr);
 /* attach WINSOCK */
 Code = wilAttach();
 if(Code<0) DisplayError(Code,"wilAttach:");
 TimeMark = GetCurrentTime();
 Code = wilPing(AddrVal,(ULONG)3000,Port,TxSeq);
 if(Code>=0)
    {/* time includes opening and closing the socket */
     printf("Time = %ld mSec\n", GetCurrentTime()-TimeMark);
     //printf("RxSeq = %d\n", (USHORT)Code);
     RxSeq = (USHORT)Code;
     if(RxSeq!=TxSeq) printf("ERROR: RxSeq = %d, TxSeq = %d\n", RxSeq, TxSeq);
   }
 else DisplayError(Code,"wilPing:");
}



