#include <winsock.h>

#include "WSAError.h"

const char *WSAGetErrorText(int iError)
{
	switch (iError)
	{
	case WSAEINTR:
		return "interrupted function call";
	case WSAEBADF:
		return "BADF";
	case WSAEACCES:
		return "permission denied";
	case WSAEFAULT:
		return "bad address";
	case WSAEINVAL:
		return "invalid argument";
	case WSAEMFILE:
		return "too many open files";
	case WSAEWOULDBLOCK:
		return "resource temporarily unavailable";
	case WSAEINPROGRESS:
		return "operation now in progress";
	case WSAEALREADY:
		return "operation already in progress";
	case WSAENOTSOCK:
		return "socket operation on non-socket";
	case WSAEDESTADDRREQ:
		return "destination address required";
	case WSAEMSGSIZE:
		return "message too long";
	case WSAEPROTOTYPE:
		return "protocol wrong type for socket";
	case WSAENOPROTOOPT:
		return "bad protocol option";
	case WSAEPROTONOSUPPORT:
		return "protocol not supported";
	case WSAESOCKTNOSUPPORT:
		return "socket type not supported";
	case WSAEOPNOTSUPP:
		return "operation not supported";
	case WSAEPFNOSUPPORT:
		return "protocol family not supported";
	case WSAEAFNOSUPPORT:
		return "address family not supported by protocol family";
	case WSAEADDRINUSE:
		return "address already in use";
	case WSAEADDRNOTAVAIL:
		return "cannot assign requested address";
	case WSAENETDOWN:
		return "network is down";
	case WSAENETUNREACH:
		return "network is unreachable";
	case WSAENETRESET:
		return "network dropped connection on reset";
	case WSAECONNABORTED:
		return "software caused connection abort";
	case WSAECONNRESET:
		return "connection reset by peer";
	case WSAENOBUFS:
		return "no buffer space available";
	case WSAEISCONN:
		return "socket is already connected";
	case WSAENOTCONN:
		return "socket is not connected";
	case WSAESHUTDOWN:
		return "cannot send after socket shutdown";
	case WSAETOOMANYREFS:
		return "TOOMANYREFS";
	case WSAETIMEDOUT:
		return "connection timed out";
	case WSAECONNREFUSED:
		return "connection refused";
	case WSAELOOP:
		return "LOOP";
	case WSAENAMETOOLONG:
		return "NAMETOOLONG";
	case WSAEHOSTDOWN:
		return "host is down";
	case WSAEHOSTUNREACH:
		return "no route to host";
	case WSAENOTEMPTY:
		return "NOTEMPTY";
	case WSAEPROCLIM:
		return "too many processes";
	case WSAEUSERS:
		return "USERS";
	case WSAEDQUOT:
		return "DQUOT";
	case WSAESTALE:
		return "STALE";
	case WSAEREMOTE:
		return "REMOTE";
	case WSAEDISCON:
		return "graceful shutdown in progress";
	case WSASYSNOTREADY:
		return "network subsystem is unavailable";
	case WSAVERNOTSUPPORTED:
		return "winsock.dll version out of range";
	case WSANOTINITIALISED:
		return "successful WSAStartup not yet performed";
	case WSAHOST_NOT_FOUND:
		return "host not found";
	case WSATRY_AGAIN:
		return "non-authoritative host not found, try again";
	case WSANO_RECOVERY:
		return "non-recoverable error";
	case WSANO_DATA:
		return "valid name, no data record of requested type";
	case  WSANO_ADDRESS:
		return "no address, look for MX record";
	}
	return "\0";
}