//
//	$Id: Bitlist.h 1.4 2000/03/21 20:15:55 Y.Roumazeilles Exp $
//
//	Copyright (C) 1992-93-94-95-96-97-98-99 Yves Roumazeilles
//	All rights reserved.
//


#ifndef	__BITLIST_H__
#define	__BITLIST_H__	

#include	<memory.h>
#include	<string.h>

/* Boolean data type declarations */
/*typedef	int	BOOL;*/
#ifndef	TRUE
# define	TRUE	1
#endif
#ifndef	FALSE
# define	FALSE	0
#endif

#ifndef	T_BASE_TYPE
# define	T_BASE_TYPE	unsigned long
#endif
#define	SZ_BASE_TYPE		sizeof(T_BASE_TYPE)
#define	BITS_BASE_TYPE		(SZ_BASE_TYPE*8)
#define	NUM_BASE_ELEM(x)	(x)->Size


typedef	struct tagBList {
	int			Size;
	int			iWordSize;
	BOOL			bAllocated;
#ifdef	NUMTAG
	int			iTag;		/* temporary numbered tag */
#endif
#ifdef	WINVER
	HANDLE			hBits;
	T_BASE_TYPE FAR*	Bits;
#else
	T_BASE_TYPE*		Bits;
#endif
#ifdef	BL_CHECK
	long			lTest;		/* temporary test pattern location */
#endif
} BLIST;
#ifdef	WINVER
typedef	BLIST*		PBLIST;
typedef	BLIST FAR*	LPBLIST;
#else
typedef	BLIST*		PBLIST;
typedef	BLIST*		LPBLIST;
#endif


/* Declaration of basic BitList operations */

#define	INDEX_BIT(n)	((n) / BITS_BASE_TYPE)
#define	MASQUE_BIT(n)	(1L << ((n) % BITS_BASE_TYPE))


#define	BSET(t, n)	(t).Bits[INDEX_BIT(n)] |= MASQUE_BIT(n)
#define	BCHG(t, n)	(t).Bits[INDEX_BIT(n)] ^= MASQUE_BIT(n)
#define	BCLR(t, n)	(t).Bits[INDEX_BIT(n)] &= ~MASQUE_BIT(n)
#define	BTST(t, n)	((t).Bits[INDEX_BIT(n)] & MASQUE_BIT(n))
#define	BSET_unlocked(t, n)	BitListLock(&t);\
				(t).Bits[INDEX_BIT(n)] |= MASQUE_BIT(n);\
				BiTListUnlock(&t)
#define	BCHG_unlocked(t, n)	BitListLock(&t);\
				(t).Bits[INDEX_BIT(n)] ^= MASQUE_BIT(n);\
				BiTListUnlock(&t)
#define	BCLR_unlocked(t, n)	BitListLock(&t);\
				(t).Bits[INDEX_BIT(n)] &= ~MASQUE_BIT(n);\
				BiTListUnlock(&t)
#define	BTST_unlocked(t, n)	BitListLock(&t);\
				((t).Bits[INDEX_BIT(n)] & MASQUE_BIT(n));\
				BiTListUnlock(&t)

#ifdef	WINVER
# define	BLCALL	FAR
#else
# define	BLCALL	
#endif
extern BOOL BLCALL	BitListIsDebug( void );

extern void BLCALL	BitListDebugOutput(LPBLIST x);
extern void BLCALL	BitListClr(LPBLIST x)/*@modifies x->Bits@*/;
extern void BLCALL	BitListSet(LPBLIST x)/*@modifies x@*/;
extern void BLCALL	BitListChg(LPBLIST x)/*@modifies x@*/;
extern BOOL BLCALL	BitListCtorSet(/*@null@*/ /*@out@*/ /*@returned@*/LPBLIST x, int n)/*@modifies *x@*/;
extern BOOL BLCALL	BitListCtorClr(/*@null@*/ /*@out@*/ /*@returned@*/LPBLIST x, int n)/*@modifies *x@*/;
#define	BitListCtor(x,n)	BitListCtorClr(x,n);
extern BOOL BLCALL	BitListEmpty(/*@null@*/ /*@out@*/ LPBLIST x)/*@modifies *x@*/;
extern void BLCALL	BitListCopy(LPBLIST x, LPBLIST y)/*@modifies *x@*/;
extern BOOL BLCALL	BitListCopyCtor(/*@null@*/ /*@out@*/ /*@returned@*/LPBLIST x, LPBLIST y, int n)/*@modifies *x@*/;
extern void BLCALL	BitListLShift(LPBLIST x, int n)/*@modifies x->Bits@*/;
extern void BLCALL	BitListRShift(LPBLIST x, int n)/*@modifies x->Bits@*/;
extern void BLCALL	BitListOr(LPBLIST x, LPBLIST y)/*@modifies x->Bits@*/;
extern void BLCALL	BitListCopyOr(LPBLIST x, LPBLIST y, LPBLIST z)/*@modifies *x@*/;
extern void BLCALL	BitListAnd(LPBLIST x, LPBLIST y)/*@modifies x->Bits@*/;
extern void BLCALL	BitListCopyAnd(LPBLIST x, LPBLIST y, LPBLIST z)/*@modifies *x@*/;
extern void BLCALL	BitListAndNot(LPBLIST x, LPBLIST y)/*@modifies x->Bits@*/;
extern void BLCALL	BitListOrNot(LPBLIST x, LPBLIST y)/*@modifies x->Bits@*/;
extern void BLCALL	BitListNot(LPBLIST x)/*@modifies x->Bits@*/;
extern void BLCALL	BitListAdd(LPBLIST x, LPBLIST y)/*@modifies x->Bits@*/;
extern void BLCALL	BitListSub(LPBLIST x, LPBLIST y)/*@modifies x->Bits@*/;
extern void BLCALL	BitListMultiply(LPBLIST x, LPBLIST y)/*@modifies x->Bits@*/;	/* not implemented */
extern void BLCALL	BitListDivide(LPBLIST x, LPBLIST y)/*@modifies x->Bits@*/;	/* not implemented */
extern BOOL BLCALL	BitListEqual(LPBLIST x, LPBLIST y)/*@modifies nothing@*/;
extern BOOL BLCALL	BitListEqualZero(LPBLIST x)/*@modifies nothing@*/;
extern int BLCALL	BitListCompare(LPBLIST x, LPBLIST y)/*@modifies nothing@*/;
#ifdef	WINVER
extern BOOL BLCALL	BitListLock(LPBLIST x)/*@modifies nothing@*/;
extern BOOL BLCALL	BitListUnlock(LPBLIST x)/*@modifies nothing@*/;
#else
# define	BitListLock(x)
# define	BitListUnlock(x)
#endif

#endif	/* __BITLIST_H__ */
