/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <libp.h>

extern int _abterm;

FILE *_pstreams[_NFILE_];
char *_filenames[_NFILE_];
int maxfiles;

FILE *__stdin ;
FILE *__stdout ;
FILE *__stderr ;
FILE *__stdaux ;
FILE *__stdprn ;
#pragma startup __fileinit 139
#pragma rundown __closeall 11

void __fileinit(void)
{
	_ll_init();
   __stdin = __getStream(0) ;
   __stdout = __getStream(1) ;
   __stderr = __getStream(2) ;
}

void __closeall(void)
{
	int i;
   if (!_abterm) {
      for (i=maxfiles-1; i >=3; i--) {
			fclose(_pstreams[i]);
		}
      maxfiles = 3 ;
   }
}
int _basefclose(FILE *stream,int release)
{
	int rv,i;
	if (stream->token == FILTOK && maxfiles) {
		int tempflag = stream->istemp;
		char *fname;
		fflush(stream);
		stream->token = (short)-1;
		if (maxfiles > 1) {
         _ll_enter_critical() ;
			for (i=0; i < maxfiles; i++)
				if (_pstreams[i] == stream) {
					fname = _filenames[i];
					_pstreams[i] = _pstreams[maxfiles-1];
					_filenames[i] = _filenames[maxfiles-1];
					break ;
				}
         _ll_exit_critical() ;
			maxfiles--;
		}
		rv = _ll_close(stream->fd);
		if (tempflag && fname)
			rv &= remove(fname);
		if (fname)
			free(fname);
		if (stream->flags & _F_BUF)
			free(stream->buffer);
		if (release)
			free(stream);
		if (!rv)
			return 0;
		else {
			return EOF;
		}
	}
	else {
		errno = _dos_errno = ENOENT;
		return EOF;
	}
}
int fclose(FILE *stream)
{
	return _basefclose(stream,1);
}