/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>

extern int _osenv ;

static CRITICAL_SECTION critical ;
int errno,_dos_errno;
unsigned char _osmajor, _osminor ;

#pragma startup checkver 19

static void checkver(void)
{
   OSVERSIONINFO versionInfo ;
   versionInfo.dwOSVersionInfoSize = sizeof(versionInfo) ;
   GetVersionEx(&versionInfo) ;
   _osmajor = versionInfo.dwMajorVersion ;
   _osminor = versionInfo.dwMinorVersion ;
}
struct tm *_ll_gettime(struct tm *tm2)
{
	SYSTEMTIME timex ;
	GetLocalTime(&timex) ;

  tm2->tm_sec = timex.wSecond;
  tm2->tm_min = timex.wMinute;
  tm2->tm_hour = timex.wHour;

  tm2->tm_mday = timex.wDay;
  tm2->tm_mon = timex.wMonth-1;
  tm2->tm_year = timex.wYear-1900;
	return tm2;
}
int _ll_ticks(void)
{
   return GetTickCount() ;
}
void sleep(int seconds)
{
   Sleep(seconds * 1000) ;  
}
int _ll_getenv(char *buf, int id)
{
	int count = 0 ;
	int rv ;
	char *env = _osenv ;
	if (buf) {
		while (id--) {
			while (*env) env++ ;
			if (*++env == 0)
				return 0;
		}
		strcpy(buf,env) ;
		return (int)env ;
	} else {
		if (!*env)
			return 0 ;
		do {
			count++ ;
			while (*env) env++ ;
			env++ ;
		} while (*env) ;
		return count ;
	}
}	

#pragma startup startcritical 120

static void startcritical(void)
{
   InitializeCriticalSection(&critical) ;
}
#pragma rundown stopcritical 1
static void stopcritical(void)
{
   DeleteCriticalSection( &critical) ;
}

void _ll_enter_critical(void)
{
   EnterCriticalSection(&critical) ;
}

void _ll_exit_critical(void)
{
   LeaveCriticalSection(&critical) ;
}