

;              ciforth : a generic I86 ISO FORTH by HCC FIG

; $Id: ci86.gnr,v 4.15.2.1 2003/03/26 13:54:43 albert Exp $
; Copyright (2000): Albert van der Horst by GNU Public License
;
;HCC FIG Holland : Hobby Computer Club, Forth Interest Group  Holland
        ;  66,106
 ;   ciforth $Revision: 4.15.2.1 $
;
; For the generic system (to generate ciforth in an other configuration than this one):
;     http://home.hccnet.nl/a.w.m.van.der.horst/ci86gnr.html
;
; If this is a configured assembly file, it should be accompanied with configured
; documentation (texinfo, ps, html.)
; WITHOUT THE DOCUMENTATION: GIVE UP! GET THE REAL THING!
; You have a configured system, if there are NO curly brackets on the next line.
;                          
;
; Configuration of this particular version:
; 32 -bits protected mode 
; running under DPMI (OS/2 or MS-Windows)
; with modern MSDOS I/O  
  
; Normally ciforth doesn't observe ISO >IN.
; Contains :
; (there may be no items here.)
;        Security words
;         Loadable words, i.e. all of ISO CORE, more than is needed
;           for a self contained kernel.
; A field in the header to point to source
;
 ;
; This is a NASM version of ciforth created by ``m4'' from the generic listing.
; It can be assembled using ``nasm'' obtainable via :
; Source: ftp://ftp.us.kernel.org/pub/software/devel/nasm/source/
; URL: http://www.cryogen.com/Nasm/

; This version can be assembled on a Linux system in behalf of a
;   version by
;   nasm -fbin ciforth.asm -o ciforth.com
; For assembling on other systems where nasm is available see the
; documentation of nasm.

%if 0
        A generic version of ISO FORTH for IBM type standard PC's by
                Albert van der Horst

                in cooperation with
                HCC Forth user group
                The Netherlands
                www.forth.hccnet.nl

              based on
              FIG-FORTH
   implemented by:  Charlie Krajewski
                    205 ( BIG ) Blue Rd.
                    Middletown, CT  06457

  The listing has been made possible by the
  prior work of:
               Thomas Newman, Hayward, Ca.

 : other_acknowledgements
         John_Cassidy
         Kim_Harris
         George_Flammer
         Robert_D._Villwock ;

 : for tools
         Richard M. Stallman
         Linus Torvalds

No one who programs with FORTH can afford to be without:
  "Starting Forth  by Leo Brodie" and "Thinking Forth by Leo Brodie".
   Both out of print.

This Forth is a descendant in the 300+ (RCS)- generations from fig-Forth.

For nostalgic reasons the following comment has never been removed:
   Although there is much to be said for typing in your own
   listing and getting it running, there is much to be said
   not typing in your own listing.  If you feel that 100+
   pages of plinking is nutty, contact me for availability
   of a disc with source & executable files.  Obtainable at
   a bargain basement price, prepare yourself for bargain
   basement support.

All publications of the FORTH Interest Group are public domain.
They may be further distributed by the inclusion of this
credit notice:
               This publication has been made available by:

               FORTH Interest Group
               P.O. Box 1105
               San Carlos, Ca.  94070
[I feel obliged to keep this last one in (AH). Note that although it is
based on fig-Forth no stone is left unturned.]
%endif
        ;
; ########################################################################################
;                       PREPARATION (no code)
; ########################################################################################
FIGREL  EQU     4       ; FIG RELEASE #
FIGREV  EQU     0       ; FIG REVISION #
USRVER  EQU     0      ; USER VERSION NUMBER, a digit now
;
;      VERY ELEMENTARY .
CW      EQU     4    ; Size of a cell in Forth, not in the bootcode.
ERRORSCREEN EQU     48    ; Screen where the error messages start.
;
;      MEMORY LAYOUT.
; Normally this is specified at the m4 configuration level.
; For a configured system these values can be changed at this single place. 
NBUF    EQU     8    ; No. of buffers, or screens 
KBBUF   EQU     1024      ; Data bytes per disk buffer
US      EQU     40H*CW  ; User variable space
EM      EQU     400000H     ; Where the memory ends w.r.t. ORIG.
EMP     EQU     (EM-1)/1000H+1 ; Number of pages.
RTS     EQU     10000H    ; Return stack & terminal input buffer
;

;
;      ASCII CHARACTER EQUIVALENTS
;
ABL     EQU     ' '     ; SPACE
ACR     EQU     0DH     ; CR
ASO     EQU     '['     ; SQUARE BRACKET OPEN 
ASC     EQU     ']'     ; SQUARE BRACKET CLOSE 
ADOT    EQU     '.'     ; PERIOD
ALF      EQU     0AH     ; LINE FEED, USED INTERNALLY AS
                        ; LINE ENDER
AFF      EQU     0CH     ; FORM FEED
BELL    EQU     07H     ; ^G
BSIN    EQU     08H     ; INPUT DELETE CHARACTER
BSOUT   EQU     08H     ; OUTPUT BACKSPACE ( ^H )
;
;      HEADER RELATED EQUATES
B_DUMMY   EQU     01H     ; dea is dummy, from vocabulary link
B_INVIS   EQU     02H     ; dea is invisible, "smudged".
B_IMMED   EQU     04H     ; dea is a immediate.
B_DENOT   EQU     08H     ; dea is a denotation.
C_HOFFSET EQU     0       ; Offsets of code field in cells, w.r.t. dea
D_HOFFSET EQU     1       ; Same for data field
F_HOFFSET EQU     2       ; Same for flag field
L_HOFFSET EQU     3       ; Same for link field
N_HOFFSET EQU     4       ; Same for name field
S_HOFFSET EQU     5       ; Same for source field
PH_OFFSET EQU     6   ; Past header field: Start of data area. 
BD_OFFSET EQU     6+1 ; Start of BODY for CREATEd word.
;


BUF1    EQU     EM-(KBBUF+2*4)*NBUF      ; FIRST DISK BUFFER
STRUSA  EQU     BUF1-US         ; User area
 ;  
; 

STRTIB  EQU     STRUSA-RTS      ; Start return stack area
                                ; Under this : data stack
INITR0  EQU     STRUSA         ; Grows down
INITS0  EQU     STRTIB          ; Grows down
 ;  

;

;

BPS     EQU     512             ;Bytes/sector, common to all of MSDOS
SPB     EQU     KBBUF/BPS
;
;

;
;


;DPMI segment defines.
;We can't aim for better than level privilege level 3.
BITS32_TOGGLE EQU 040H   ; The Big (and Granularity, not yet) bits are complemented
                            ; on switching to 32 bits mode in 6th byte.
CODE_TOGGLE EQU 08H   ; Toggle between code and data, in the 5th byte.
 ; 
; 

; 

create  EQU     3C00H
open    EQU     3D00H
close   EQU     3E00H
read    EQU     3F00H
write   EQU     4000H
delete  EQU     4100H
lseek   EQU     4200H
; 

; 

; ########################################################################################
;                      BOOTCODE    (optional, always real mode)
; ########################################################################################

; All bootcode must be relocatable and its memory references absolute.
; Not for the sake of booting, but to allow MSDOS to start the program too. 

        ;    SEGMENT PARA PUBLIC 'CODE'
        ; CS:;,DS:;,SS:;,ES:;
    
    
ORG0:

; 

; 
; 
NOBOOT:         ; Skip till here if not booting.

; 
ENDBOOT:

; ########################################################################################
;                       ADJUST CODE SEGMENT REGISTER (still real mode)
; ########################################################################################
; Required start of .COM program.

; ########################################################################################
;                       MOVE CODE TO ITS PLACE (still real mode)
; ########################################################################################
;
; ########################################################################################
;                       FILL GDT AND SWITCH TO PROTECTED MODE/32 BITS (optional)
; ########################################################################################
; 

; 
; 

; 
; ########################################################################################
;                       PREPARE FOR USING DPMI (OPTIONAL)
; ########################################################################################


; Required start of .COM program.
        ORG     100H
ORIG:                         ; Accommodate also .exe files
        MOV     BX, (((100H + TEXTEND-ORIG)-1)|0FFFFH)/10H+1 ;Leave at least 64K.
        MOV     AH,4Ah              ;Modify memory allocation
        INT     21h
; These are real mode descriptors !
        MOV      WORD[SaveCS],CS           ; Once and for all
        MOV      WORD[SaveDS],DS
        MOV      WORD[SaveES],ES           ; Still pointing to PSP (!?)
 ; 

        MOV     [LOADEXEC+4], DS
        MOV     [LOADEXEC+8], DS
        MOV     [LOADEXEC+12], DS

;Must be done before switching to protected mode.
        MOV     AX, [ES:2CH]
        MOV     [USINI+(CW*(31))],AX   ;Remember ENV pointer.
        MOV     [LOADEXEC], AX
 ; 


;
; Check to see if DPMI is available, and make the switch if it is
; If one is, the stat info is stored.
            MOV     BL,1
            MOV     AX,1687h            ;Get DPMI host address
            INT     2Fh                 ;Multiplex interrupt

            CMP     AX,0                ;Was it there?
            JNE     ERRMSG              ;Nope, so exit

            AND     BL,1                ;Test bit 1 (32-bit OK?)
;            MOV     [Flag32],BL
;            MOV     [ProcType],CL
;            MOV     [VerNum],DX
            MOV     [DPMIentry+0],DI
            MOV     [DPMIentry+2],ES
            PUSH    SI                  ;Allocation.

            MOV     AX,0                ;In case no memory needed
            POP     BX                  ;Get number of paragraphs needed by host
            CMP     BL,0                ;Any allocation needed?
            JE      Plunge              ;No, so continue
            MOV     AH,48h              ;Allocate memory
            INT     21h
            MOV     BL,2
            JC      ERRMSG              ;Could not allocate

Plunge:     MOV     ES,AX
;Setting this bit, doesn't mean you arrive in a 32 bit segment!
            MOV     AX,  1 
            CALL FAR [DPMIentry] ;Switch to protected mode
; From here to where the assembler switches to protected mode,
; code must be 16/32 bit independant.
            MOV     BL,3
            JC      ERRMSG      ;still in real mode

            JMP     SHORT DPMISUCCESS
; Data used by check DPMI.

;Flag32      DB      00
;ProcType    DB      00
;VerNum      DW      0000
DPMIentry   DW      0000,0000
MEM_HANDLESI: DW     0000
MEM_HANDLEDI: DW     0000

;Error-- called from diverse places.
ERRMSG:
           MOV     AL, BL ; Use the infamous errorlevel.
           MOV     AH,4CH
           INT     21H
; The error number is patched!
;EMsg       DB      'ciforth DPMI : ERROR #',ACR,ALF
;EMsgS      EQU     $-EMsg


; If we reach this point, we are operating in protected mode
DPMISUCCESS:
; -------------- First and for all: save --------
            MOV      WORD[Save_CS_PR],CS
            MOV      WORD[Save_DS_PR],DS
            MOV      WORD[Save_ES_PR],ES
; -------------- Get a new segment for our Forth to ES --------
            MOV     AX,0000H            ;A new selector.
            MOV     CX,1
            INT     31H
            MOV     BL,4
            MOV     ES,AX
            JC      ERRMSG

            MOV     AX,0501H            ;Allocate memory
            MOV     BX, EM/10000H
            MOV     CX, EM & 0FFFFH
            INT     31H
            PUSH    CX
            PUSH    BX
            MOV     [MEM_HANDLESI],SI
            MOV     [MEM_HANDLEDI],DI
            MOV     BL,4
            MOV     CX,AX
            JC      ERRMSG

            MOV     AX,0007H            ;Set base address.
            MOV     BX,ES
            POP     CX
            POP     DX
            INT     31H
            MOV     BL,6
ERRMSG2:    JC      ERRMSG

            MOV     AX,0008H            ;Set segment limit.
            MOV     BX,ES
            MOV     CX, (EMP-1)/10000H
            MOV     DX, (EMP-1) & 0FFFFH
            INT     31H
            MOV     BL,7
            JC      ERRMSG2

            MOV     AX,0009H            ;Set access rights.
            MOV     BX,ES
            MOV     CX, 80F2H ; %1000 0000 1111 0010 Wyatt pg.618
            INT     31H
            MOV     BL,7
            JC      ERRMSG2

; -------------- Fill in the vector at BYE ----------------------
;This must be done before copying!
        LEA     ECX,[RETDOS]
        LEA     BX,[RETDOSV+1]
        MOV     [BX],ECX
        LEA     BX, [BX+CW]
        MOV     AX,CS
        MOV     [BX],AX

; -------------- Get an 32-bit alias for the data segment into DX  --------
            MOV     AX,000AH            ;Alias for LDT descriptor.
            MOV     BX,DS
            INT     31H
            MOV     DX,AX
            MOV     BL,7
            JC      ERRMSG2             ;Could not allocate.

            MOV     AX,0009H            ;Set access rights.
            MOV     BX,DX
            ; %1000 0000 1111 1010  %1100 0000 1111 1010
            MOV     CX, 80F2H  | 4000H
            INT     31H
            MOV     BL,7
            JC      ERRMSG2             ;Could not allocate.

; --------------  Now copy -------------------------------------------
            PUSH    DS
            MOV     DS, DX
            MOV     ECX, [DPA]
            XOR     EDI, EDI      ;SRC
            XOR     ESI, ESI      ;dest
            A32  REP     MOVSB
            POP     DS


; -------------- Release the 32-bit alias -------------------------------
;           ????

;We are now in a position to release the original memory.
;           MOV     BX, 1000H          ;BX=paragraphs needed (64K)
;           MOV     AH,4Ah              ;Modify memory allocation
;           INT     21h

; -------------- Alias descriptors for ES --------
; After this section : ES is an alias for CS , DX for DS.

            MOV     AX,000AH            ;Alias for LDT descriptor.
            MOV     BX,ES
            INT     31H
            MOV     BL,5
            MOV     DX,AX
ERRMSG3:    JC      ERRMSG2             ;Could not allocate.

; -------------- Fill in the alias descriptors, possibly 32 bits --------

            MOV     AX,0009H            ;Set access rights.
            MOV     BX,ES
            ; %1000 0000 1111 1010  %1100 0000 1111 1010
            MOV     CX, 80FAH  | 4000H  
            INT     31H
            MOV     BL,7
            JC      ERRMSG2

            MOV     AX,0009H            ;Set access rights.
            MOV     BX,DX
            ; %1000 0000 1111 1010  %1100 0000 1111 1010
            MOV     CX, 80F2H  | 4000H  
            INT     31H
            MOV     BL,7
            JC      ERRMSG3

; -------------- Use the alias descriptors for CS and DS --------
            PUSH    ES    ; Corrected code segment
            MOV     BX, ENDDPMI ; Correct program counter
            PUSH    BX
            MOV     DS,DX
            MOV     ES,DX
            RETF        ; Returning to ENDDPMI

; ######################### DPMI CLEAN UP CODE #####################################################

RETDOS:
;       JMP     SHORT $
; BY jumping back here from BYE CS is restored.
; Restore also the DS ES and SS.
        MOV     AX, [Save_DS_PR] ;Aliased.
        MOV     DS,AX
        MOV     ES,AX

; FIXME   the real cleanup code comes here
; It turns out that no cleanup code is required to prevent
; memory leaks.

        MOV     AL,BL
        MOV     AH,4CH
        INT     21H    ; Only works if cs is the same as while starting.

ENDDPMI:
; ######################### DPMI ; ###############################################################
 ; 


;************************
BITS   32         ; Assembler directive

;************************
 
; 

; ########################################################################################
;                       FORTH GLUE CODE (optional, except for the jump)
; ########################################################################################

;

;
COLD_ENTRY:
        CLD                     ; DIR = INC

        MOV     AX,DS
        MOV     SS,AX           ;Atomic with next instruction.
        MOV     ESP, LONG[USINI+(CW*(2))]    ;PARAM. STACK
        MOV     EBP, LONG[USINI+(CW*(3))]    ;RETURN STACK
        MOV     ESI, CLD1  ; (IP) <-
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;
CLD1:   DD      COLD    ;  This is a piece of headerless high level code.
;
; ########################################################################################
;                       FORTH ITSELF (entry point : BOOTUP)
; ########################################################################################
;
%if 0
   FORTH REGISTERS
   The names under FORTH are used in the generic source.

   FORTH   8088     FORTH PRESERVATION RULES
   -----   ----     ----- ------------ -----
   HIP   ESI      High level Interpreter Pointer.  Must be preserved
                    across FORTH words.

   WOR   EAX      Working register.  When entering a word
                    via its code field the DEA is passed in WOR.

   SPO   ESP      Parameter stack pointer.  Must be preserved
                    across FORTH words.

   RPO   EBP      Return stack pointer.  Must be preserved across
                    FORTH words.

            EAX      General register.  Used to pass data from
                    FORTH words, see label APUSH or macro _APUSH

            EDX      General register.  Used to pass more data from
                    FORTH words, see label DPUSH or macro _DPUSH

            EBX      General purpose register.

            ECX      General purpose register.

            CS      Segment register. Must be preserved
                    across FORTH words.

            DS      ditto

            SS      ibid

            ES      Temporary segment register only used by
                    a few words. However it MUST remain equal to
                    DS, such that string primitives can be used
                    with impunity.

----------------------------------------------------------
%endif
        ;
%if 0
---------------------------------------------

   COMMENT CONVENTIONS
   ------- -----------

   =       IS EQUAL TO
   <-      ASSIGNMENT

  NAME        =  Address of name
  (NAME)      =  Contents of name

  CFA         =  CODE FIELD ADDRESS : a pointer to executable code
  DFA         =  DATA FIELD ADDRESS : a pointer to
                        data/high level code/ DOES> pointer
  FFA         =  FLAG FIELD ADDRESS: contains flags
  LFA         =  LINK FIELD ADDRESS: a pointer
  NFA         =  NAME FIELD ADDRESS: a pointer to a variable number of chars
  PHA         =  POST HEADER ADDRESS

  S1          =  Parameter stack - 1st cell
  S2          =  Parameter stack - 2nd cell
  R1          =  Return stack    - 1st cell
  R2          =  Return stack    - 2nd cell

  LSB         =  Least significant bit
  MSB         =  Most  significant bit
  LB          =  Low byte
  HB          =  High byte
  LW          =  Low  cell

------------------------------------------------------------
%endif
; 
        ;

; 
; 
;
; 
; In 32 bit versions there may be no jumps to NEXT at all 
; The label NEXT1 is rarely relevant (for _OLDDEBUG_) 
DPUSH:  PUSH    EDX      ; Fall through.
APUSH:  PUSH    EAX
NEXT:
;
        LODSD           ;AX <- (IP)
NEXT1:  MOV     EAX,EAX   ; (WOR) <- (IP)

        JMP      LONG[EAX]    ; TO `CFA'
;
;       Dictionary starts here.

DP0:
; Vocabularies all end in a link to 0.
; Only the word FORTH links to the DENOTATION wordlist,
; that in turn links to 0.


;  *********
;  *   '   *
;  *********
;
N_TICK:   DD      1
        DB      "'"
TICK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED + B_DENOT
        DD    0
        DD    N_TICK
    DD    0

        DD      ITICK
        DD      LITER
        DD      SEMIS
;

;  *********
;  *   &   *
;  *********
;
N_DCHAR:   DD      1
        DB      "&"
DCHAR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED + B_DENOT
        DD    TICK-(CW*(C_HOFFSET))
        DD    N_DCHAR
    DD    0

        DD      INBRS
        DD      SWAP, DROP
        DD      LDUP, QBL
        DD      LIT, 10, QERR
        DD      LITER
        DD      QDELIM
        DD      SEMIS
;

;  *********
;  *   ^   *
;  *********
;
N_DCTL:   DD      1
        DB      "^"
DCTL:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED + B_DENOT
        DD    DCHAR-(CW*(C_HOFFSET))
        DD    N_DCTL
    DD    0

        DD      INBRS
        DD      SWAP, DROP
        DD      LDUP, QBL
        DD      LIT, 10, QERR
        DD      LIT, '@', LSUB
        DD      LITER
        DD      QDELIM
        DD      SEMIS
;

;  *********
;  *   0   *
;  *********
;
N_DEN0:   DD      1
        DB      "0"
DEN0:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DCTL-(CW*(C_HOFFSET))
        DD    N_DEN0
    DD    0

;  *********
;  *   1   *
;  *********
;
N_DEN1:   DD      1
        DB      "1"
DEN1:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN0-(CW*(C_HOFFSET))
        DD    N_DEN1
    DD    0

;  *********
;  *   2   *
;  *********
;
N_DEN2:   DD      1
        DB      "2"
DEN2:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN1-(CW*(C_HOFFSET))
        DD    N_DEN2
    DD    0

;  *********
;  *   3   *
;  *********
;
N_DEN3:   DD      1
        DB      "3"
DEN3:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN2-(CW*(C_HOFFSET))
        DD    N_DEN3
    DD    0

;  *********
;  *   4   *
;  *********
;
N_DEN4:   DD      1
        DB      "4"
DEN4:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN3-(CW*(C_HOFFSET))
        DD    N_DEN4
    DD    0

;  *********
;  *   5   *
;  *********
;
N_DEN5:   DD      1
        DB      "5"
DEN5:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN4-(CW*(C_HOFFSET))
        DD    N_DEN5
    DD    0

;  *********
;  *   6   *
;  *********
;
N_DEN6:   DD      1
        DB      "6"
DEN6:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN5-(CW*(C_HOFFSET))
        DD    N_DEN6
    DD    0

;  *********
;  *   7   *
;  *********
;
N_DEN7:   DD      1
        DB      "7"
DEN7:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN6-(CW*(C_HOFFSET))
        DD    N_DEN7
    DD    0

;  *********
;  *   8   *
;  *********
;
N_DEN8:   DD      1
        DB      "8"
DEN8:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN7-(CW*(C_HOFFSET))
        DD    N_DEN8
    DD    0

;  *********
;  *   9   *
;  *********
;
N_DEN9:   DD      1
        DB      "9"
DEN9:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN8-(CW*(C_HOFFSET))
        DD    N_DEN9
    DD    0

;  *********
;  *   A   *
;  *********
;
N_DENA:   DD      1
        DB      "A"
DENA:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEN9-(CW*(C_HOFFSET))
        DD    N_DENA
    DD    0

;  *********
;  *   B   *
;  *********
;
N_DENB:   DD      1
        DB      "B"
DENB:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DENA-(CW*(C_HOFFSET))
        DD    N_DENB
    DD    0

;  *********
;  *   C   *
;  *********
;
N_DENC:   DD      1
        DB      "C"
DENC:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DENB-(CW*(C_HOFFSET))
        DD    N_DENC
    DD    0

;  *********
;  *   D   *
;  *********
;
N_DEND:   DD      1
        DB      "D"
DEND:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DENC-(CW*(C_HOFFSET))
        DD    N_DEND
    DD    0

;  *********
;  *   E   *
;  *********
;
N_DENE:   DD      1
        DB      "E"
DENE:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DEND-(CW*(C_HOFFSET))
        DD    N_DENE
    DD    0

;  *********
;  *   F   *
;  *********
;
N_DENF:   DD      1
        DB      "F"
DENF:        DD    DOCOL
        DD    LNUMB
        DD    B_IMMED + B_DENOT
        DD    DENE-(CW*(C_HOFFSET))
        DD    N_DENF
    DD    0

;

;  *********
;  *   -   *
;  *********
;
N_DENM:   DD      1
        DB      "-"
DENM:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED + B_DENOT
        DD    DENF-(CW*(C_HOFFSET))
        DD    N_DENM
    DD    0

        DD      PNUMB, DNEGA, SDLITE
        DD      SEMIS
;

;  *********
;  *   +   *
;  *********
;
N_DENP:   DD      1
        DB      "+"
DENP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED + B_DENOT
        DD    DENM-(CW*(C_HOFFSET))
        DD    N_DENP
    DD    0

        DD      PNUMB, SDLITE
        DD      SEMIS
;

;  *********
;  *   "   *
;  *********
;
N_DENQ:   DD      1
        DB      '"'
DENQ:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED + B_DENOT
        DD    DENP-(CW*(C_HOFFSET))
        DD    N_DENQ
    DD    0

        DD      LIT, SKIP, COMMA        ;  'SKIP , HERE >R 0 ,
        DD      HERE, TOR, ZERO, COMMA
DENQ1:
        DD      LIT, '"', PPARS         ;           BEGIN &" (PARSE)
        DD      INBRS, LDUP, LIT, '"', EQUAL ;           IN[] DUP &" =
        DD      ZBRAN
        DD      DENQ2-$-CW                 ;           WHILE
        DD      TDROP, ONEP             ;           2DROP 1+ R@ $+!
        DD      LDUP, ALLOT, RR, SADD
        DD      BRAN
        DD      DENQ1-$-CW                  ;           REPEAT
DENQ2:
        DD      QBL, ZEQU
        DD      LIT, 10, QERR           ;           ?BLANK 0= 5 ?ERROR
        DD      DROP                    ;                DROP R@ $+!
        DD      LDUP, ALLOT, RR, SADD
        DD      FROMR, SFET, DLITE      ;           R> $@ POSTPONE DLITERAL ;
        DD      SEMIS
;

; The FORTH vocabulary is the only one not to link to zero.
; It links to the DENOTATION vocabulary.
;  *************
;  *   FORTH   *
;  *************
;
N_FORTH:   DD      5
        DB      "FORTH"
FORTH:        DD    DODOE
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    DENOTBODY 
        DD    N_FORTH
    DD    0

        DD      DOVOC
        DD      0       ; END OF VOCABULARY LIST

        DD    0H
        DD    0
        DD    B_DUMMY
        DD    TASK-(CW*(C_HOFFSET))
        DD    0
    DD    0

;
;

;  ************
;  *   CORE   *
;  ************
;
N_CORE:   DD      4
        DB      "CORE"
CORE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    0
        DD    N_CORE
    DD    0

        DD      ZERO    ; Not (fully) present.
        DD      SEMIS
;

;  ***********
;  *   CPU   *
;  ***********
;
N_LCPU:   DD      3
        DB      "CPU"
LCPU:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CORE-(CW*(C_HOFFSET))
        DD    N_LCPU
    DD    0


       DD      LIT, 0CD1856H, ZERO       ; '80386'
           ; '80386'
; 

        DD      SEMIS
;

;  ***************
;  *   VERSION   *
;  ***************
;
N_LVERSION:   DD      7
        DB      "VERSION"
LVERSION:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LCPU-(CW*(C_HOFFSET))
        DD    N_LVERSION
    DD    0

%if 0
;       If this is there it is an official release
        DD      SKIP
        DD      22
IBMPC:  DB      'IBM-PC ciforth'
        DB      FIGREL+40H,ADOT,FIGREV+30H,ADOT,USRVER+30H
        DD      LIT, IBMPC, LIT, 22
%endif
;       If M4_VERSION exists and contains a . it is an official release
        DD      SKIP
         DD      5
SB0: DB      "4.0.2"
       
        DD      LIT, SB0
        DD      LIT, 5
        DD      SEMIS
;

;  ************
;  *   NAME   *
;  ************
;
N_LNAME:   DD      4
        DB      "NAME"
LNAME:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LVERSION-(CW*(C_HOFFSET))
        DD    N_LNAME
    DD    0

        DD      SKIP
         DD      7
SB1: DB      "ciforth"
       
        DD      LIT, SB1
        DD      LIT, 7
        DD      SEMIS
;

;  ****************
;  *   SUPPLIER   *
;  ****************
;
N_SUPPLIER:   DD      8
        DB      "SUPPLIER"
SUPPLIER:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LNAME-(CW*(C_HOFFSET))
        DD    N_SUPPLIER
    DD    0

        DD      SKIP
         DD      20
SB2: DB      "Albert van der Horst"
       
        DD      LIT, SB2
        DD      LIT, 20
        DD      SEMIS
;
;

;  ******************
;  *   DENOTATION   *
;  ******************
;
N_DENOT:   DD      10
        DB      "DENOTATION"
DENOT:        DD    DODOE
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    FORTH
        DD    N_DENOT
    DD    0

        DD      DOVOC
        DD      FORTH-(CW*(C_HOFFSET))     ; NEXT VOCABULARY 
DENOTBODY:

        DD    0H
        DD    0
        DD    B_DUMMY
        DD    DENQ-(CW*(C_HOFFSET))
        DD    0
    DD    0

;

;  *******************
;  *   ENVIRONMENT   *
;  *******************
;
N_ENV:   DD      11
        DB      "ENVIRONMENT"
ENV:        DD    DODOE
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    DENOT-(CW*(C_HOFFSET))
        DD    N_ENV
    DD    0

        DD      DOVOC
        DD      DENOT-(CW*(C_HOFFSET))       ; NEXT VOCABULARY 

        DD    0H
        DD    0
        DD    B_DUMMY
        DD    SUPPLIER-(CW*(C_HOFFSET))
        DD    0
    DD    0

;

;  ************
;  *   NOOP   *
;  ************
;
N_NOOP:   DD      4
        DB      "NOOP"
NOOP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ENV-(CW*(C_HOFFSET))
        DD    N_NOOP
    DD    0

       LODSD                 ; NEXT
        JMP      LONG[EAX]   
;
; 
;

;  ***********
;  *   LIT   *
;  ***********
;
N_LIT:   DD      3
        DB      "LIT"
LIT:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    NOOP-(CW*(C_HOFFSET))
        DD    N_LIT
    DD    0

        LODSD           ; AX <- LITERAL
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]             ; TO TOP OF STACK
;

;  ***************
;  *   EXECUTE   *
;  ***************
;
N_EXEC:   DD      7
        DB      "EXECUTE"
EXEC:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LIT-(CW*(C_HOFFSET))
        DD    N_EXEC
    DD    0

        POP     EAX      ; GET XT
        JMP      LONG[EAX + (CW*(C_HOFFSET))]  ;(IP) <- (PFA)
;


;  ***************
;  *   RECURSE   *
;  ***************
;
N_RECURSE:   DD      7
        DB      "RECURSE"
RECURSE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    EXEC-(CW*(C_HOFFSET))
        DD    N_RECURSE
    DD    0

        DD      LATEST, COMMA
        DD      SEMIS
;
;

;  **************
;  *   BRANCH   *
;  **************
;
N_BRAN:   DD      6
        DB      "BRANCH"
BRAN:        DD    (SKIP+(CW*(PH_OFFSET-C_HOFFSET)))
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RECURSE-(CW*(C_HOFFSET))
        DD    N_BRAN
    DD    0

;

;  ************
;  *   SKIP   *
;  ************
;
N_SKIP:   DD      4
        DB      "SKIP"
SKIP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BRAN-(CW*(C_HOFFSET))
        DD    N_SKIP
    DD    0

BRAN1:  LODSD
        ADD     ESI,EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***************
;  *   0BRANCH   *
;  ***************
;
N_ZBRAN:   DD      7
        DB      "0BRANCH"
ZBRAN:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SKIP-(CW*(C_HOFFSET))
        DD    N_ZBRAN
    DD    0

        POP     EAX      ; GET STACK VALUE
        OR      EAX,EAX   ; ZERO?
        JZ      BRAN1   ; YES, BRANCH
        LEA     ESI,[ESI+(CW*(1))]
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;
;

;  **************
;  *   (LOOP)   *
;  **************
;
N_XLOOP:   DD      6
        DB      "(LOOP)"
XLOOP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ZBRAN-(CW*(C_HOFFSET))
        DD    N_XLOOP
    DD    0

        MOV     EBX,1    ; INCREMENT
XLOO1:  ADD     [EBP],EBX ; INDEX = INDEX + INCR
        MOV     EAX,[EBP] ; GET NEW INDEX
        SUB     EAX,[EBP+(CW*(1))]        ; COMPARE WITH LIMIT
        XOR     EAX,EBX   ; TEST SIGN
        JS      BRAN1   ; KEEP LOOPING
;
;  END OF `DO' LOOP
        LEA     EBP,[EBP+(CW*(3))]  ; ADJ RETURN STACK
        LEA     ESI,[ESI+(CW*(1))]       ; BYPASS BRANCH OFFSET
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***************
;  *   (+LOOP)   *
;  ***************
;
N_XPLOO:   DD      7
        DB      "(+LOOP)"
XPLOO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    XLOOP-(CW*(C_HOFFSET))
        DD    N_XPLOO
    DD    0

        POP     EBX      ; GET LOOP VALUE
        JMP SHORT     XLOO1
        LODSD                 ; NEXT
        JMP      LONG[EAX]              ;Helpfull for disassembly.
;

;  ************
;  *   (DO)   *
;  ************
;
N_XDO:   DD      4
        DB      "(DO)"
XDO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    XPLOO-(CW*(C_HOFFSET))
        DD    N_XDO
    DD    0

        LODSD
        ADD     EAX,ESI  ;Make absolute
        POP     EDX      ; INITIAL INDEX VALUE
        POP     EBX      ; LIMIT VALUE
        XCHG    EBP,ESP   ; GET RETURN STACK
        PUSH    EAX      ; Target location.
        PUSH    EBX
        PUSH    EDX
        XCHG    EBP,ESP   ; GET PARAMETER STACK
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *************
;  *   (?DO)   *
;  *************
;
N_XQDO:   DD      5
        DB      "(?DO)"
XQDO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    XDO-(CW*(C_HOFFSET))
        DD    N_XQDO
    DD    0

        LODSD
        ADD     EAX,ESI  ;Make absolute
        POP     EDX      ; INITIAL INDEX VALUE
        POP     EBX      ; LIMIT VALUE
        CMP     EDX,EBX
        JZ      QXDO1
        XCHG    EBP,ESP   ; GET RETURN STACK
        PUSH    EAX      ; Target location.
        PUSH    EBX
        PUSH    EDX
        XCHG    EBP,ESP   ; GET PARAMETER STACK
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
QXDO1:  MOV     ESI,EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *********
;  *   I   *
;  *********
;
N_IDO:   DD      1
        DB      "I"
IDO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    XQDO-(CW*(C_HOFFSET))
        DD    N_IDO
    DD    0

        MOV     EAX,[EBP] ; GET INDEX VALUE
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]             ; TO PARAMETER STACK
;

;  *********
;  *   J   *
;  *********
;
N_JDO:   DD      1
        DB      "J"
JDO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    IDO-(CW*(C_HOFFSET))
        DD    N_JDO
    DD    0

        MOV     EAX,[EBP+(CW*(3))] ; GET INDEX VALUE
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]             ; TO PARAMETER STACK
;

;  **************
;  *   UNLOOP   *
;  **************
;
N_UNLOOP:   DD      6
        DB      "UNLOOP"
UNLOOP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    JDO-(CW*(C_HOFFSET))
        DD    N_UNLOOP
    DD    0

        DD      LIT, RDROP, COMMA
        DD      LIT, RDROP, COMMA
        DD      LIT, RDROP, COMMA
        DD      SEMIS
;

;  ***************
;  *   +ORIGIN   *
;  ***************
;
N_PORIG:   DD      7
        DB      "+ORIGIN"
PORIG:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    UNLOOP-(CW*(C_HOFFSET))
        DD    N_PORIG
    DD    0

        DD      LIT
        DD      USINI
        DD      PLUS
        DD      SEMIS
;
;      Initialisation block for user variables through DOC-LINK
;       <<<<< must be in same order as user variables >>>>>
;
;        DD      WARM_ENTRY FIXME
;        DD      COLD_ENTRY
USINI:  DD      STRUSA  ; User area currently in use, cold value same as next.
        DD      STRUSA  ; INIT (U0) user area of the main task 1
        DD      INITS0  ; INIT (S0)         2
        DD      INITR0  ; INIT (R0)         3
        DD      STRTIB  ; INIT (TIB)        4
        DD      BSIN    ; RUBOUT: get rid of latest char 5
        DD      0       ; AVAILABLE         6
        DD      1       ; INIT (WARNING)     7
        DD      INITDP  ;      INIT (FENCE)  8
DPA:    DD      INITDP  ;      INIT (DP)     9
        DD      ENV-(CW*(C_HOFFSET)) ;       INIT (VOC-LINK) 10
;

        DD      0       ; INIT (OFFSET) 
;
;
;
;
;
        DD      0, 0            ; WHERE             12 13 
        DD      0, STRTIB       ;REMAINDER   14 15 
; 
        RESB    US-($ - USINI)        ; All user can be initialised.
;
;      <<<<< end of data used by cold start >>>>>

;  *************
;  *   DIGIT   *
;  *************
;
N_DIGIT:   DD      5
        DB      "DIGIT"
DIGIT:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PORIG-(CW*(C_HOFFSET))
        DD    N_DIGIT
    DD    0

        POP     EDX      ;NUMBER BASE
        POP     EAX      ;ASCII DIGIT
        SUB     AL,'0'
        JB      DIGI2   ;NUMBER ERROR
        CMP     AL,9
        JBE     DIGI1   ;NUMBER = 0 THRU 9
        SUB     AL,7
        CMP     AL,10   ;NUMBER 'A' THRU 'Z'?
        JB      DIGI2   ;NO
DIGI1:  CMP     AL,DL   ; COMPARE NUMBER TO BASE
        JAE     DIGI2   ;NUMBER ERROR
        SUB     EDX,EDX   ;ZERO
        MOV     DL,AL   ;NEW BINARY NUMBER
        MOV     AL,1    ;TRUE FLAG
        NEG     EAX
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]             ;ADD TO STACK
;   NUMBER ERROR
DIGI2:  SUB     EAX,EAX   ;FALSE FLAG
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***************
;  *   (MATCH)   *
;  ***************
;
N_PMATCH:   DD      7
        DB      "(MATCH)"
PMATCH:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DIGIT-(CW*(C_HOFFSET))
        DD    N_PMATCH
    DD    0

        DD      TOR
        DD      RR, TFFA, FETCH
        DD      LIT, B_INVIS | B_DUMMY, LAND ;Get flags.
        DD      ZEQU
        DD      LDUP
        DD      ZBRAN
        DD      MATS2-$-CW
        DD      DROP
        DD      RR, TNFA, FETCH, FETCH
        DD      OVER, LSUB
;
; The following four lines take care of denotations.
        DD      LDUP, ZLESS  ;Ignorable length difference.
        DD      RR, TFFA, FETCH, LIT, B_DENOT, LAND ;Get flag.
        DD      LAND  ;Denotation applicable. 
        DD      ZEQU, LAND ;This AND is actually an OR.
;
        DD      ZEQU
        DD      LDUP
        DD      ZBRAN
        DD      MATS2-$-CW
        DD      DROP, OVER
        DD      RR, TNFA, FETCH, SFET
        DD      CORA, ZEQU  ; Compare equals.
MATS2:  DD      FROMR, SWAP
        DD      SEMIS
;

;  **************
;  *   ?BLANK   *
;  **************
;
N_QBL:   DD      6
        DB      "?BLANK"
QBL:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PMATCH-(CW*(C_HOFFSET))
        DD    N_QBL
    DD    0

        DD      LBL, ONEP, LESS
        DD      SEMIS
;

;  ************
;  *   IN[]   *
;  ************
;
N_INBRS:   DD      4
        DB      "IN[]"
INBRS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QBL-(CW*(C_HOFFSET))
        DD    N_INBRS
    DD    0

        DD      SRC, CELLP, TFET
        DD      OVER, EQUAL
        DD      ZBRAN
        DD      INBRS1-$-CW
        DD      ZERO
        DD      BRAN
        DD      INBRS2-$-CW
INBRS1:
        DD      LDUP
        
        DD      CFET
        DD      ONE, LIN, PSTORE
INBRS2:
        DD      SEMIS
;

;  **************
;  *   (WORD)   *
;  **************
;
N_LPWORD:   DD      6
        DB      "(WORD)"
LPWORD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    INBRS-(CW*(C_HOFFSET))
        DD    N_LPWORD
    DD    0

        DD      X
PWORD0: DD      DROP
        DD      INBRS, QBL
        DD      OVER, SRC, CELLP, FETCH, LSUB ; At end?
        DD      LAND, ZEQU
        DD      ZBRAN
        DD      PWORD0-$-CW

        DD      X
PWORD1: DD      DROP
        DD      INBRS, QBL
        DD      ZBRAN
        DD      PWORD1-$-CW

        DD      OVER, LSUB
        
        DD      SEMIS
;

;  ***************
;  *   (PARSE)   *
;  ***************
;
N_PPARS:   DD      7
        DB      "(PARSE)"
PPARS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LPWORD-(CW*(C_HOFFSET))
        DD    N_PPARS
    DD    0

        DD      SRC, CELLP, TFET
        DD      OVER, LSUB
        
        DD      ROT, SSPLIT, TSWAP
        DD      ZEQU
        DD      ZBRAN
        DD      PPARS8-$-CW
        DD      DROP, SRC, CELLP, FETCH
PPARS8: 
        DD      LIN, STORE
        DD SEMIS
;

;  ***********
;  *   SRC   *
;  ***********
;
N_SRC:   DD      3
        DB      "SRC"
SRC:        DD    DOUSE
        DD    (CW*(27))
        DD    0H
        DD    PPARS-(CW*(C_HOFFSET))
        DD    N_SRC
    DD    0
      ; And 28 and 29.
;


;  **************
;  *   SOURCE   *
;  **************
;
N_SOURCE:   DD      6
        DB      "SOURCE"
SOURCE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SRC-(CW*(C_HOFFSET))
        DD    N_SOURCE
    DD    0

        DD      SRC, FETCH
        DD      SRC, CELLP, FETCH
        DD      OVER, LSUB
        DD      SEMIS
;

;  ***********
;  *   >IN   *
;  ***********
;
N_IIN:   DD      3
        DB      ">IN"
IIN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SOURCE-(CW*(C_HOFFSET))
        DD    N_IIN
    DD    0

        DD      LIN, FETCH
DD      SRC, FETCH, LSUB     
        DD      PIIN, STORE
        DD      PIIN
        DD      SEMIS
;
;

;  **********
;  *   CR   *
;  **********
;
N_CR:   DD      2
        DB      "CR"
CR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    IIN-(CW*(C_HOFFSET))
        DD    N_CR
    DD    0

        DD      LIT,ALF
        DD      EMIT
        DD      ZERO, LOUT, STORE
        DD      SEMIS
;

;  *************
;  *   CMOVE   *
;  *************
;
N_LCMOVE:   DD      5
        DB      "CMOVE"
LCMOVE:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CR-(CW*(C_HOFFSET))
        DD    N_LCMOVE
    DD    0

        CLD             ;direction
        MOV     EBX,ESI   ;save 
        POP     ECX      ;count
        POP     EDI      ;dest
        POP     ESI      ;source
        REP     MOVSB
        MOV     ESI,EBX   ;get back 
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   MOVE   *
;  ************
;
N_LMOVE:   DD      4
        DB      "MOVE"
LMOVE:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LCMOVE-(CW*(C_HOFFSET))
        DD    N_LMOVE
    DD    0

        MOV     EBX,ESI   ;SAVE 
        POP     ECX      ;count
        POP     EDI      ;dest
        POP     ESI      ;source
        CMP     ESI,EDI
        JC    MOVE1
        CLD             ;INC DIRECTION
        JMP SHORT MOVE2
MOVE1:  STD
        ADD     EDI,ECX
        DEC     EDI
        ADD     ESI,ECX
        DEC     ESI
MOVE2:
        REP     MOVSB   ;THAT'S THE MOVE
        CLD             ;INC DIRECTION
        MOV     ESI,EBX   ;GET BACK 
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***************
;  *   FARMOVE   *
;  ***************
;
N_FMOVE:   DD      7
        DB      "FARMOVE"
FMOVE:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LMOVE-(CW*(C_HOFFSET))
        DD    N_FMOVE
    DD    0

        CLD             ;direction
        MOV     EAX,ESI   ;save 
        MOV     EBX,DS    ;save 
        POP     ECX      ;count
        POP     EDI      ;dest
        POP     EDX
        AND     EDX,EDX
        JZ      FARMV1
        MOV     ES,EDX
FARMV1:
        POP     ESI      ;source
        POP     EDX
        PUSH    DS
        PUSH    EBX      ;ES in fact.
        AND     EDX,EDX
        JZ      FARMV2
        MOV     DS,EDX
FARMV2:
        REP     MOVSB
        MOV     ESI,EAX   ;restore 
        POP     ES
        POP     DS
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***********
;  *   UM*   *
;  ***********
;
N_USTAR:   DD      3
        DB      "UM*"
USTAR:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FMOVE-(CW*(C_HOFFSET))
        DD    N_USTAR
    DD    0

        POP     EAX
        POP     EBX
        MUL     EBX      ;UNSIGNED
        XCHG    EAX,EDX   ;AX NOW = MSW
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]             ;STORE DOUBLE CELL
;

;  **************
;  *   UM/MOD   *
;  **************
;
N_USLAS:   DD      6
        DB      "UM/MOD"
USLAS:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    USTAR-(CW*(C_HOFFSET))
        DD    N_USLAS
    DD    0

        POP     EBX      ;DIVISOR
        POP     EDX      ;MSW OF DIVIDEND
        POP     EAX      ;LSW OF DIVIDEND
        DIV     EBX      ;16 BIT DIVIDE
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]             ;STORE QUOT/REM
;

;  ***********
;  *   AND   *
;  ***********
;
N_LAND:   DD      3
        DB      "AND"
LAND:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    USLAS-(CW*(C_HOFFSET))
        DD    N_LAND
    DD    0

        POP     EAX
        POP     EBX
        AND     EAX,EBX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   OR   *
;  **********
;
N_LOR:   DD      2
        DB      "OR"
LOR:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LAND-(CW*(C_HOFFSET))
        DD    N_LOR
    DD    0

        POP     EAX      ; (S1) <- (S1) OR (S2)
        POP     EBX
        OR      EAX,EBX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***********
;  *   XOR   *
;  ***********
;
N_LXOR:   DD      3
        DB      "XOR"
LXOR:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LOR-(CW*(C_HOFFSET))
        DD    N_LXOR
    DD    0

        POP     EAX      ; (S1) <- (S1) XOR (S2)
        POP     EBX
        XOR     EAX,EBX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **************
;  *   INVERT   *
;  **************
;
N_INVERT:   DD      6
        DB      "INVERT"
INVERT:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LXOR-(CW*(C_HOFFSET))
        DD    N_INVERT
    DD    0

        POP     EAX      ; (S1) <- (S1) XOR (S2)
        NOT     EAX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   DSP@   *
;  ************
;
N_SPFET:   DD      4
        DB      "DSP@"
SPFET:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    INVERT-(CW*(C_HOFFSET))
        DD    N_SPFET
    DD    0

        MOV     EAX,ESP   ; (S1) <- (SP)
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   DSP!   *
;  ************
;
N_SPSTO:   DD      4
        DB      "DSP!"
SPSTO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SPFET-(CW*(C_HOFFSET))
        DD    N_SPSTO
    DD    0

        POP     EAX
        MOV     ESP,EAX        ;RESET PARAM STACK POINTER
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;


;  *************
;  *   DEPTH   *
;  *************
;
N_DEPTH:   DD      5
        DB      "DEPTH"
DEPTH:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SPSTO-(CW*(C_HOFFSET))
        DD    N_DEPTH
    DD    0

        DD      SZERO, FETCH
        DD      SPFET
        DD      LSUB
        DD      LIT, CW, SLASH
        DD      ONEM
        DD      SEMIS
;
;

;  ************
;  *   RSP@   *
;  ************
;
N_RPFET:   DD      4
        DB      "RSP@"
RPFET:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DEPTH-(CW*(C_HOFFSET))
        DD    N_RPFET
    DD    0
      ;(S1) <- (RP)
        PUSH    EBP
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   RSP!   *
;  ************
;
N_RPSTO:   DD      4
        DB      "RSP!"
RPSTO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RPFET-(CW*(C_HOFFSET))
        DD    N_RPSTO
    DD    0

        POP     EBP
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   EXIT   *
;  ************
;
N_EXIT:   DD      4
        DB      "EXIT"
EXIT:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RPSTO-(CW*(C_HOFFSET))
        DD    N_EXIT
    DD    0

        MOV     ESI,[EBP] ;(IP) <- (R1)
        LEA     EBP,[EBP+(CW*(1))]
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   CO   *
;  **********
;
N_CO:   DD      2
        DB      "CO"
CO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    EXIT-(CW*(C_HOFFSET))
        DD    N_CO
    DD    0

        XCHG    ESI,[EBP]
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***********
;  *   (;)   *
;  ***********
;
N_SEMIS:   DD      3
        DB      "(;)"
SEMIS:        DD    (EXIT+(CW*(PH_OFFSET-C_HOFFSET)))
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CO-(CW*(C_HOFFSET))
        DD    N_SEMIS
    DD    0

;

;  *************
;  *   LEAVE   *
;  *************
;
N_LLEAV:   DD      5
        DB      "LEAVE"
LLEAV:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SEMIS-(CW*(C_HOFFSET))
        DD    N_LLEAV
    DD    0
  ;LIMIT <- INDEX
        DD      RDROP, RDROP, RDROP
        DD      SEMIS
;

;  **********
;  *   >R   *
;  **********
;
N_TOR:   DD      2
        DB      ">R"
TOR:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LLEAV-(CW*(C_HOFFSET))
        DD    N_TOR
    DD    0
        ; (R1) <- (S1)
        POP     EBX      ;GET STACK PARAMETER
        LEA     EBP,[EBP - (CW*(1))]    ;MOVE RETURN STACK DOWN
        MOV     [EBP],EBX ;ADD TO RETURN STACK
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   R>   *
;  **********
;
N_FROMR:   DD      2
        DB      "R>"
FROMR:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TOR-(CW*(C_HOFFSET))
        DD    N_FROMR
    DD    0
      ;(S1) <- (R1)
        MOV     EAX,[EBP] ; GET RETURN STACK VALUE
        LEA     EBP,[EBP + (CW*(1))]
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *************
;  *   RDROP   *
;  *************
;
N_RDROP:   DD      5
        DB      "RDROP"
RDROP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FROMR-(CW*(C_HOFFSET))
        DD    N_RDROP
    DD    0
      ;(S1) <- (R1)
        LEA     EBP,[EBP+(CW*(1))]
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   R@   *
;  **********
;
N_RR:   DD      2
        DB      "R@"
RR:        DD    (IDO+(CW*(PH_OFFSET-C_HOFFSET)))
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RDROP-(CW*(C_HOFFSET))
        DD    N_RR
    DD    0

;

;  **********
;  *   0=   *
;  **********
;
N_ZEQU:   DD      2
        DB      "0="
ZEQU:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RR-(CW*(C_HOFFSET))
        DD    N_ZEQU
    DD    0

        POP     EAX
        NEG     EAX
        CMC
        SBB     EAX,EAX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   0<   *
;  **********
;
N_ZLESS:   DD      2
        DB      "0<"
ZLESS:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ZEQU-(CW*(C_HOFFSET))
        DD    N_ZLESS
    DD    0

        POP     EAX
        OR      EAX,EAX   ;SET FLAGS
        MOV     EAX,0    ;FALSE
        JNS     ZLESS1
        DEC     EAX      ;TRUE
ZLESS1: PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *********
;  *   +   *
;  *********
;
N_PLUS:   DD      1
        DB      "+"
PLUS:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ZLESS-(CW*(C_HOFFSET))
        DD    N_PLUS
    DD    0

        POP     EAX      ;(S1) <- (S1) + (S2)
        POP     EBX
        ADD     EAX,EBX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   D+   *
;  **********
;
N_DPLUS:   DD      2
        DB      "D+"
DPLUS:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PLUS-(CW*(C_HOFFSET))
        DD    N_DPLUS
    DD    0

        POP     EAX      ; YHW
        POP     EDX      ; YLW
        POP     EBX      ; XHW
        POP     ECX      ; XLW
        ADD     EDX,ECX   ; SLW
        ADC     EAX,EBX   ; SHW
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **************
;  *   NEGATE   *
;  **************
;
N_NEGATE:   DD      6
        DB      "NEGATE"
NEGATE:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DPLUS-(CW*(C_HOFFSET))
        DD    N_NEGATE
    DD    0

        POP     EAX
        NEG     EAX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***************
;  *   DNEGATE   *
;  ***************
;
N_DNEGA:   DD      7
        DB      "DNEGATE"
DNEGA:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    NEGATE-(CW*(C_HOFFSET))
        DD    N_DNEGA
    DD    0

        POP     EBX
        POP     ECX
        SUB     EAX,EAX
        MOV     EDX,EAX
        SUB     EDX,ECX   ; MAKE 2'S COMPLEMENT
        SBB     EAX,EBX   ; HIGH CELL
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
        ;
;

;  ************
;  *   OVER   *
;  ************
;
N_OVER:   DD      4
        DB      "OVER"
OVER:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DNEGA-(CW*(C_HOFFSET))
        DD    N_OVER
    DD    0

        POP     EDX
        POP     EAX
        PUSH    EAX
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   DROP   *
;  ************
;
N_DROP:   DD      4
        DB      "DROP"
DROP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    OVER-(CW*(C_HOFFSET))
        DD    N_DROP
    DD    0

        POP     EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *************
;  *   2DROP   *
;  *************
;
N_TDROP:   DD      5
        DB      "2DROP"
TDROP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DROP-(CW*(C_HOFFSET))
        DD    N_TDROP
    DD    0

        POP     EAX
        POP     EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   SWAP   *
;  ************
;
N_SWAP:   DD      4
        DB      "SWAP"
SWAP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TDROP-(CW*(C_HOFFSET))
        DD    N_SWAP
    DD    0

        POP     EDX
        POP     EAX
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***********
;  *   DUP   *
;  ***********
;
N_LDUP:   DD      3
        DB      "DUP"
LDUP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SWAP-(CW*(C_HOFFSET))
        DD    N_LDUP
    DD    0

        POP     EAX
        PUSH    EAX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   2DUP   *
;  ************
;
N_TDUP:   DD      4
        DB      "2DUP"
TDUP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LDUP-(CW*(C_HOFFSET))
        DD    N_TDUP
    DD    0

        POP     EAX
        POP     EDX
        PUSH    EDX
        PUSH    EAX
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *************
;  *   2SWAP   *
;  *************
;
N_TSWAP:   DD      5
        DB      "2SWAP"
TSWAP:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TDUP-(CW*(C_HOFFSET))
        DD    N_TSWAP
    DD    0

        POP     EBX
        POP     ECX
        POP     EAX
        POP     EDX
        PUSH     ECX
        PUSH     EBX
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *************
;  *   2OVER   *
;  *************
;
N_TOVER:   DD      5
        DB      "2OVER"
TOVER:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TSWAP-(CW*(C_HOFFSET))
        DD    N_TOVER
    DD    0

        POP     EBX
        POP     ECX
        POP     EAX
        POP     EDX
        PUSH     EDX
        PUSH     EAX
        PUSH     ECX
        PUSH     EBX
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   +!   *
;  **********
;
N_PSTORE:   DD      2
        DB      "+!"
PSTORE:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TOVER-(CW*(C_HOFFSET))
        DD    N_PSTORE
    DD    0

        POP     EBX      ;ADDRESS
        POP     EAX      ;INCREMENT
        ADD     [EBX],EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **************
;  *   TOGGLE   *
;  **************
;
N_TOGGL:   DD      6
        DB      "TOGGLE"
TOGGL:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PSTORE-(CW*(C_HOFFSET))
        DD    N_TOGGL
    DD    0

        POP     EAX      ;BIT PATTERN
        POP     EBX      ;ADDR
        XOR     [EBX],EAX ;
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *********
;  *   @   *
;  *********
;
N_FETCH:   DD      1
        DB      "@"
FETCH:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TOGGL-(CW*(C_HOFFSET))
        DD    N_FETCH
    DD    0

        POP     EBX
        MOV     EAX,[EBX]
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   C@   *
;  **********
;
N_CFET:   DD      2
        DB      "C@"
CFET:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FETCH-(CW*(C_HOFFSET))
        DD    N_CFET
    DD    0

        POP     EBX
        XOR     EAX,EAX
        MOV     AL,[EBX]
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   2@   *
;  **********
;
N_TFET:   DD      2
        DB      "2@"
TFET:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CFET-(CW*(C_HOFFSET))
        DD    N_TFET
    DD    0

        POP     EBX      ;ADDR
        MOV     EAX,[EBX] ;MSW
        MOV     EDX,[EBX+(CW*(1))]        ;LSW
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *********
;  *   !   *
;  *********
;
N_STORE:   DD      1
        DB      "!"
STORE:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TFET-(CW*(C_HOFFSET))
        DD    N_STORE
    DD    0

        POP     EBX      ;ADDR
        POP     EAX      ;DATA
        MOV     [EBX],EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   C!   *
;  **********
;
N_CSTOR:   DD      2
        DB      "C!"
CSTOR:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    STORE-(CW*(C_HOFFSET))
        DD    N_CSTOR
    DD    0

        POP     EBX      ;ADDR
        POP     EAX      ;DATA
        MOV     [EBX],AL
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   2!   *
;  **********
;
N_TSTOR:   DD      2
        DB      "2!"
TSTOR:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CSTOR-(CW*(C_HOFFSET))
        DD    N_TSTOR
    DD    0

        POP     EBX      ;ADDR
        POP     EAX      ;MSW
        MOV     [EBX],EAX
        POP     EAX      ;LSW
        MOV     [EBX+(CW*(1))],EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **************
;  *   WITHIN   *
;  **************
;
N_WITHIN:   DD      6
        DB      "WITHIN"
WITHIN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TSTOR-(CW*(C_HOFFSET))
        DD    N_WITHIN
    DD    0

        DD      OVER, LSUB, TOR
        DD      LSUB, FROMR
        DD      ULESS
        DD      SEMIS
;


;  **********
;  *   L@   *
;  **********
;
N_LFET:   DD      2
        DB      "L@"
LFET:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    WITHIN-(CW*(C_HOFFSET))
        DD    N_LFET
    DD    0

        POP     EBX      ;MEM LOC
        POP     ECX      ;SEG REG VAL
        MOV     EDX,DS   ; Leave this for real mode code.
        MOV     DS,ECX
        MOV     EBX,[EBX]
        MOV     DS,EDX
        PUSH    EBX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   L!   *
;  **********
;
N_LSTORE:   DD      2
        DB      "L!"
LSTORE:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LFET-(CW*(C_HOFFSET))
        DD    N_LSTORE
    DD    0

        POP     EBX
        POP     ECX
        POP     EDX
        MOV     EAX,DS
        MOV     DS,ECX
        MOV     [EBX],EDX
        MOV     DS,EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;
;

;  *********
;  *   :   *
;  *********
;
N_COLON:   DD      1
        DB      ":"
COLON:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LSTORE-(CW*(C_HOFFSET))
        DD    N_COLON
    DD    0

        DD      SCSP
        DD      LPWORD
        DD      PCREAT
        DD      LATEST, HIDDEN
        DD      RBRAC
        DD      PSCOD
DOCOL:  LEA     EBP,[EBP - (CW*(1))]  ;Push HIP
        MOV     [EBP],ESI ;R1 <- (IP)
         MOV     ESI,[EAX+(CW*(D_HOFFSET - C_HOFFSET))]  ;(IP) <- (PFA)
;        CALL    DISPLAYSI
; 
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *********
;  *   ;   *
;  *********
;
N_SEMI:   DD      1
        DB      ";"
SEMI:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    COLON-(CW*(C_HOFFSET))
        DD    N_SEMI
    DD    0

        DD      QCSP
        DD      LIT, SEMIS, COMMA
        DD      LATEST, HIDDEN
        DD      LBRAC
        DD      SEMIS
;

;  ****************
;  *   CONSTANT   *
;  ****************
;
N_LCONST:   DD      8
        DB      "CONSTANT"
LCONST:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SEMI-(CW*(C_HOFFSET))
        DD    N_LCONST
    DD    0

        DD      LPWORD
        DD      PCREAT
        DD      LATEST, TDFA, STORE
        DD      PSCOD
DOCON:  MOV     EAX,[EAX+(CW*((D_HOFFSET-C_HOFFSET)))] ;GET DATA FROM PFA
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ****************
;  *   VARIABLE   *
;  ****************
;
N_VAR:   DD      8
        DB      "VARIABLE"
VAR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LCONST-(CW*(C_HOFFSET))
        DD    N_VAR
    DD    0

        DD      LPWORD
        DD      PCREAT
        DD      ZERO, COMMA
        DD      PSCOD
DOVAR:  MOV     EAX,[EAX+(CW*((D_HOFFSET-C_HOFFSET)))] ;(AX) <- PFA
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   USER   *
;  ************
;
N_USER:   DD      4
        DB      "USER"
USER:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    VAR-(CW*(C_HOFFSET))
        DD    N_USER
    DD    0

        DD      LCONST
        DD      PSCOD
DOUSE:  MOV     EBX,[EAX+(CW*((D_HOFFSET-C_HOFFSET)))] ;PFA  
        MOV     EDI, LONG[USINI]
        LEA     EAX,[EBX+EDI]      ;ADDR OF VARIABLE
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;
;

;  *********
;  *   _   *
;  *********
;
N_X:   DD      1
        DB      "_"
X:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    USER-(CW*(C_HOFFSET))
        DD    N_X
    DD    0

        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]    ;Whatever happens to be in EAX, i.e. the dea of ``_''.
;

;  *********
;  *   0   *
;  *********
;
N_ZERO:   DD      1
        DB      "0"
ZERO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    X-(CW*(C_HOFFSET))
        DD    N_ZERO
    DD    0

        XOR     EAX,EAX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *********
;  *   1   *
;  *********
;
N_ONE:   DD      1
        DB      "1"
ONE:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ZERO-(CW*(C_HOFFSET))
        DD    N_ONE
    DD    0

        MOV     EAX,1
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *********
;  *   2   *
;  *********
;
N_TWO:   DD      1
        DB      "2"
TWO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ONE-(CW*(C_HOFFSET))
        DD    N_TWO
    DD    0

        MOV     EAX,2
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   BL   *
;  **********
;
N_LBL:   DD      2
        DB      "BL"
LBL:        DD    DOCON
        DD    ABL
        DD    0H
        DD    TWO-(CW*(C_HOFFSET))
        DD    N_LBL
    DD    0

;

;  **********
;  *   $@   *
;  **********
;
N_SFET:   DD      2
        DB      "$@"
SFET:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LBL-(CW*(C_HOFFSET))
        DD    N_SFET
    DD    0

        DD LDUP, CELLP, SWAP, FETCH
        DD SEMIS
;

;  **********
;  *   $!   *
;  **********
;
N_SSTOR:   DD      2
        DB      "$!"
SSTOR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SFET-(CW*(C_HOFFSET))
        DD    N_SSTOR
    DD    0

        DD TDUP, STORE, CELLP, SWAP, LCMOVE
        DD SEMIS
;

;  *************
;  *   $!-BD   *
;  *************
;
N_SSTORBD:   DD      5
        DB      "$!-BD"
SSTORBD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SSTOR-(CW*(C_HOFFSET))
        DD    N_SSTORBD
    DD    0

        DD TDUP, CSTOR, ONEP, SWAP, LCMOVE
        DD SEMIS
;

;  ***********
;  *   $+!   *
;  ***********
;
N_SADD:   DD      3
        DB      "$+!"
SADD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SSTORBD-(CW*(C_HOFFSET))
        DD    N_SADD
    DD    0

        DD   LDUP, FETCH, TOR ; Remember old count.
        DD   TDUP, PSTORE
        DD   CELLP, FROMR, PLUS, SWAP, LCMOVE
        DD SEMIS
;

;  ***********
;  *   $C+   *
;  ***********
;
N_CHAPP:   DD      3
        DB      "$C+"
CHAPP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SADD-(CW*(C_HOFFSET))
        DD    N_CHAPP
    DD    0

        DD   LDUP, TOR
        DD   LDUP, FETCH, PLUS, CELLP, CSTOR
        DD   ONE, FROMR, PSTORE
        DD SEMIS
;

;  **********
;  *   $,   *
;  **********
;
N_SCOMMA:   DD      2
        DB      "$,"
SCOMMA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CHAPP-(CW*(C_HOFFSET))
        DD    N_SCOMMA
    DD    0

        DD HERE, TOR
        DD LDUP, CELLP, ALLOT
        DD RR, SSTOR, FROMR
        DD SEMIS
;

;  ***********
;  *   C/L   *
;  ***********
;
N_CSLL:   DD      3
        DB      "C/L"
CSLL:        DD    DOCON
        DD    64
        DD    0H
        DD    SCOMMA-(CW*(C_HOFFSET))
        DD    N_CSLL
    DD    0

;


;  *************
;  *   FIRST   *
;  *************
;
N_FIRST:   DD      5
        DB      "FIRST"
FIRST:        DD    DOCON
        DD    BUF1
        DD    0H
        DD    CSLL-(CW*(C_HOFFSET))
        DD    N_FIRST
    DD    0

 ;  
;
; 
;

;  *************
;  *   LIMIT   *
;  *************
;
N_LIMIT:   DD      5
        DB      "LIMIT"
LIMIT:        DD    DOCON
        DD    BUF1+(KBBUF+2*CW)*NBUF
        DD    0H
        DD    FIRST-(CW*(C_HOFFSET))
        DD    N_LIMIT
    DD    0

; THE END  OF THE MEMORY 

;  **********
;  *   EM   *
;  **********
;
N_LEM:   DD      2
        DB      "EM"
LEM:        DD    DOCON
        DD    ACTUAL_EM
        DD    0H
        DD    LIMIT-(CW*(C_HOFFSET))
        DD    N_LEM
    DD    0

;

;  **********
;  *   BM   *
;  **********
;
N_LBM:   DD      2
        DB      "BM"
LBM:        DD    DOCON
        DD    ORG0
        DD    0H
        DD    LEM-(CW*(C_HOFFSET))
        DD    N_LBM
    DD    0

;

;  *************
;  *   B/BUF   *
;  *************
;
N_BBUF:   DD      5
        DB      "B/BUF"
BBUF:        DD    DOCON
        DD    KBBUF
        DD    0H
        DD    LBM-(CW*(C_HOFFSET))
        DD    N_BBUF
    DD    0

;
; All user variables are initialised 
; with the values from USINI.
; The implementation relies on the initialisation of 
; those with numbers (1..11), so change in concord with USINI.

;  **********
;  *   U0   *
;  **********
;
N_UZERO:   DD      2
        DB      "U0"
UZERO:        DD    DOUSE
        DD    (CW*(1))
        DD    0H
        DD    BBUF-(CW*(C_HOFFSET))
        DD    N_UZERO
    DD    0

;

;  **********
;  *   S0   *
;  **********
;
N_SZERO:   DD      2
        DB      "S0"
SZERO:        DD    DOUSE
        DD    (CW*(2))
        DD    0H
        DD    UZERO-(CW*(C_HOFFSET))
        DD    N_SZERO
    DD    0

;

;  **********
;  *   R0   *
;  **********
;
N_RZERO:   DD      2
        DB      "R0"
RZERO:        DD    DOUSE
        DD    (CW*(3))
        DD    0H
        DD    SZERO-(CW*(C_HOFFSET))
        DD    N_RZERO
    DD    0

;

;  ***********
;  *   TIB   *
;  ***********
;
N_TIB:   DD      3
        DB      "TIB"
TIB:        DD    DOUSE
        DD    (CW*(4))
        DD    0H
        DD    RZERO-(CW*(C_HOFFSET))
        DD    N_TIB
    DD    0

;

;  **************
;  *   RUBOUT   *
;  **************
;
N_RUBOUT:   DD      6
        DB      "RUBOUT"
RUBOUT:        DD    DOUSE
        DD    (CW*(5))
        DD    0H
        DD    TIB-(CW*(C_HOFFSET))
        DD    N_RUBOUT
    DD    0

;

;  ***************
;  *   WARNING   *
;  ***************
;
N_LWARN:   DD      7
        DB      "WARNING"
LWARN:        DD    DOUSE
        DD    (CW*(7))
        DD    0H
        DD    RUBOUT-(CW*(C_HOFFSET))
        DD    N_LWARN
    DD    0

;

;  *************
;  *   FENCE   *
;  *************
;
N_FENCE:   DD      5
        DB      "FENCE"
FENCE:        DD    DOUSE
        DD    (CW*(8))
        DD    0H
        DD    LWARN-(CW*(C_HOFFSET))
        DD    N_FENCE
    DD    0

;

;  **********
;  *   DP   *
;  **********
;
N_LDP:   DD      2
        DB      "DP"
LDP:        DD    DOUSE
        DD    (CW*(9))
        DD    0H
        DD    FENCE-(CW*(C_HOFFSET))
        DD    N_LDP
    DD    0

;

;  ****************
;  *   VOC-LINK   *
;  ****************
;
N_VOCL:   DD      8
        DB      "VOC-LINK"
VOCL:        DD    DOUSE
        DD    (CW*(10))
        DD    0H
        DD    LDP-(CW*(C_HOFFSET))
        DD    N_VOCL
    DD    0

;

;  **************
;  *   OFFSET   *
;  **************
;
N_LOFFSET:   DD      6
        DB      "OFFSET"
LOFFSET:        DD    DOUSE
        DD    (CW*(11))
        DD    0H
        DD    VOCL-(CW*(C_HOFFSET))
        DD    N_LOFFSET
    DD    0

;
; End of user variables with fixed place.
;
;

;  *************
;  *   WHERE   *
;  *************
;
N_LWHERE:   DD      5
        DB      "WHERE"
LWHERE:        DD    DOUSE
        DD    (CW*(12))
        DD    0H
        DD    LOFFSET-(CW*(C_HOFFSET))
        DD    N_LWHERE
    DD    0
    ;  Occupies two CELLS! 
;

;  ***********
;  *   SCR   *
;  ***********
;
N_SCR:   DD      3
        DB      "SCR"
SCR:        DD    DOUSE
        DD    (CW*(33))
        DD    0H
        DD    LWHERE-(CW*(C_HOFFSET))
        DD    N_SCR
    DD    0

;

;  *************
;  *   STATE   *
;  *************
;
N_STATE:   DD      5
        DB      "STATE"
STATE:        DD    DOUSE
        DD    (CW*(18))
        DD    0H
        DD    SCR-(CW*(C_HOFFSET))
        DD    N_STATE
    DD    0

;

;  ************
;  *   BASE   *
;  ************
;
N_BASE:   DD      4
        DB      "BASE"
BASE:        DD    DOUSE
        DD    (CW*(19))
        DD    0H
        DD    STATE-(CW*(C_HOFFSET))
        DD    N_BASE
    DD    0

;

;  ***********
;  *   DPL   *
;  ***********
;
N_DPL:   DD      3
        DB      "DPL"
DPL:        DD    DOUSE
        DD    (CW*(20))
        DD    0H
        DD    BASE-(CW*(C_HOFFSET))
        DD    N_DPL
    DD    0

;

;  ***********
;  *   FLD   *
;  ***********
;
N_LFLD:   DD      3
        DB      "FLD"
LFLD:        DD    DOUSE
        DD    (CW*(21))
        DD    0H
        DD    DPL-(CW*(C_HOFFSET))
        DD    N_LFLD
    DD    0

;


;  ***********
;  *   CSP   *
;  ***********
;
N_LCSP:   DD      3
        DB      "CSP"
LCSP:        DD    DOUSE
        DD    (CW*(22))
        DD    0H
        DD    LFLD-(CW*(C_HOFFSET))
        DD    N_LCSP
    DD    0

;
;

;  **********
;  *   R#   *
;  **********
;
N_RNUM:   DD      2
        DB      "R#"
RNUM:        DD    DOUSE
        DD    (CW*(23))
        DD    0H
        DD    LCSP-(CW*(C_HOFFSET))
        DD    N_RNUM
    DD    0

;

;  ***********
;  *   HLD   *
;  ***********
;
N_HLD:   DD      3
        DB      "HLD"
HLD:        DD    DOUSE
        DD    (CW*(24))
        DD    0H
        DD    RNUM-(CW*(C_HOFFSET))
        DD    N_HLD
    DD    0

;

;  ***********
;  *   OUT   *
;  ***********
;
N_LOUT:   DD      3
        DB      "OUT"
LOUT:        DD    DOUSE
        DD    (CW*(25))
        DD    0H
        DD    HLD-(CW*(C_HOFFSET))
        DD    N_LOUT
    DD    0

;

;  *************
;  *   (BLK)   *
;  *************
;
N_PBLK:   DD      5
        DB      "(BLK)"
PBLK:        DD    DOUSE
        DD    (CW*(26))
        DD    0H
        DD    LOUT-(CW*(C_HOFFSET))
        DD    N_PBLK
    DD    0

;

;  **********
;  *   IN   *
;  **********
;
N_LIN:   DD      2
        DB      "IN"
LIN:        DD    DOUSE
        DD    (CW*(29))
        DD    0H
        DD    PBLK-(CW*(C_HOFFSET))
        DD    N_LIN
    DD    0

;


;  *************
;  *   (>IN)   *
;  *************
;
N_PIIN:   DD      5
        DB      "(>IN)"
PIIN:        DD    DOUSE
        DD    (CW*(30))
        DD    0H
        DD    LIN-(CW*(C_HOFFSET))
        DD    N_PIIN
    DD    0

;
;

;  ************
;  *   ARGS   *
;  ************
;
N_ARGS:   DD      4
        DB      "ARGS"
ARGS:        DD    DOUSE
        DD    (CW*(31))
        DD    0H
        DD    PIIN-(CW*(C_HOFFSET))
        DD    N_ARGS
    DD    0

;

;  ***************
;  *   HANDLER   *
;  ***************
;
N_HANDLER:   DD      7
        DB      "HANDLER"
HANDLER:        DD    DOUSE
        DD    (CW*(32))
        DD    0H
        DD    ARGS-(CW*(C_HOFFSET))
        DD    N_HANDLER
    DD    0

;

;  ***************
;  *   CURRENT   *
;  ***************
;
N_CURR:   DD      7
        DB      "CURRENT"
CURR:        DD    DOUSE
        DD    (CW*(34))
        DD    0H
        DD    HANDLER-(CW*(C_HOFFSET))
        DD    N_CURR
    DD    0

;

;  *****************
;  *   REMAINDER   *
;  *****************
;
N_REMAIND:   DD      9
        DB      "REMAINDER"
REMAIND:        DD    DOUSE
        DD    (CW*(14))
        DD    0H
        DD    CURR-(CW*(C_HOFFSET))
        DD    N_REMAIND
    DD    0

;      IMPORTANT
; REQUIRES ONE MORE CELL!
;

;  ********************
;  *   SEARCH-ORDER   *
;  ********************
;
N_SEARCH:   DD      12
        DB      "SEARCH-ORDER"
SEARCH:        DD    DOUSE
        DD    (CW*(37))
        DD    0H
        DD    REMAIND-(CW*(C_HOFFSET))
        DD    N_SEARCH
    DD    0
 ; Up to  37+8
;      IMPORTANT
;     8 USER SPACE CELLS MUST BE KEPT FREE
;     IN ADDITION TO THE ONE FOR SEARCH
;
;========== END USER VARIABLES =============;
;

;  **********
;  *   1+   *
;  **********
;
N_ONEP:   DD      2
        DB      "1+"
ONEP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SEARCH-(CW*(C_HOFFSET))
        DD    N_ONEP
    DD    0

        DD      ONE
        DD      PLUS
        DD      SEMIS
;

;  *************
;  *   CELL+   *
;  *************
;
N_CELLP:   DD      5
        DB      "CELL+"
CELLP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ONEP-(CW*(C_HOFFSET))
        DD    N_CELLP
    DD    0

        DD      LIT, CW
        DD      PLUS
        DD      SEMIS
;

;
;  *************
;  *   CELLS   *
;  *************
;
N_LCELLS:   DD      5
        DB      "CELLS"
LCELLS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CELLP-(CW*(C_HOFFSET))
        DD    N_LCELLS
    DD    0

        DD       TWO 
        DD      LSHIFT
        DD      SEMIS
;

;  *************
;  *   CHAR+   *
;  *************
;
N_CHARP:   DD      5
        DB      "CHAR+"
CHARP:        DD    DOCOL
        DD    (ONEP+(CW*(PH_OFFSET-C_HOFFSET)))
        DD    0H
        DD    LCELLS-(CW*(C_HOFFSET))
        DD    N_CHARP
    DD    0

;

;  *************
;  *   CHARS   *
;  *************
;
N_CHARS:   DD      5
        DB      "CHARS"
CHARS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    CHARP-(CW*(C_HOFFSET))
        DD    N_CHARS
    DD    0

        DD      SEMIS
;

;  *************
;  *   ALIGN   *
;  *************
;
N_LALIGN:   DD      5
        DB      "ALIGN"
LALIGN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    CHARS-(CW*(C_HOFFSET))
        DD    N_LALIGN
    DD    0

        DD      SEMIS
;

;  ***************
;  *   ALIGNED   *
;  ***************
;
N_ALIGNED:   DD      7
        DB      "ALIGNED"
ALIGNED:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LALIGN-(CW*(C_HOFFSET))
        DD    N_ALIGNED
    DD    0

        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   HERE   *
;  ************
;
N_HERE:   DD      4
        DB      "HERE"
HERE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ALIGNED-(CW*(C_HOFFSET))
        DD    N_HERE
    DD    0

        DD      LDP
        DD      FETCH
        DD      SEMIS
;

;  *************
;  *   ALLOT   *
;  *************
;
N_ALLOT:   DD      5
        DB      "ALLOT"
ALLOT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    HERE-(CW*(C_HOFFSET))
        DD    N_ALLOT
    DD    0

        DD      LDP
        DD      PSTORE
        DD      SEMIS
;

;  *********
;  *   ,   *
;  *********
;
N_COMMA:   DD      1
        DB      ","
COMMA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ALLOT-(CW*(C_HOFFSET))
        DD    N_COMMA
    DD    0

        DD      HERE
        DD      STORE
        DD      LIT, CW
        DD      ALLOT
        DD      SEMIS
;

;  **********
;  *   C,   *
;  **********
;
N_CCOMM:   DD      2
        DB      "C,"
CCOMM:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    COMMA-(CW*(C_HOFFSET))
        DD    N_CCOMM
    DD    0

        DD      HERE
        DD      CSTOR
        DD      ONE
        DD      ALLOT
        DD      SEMIS
;

;  *********
;  *   -   *
;  *********
;
N_LSUB:   DD      1
        DB      "-"
LSUB:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CCOMM-(CW*(C_HOFFSET))
        DD    N_LSUB
    DD    0

        POP     EDX      ;S1
        POP     EAX
        SUB     EAX,EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]      ;S1 = S2 - S1
;

;  *********
;  *   =   *
;  *********
;
N_EQUAL:   DD      1
        DB      "="
EQUAL:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LSUB-(CW*(C_HOFFSET))
        DD    N_EQUAL
    DD    0

        DD      LSUB
        DD      ZEQU
        DD      SEMIS
;

;  *********
;  *   <   *
;  *********
;
N_LESS:   DD      1
        DB      "<"
LESS:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    EQUAL-(CW*(C_HOFFSET))
        DD    N_LESS
    DD    0

        POP     EDX      ;S1
        POP     EBX      ;S2
        XOR     EAX,EAX   ;0 default RESULT
        CMP     EBX,EDX
        JNL     LES1
        DEC     EAX
LES1:   PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   U<   *
;  **********
;
N_ULESS:   DD      2
        DB      "U<"
ULESS:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LESS-(CW*(C_HOFFSET))
        DD    N_ULESS
    DD    0

        POP     EAX
        POP     EDX
        SUB     EDX,EAX
        SBB     EAX,EAX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *********
;  *   >   *
;  *********
;
N_GREAT:   DD      1
        DB      ">"
GREAT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ULESS-(CW*(C_HOFFSET))
        DD    N_GREAT
    DD    0

        DD      SWAP
        DD      LESS
        DD      SEMIS
;

;  **********
;  *   <>   *
;  **********
;
N_UNEQ:   DD      2
        DB      "<>"
UNEQ:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    GREAT-(CW*(C_HOFFSET))
        DD    N_UNEQ
    DD    0

        DD      LSUB
        DD      ZEQU
        DD      ZEQU
        DD      SEMIS
;

;  ***********
;  *   ROT   *
;  ***********
;
N_ROT:   DD      3
        DB      "ROT"
ROT:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    UNEQ-(CW*(C_HOFFSET))
        DD    N_ROT
    DD    0

        POP     EDX      ;S1
        POP     EBX      ;S2
        POP     EAX      ;S3
        PUSH    EBX
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *************
;  *   SPACE   *
;  *************
;
N_SPACE:   DD      5
        DB      "SPACE"
SPACE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ROT-(CW*(C_HOFFSET))
        DD    N_SPACE
    DD    0

        DD      LBL
        DD      EMIT
        DD      SEMIS
;

;  ************
;  *   ?DUP   *
;  ************
;
N_QDUP:   DD      4
        DB      "?DUP"
QDUP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SPACE-(CW*(C_HOFFSET))
        DD    N_QDUP
    DD    0

        DD      LDUP
        DD      ZBRAN
        DD      QDUP1-$-CW ; IF
        DD      LDUP    ;THEN
QDUP1:  DD      SEMIS
;

;  **************
;  *   LATEST   *
;  **************
;
N_LATEST:   DD      6
        DB      "LATEST"
LATEST:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QDUP-(CW*(C_HOFFSET))
        DD    N_LATEST
    DD    0

        DD      CURR
        DD      FETCH
        DD      TLFA
        DD      FETCH
        DD      SEMIS
;

;  ************
;  *   >CFA   *
;  ************
;
N_TCFA:   DD      4
        DB      ">CFA"
TCFA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LATEST-(CW*(C_HOFFSET))
        DD    N_TCFA
    DD    0

        DD      LIT, (CW*(C_HOFFSET))
        DD      PLUS
        DD      SEMIS
;

;  ************
;  *   >DFA   *
;  ************
;
N_TDFA:   DD      4
        DB      ">DFA"
TDFA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TCFA-(CW*(C_HOFFSET))
        DD    N_TDFA
    DD    0

        DD      LIT, (CW*(D_HOFFSET))
        DD      PLUS
        DD      SEMIS
;

;  ************
;  *   >FFA   *
;  ************
;
N_TFFA:   DD      4
        DB      ">FFA"
TFFA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TDFA-(CW*(C_HOFFSET))
        DD    N_TFFA
    DD    0

        DD      LIT, (CW*(F_HOFFSET))
        DD      PLUS
        DD      SEMIS
;

;  ************
;  *   >LFA   *
;  ************
;
N_TLFA:   DD      4
        DB      ">LFA"
TLFA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TFFA-(CW*(C_HOFFSET))
        DD    N_TLFA
    DD    0

        DD      LIT, (CW*(L_HOFFSET))
        DD      PLUS
        DD      SEMIS
;

;  ************
;  *   >NFA   *
;  ************
;
N_TNFA:   DD      4
        DB      ">NFA"
TNFA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TLFA-(CW*(C_HOFFSET))
        DD    N_TNFA
    DD    0

        DD      LIT,(CW*(N_HOFFSET))
        DD      PLUS
        DD      SEMIS
;


;
;  ************
;  *   >SFA   *
;  ************
;
N_TSFA:   DD      4
        DB      ">SFA"
TSFA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TNFA-(CW*(C_HOFFSET))
        DD    N_TSFA
    DD    0

        DD      LIT,(CW*(S_HOFFSET))
        DD      PLUS
        DD      SEMIS
;
;

;  ************
;  *   >PHA   *
;  ************
;
N_TPHA:   DD      4
        DB      ">PHA"
TPHA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TSFA-(CW*(C_HOFFSET))
        DD    N_TPHA
    DD    0

        DD      LIT,(CW*(PH_OFFSET))
        DD      PLUS
        DD      SEMIS
;

;  *************
;  *   >BODY   *
;  *************
;
N_TOBODY:   DD      5
        DB      ">BODY"
TOBODY:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TPHA-(CW*(C_HOFFSET))
        DD    N_TOBODY
    DD    0

        DD      CTOD
        DD      TDFA, FETCH
        DD      CELLP           ; Skip DOES> pointer.
        DD      SEMIS
;

;  *************
;  *   BODY>   *
;  *************
;
N_BODYF:   DD      5
        DB      "BODY>"
BODYF:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TOBODY-(CW*(C_HOFFSET))
        DD    N_BODYF
    DD    0

        DD      LIT,(CW*(BD_OFFSET))
        DD      LSUB
        DD      SEMIS
;

;  ************
;  *   CFA>   *
;  ************
;
N_CTOD:   DD      4
        DB      "CFA>"
CTOD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BODYF-(CW*(C_HOFFSET))
        DD    N_CTOD
    DD    0

        DD      LIT,(CW*(C_HOFFSET))
        DD      LSUB
        DD      SEMIS
;

;  ************
;  *   >WID   *
;  ************
;
N_TWID:   DD      4
        DB      ">WID"
TWID:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CTOD-(CW*(C_HOFFSET))
        DD    N_TWID
    DD    0

        DD      TOBODY
        DD      CELLP ; Skip vfa link.
        DD      SEMIS
;

;  ************
;  *   >VFA   *
;  ************
;
N_TVFA:   DD      4
        DB      ">VFA"
TVFA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TWID-(CW*(C_HOFFSET))
        DD    N_TVFA
    DD    0

        DD      TOBODY
        DD      SEMIS
;


;  ************
;  *   !CSP   *
;  ************
;
N_SCSP:   DD      4
        DB      "!CSP"
SCSP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TVFA-(CW*(C_HOFFSET))
        DD    N_SCSP
    DD    0

        DD      SPFET
        DD      LCSP
        DD      STORE
        DD      SEMIS
;
;

;  **************
;  *   ?ERROR   *
;  **************
;
N_QERR:   DD      6
        DB      "?ERROR"
QERR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SCSP-(CW*(C_HOFFSET))
        DD    N_QERR
    DD    0

        DD      SWAP
        DD      ZBRAN
        DD      QERR1-$-CW ;IF
        DD      LIN, FETCH
        DD      SRC, FETCH
        DD      LWHERE, TSTOR
        DD      THROW
        DD      BRAN
        DD      QERR2-$-CW  ;ELSE
QERR1:  DD      DROP    ;THEN
QERR2:  DD      SEMIS
;

;  **************
;  *   ?ERRUR   *
;  **************
;
N_QERRUR:   DD      6
        DB      "?ERRUR"
QERRUR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QERR-(CW*(C_HOFFSET))
        DD    N_QERRUR
    DD    0

        DD      ZERO, MIN, LDUP, QERR
        DD      SEMIS
;


;  **************
;  *   ?DELIM   *
;  **************
;
N_QDELIM:   DD      6
        DB      "?DELIM"
QDELIM:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QERRUR-(CW*(C_HOFFSET))
        DD    N_QDELIM
    DD    0

        DD      INBRS
        DD      QBL
        DD      ZEQU
        DD      LIT, 10, QERR
        DD      DROP
        DD      SEMIS
;

;  ************
;  *   ?CSP   *
;  ************
;
N_QCSP:   DD      4
        DB      "?CSP"
QCSP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QDELIM-(CW*(C_HOFFSET))
        DD    N_QCSP
    DD    0

        DD      SPFET
        DD      LCSP
        DD      FETCH
        DD      LSUB
        DD      LIT, 20, QERR
        DD      SEMIS
;

;  *************
;  *   ?COMP   *
;  *************
;
N_QCOMP:   DD      5
        DB      "?COMP"
QCOMP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QCSP-(CW*(C_HOFFSET))
        DD    N_QCOMP
    DD    0

        DD      STATE
        DD      FETCH
        DD      ZEQU
        DD      LIT, 17, QERR
        DD      SEMIS
;

;  *************
;  *   ?EXEC   *
;  *************
;
N_QEXEC:   DD      5
        DB      "?EXEC"
QEXEC:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QCOMP-(CW*(C_HOFFSET))
        DD    N_QEXEC
    DD    0

        DD      STATE
        DD      FETCH
        DD      LIT, 18, QERR
        DD      SEMIS
;

;  **************
;  *   ?PAIRS   *
;  **************
;
N_QPAIR:   DD      6
        DB      "?PAIRS"
QPAIR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QEXEC-(CW*(C_HOFFSET))
        DD    N_QPAIR
    DD    0

        DD      LSUB
        DD      LIT, 19, QERR
        DD      SEMIS
;


;  ****************
;  *   ?LOADING   *
;  ****************
;
N_QLOAD:   DD      8
        DB      "?LOADING"
QLOAD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QPAIR-(CW*(C_HOFFSET))
        DD    N_QLOAD
    DD    0

        DD      BLK
        DD      FETCH
        DD      ZEQU
        DD      LIT, 22, QERR
        DD      SEMIS
;
;
;
;

;  *********
;  *   [   *
;  *********
;
N_LBRAC:   DD      1
        DB      "["
LBRAC:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    QLOAD-(CW*(C_HOFFSET))
        DD    N_LBRAC
    DD    0

        DD      ZERO
        DD      STATE
        DD      STORE
        DD      SEMIS
;

;  *********
;  *   ]   *
;  *********
;
N_RBRAC:   DD      1
        DB      "]"
RBRAC:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LBRAC-(CW*(C_HOFFSET))
        DD    N_RBRAC
    DD    0

        DD      ONE
        DD      STATE
        DD      STORE
        DD      SEMIS
;

;  **************
;  *   HIDDEN   *
;  **************
;
N_HIDDEN:   DD      6
        DB      "HIDDEN"
HIDDEN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RBRAC-(CW*(C_HOFFSET))
        DD    N_HIDDEN
    DD    0

        DD      TFFA
        DD      LIT,B_INVIS
        DD      TOGGL
        DD      SEMIS
;

;  ***********
;  *   HEX   *
;  ***********
;
N_HEX:   DD      3
        DB      "HEX"
HEX:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    HIDDEN-(CW*(C_HOFFSET))
        DD    N_HEX
    DD    0

        DD      LIT,16
        DD      BASE
        DD      STORE
        DD      SEMIS
;

;  ***************
;  *   DECIMAL   *
;  ***************
;
N_DECA:   DD      7
        DB      "DECIMAL"
DECA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    HEX-(CW*(C_HOFFSET))
        DD    N_DECA
    DD    0

        DD      LIT,10
        DD      BASE
        DD      STORE
        DD      SEMIS
;

;  ***************
;  *   (;CODE)   *
;  ***************
;
N_PSCOD:   DD      7
        DB      "(;CODE)"
PSCOD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DECA-(CW*(C_HOFFSET))
        DD    N_PSCOD
    DD    0

        DD      FROMR
        DD      LATEST
        DD      TCFA
        DD      STORE
        DD      SEMIS
;

;

;  **************
;  *   CREATE   *
;  **************
;
N_CREATE:   DD      6
        DB      "CREATE"
CREATE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PSCOD-(CW*(C_HOFFSET))
        DD    N_CREATE
    DD    0

        DD      LPWORD
        DD      PCREAT
        DD      LIT, HLNOOP, COMMA
        DD      PSCOD
DODOE:  LEA     EBP,[EBP - (CW*(1))] ;Push HIP.
        MOV     [EBP],ESI
        MOV     ESI,[EAX+(CW*((D_HOFFSET-C_HOFFSET)))] ;NEW IP 
        LEA     EAX,[ESI+(CW*(1))]
        MOV     ESI,[ESI]
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
HLNOOP: DD      SEMIS
;

;  *************
;  *   DOES>   *
;  *************
;
N_DOES:   DD      5
        DB      "DOES>"
DOES:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CREATE-(CW*(C_HOFFSET))
        DD    N_DOES
    DD    0

        DD      FROMR
        DD      LATEST
        DD      TDFA
        DD      FETCH
        DD      STORE
        DD      SEMIS
;

;  *************
;  *   COUNT   *
;  *************
;
N_COUNT:   DD      5
        DB      "COUNT"
COUNT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DOES-(CW*(C_HOFFSET))
        DD    N_COUNT
    DD    0

        DD      LDUP
        DD      ONEP
        DD      SWAP
        DD      CFET
        DD      SEMIS
;

;  *****************
;  *   -TRAILING   *
;  *****************
;
N_DTRAI:   DD      9
        DB      "-TRAILING"
DTRAI:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    COUNT-(CW*(C_HOFFSET))
        DD    N_DTRAI
    DD    0

        DD      LDUP
        DD      ZERO
        DD     XQDO
        DD      DTRA4-$-CW
DTRA1:  DD      OVER
        DD      OVER
        DD      PLUS
        DD      ONE
        DD      LSUB
        DD      CFET
        DD      QBL
        DD      ZEQU
        DD      ZBRAN
        DD      DTRA2-$-CW ;IF
        DD      LLEAV
DTRA2:  DD      ONE
        DD      LSUB    ; THEN
        DD     XLOOP
        DD      DTRA1-$-CW    ; LOOP
DTRA4:
        DD      SEMIS
;


;  **********
;  *   S"   *
;  **********
;
N_SQUOT:   DD      2
        DB      'S"'
SQUOT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    DTRAI-(CW*(C_HOFFSET))
        DD    N_SQUOT
    DD    0

        DD      DENQ
        DD      SEMIS
;
;

;  **********
;  *   ."   *
;  **********
;
N_DOTQ:   DD      2
        DB      '."'
DOTQ:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    SQUOT-(CW*(C_HOFFSET))
        DD    N_DOTQ
    DD    0

        DD      DENQ
        DD      STATE
        DD      FETCH
        DD      ZBRAN
        DD      DOTQ1-$-CW ; IF
        DD      LIT, LTYPE, COMMA
        DD      BRAN
        DD      DOTQ2-$-CW
DOTQ1:
        DD      LTYPE
DOTQ2:
        DD      SEMIS   ; THEN
;

;  **********
;  *   .(   *
;  **********
;
N_DOTP:   DD      2
        DB      ".("
DOTP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    DOTQ-(CW*(C_HOFFSET))
        DD    N_DOTP
    DD    0

        DD      LIT, ')'
        DD      PPARS
        DD      LTYPE
        DD      SEMIS
;

;  ***************
;  *   SET-SRC   *
;  ***************
;
N_SETSRC:   DD      7
        DB      "SET-SRC"
SETSRC:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DOTP-(CW*(C_HOFFSET))
        DD    N_SETSRC
    DD    0

        DD      OVER, PLUS
        DD      SWAP, SRC, TSTOR
        DD      SRC, FETCH
        DD      LIN, STORE ;  IN

;       DD      DOTS
        DD      SEMIS
;

;  ****************
;  *   EVALUATE   *
;  ****************
;
N_EVALUATE:   DD      8
        DB      "EVALUATE"
EVALUATE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SETSRC-(CW*(C_HOFFSET))
        DD    N_EVALUATE
    DD    0

        DD      SAVE
        DD      SETSRC
        DD      LIT, INTER, CATCH
        DD      RESTO
        DD      THROW
        DD      SEMIS
;

;  ************
;  *   FILL   *
;  ************
;
N_FILL:   DD      4
        DB      "FILL"
FILL:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    EVALUATE-(CW*(C_HOFFSET))
        DD    N_FILL
    DD    0

        POP     EAX      ; FILL CHAR
        POP     ECX      ; FILL COUNT
        POP     EDI      ; BEGIN ADDR
;       MOV    BX,DS
;       MOV    ES,BX   ; ES <- DS
        CLD             ; INC DIRECTION
        REP     STOSB   ;STORE BYTE
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ************
;  *   CORA   *
;  ************
;
N_CORA:   DD      4
        DB      "CORA"
CORA:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FILL-(CW*(C_HOFFSET))
        DD    N_CORA
    DD    0

;       MOV    ES,BX   ; ES <- DS
;       MOV    BX,DS
        MOV     EDX,ESI   ;SAVE
        XOR     EAX,EAX   ; Result
        POP     ECX      ; count
        POP     EDI      ; addr2
        POP     ESI      ; addr1
        CLD             ; INC DIRECTION
        REP     CMPSB   ; Compare BYTE
        JZ      CORA3
        MOV     AL,1    ;Remainder is already 0
        JNC     CORA3
        NEG     EAX
CORA3:
        MOV     ESI,EDX  ;Restore
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   $I   *
;  **********
;
N_SINDEX:   DD      2
        DB      "$I"
SINDEX:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CORA-(CW*(C_HOFFSET))
        DD    N_SINDEX
    DD    0

;       MOV    ES,BX   ; ES <- DS
;       MOV    BX,DS
        POP     EAX      ; char
        POP     ECX      ; count
        POP     EDI      ; addr
        OR      EDI,EDI   ;Clear zero flag.
        CLD             ; INC DIRECTION
        REPNZ     SCASB   ; Compare BYTE
        JZ      SINDEX1
        XOR     EDI,EDI    ;Not found: 0
        INC     EDI
SINDEX1:
        DEC     EDI
        PUSH    EDI
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   $S   *
;  **********
;
N_SSPLIT:   DD      2
        DB      "$S"
SSPLIT:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SINDEX-(CW*(C_HOFFSET))
        DD    N_SSPLIT
    DD    0

;       MOV    ES,BX   ; ES <- DS
;       MOV    BX,DS
        POP     EAX      ; char
        POP     ECX      ; count
        MOV     EBX,ECX
        POP     EDI      ; addr
        OR      EDI,EDI   ;Clear zero flag.
        MOV     EDX,EDI   ; Copy
        CLD             ; INC DIRECTION
        REPNZ     SCASB   ; Compare BYTE
        JZ      SSPLIT1
; Not present.
        PUSH    ECX   ; Nil pointer.
        JMP SSPLIT2
SSPLIT1:
        PUSH    EDI
        SUB     EBX,ECX
        DEC     EBX      ;Delimiter is not part of first string.
SSPLIT2:
        PUSH    ECX   ;Remaining length
        PUSH    EDX   ;Start of first string.
        PUSH    EBX   ;Skipped length.
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  *************
;  *   ERASE   *
;  *************
;
N_LERASE:   DD      5
        DB      "ERASE"
LERASE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SSPLIT-(CW*(C_HOFFSET))
        DD    N_LERASE
    DD    0

        DD      ZERO
        DD      FILL
        DD      SEMIS
;


;  *************
;  *   BLANK   *
;  *************
;
N_BLANK:   DD      5
        DB      "BLANK"
BLANK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LERASE-(CW*(C_HOFFSET))
        DD    N_BLANK
    DD    0

        DD      LBL
        DD      FILL
        DD      SEMIS
;
;

;  ************
;  *   HOLD   *
;  ************
;
N_HOLD:   DD      4
        DB      "HOLD"
HOLD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BLANK-(CW*(C_HOFFSET))
        DD    N_HOLD
    DD    0

        DD      LIT,-1
        DD      HLD
        DD      PSTORE
        DD      HLD
        DD      FETCH
        DD      CSTOR
        DD      SEMIS
;

;  ***********
;  *   PAD   *
;  ***********
;
N_PAD:   DD      3
        DB      "PAD"
PAD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    HOLD-(CW*(C_HOFFSET))
        DD    N_PAD
    DD    0

        DD      HERE
; Allow for a one line name, a double binary number and some hold char's
        DD      LIT,84+128+64
        DD      PLUS
        DD      SEMIS
;


;  ************
;  *   WORD   *
;  ************
;
N_IWORD:   DD      4
        DB      "WORD"
IWORD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PAD-(CW*(C_HOFFSET))
        DD    N_IWORD
    DD    0

        DD      LDUP, LBL, EQUAL
        DD      ZBRAN
        DD      IWORD1-$-CW
         DD      DROP
         DD      LPWORD
        DD      BRAN
        DD      IWORD2-$-CW
IWORD1: DD      TOR
IWORD3:  DD      INBRS, RR, EQUAL
        DD      ZBRAN
        DD      IWORD4-$-CW
        DD      DROP
        DD      BRAN
        DD      IWORD3-$-CW
IWORD4:
        DD      DROP
        DD      LIT, -1, LIN, PSTORE ; Backtrace to first non-delimiter.
        DD      FROMR, PPARS
;        DD      DOTS
IWORD2:
        DD      HERE
        DD      LIT,22H
        DD      BLANK
        DD      HERE
        DD      SSTORBD     ; FIXME
        DD      HERE
;        DD      DOTS
        DD      SEMIS
;
;

;  ************
;  *   CHAR   *
;  ************
;
N_LCHAR:   DD      4
        DB      "CHAR"
LCHAR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    IWORD-(CW*(C_HOFFSET))
        DD    N_LCHAR
    DD    0

        DD      LPWORD, DROP, CFET
        DD      SEMIS
;

;  **************
;  *   [CHAR]   *
;  **************
;
N_BCHAR:   DD      6
        DB      "[CHAR]"
BCHAR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    LCHAR-(CW*(C_HOFFSET))
        DD    N_BCHAR
    DD    0

        DD      LCHAR, LITER
        DD      SEMIS
;

;  ****************
;  *   (NUMBER)   *
;  ****************
;
N_PNUMB:   DD      8
        DB      "(NUMBER)"
PNUMB:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BCHAR-(CW*(C_HOFFSET))
        DD    N_PNUMB
    DD    0

        DD      ZERO, ZERO
        DD      ZERO, DPL, STORE
NPNUM1:  DD      INBRS   ; BEGIN
        DD      LDUP, LIT, ADOT, EQUAL
        DD      ZBRAN
        DD      NPNUM2A-$-CW ; IF
        DD      DROP, DPL, STORE, ZERO
        DD      BRAN
        DD      NPNUM3-$-CW ; ELSE
NPNUM2A:
        DD      LDUP, LIT, ',', EQUAL
        DD      ZBRAN
        DD      NPNUM2-$-CW ; IF
        DD      TDROP, ZERO
        DD      BRAN
        DD      NPNUM3-$-CW ; ELSE
NPNUM2:
        DD      LDUP, QBL
        DD      ZBRAN
        DD      NPNUM4-$-CW ; IF
        DD      DROP, DROP, ONE
        DD      BRAN
        DD      NPNUM3-$-CW ; ELSE
NPNUM4:
        DD      SWAP, DROP
        DD      BASE, FETCH, DIGIT
        DD      ZEQU
        DD      LIT, 10, QERR

        DD      SWAP
        DD      BASE
        DD      FETCH
        DD      USTAR
        DD      DROP
        DD      ROT
        DD      BASE
        DD      FETCH
        DD      USTAR
        DD      DPLUS
        DD      ZERO
NPNUM3:                 ; THEN THEN
        DD      ZBRAN
        DD      NPNUM1-$-CW
        DD      SEMIS
;

;  **************
;  *   NUMBER   *
;  **************
;
N_NUMB:   DD      6
        DB      "NUMBER"
NUMB:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PNUMB-(CW*(C_HOFFSET))
        DD    N_NUMB
    DD    0

LNUMB:
        DD      LIT, -1, LIN, PSTORE
        DD      PNUMB, SDLITE
        DD      SEMIS
;


;  ***************
;  *   >NUMBER   *
;  ***************
;
N_TONUMB:   DD      7
        DB      ">NUMBER"
TONUMB:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    NUMB-(CW*(C_HOFFSET))
        DD    N_TONUMB
    DD    0

        DD      TDUP, PLUS, TOR     ; End available on return stack.
        DD      ZERO
        DD     XQDO
        DD      TONUM9-$-CW
TONUM1:
        DD      LDUP, CFET, BASE, FETCH, DIGIT
        DD      ZEQU
        DD      ZBRAN
        DD      TONUM4-$-CW ; IF
        DD      DROP
        DD      LLEAV
TONUM4:
        DD      SWAP, TOR ; Address out of the way.
        DD      SWAP
        DD      BASE
        DD      FETCH
        DD      USTAR
        DD      DROP
        DD      ROT
        DD      BASE
        DD      FETCH
        DD      USTAR
        DD      DPLUS
        DD      FROMR, ONEP     ; Address back.
        DD     XLOOP
        DD      TONUM1-$-CW
TONUM9:
        DD      FROMR
        DD      OVER, LSUB
        DD      SEMIS
;
;

;  *************
;  *   FOUND   *
;  *************
;
N_FOUND:   DD      5
        DB      "FOUND"
FOUND:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TONUMB-(CW*(C_HOFFSET))
        DD    N_FOUND
    DD    0

        DD      SEARCH, TOR
FOUND1: DD      RR, FETCH
;        DD      DOTS
        DD      PFIND, LDUP, ZEQU
        DD      ZBRAN
        DD      FOUND3-$-CW
        DD      DROP
        DD      RR, FETCH, LIT, FORTH, LSUB ;Was this ONLY?
        DD      ZBRAN
        DD      FOUND2-$-CW
        DD      FROMR, CELLP, TOR
        DD      BRAN
        DD      FOUND1-$-CW
FOUND2: DD      ZERO
FOUND3: DD      RDROP
        DD      SWAP,DROP,SWAP,DROP
        DD      SEMIS
;

;  ***************
;  *   PRESENT   *
;  ***************
;
N_PRESENT:   DD      7
        DB      "PRESENT"
PRESENT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FOUND-(CW*(C_HOFFSET))
        DD    N_PRESENT
    DD    0

        DD      LDUP, TOR
        DD      FOUND
        DD      LDUP
        DD      ZBRAN
        DD      PRES1-$-CW
        DD      LDUP
        DD      TNFA, FETCH, FETCH ;  Get precise length.
        DD      RR, EQUAL
        DD      LAND
PRES1:
        DD      RDROP
        DD      SEMIS
;


;  ************
;  *   FIND   *
;  ************
;
N_FIND:   DD      4
        DB      "FIND"
FIND:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PRESENT-(CW*(C_HOFFSET))
        DD    N_FIND
    DD    0

        DD      LDUP, COUNT, PRESENT
        DD      LDUP
        DD      ZBRAN
        DD      FIND1-$-CW ;IF
        DD      SWAP, DROP ; The address.
        ; Fine point, get xt by TCFA. Even if a NOOP.
        DD      LDUP, TCFA, SWAP
        DD      TFFA, FETCH
        DD      LIT, B_IMMED, LAND
        DD      LIT, -1, SWAP
        DD      ZBRAN
        DD      FIND1-$-CW ;IF
        DD      NEGATE
FIND1:               ;THEN THEN
        DD      SEMIS
;

;  **************
;  *   (FIND)   *
;  **************
;
N_PFIND:   DD      6
        DB      "(FIND)"
PFIND:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FIND-(CW*(C_HOFFSET))
        DD    N_PFIND
    DD    0

PFIND0:
        DD      LDUP
        DD      ZBRAN
        DD      PFIND1-$-CW
        DD      PMATCH, ZEQU
        DD      ZBRAN
        DD      PFIND1-$-CW
        DD     TLFA, FETCH
        DD      BRAN
        DD      PFIND0-$-CW
PFIND1:
        DD      SEMIS
;

;  *************
;  *   ERROR   *
;  *************
;
N_ERROR:   DD      5
        DB      "ERROR"
ERROR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PFIND-(CW*(C_HOFFSET))
        DD    N_ERROR
    DD    0

        DD      LWHERE, TFET
        DD      OVER, LIT, 20, LSUB
        DD      MAX
        DD      SWAP,OVER, LSUB
        DD      LTYPE
        DD      SKIP
         DD      18
SB3: DB      "? ciforth ERROR # "
       
        DD      LIT, SB3
        DD      LIT, 18
        DD      LTYPE
        DD      BASE, FETCH
        DD      DECA
        DD      OVER
        DD      STOD, ZERO, PDDOTR      ;This is about (.) 
        DD      LTYPE
        DD      BASE, STORE
        DD      MESS
        DD      SEMIS
;

;  *************
;  *   CATCH   *
;  *************
;
N_CATCH:   DD      5
        DB      "CATCH"
CATCH:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ERROR-(CW*(C_HOFFSET))
        DD    N_CATCH
    DD    0

        DD      SPFET, CELLP, TOR
        DD      HANDLER, FETCH, TOR
        DD      RPFET, HANDLER, STORE
        DD      EXEC
        DD      FROMR, HANDLER, STORE
        DD      RDROP, ZERO
        DD      SEMIS
;

;  *************
;  *   THROW   *
;  *************
;
N_THROW:   DD      5
        DB      "THROW"
THROW:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CATCH-(CW*(C_HOFFSET))
        DD    N_THROW
    DD    0

        DD      LDUP
        DD      ZBRAN
        DD      THROW1-$-CW
        DD      HANDLER, FETCH, ZEQU
        DD      ZBRAN
        DD      THROW2-$-CW
        DD      ERROR
        DD      MTBUF  ; A (too) crude way to remove locks
        DD      SZERO, FETCH, SPSTO
        DD      QUIT
THROW2:
        DD      HANDLER, FETCH, RPSTO
        DD      FROMR, HANDLER, STORE
        DD      FROMR, SWAP, TOR
        DD      SPSTO
        DD      FROMR
        DD      X
THROW1:
        DD      DROP
        DD      SEMIS
;


;  ****************
;  *   (ABORT")   *
;  ****************
;
N_PABORTQ:   DD      8
        DB      '(ABORT")'
PABORTQ:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    THROW-(CW*(C_HOFFSET))
        DD    N_PABORTQ
    DD    0

        DD      ROT
        DD      ZBRAN
        DD      PABQ1-$-CW ;IF
        DD      LTYPE
        DD      SIGNON, ABORT
        DD      BRAN
        DD      PABQ2-$-CW ;ELSE
PABQ1:  DD       TDROP
PABQ2:   DD      SEMIS
;

;  **************
;  *   ABORT"   *
;  **************
;
N_ABORTQ:   DD      6
        DB      'ABORT"'
ABORTQ:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    PABORTQ-(CW*(C_HOFFSET))
        DD    N_ABORTQ
    DD    0

        DD      QCOMP
        DD      DENQ
        DD      LIT, PABORTQ, COMMA
        DD      SEMIS
;
;

;  ***********
;  *   ID.   *
;  ***********
;
N_IDDOT:   DD      3
        DB      "ID."
IDDOT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ABORTQ-(CW*(C_HOFFSET))
        DD    N_IDDOT
    DD    0

        DD      LDUP, TFFA
        DD      FETCH, LIT, B_DUMMY, LXOR
        DD      ZBRAN
        DD      IDDOT1-$-CW
        DD      TNFA
        DD      FETCH
        DD      SFET
        DD      LTYPE
        DD      SPACE
        DD      SPACE
        DD      SPACE
        DD      BRAN
        DD      IDDOT2-$-CW
IDDOT1:
        DD      DROP
IDDOT2:
        DD      SEMIS
;

;  ****************
;  *   (CREATE)   *
;  ****************
;
N_PCREAT:   DD      8
        DB      "(CREATE)"
PCREAT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    IDDOT-(CW*(C_HOFFSET))
        DD    N_PCREAT
    DD    0

        DD      LDUP
        DD      ZEQU
        DD      LIT, 5, QERR
        DD      TDUP
        DD      PRESENT
        DD      LDUP
        DD      ZBRAN
        DD      CREA1-$-CW ;IF
        DD      TNFA, FETCH, SFET
        DD      LTYPE
        DD      LIT,4
        DD      MESS
        DD      X       ;THEN
CREA1:  DD      DROP
        DD      SCOMMA
        DD      HERE,TOR

        DD      RR, TPHA, COMMA         ; Code field.

        DD      RR, TPHA, COMMA         ; Data field.

        DD      ZERO, COMMA ; Flag field.

        DD      CURR, FETCH, TLFA
        DD      LDUP, FETCH, COMMA   ; Link field.
        DD      RR, SWAP, STORE

        DD      COMMA   ; Name field.


        DD      BLK, FETCH, LDUP, ZEQU
        DD      ZBRAN
        DD      CREA2-$-CW
        DD      DROP, LIN, FETCH
CREA2:  DD      COMMA  ; Source field.

        DD      RDROP
        DD      SEMIS
;

;  *****************
;  *   [COMPILE]   *
;  *****************
;
N_BCOMP:   DD      9
        DB      "[COMPILE]"
BCOMP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    PCREAT-(CW*(C_HOFFSET))
        DD    N_BCOMP
    DD    0

        DD      LPWORD
        DD      PRESENT
        DD      LDUP
        DD      ZEQU
        DD      LIT, 16, QERR
        DD      TCFA
        DD      COMMA
        DD      SEMIS
;

;  ****************
;  *   POSTPONE   *
;  ****************
;
N_POSTP:   DD      8
        DB      "POSTPONE"
POSTP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    BCOMP-(CW*(C_HOFFSET))
        DD    N_POSTP
    DD    0

        DD      LPWORD
        DD      PRESENT
        DD      LDUP
        DD      ZEQU
        DD      LIT, 15, QERR
        DD      LDUP, TFFA, FETCH
        DD      LIT, B_IMMED, LAND, ZEQU
        DD      ZBRAN
        DD      POSTP1-$-CW
         DD      LIT, LIT, COMMA
         DD      COMMA
         DD      LIT, COMMA, COMMA
        DD      BRAN
        DD      POSTP2-$-CW
POSTP1:
         DD      COMMA
POSTP2:
        DD      SEMIS
;

;  ***************
;  *   LITERAL   *
;  ***************
;
N_LITER:   DD      7
        DB      "LITERAL"
LITER:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    POSTP-(CW*(C_HOFFSET))
        DD    N_LITER
    DD    0

        DD      STATE
        DD      FETCH
        DD      ZBRAN
        DD      LITE1-$-CW ;IF
        DD      LIT, LIT, COMMA
        DD      COMMA   ;THEN
LITE1:  DD      SEMIS
;

;  ****************
;  *   DLITERAL   *
;  ****************
;
N_DLITE:   DD      8
        DB      "DLITERAL"
DLITE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    LITER-(CW*(C_HOFFSET))
        DD    N_DLITE
    DD    0

        DD      STATE
        DD      FETCH
        DD      ZBRAN
        DD      DLIT1-$-CW ; IF
        DD      SWAP
        DD      LITER
        DD      LITER   ; THEN
DLIT1:  DD      SEMIS
;
;

;  *****************
;  *   SDLITERAL   *
;  *****************
;
N_SDLITE:   DD      9
        DB      "SDLITERAL"
SDLITE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    DLITE-(CW*(C_HOFFSET))
        DD    N_SDLITE
    DD    0

        DD      DPL
        DD      FETCH
        DD      ZBRAN
        DD      SDLIT1-$-CW ; IF
        DD      DLITE
        DD      BRAN
        DD      SDLIT2-$-CW ; IF
SDLIT1:
        DD      DROP, LITER
SDLIT2:
        DD      SEMIS
;


;  **************
;  *   ?STACK   *
;  **************
;
N_QSTAC:   DD      6
        DB      "?STACK"
QSTAC:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SDLITE-(CW*(C_HOFFSET))
        DD    N_QSTAC
    DD    0

        DD      SPFET
        DD      SZERO
        DD      FETCH
        DD      SWAP
        DD      ULESS
        DD      ONE, QERR
        DD      SPFET
        DD      HERE
        DD      LIT,80H
        DD      PLUS
        DD      ULESS
        DD      LIT, 7, QERR
        DD      SEMIS
        ;
;
;

;  *****************
;  *   INTERPRET   *
;  *****************
;
N_INTER:   DD      9
        DB      "INTERPRET"
INTER:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QSTAC-(CW*(C_HOFFSET))
        DD    N_INTER
    DD    0

INTE1:
        DD      LPWORD
        DD      LDUP      ; Zero length.
        DD      ZBRAN
        DD      INTE8-$-CW ;WHILE
;       DD      DOTS
;       DD      TDUP, LTYPE
        DD      OVER, TOR       ; Save old parse pointer.
        DD      FOUND
        DD      LDUP, ZEQU
        DD      LIT, 12, QERR
        DD      LDUP, TFFA, FETCH
        DD      LDUP, LIT, B_DENOT, LAND ;Retain copy of flags.
        DD      ZBRAN
        DD      INTE3B-$-CW ;IF
        DD      OVER, TNFA, FETCH, FETCH
        DD      RR, PLUS, LIN, STORE  ;Skip over prefix.
INTE3B:                  ;THEN 
        DD      RDROP           ; Drop old parse pointer.
        DD      LIT, B_IMMED, LAND
        DD      STATE, FETCH, ZEQU, LOR
        DD      ZBRAN
        DD      INTE3-$-CW ;IF
        DD      EXEC
        DD      BRAN
        DD      INTE4-$-CW ;IF
INTE3:
        DD      COMMA
                        ;THEN
INTE4:
        DD      QSTAC
        DD      BRAN
        DD      INTE1-$-CW  ;AGAIN
INTE8:  DD      DROP, DROP
        DD      SEMIS
;

;  *****************
;  *   IMMEDIATE   *
;  *****************
;
N_IMMED:   DD      9
        DB      "IMMEDIATE"
IMMED:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    INTER-(CW*(C_HOFFSET))
        DD    N_IMMED
    DD    0

        DD      LATEST
        DD      TFFA
        DD      LIT, B_IMMED
        DD      TOGGL
        DD      SEMIS
;

;  ******************
;  *   VOCABULARY   *
;  ******************
;
N_VOCAB:   DD      10
        DB      "VOCABULARY"
VOCAB:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    IMMED-(CW*(C_HOFFSET))
        DD    N_VOCAB
    DD    0

        DD      CREATE
        DD      LATEST   ; Link this DEA into VOC-LINK chain.
        DD      VOCL
        DD      FETCH
        DD      COMMA
        DD      VOCL
        DD      STORE
        DD      ZERO, COMMA   ; Dummy code field
        DD      ZERO, COMMA   ; Dummy data field
        DD      LIT, B_DUMMY, COMMA ; Dummy flag field
        DD      ZERO, COMMA ;Links to the word FORTH

        DD      DOES
DOVOC:
        DD      ALSO
        DD      CELLP   ; Make it a WID. 
        DD      SEARCH
        DD      STORE
        DD      SEMIS
        ;
;
;   The link to task is a cold start value only.
;   It is updated each time a definition is
;   appended to the 'FORTH' vocabulary.
;

;

;  *******************
;  *   DEFINITIONS   *
;  *******************
;
N_DEFIN:   DD      11
        DB      "DEFINITIONS"
DEFIN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    VOCAB-(CW*(C_HOFFSET))
        DD    N_DEFIN
    DD    0

        DD      SEARCH
        DD      FETCH
        DD      CURR
        DD      STORE
        DD      SEMIS
;

;  ************
;  *   ALSO   *
;  ************
;
N_ALSO:   DD      4
        DB      "ALSO"
ALSO:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DEFIN-(CW*(C_HOFFSET))
        DD    N_ALSO
    DD    0

        DD      SEARCH, LDUP, CELLP
        DD      LIT, (CW*(8-1))
        DD      LMOVE
        DD      LIT, FORTH  ;End sentinel for array of word lists.
        DD      SEARCH, LIT, (CW*(8)), PLUS
        DD      STORE ;Trim sets of wordset.
        DD      SEMIS
;

;  ****************
;  *   PREVIOUS   *
;  ****************
;
N_PREVI:   DD      8
        DB      "PREVIOUS"
PREVI:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ALSO-(CW*(C_HOFFSET))
        DD    N_PREVI
    DD    0

        DD      SEARCH, LDUP, CELLP, SWAP
        DD      LIT, (CW*(8))
        DD      LMOVE
        DD      SEMIS
;

;  ************
;  *   ONLY   *
;  ************
;
N_ONLY:   DD      4
        DB      "ONLY"
ONLY:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PREVI-(CW*(C_HOFFSET))
        DD    N_ONLY
    DD    0

        DD      LIT, FORTH, SEARCH, STORE
        DD      SEARCH, LDUP, CELLP
        DD      LIT, (CW*(8-1))
        DD      LCMOVE
        DD      SEMIS
;

;  *********
;  *   (   *
;  *********
;
N_PAREN:   DD      1
        DB      "("
PAREN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    ONLY-(CW*(C_HOFFSET))
        DD    N_PAREN
    DD    0

        DD      LIT,')'
        DD      PPARS
        DD      TDROP
        DD      SEMIS
;
;

;  *********
;  *   \   *
;  *********
;
N_BACKS:   DD      1
        DB      "\"
BACKS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    PAREN-(CW*(C_HOFFSET))
        DD    N_BACKS
    DD    0

        DD      LIT,ALF
        DD      PPARS
        DD      TDROP
        DD      SEMIS
;

;  ************
;  *   QUIT   *
;  ************
;
N_QUIT:   DD      4
        DB      "QUIT"
QUIT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BACKS-(CW*(C_HOFFSET))
        DD    N_QUIT
    DD    0

        DD      LBRAC
QUIT1:                  ;BEGIN
        DD      RZERO
        DD      FETCH
        DD      RPSTO
        
        DD      PACCEP
;
        DD       SETSRC
        DD      INTER
        DD      OK
        DD      BRAN
        DD      QUIT1-$-CW  ;AGAIN
        DD      SEMIS   ;Unnecessary, but helpful for decompilation.
;

;  **********
;  *   OK   *
;  **********
;
N_OK:   DD      2
        DB      "OK"
OK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QUIT-(CW*(C_HOFFSET))
        DD    N_OK
    DD    0

        DD      STATE
        DD      FETCH
        DD      ZEQU
        DD      ZBRAN
        DD      OK2-$-CW ;IF
        DD      SKIP
         DD      3
SB4: DB      " OK"
       
        DD      LIT, SB4
        DD      LIT, 3
        DD      LTYPE
        DD      CR
OK2:
        DD      SEMIS
;

;  *************
;  *   ABORT   *
;  *************
;
N_ABORT:   DD      5
        DB      "ABORT"
ABORT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    OK-(CW*(C_HOFFSET))
        DD    N_ABORT
    DD    0

        DD      SZERO, FETCH, SPSTO
        DD      ZERO, HANDLER, STORE
        DD      DECA
        DD      ONLY
        DD      FORTH
        DD      DEFIN
        DD      QUIT
        DD      SEMIS   ;Unnecessary, but helpful for decompilation.
;
;      WARM START VECTOR COMES HERE
;      For booting code we enter here, real mode and using the switchsegment.
;      BY control BREAK.
WARM_ENTRY:
; 
        
        MOV     ESI, WRM1
        LODSD                 ; NEXT
        JMP      LONG[EAX]                      ;Hope stacks are still okay.
;
WRM1:   DD      WARM
;

;  ************
;  *   WARM   *
;  ************
;
N_WARM:   DD      4
        DB      "WARM"
WARM:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ABORT-(CW*(C_HOFFSET))
        DD    N_WARM
    DD    0

        DD      MTBUF
        DD      SIGNON
        DD      ABORT
        DD      SEMIS   ;Unnecessary, but helpful for decompilation.
;


;  ***************
;  *   OPTIONS   *
;  ***************
;
N_OPTIONS:   DD      7
        DB      "OPTIONS"
OPTIONS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    WARM-(CW*(C_HOFFSET))
        DD    N_OPTIONS
    DD    0

;       Execute option.

        DD      LIT, 81H
OPT1:
        DD      LDUP, CFET, LBL, EQUAL
        DD      ZBRAN
        DD      OPT2-$-CW            ; Skip blanks.
        DD      ONEP
        DD      BRAN
        DD      OPT1-$-CW
OPT2:   DD      LDUP, CFET, LIT, ACR, UNEQ
        DD      ZBRAN
        DD      OPT4-$-CW ; No options  
        DD      FETCH
        DD      LDUP
        DD      LIT, 0FDH  , LAND
        DD      LIT, '-', UNEQ
        DD      ZBRAN
        DD      OPT3-$-CW
        DD      LIT, 3, LDUP, ERROR
        DD      XCODE, STORE, BYE
OPT3:
        DD      LIT, 8, RSHIFT
        DD      LIT, 1FH, LAND
        DD      LOAD
        DD      ZERO, SWAP ; Sign on suppressed.
OPT4:
        DD      DROP
        DD      SEMIS   ;Unnecessary, but helpful for decompilation.
;


;  ************
;  *   COLD   *
;  ************
;
N_COLD:   DD      4
        DB      "COLD"
COLD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    OPTIONS-(CW*(C_HOFFSET))
        DD    N_COLD
    DD    0

        DD      ZERO, HANDLER, STORE
        DD      MTBUF
        DD      FIRST
        DD      STALEST,STORE
        DD      FIRST
        DD      PREV,STORE
; Fill user area for single task.
        DD      LIT, USINI
        DD      LIT, USINI+(CW*(1)), FETCH
        DD      LIT, US
        DD      LCMOVE

        DD      LIT, 0, BLINI  ;Default, don't write in the library file!
;
        DD      DECA    ; FIXME has to go done by ABORT anyway.
        DD      ONLY    ; FIXME has to go done by ABORT anyway.
        DD      FORTH   ; FIXME has to go done by ABORT anyway.
        DD      DEFIN   ; FIXME has to go done by ABORT anyway.
        DD      ONE            ; Sign on wanted.
;
        DD      OPTIONS
        DD      ZBRAN
        DD      COLD5-$-CW
        DD      SIGNON    ; Suppressed for scripting! Or any options.
COLD5:
        DD      ABORT
        DD      BYE     ; In case of turnkey programs.
        DD      SEMIS   ; Unnecessary, but helpful for decompilation.
;

;  ***********
;  *   S>D   *
;  ***********
;
N_STOD:   DD      3
        DB      "S>D"
STOD:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    COLD-(CW*(C_HOFFSET))
        DD    N_STOD
    DD    0

        POP     EDX      ;S1
        SUB     EAX,EAX
        OR      EDX,EDX
        JNS     STOD1   ;POS
        DEC     EAX      ;NEG
STOD1:  PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***********
;  *   ABS   *
;  ***********
;
N_LABS:   DD      3
        DB      "ABS"
LABS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    STOD-(CW*(C_HOFFSET))
        DD    N_LABS
    DD    0

        DD      LDUP
        DD      ZLESS
        DD      ZBRAN
        DD      PM1-$-CW   ;IF
        DD      NEGATE   ;THEN
PM1:
        DD      SEMIS
;

;  ************
;  *   DABS   *
;  ************
;
N_DABS:   DD      4
        DB      "DABS"
DABS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LABS-(CW*(C_HOFFSET))
        DD    N_DABS
    DD    0

        DD      LDUP
        DD      ZLESS
        DD      ZBRAN
        DD      DPM1-$-CW  ;IF
        DD      DNEGA   ;THEN
DPM1:
        DD      SEMIS
;

;  ***********
;  *   MIN   *
;  ***********
;
N_MIN:   DD      3
        DB      "MIN"
MIN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DABS-(CW*(C_HOFFSET))
        DD    N_MIN
    DD    0

        DD      TDUP
        DD      GREAT
        DD      ZBRAN
        DD      MIN1-$-CW  ;IF
        DD      SWAP    ;THEN
MIN1:   DD      DROP
        DD      SEMIS
;

;  ***********
;  *   MAX   *
;  ***********
;
N_MAX:   DD      3
        DB      "MAX"
MAX:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    MIN-(CW*(C_HOFFSET))
        DD    N_MAX
    DD    0

        DD      TDUP
        DD      LESS
        DD      ZBRAN
        DD      MAX1-$-CW  ;IF
        DD      SWAP    ;THEN
MAX1:   DD      DROP
        DD      SEMIS
;

;  **************
;  *   LSHIFT   *
;  **************
;
N_LSHIFT:   DD      6
        DB      "LSHIFT"
LSHIFT:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    MAX-(CW*(C_HOFFSET))
        DD    N_LSHIFT
    DD    0

        POP     ECX
        POP     EAX
        SHL     EAX,CL
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **************
;  *   RSHIFT   *
;  **************
;
N_RSHIFT:   DD      6
        DB      "RSHIFT"
RSHIFT:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LSHIFT-(CW*(C_HOFFSET))
        DD    N_RSHIFT
    DD    0

        POP     ECX
        POP     EAX
        SHR     EAX,CL
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   M*   *
;  **********
;
N_MSTAR:   DD      2
        DB      "M*"
MSTAR:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RSHIFT-(CW*(C_HOFFSET))
        DD    N_MSTAR
    DD    0

        POP     EAX
        POP     EBX
        IMUL     EBX      ;SIGNED
        XCHG    EAX,EDX   ;AX NOW = MSW
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]             ;STORE DOUBLE CELL
;

;  **************
;  *   SM/REM   *
;  **************
;
N_MSLAS:   DD      6
        DB      "SM/REM"
MSLAS:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    MSTAR-(CW*(C_HOFFSET))
        DD    N_MSLAS
    DD    0

        POP     EBX      ;DIVISOR
        POP     EDX      ;MSW OF DIVIDEND
        POP     EAX      ;LSW OF DIVIDEND
        IDIV     EBX      ;16 BIT DIVIDE
        PUSH    EDX
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]             ;STORE QUOT/REM
;


;  **********
;  *   2/   *
;  **********
;
N_TWOSL:   DD      2
        DB      "2/"
TWOSL:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    MSLAS-(CW*(C_HOFFSET))
        DD    N_TWOSL
    DD    0

        DD      STOD, TWO, FMSLAS
        DD      SWAP, DROP
        DD      SEMIS
;

;  **********
;  *   2*   *
;  **********
;
N_TWOST:   DD      2
        DB      "2*"
TWOST:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TWOSL-(CW*(C_HOFFSET))
        DD    N_TWOST
    DD    0

        DD      TWO, STAR
        DD      SEMIS
;

;  **********
;  *   1-   *
;  **********
;
N_ONEM:   DD      2
        DB      "1-"
ONEM:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TWOST-(CW*(C_HOFFSET))
        DD    N_ONEM
    DD    0

        DD      ONE, LSUB
        DD      SEMIS
;
;

;  **************
;  *   FM/MOD   *
;  **************
;
N_FMSLAS:   DD      6
        DB      "FM/MOD"
FMSLAS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ONEM-(CW*(C_HOFFSET))
        DD    N_FMSLAS
    DD    0

        DD      LDUP, TOR
        DD      TDUP, LXOR, TOR
        DD      MSLAS
        DD      FROMR, ZLESS
        DD      ZBRAN
        DD      FMMOD1-$-CW
        DD      OVER
        DD      ZBRAN
        DD      FMMOD1-$-CW
        DD      ONE, LSUB
        DD      SWAP, FROMR, PLUS, SWAP
        DD      BRAN
        DD      FMMOD2-$-CW
FMMOD1:
        DD      RDROP
FMMOD2:
        DD      SEMIS
;

;  *********
;  *   *   *
;  *********
;
N_STAR:   DD      1
        DB      "*"
STAR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FMSLAS-(CW*(C_HOFFSET))
        DD    N_STAR
    DD    0

        DD      MSTAR
        DD      DROP
        DD      SEMIS
;

;  ************
;  *   /MOD   *
;  ************
;
N_SLMOD:   DD      4
        DB      "/MOD"
SLMOD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    STAR-(CW*(C_HOFFSET))
        DD    N_SLMOD
    DD    0

        DD      TOR
        DD      STOD
        DD      FROMR
        DD      MSLAS
        DD      SEMIS
;

;  *********
;  *   /   *
;  *********
;
N_SLASH:   DD      1
        DB      "/"
SLASH:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SLMOD-(CW*(C_HOFFSET))
        DD    N_SLASH
    DD    0

        DD      SLMOD
        DD      SWAP
        DD      DROP
        DD      SEMIS
;

;  ***********
;  *   MOD   *
;  ***********
;
N_LMOD:   DD      3
        DB      "MOD"
LMOD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SLASH-(CW*(C_HOFFSET))
        DD    N_LMOD
    DD    0

        DD      SLMOD
        DD      DROP
        DD      SEMIS
;

;  *************
;  *   */MOD   *
;  *************
;
N_SSMOD:   DD      5
        DB      "*/MOD"
SSMOD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LMOD-(CW*(C_HOFFSET))
        DD    N_SSMOD
    DD    0

        DD      TOR
        DD      MSTAR
        DD      FROMR
        DD      MSLAS
        DD      SEMIS
;

;  **********
;  *   */   *
;  **********
;
N_SSLA:   DD      2
        DB      "*/"
SSLA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SSMOD-(CW*(C_HOFFSET))
        DD    N_SSLA
    DD    0

        DD      SSMOD
        DD      SWAP
        DD      DROP
        DD      SEMIS
;

;  *************
;  *   M/MOD   *
;  *************
;
N_MSMOD:   DD      5
        DB      "M/MOD"
MSMOD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SSLA-(CW*(C_HOFFSET))
        DD    N_MSMOD
    DD    0

        DD      TOR
        DD      ZERO
        DD      RR
        DD      USLAS
        DD      FROMR
        DD      SWAP
        DD      TOR
        DD      USLAS
        DD      FROMR
        DD      SEMIS
;

;  **************
;  *   (LINE)   *
;  **************
;
N_PLINE:   DD      6
        DB      "(LINE)"
PLINE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    MSMOD-(CW*(C_HOFFSET))
        DD    N_PLINE
    DD    0

        DD      TOR
        DD      LIT,64
        DD      MSTAR
        DD      BBUF
        DD      FMSLAS
        DD      FROMR ; This blocks, so is screens.
        DD      PLUS
        DD      BLOCK
        DD      PLUS
        DD      LIT,63
        DD      SEMIS
;

;  **************
;  *   ERRSCR   *
;  **************
;
N_ERRSCR:   DD      6
        DB      "ERRSCR"
ERRSCR:        DD    DOVAR
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PLINE-(CW*(C_HOFFSET))
        DD    N_ERRSCR
    DD    0

        DD ERRORSCREEN
;

;  ***************
;  *   MESSAGE   *
;  ***************
;
N_MESS:   DD      7
        DB      "MESSAGE"
MESS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ERRSCR-(CW*(C_HOFFSET))
        DD    N_MESS
    DD    0

        DD      LWARN
        DD      FETCH
        DD      ZBRAN
        DD      MESS1-$-CW ;IF
        DD      ERRSCR, FETCH
        DD      PLINE, ONEP     ; Also print the '\n' !
        DD      LTYPE
        DD      X
MESS1:                  ;THEN
        DD      DROP
        DD      SEMIS
;

;  ***********
;  *   PC@   *
;  ***********
;
N_PCFET:   DD      3
        DB      "PC@"
PCFET:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    MESS-(CW*(C_HOFFSET))
        DD    N_PCFET
    DD    0

; FETCH CHARACTER (BYTE) FROM PORT
        POP     EDX      ; PORT ADDR
        XOR     EAX,EAX
        IN      AL,DX  ; BYTE INPUT
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***********
;  *   PC!   *
;  ***********
;
N_PCSTO:   DD      3
        DB      "PC!"
PCSTO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PCFET-(CW*(C_HOFFSET))
        DD    N_PCSTO
    DD    0

        POP     EDX      ;PORT ADDR
        POP     EAX      ;DATA
        OUT     DX,AL   ; BYTE OUTPUT
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   P@   *
;  **********
;
N_PFET:   DD      2
        DB      "P@"
PFET:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PCSTO-(CW*(C_HOFFSET))
        DD    N_PFET
    DD    0

        POP     EDX      ;PORT ADDR
        IN      EAX,DX  ;WORD INPUT
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  **********
;  *   P!   *
;  **********
;
N_PSTO:   DD      2
        DB      "P!"
PSTO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PFET-(CW*(C_HOFFSET))
        DD    N_PSTO
    DD    0

        POP     EDX      ;PORT ADDR
        POP     EAX      ;DATA
        OUT     DX,EAX   ;WORD OUTPUT
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;  ***************
;  *   STALEST   *
;  ***************
;
N_STALEST:   DD      7
        DB      "STALEST"
STALEST:        DD    DOVAR
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PSTO-(CW*(C_HOFFSET))
        DD    N_STALEST
    DD    0

        DD BUF1
;

;  ************
;  *   PREV   *
;  ************
;
N_PREV:   DD      4
        DB      "PREV"
PREV:        DD    DOVAR
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    STALEST-(CW*(C_HOFFSET))
        DD    N_PREV
    DD    0

        DD      BUF1
;

;  *************
;  *   #BUFF   *
;  *************
;
N_NOBUF:   DD      5
        DB      "#BUFF"
NOBUF:        DD    DOCON
        DD    NBUF
        DD    0H
        DD    PREV-(CW*(C_HOFFSET))
        DD    N_NOBUF
    DD    0

;

;  ************
;  *   +BUF   *
;  ************
;
N_PBUF:   DD      4
        DB      "+BUF"
PBUF:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    NOBUF-(CW*(C_HOFFSET))
        DD    N_PBUF
    DD    0

        DD      LIT,(KBBUF+2*CW)
        DD      PLUS,LDUP
        DD      LIMIT,EQUAL
        DD      ZBRAN
        DD      PBUF1-$-CW
        DD      DROP,FIRST
PBUF1:  DD      LDUP, PREV, FETCH, LSUB
        DD      SEMIS
;

;  **************
;  *   UPDATE   *
;  **************
;
N_UPDAT:   DD      6
        DB      "UPDATE"
UPDAT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PBUF-(CW*(C_HOFFSET))
        DD    N_UPDAT
    DD    0

        DD      PREV, FETCH
        DD      LDUP, CELLP,CELLP
        DD      SWAP, FETCH
        DD      LOFFSET,  FETCH, PLUS
        DD      ZERO
        DD      RSLW
        DD      SEMIS
;

;  *********************
;  *   EMPTY-BUFFERS   *
;  *********************
;
N_MTBUF:   DD      13
        DB      "EMPTY-BUFFERS"
MTBUF:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    UPDAT-(CW*(C_HOFFSET))
        DD    N_MTBUF
    DD    0

        DD      FIRST
        DD      LIMIT,OVER
        DD      LSUB,LERASE
        DD      SEMIS
        ;
;

;  ****************
;  *   (BUFFER)   *
;  ****************
;
N_BUFFER:   DD      8
        DB      "(BUFFER)"
BUFFER:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    MTBUF-(CW*(C_HOFFSET))
        DD    N_BUFFER
    DD    0

; Find the buffer, if it is already here.
    DD      PREV, FETCH
BUFFER1:
    DD          TOR, RR, FETCH, OVER, EQUAL
    DD      ZBRAN
        DD      BUFFER3-$-CW
    DD        DROP, FROMR, EXIT
BUFFER3:
    DD          FROMR
    DD      PBUF, ZEQU
    DD      ZBRAN
        DD      BUFFER1-$-CW
    DD       DROP
; Just allocate the stalest buffer.
    DD       STALEST,   FETCH, TOR
; Remember the next stalest buffer. 
    DD       RR
BUFFER2:
    DD       PBUF, OVER, CELLP, FETCH,
    DD       LIT, -1, GREAT, LAND
    DD      ZBRAN
        DD      BUFFER2-$-CW
    DD       STALEST, STORE
; Fill in the house keeping.
    DD       RR, STORE
    DD       ZERO, RR, CELLP, STORE
    DD       RR, PREV, STORE
    DD       FROMR
    DD  SEMIS
;


;  *************
;  *   BLOCK   *
;  *************
;
N_BLOCK:   DD      5
        DB      "BLOCK"
BLOCK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BUFFER-(CW*(C_HOFFSET))
        DD    N_BLOCK
    DD    0


        DD      BUFFER
        DD      LDUP, CELLP, FETCH, ZEQU
        DD      ZBRAN
        DD      BLOCK1-$-CW
        DD      LDUP, CELLP, CELLP
        DD      OVER, FETCH
        DD      LOFFSET,  FETCH, PLUS
        DD      ONE
        DD      RSLW
        DD      ONE, OVER, CELLP, STORE
BLOCK1:
        DD      LDUP, PREV, STORE
        DD      CELLP, CELLP
        DD      SEMIS
;

;  *************
;  *   FLUSH   *
;  *************
;
N_FLUSH:   DD      5
        DB      "FLUSH"
FLUSH:        DD    DOCOL
        DD    (MTBUF+(CW*(PH_OFFSET-C_HOFFSET)))
        DD    0H
        DD    BLOCK-(CW*(C_HOFFSET))
        DD    N_FLUSH
    DD    0


; Unlock all buffers
        DD      LIMIT
        DD      FIRST, CELLP
        DD     XDO
        DD      FLUS2-$-CW
FLUS1:  DD      ZERO, IDO, STORE
        DD      LIT,(KBBUF+2*CW)
        DD      PLOOP
        DD      (FLUS1-$)
FLUS2:
        DD      SEMIS
;

;  ************
;  *   SAVE   *
;  ************
;
N_SAVE:   DD      4
        DB      "SAVE"
SAVE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FLUSH-(CW*(C_HOFFSET))
        DD    N_SAVE
    DD    0

        DD      FROMR
        DD      SRC, TFET
        DD      LIN, FETCH
        DD      TOR, TOR, TOR
        DD      TOR
        DD SEMIS
;

;  ***************
;  *   RESTORE   *
;  ***************
;
N_RESTO:   DD      7
        DB      "RESTORE"
RESTO:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SAVE-(CW*(C_HOFFSET))
        DD    N_RESTO
    DD    0

        DD      FROMR
        DD      FROMR, FROMR, FROMR
        DD      LIN, STORE
        DD      SRC, TSTOR
        DD      TOR
        DD SEMIS
;


;  ******************
;  *   SAVE-INPUT   *
;  ******************
;
N_SAVEI:   DD      10
        DB      "SAVE-INPUT"
SAVEI:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RESTO-(CW*(C_HOFFSET))
        DD    N_SAVEI
    DD    0

        DD      SRC, TFET
        DD      LIN, FETCH
        DD      LIT, 3
        DD SEMIS
;

;  *********************
;  *   RESTORE-INPUT   *
;  *********************
;
N_RESTOI:   DD      13
        DB      "RESTORE-INPUT"
RESTOI:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SAVEI-(CW*(C_HOFFSET))
        DD    N_RESTOI
    DD    0

        DD      DROP
        DD      LIN, STORE
        DD      SRC, TSTOR
        DD      LIT, -1
        DD SEMIS
;
;

;  ************
;  *   LOCK   *
;  ************
;
N_LLOCK:   DD      4
        DB      "LOCK"
LLOCK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RESTOI-(CW*(C_HOFFSET))
        DD    N_LLOCK
    DD    0

        DD      BLOCK
        DD      LIT, CW, LSUB
        DD      LIT, -2, SWAP, PSTORE
        DD      SEMIS
;

;  **************
;  *   UNLOCK   *
;  **************
;
N_LUNLOCK:   DD      6
        DB      "UNLOCK"
LUNLOCK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LLOCK-(CW*(C_HOFFSET))
        DD    N_LUNLOCK
    DD    0

        DD      BLOCK
        DD      LIT, CW, LSUB
        DD      TWO, SWAP, PSTORE
        DD      SEMIS
;

;  ************
;  *   LOAD   *
;  ************
;
N_LOAD:   DD      4
        DB      "LOAD"
LOAD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LUNLOCK-(CW*(C_HOFFSET))
        DD    N_LOAD
    DD    0

        DD      LDUP, THRU
        DD      SEMIS
;

;  ************
;  *   THRU   *
;  ************
;
N_THRU:   DD      4
        DB      "THRU"
THRU:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LOAD-(CW*(C_HOFFSET))
        DD    N_THRU
    DD    0

        DD      SAVE
        DD      ONEP, SWAP
        DD     XDO
        DD      THRU2-$-CW
THRU1:
        DD      IDO, LLOCK
        DD      IDO, BLOCK
        DD      LIT, KBBUF
        DD      SETSRC
        DD      LIT, INTER, CATCH
        DD      IDO, LUNLOCK
        DD      QDUP
        DD      ZBRAN
        DD      THRU3-$-CW
        DD      RDROP, RDROP, RDROP; UNLOOP.
        DD      RESTO
        DD      THROW
THRU3:
        DD     XLOOP
        DD      THRU1-$-CW
THRU2:
        DD      RESTO
        DD      SEMIS
;

;

;  ***********
;  *   BLK   *
;  ***********
;
N_BLK:   DD      3
        DB      "BLK"
BLK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    THRU-(CW*(C_HOFFSET))
        DD    N_BLK
    DD    0

        DD      LIN, FETCH
        DD      FIRST, LIMIT, WITHIN
        DD      SRC, TFET, LSUB
        DD      LIT, 1024, EQUAL, LAND
        DD      ZBRAN
        DD      BLK1-$-CW
        DD      SRC, FETCH, TWO, LCELLS, LSUB, FETCH
        DD      BRAN
        DD      BLK2-$-CW
BLK1:
        DD      ZERO
BLK2:
        DD      PBLK, STORE
        DD      PBLK
        DD      SEMIS
;

;  ***********
;  *   -->   *
;  ***********
;
N_ARROW:   DD      3
        DB      "-->"
ARROW:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    BLK-(CW*(C_HOFFSET))
        DD    N_ARROW
    DD    0

        DD      QLOAD
        DD      BLK, FETCH
        DD      LDUP, LUNLOCK
        DD      ONEP
        DD      LDUP, LLOCK
        DD      LDUP, BLK, STORE
        DD      BLOCK
        DD      LIT, KBBUF
        DD      SETSRC
        DD      SEMIS
        ;
;
;

; Generic call on BIOS. A boon for experimenters.

;

;  *************
;  *   BIOSO   *
;  *************
;
N_BIOSO:   DD      5
        DB      "BIOSO"
BIOSO:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ARROW-(CW*(C_HOFFSET))
        DD    N_BIOSO
    DD    0

; Adapted from Allen Wyatt, Advanced Assembly language, QUE
; from pmtest.asm.

        POP     EBX      ; Function code
        POP     EAX
        MOV      LONG[SaveDX],EAX ;Parameters specified from stack.
        POP     EAX
        MOV      LONG[SaveCX],EAX
        POP     EAX
        MOV      LONG[SaveBX],EAX
        POP     EAX
        MOV      LONG[SaveAX],EAX
        PUSHF
        POP     EAX
        MOV      LONG[SaveFlags],EAX


       MOV      LONG[SaveSI],ESI ;Save some registers.
       MOV      LONG[SaveDI],EDI
       MOV      LONG[SaveBP],EBP

       MOV     EAX,0300h            ;Simulate real-mode interrupt
       ;  Function number was popped into EBX register.
       MOV     ECX,0                ;Copy nothing from stack
       LEA     EDI, [REGSET+(CW*(PH_OFFSET-C_HOFFSET))]
       INT     31h

       MOV     ESI, LONG[SaveSI] ;Restore some registers.
       MOV     EDI, LONG[SaveDI]
       MOV     EBP, LONG[SaveBP]

       MOV     EAX, LONG[SaveAX] ;Make others available.
       PUSH     EAX
       MOV     EAX, LONG[SaveBX]
       PUSH     EAX
       MOV     EAX, LONG[SaveCX]
       PUSH     EAX
       MOV     EAX, LONG[SaveDX]
       PUSH     EAX
       MOV     EAX, LONG[SaveFlags]
       PUSH    EAX
       JMP     NEXT
;
;
; Generic call on BIOS. A boon for experimenters.


;

;  *************
;  *   BIOSN   *
;  *************
;
N_BIOSN:   DD      5
        DB      "BIOSN"
BIOSN:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BIOSO-(CW*(C_HOFFSET))
        DD    N_BIOSN
    DD    0

; Adapted from Allen Wyatt, Advanced Assembly language, QUE
; from pmtest.asm.

        POP     EBX      ; Put function code on return stack.
        LEA     EBP,[EBP - (CW*(1))]
        MOV     [EBP],EBX

        POP     EAX
        POP     EBX
        POP     ECX
        POP     EDX
        PUSHAD            ;Save also Forth registers.

        MOV     ECX, 8
        MOV     ESI, ESP
        LEA     EDI, [REGSET+(CW*(PH_OFFSET-C_HOFFSET))]
        REP     MOVSD

        MOV     EAX,0300h            ;Simulate real-mode interrupt.
        MOV     EBX,[EBP] ; Get function code from return stack.
        MOV     ECX,0                ;Copy nothing from stack
        LEA     EDI, [REGSET+(CW*(PH_OFFSET-C_HOFFSET))]
        INT     31h

        POPAD   ;Get it all back.
        LEA     EBP,[EBP + (CW*(1))] ;Bump return stack. After the pop!.
        MOV     EAX, LONG[SaveAX]
        PUSH    EAX
        MOV     EAX, LONG[SaveFlags]
        PUSH    EAX
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;

;  ***************
;  *   REG-SET   *
;  ***************
;
N_REGSET:   DD      7
        DB      "REG-SET"
REGSET:        DD    DOVAR
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BIOSN-(CW*(C_HOFFSET))
        DD    N_REGSET
    DD    0

SaveDI:     DD      00000000
SaveSI:     DD      00000000
SaveBP:     DD      00000000
            DD      00000000            ;Reserved area--set to 0
SaveBX:     DD      00000000
SaveDX:     DD      00000000
SaveCX:     DD      00000000
SaveAX:     DD      00000000
SaveFlags:  DW      0000
SaveES:     DW      0000
SaveDS:     DW      0000
SaveFS:     DW      0000
SaveGS:     DW      0000
SaveIP:     DW      0000
SaveCS:     DW      0000
SaveSP:     DW      0000
SaveSS:     DW      0000

;
Save_CS_PR: DW    0000
Save_DS_PR: DW    0000
Save_ES_PR: DW    0000
 ;  
;

; Wanted here is a generic call on BIOS. A boon for experimenters.
; Because there is no such thing as a variable interrupt:
; I tried to use self modifying code , filling in the interrupt
; number. Like in the BIOS for the real case.
; In protected mode with different selectors for code
; and data this is dubious. If it turns out to work, this could
; be made in a general trap generator.
;  **************
;  *   BIOS31   *
;  **************
;
N_BIOS31:   DD      6
        DB      "BIOS31"
BIOS31:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    REGSET-(CW*(C_HOFFSET))
        DD    N_BIOS31
    DD    0

        POP     EDI
        POP     EDX
        POP     ECX
        POP     EBX
        POP     EAX
RQBIOS: INT(31H)          ; Request number to be overwritten.
        PUSH     EAX
        PUSH     EBX
        PUSH     ECX
        PUSH     EDX
        PUSHF
        LODSD                 ; NEXT
        JMP      LONG[EAX]   
;

;

;  *************
;  *   BDOSO   *
;  *************
;
N_BDOSO:   DD      5
        DB      "BDOSO"
BDOSO:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BIOS31-(CW*(C_HOFFSET))
        DD    N_BDOSO
    DD    0

        DD      LIT,  21H
        DD      BIOSO
        DD      SEMIS
;
; 
; 
        ;
;------------------------------------
;       SYSTEM DEPENDANT CHAR I/O
;------------------------------------


;  ************
;  *   EMIT   *
;  ************
;
N_EMIT:   DD      4
        DB      "EMIT"
EMIT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BDOSO-(CW*(C_HOFFSET))
        DD    N_EMIT
    DD    0

        DD      LDUP,LIT,ALF,EQUAL
        DD      ZBRAN
        DD      EMIT1-$-CW
        DD      LIT,ACR,EMIT
        DD      ZERO,LOUT,STORE
EMIT1:
        DD      SPFET, ONE, LTYPE
        DD      DROP
        DD      SEMIS
;

;  ***********
;  *   KEY   *
;  ***********
;
N_KEY:   DD      3
        DB      "KEY"
KEY:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    EMIT-(CW*(C_HOFFSET))
        DD    N_KEY
    DD    0

        DD      X, X, X, LIT, 1000H
        DD      LIT, 0016H, BIOSN
        DD      DROP
        DD      LIT, 00FFH, LAND, SEMIS
;

;  ************
;  *   KEY?   *
;  ************
;
N_KEYQ:   DD      4
        DB      "KEY?"
KEYQ:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    KEY-(CW*(C_HOFFSET))
        DD    N_KEYQ
    DD    0

        DD      X, X, X, LIT, 0B00H
        DD      BDOSN, DROP ; ignore error 
        DD      LIT, 01H, LAND  ;Dubious!! FIXME!!
        DD      SEMIS
;

;  ************
;  *   TYPE   *
;  ************
;
N_LTYPE:   DD      4
        DB      "TYPE"
LTYPE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    KEYQ-(CW*(C_HOFFSET))
        DD    N_LTYPE
    DD    0

        DD      LDUP, LOUT, PSTORE
        DD      ONE, WFILE, DROP
        DD      SEMIS
;

;  ****************
;  *   (ACCEPT)   *
;  ****************
;
N_PACCEP:   DD      8
        DB      "(ACCEPT)"
PACCEP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LTYPE-(CW*(C_HOFFSET))
        DD    N_PACCEP
    DD    0

PACCEP2:
        DD      REMAIND
        DD      TFET
        DD      LIT, ALF, SINDEX
        DD      ZEQU
        DD      ZBRAN
        DD      PACCEP1-$-CW
        DD      REMAIND, TFET
        DD      TIB, FETCH
        DD      SWAP, LMOVE
        DD      TIB, FETCH
        DD      REMAIND, CELLP, STORE
        DD      REFTIB
        DD      BRAN
        DD      PACCEP2-$-CW
PACCEP1:
        DD      REMAIND, TFET
        DD      LIT, ALF, SSPLIT
        DD      TSWAP, REMAIND, TSTOR
        DD ONEM
        DD      SEMIS
;

;  *************
;  *   BDOSN   *
;  *************
;
N_BDOSN:   DD      5
        DB      "BDOSN"
BDOSN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PACCEP-(CW*(C_HOFFSET))
        DD    N_BDOSN
    DD    0

        DD      LIT, 21H, BIOSN
        DD      ONE, LAND
        DD      LDUP
        DD      ZBRAN
        DD      BDOSN1-$-CW
        DD      SWAP
        DD      NEGATE
        DD      SWAP
BDOSN1:
        DD      SEMIS
;
 ; 




;  *****************
;  *   RW-BUFFER   *
;  *****************
;
N_RWBUF:   DD      9
        DB      "RW-BUFFER"
RWBUF:        DD    DOCON
        DD    8000H
        DD    0H
        DD    BDOSN-(CW*(C_HOFFSET))
        DD    N_RWBUF
    DD    0

 ;  
; 
; 
;

; 
; 

;  ***********
;  *   ZEN   *
;  ***********
;
N_ZEN:   DD      3
        DB      "ZEN"
ZEN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RWBUF-(CW*(C_HOFFSET))
        DD    N_ZEN
    DD    0

        DD      TOR, ZERO, SWAP
        DD      LIT, Save_DS_PR, FETCH, RWBUF ; <FAR> RW-BUFFER
        DD      RR, FMOVE        ;  R@ FARMOVE
        DD      ZERO
        DD      LIT, Save_DS_PR, FETCH, RWBUF ; <FAR> RW-BUFFER
        DD      FROMR, PLUS, LSTORE
        DD      RWBUF
        DD      SEMIS
 ;  
;

;

;  *****************
;  *   OPEN-FILE   *
;  *****************
;
N_OFILE:   DD      9
        DB      "OPEN-FILE"
OFILE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ZEN-(CW*(C_HOFFSET))
        DD    N_OFILE
    DD    0

        DD      TOR, ZEN, X, X
        DD      LIT, open, FROMR, PLUS, BDOSN
        DD      ZBRAN
        DD      OFILE1-$-CW
        DD      LDUP
        DD      BRAN
        DD      OFILE2-$-CW
OFILE1:
        DD      ZERO
OFILE2:
        DD      SEMIS
 ; 
;

;

;  ******************
;  *   CLOSE-FILE   *
;  ******************
;
N_CFILE:   DD      10
        DB      "CLOSE-FILE"
CFILE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    OFILE-(CW*(C_HOFFSET))
        DD    N_CFILE
    DD    0

        DD      TOR, X, X, FROMR
        DD      LIT, close, BDOSN
        DD      ZBRAN
        DD      CFILE1-$-CW
        DD      BRAN
        DD      CFILE2-$-CW
CFILE1:
        DD      DROP, ZERO
CFILE2:
        DD      SEMIS
 ; 
;

;

;  *******************
;  *   CREATE-FILE   *
;  *******************
;
N_CREATEF:   DD      11
        DB      "CREATE-FILE"
CREATEF:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CFILE-(CW*(C_HOFFSET))
        DD    N_CREATEF
    DD    0

        DD      TOR, ZEN, FROMR, X
        DD      LIT, create, BDOSN
        DD      ZBRAN
        DD      CRFILE1-$-CW
        DD      LDUP
        DD      BRAN
        DD      CRFILE2-$-CW
CRFILE1:
        DD      ZERO
CRFILE2:
        DD      SEMIS
 ; 
;

;

;  *******************
;  *   DELETE-FILE   *
;  *******************
;
N_DFILE:   DD      11
        DB      "DELETE-FILE"
DFILE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    CREATEF-(CW*(C_HOFFSET))
        DD    N_DFILE
    DD    0

        DD      ZEN, X, X
        DD      LIT, delete, BDOSN
        DD      ZEQU
        DD      ZBRAN
        DD      DFILE1-$-CW
        DD      DROP, ZERO
DFILE1:
        DD      SEMIS
 ; 
;

; 
; 

;  *****************
;  *   READ-FILE   *
;  *****************
;
N_RFILE:   DD      9
        DB      "READ-FILE"
RFILE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DFILE-(CW*(C_HOFFSET))
        DD    N_RFILE
    DD    0

        DD      ZERO, LIT, RC, STORE, TOR
RFIL1:
        DD      TDUP, LIT, 8000H, MIN
        DD      RR, READ
        DD      LDUP
        DD      ZBRAN
        DD      RFIL2-$-CW
        DD      RDROP, TOR, TDROP, FROMR, EXIT
RFIL2:
        DD      DROP
        DD      LIT, RC, PSTORE
        DD      LIT, 8000H, LSUB, LDUP
        DD      ZERO, GREAT
        DD      ZBRAN
        DD      RFIL3-$-CW
        DD      SWAP, LIT, 8000H, PLUS, SWAP
        DD      BRAN
        DD      RFIL1-$-CW
RFIL3:
        DD      TDROP, RDROP
        DD      LIT, RC, FETCH, ZERO
        DD      SEMIS
RC:     DD      0
 ;  
;

;

;  ***********************
;  *   REPOSITION-FILE   *
;  ***********************
;
N_PFILE:   DD      15
        DB      "REPOSITION-FILE"
PFILE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RFILE-(CW*(C_HOFFSET))
        DD    N_PFILE
    DD    0

        DD     TOR, DROP, LIT, 10000H, SLMOD, FROMR 
        DD      LIT, lseek, BDOSN
        DD      ZEQU
        DD      ZBRAN
        DD      PFILE1-$-CW
        DD      DROP, ZERO
PFILE1:
        DD      SEMIS
 ; 
;

; 
; 

;  ******************
;  *   WRITE-FILE   *
;  ******************
;
N_WFILE:   DD      10
        DB      "WRITE-FILE"
WFILE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PFILE-(CW*(C_HOFFSET))
        DD    N_WFILE
    DD    0

        DD      TOR             ;>R
WFIL1:                          ;BEGIN
        DD      TDUP, LIT, 8000H ;   2DUP 8000 MIN R@ ^ WRITE-FILE
        DD      MIN, RR, WRITE
        DD      LDUP             ;   DUP
        DD      ZBRAN
        DD      WFIL2-$-CW        ; IF RDROP >R 2DROP R> EXIT
        DD      RDROP, TOR, TDROP, TOR, EXIT
WFIL2:                           ; THEN DROP
        DD      DROP, LIT, 8000H, LSUB      ; 8000 -
        DD      LDUP, ZERO, GREAT      ; 8000 - DUP 0 >
        DD      ZBRAN
        DD      WFIL3-$-CW        ; WHILE
        DD      SWAP, LIT, 8000H ; SWAP 8000
        DD      PLUS, SWAP       ; + SWAP
        DD      BRAN
        DD      WFIL1-$-CW         ; REPEAT
WFIL3:
        DD      TDROP, RDROP, ZERO ; 2DROP RDROP 0
        DD      SEMIS
 ;  
;


;  ************
;  *   READ   *
;  ************
;
N_READ:   DD      4
        DB      "READ"
READ:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    WFILE-(CW*(C_HOFFSET))
        DD    N_READ
    DD    0

        DD      RWBUF, ROT, ROT         ; RW-BUFFER ROT ROT
        DD      LIT, read, BDOSN        ; 3F00 BDOSN IF
        DD      ZBRAN
        DD      READ1-$-CW
        DD      TOR, DROP               ; >R DROP
        DD      ZERO, FROMR             ; 0 R> NEGATE ELSE
        DD      BRAN
        DD      READ2-$-CW
READ1:
        DD      TOR, TOR         ; >R >R
        DD      LIT, Save_DS_PR, FETCH, RWBUF ; <FAR> RW-BUFFER
        DD      ZERO, FROMR                   ; 0 R>
        DD      RR, FMOVE, FROMR, ZERO        ; R@ FARMOVE   R> 0
READ2:
        DD      SEMIS
;

;  *************
;  *   WRITE   *
;  *************
;
N_WRITE:   DD      5
        DB      "WRITE"
WRITE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    READ-(CW*(C_HOFFSET))
        DD    N_WRITE
    DD    0

        DD      TOR, TOR, ZERO, SWAP    ;   >R >R  0 SWAP
        DD      LIT, Save_DS_PR, FETCH, RWBUF  ; PD RW-BUFFER
        DD      RR, FMOVE               ; R@ FARMOVE
        DD      RWBUF, FROMR, FROMR     ; RW-BUFFER R> R>
        DD      LIT, write, BDOSN       ;  4000 BDOSN
        DD      ZEQU
        DD      ZBRAN
        DD      WRITE1-$-CW              ; IF NEGATE ELSE DROP 0 THEN ;
        DD      DROP
        DD      ZERO
WRITE1:
        DD      SEMIS
;
 ;  

;  ****************
;  *   GET-FILE   *
;  ****************
;
N_GETFILE:   DD      8
        DB      "GET-FILE"
GETFILE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    WRITE-(CW*(C_HOFFSET))
        DD    N_GETFILE
    DD    0

        DD      TDUP, SCOMMA, DROP
        DD      LIT, 'F'+(100H*('i'+100H*('L'+100H*'e'))), COMMA ;Magic number.
        DD      ZERO, OFILE, THROW, TOR
        DD      HERE, LDUP
        DD      LEM, LIT, 6, SLASH, LDUP, ALLOT
        DD      LIT, 1000, LSUB
        DD      RR, RFILE, THROW
        DD      FROMR, CFILE, THROW
        DD      TDUP, PLUS, LDP, STORE        ; No allocation if it fails.
        DD      SEMIS
;

;  ****************
;  *   PUT-FILE   *
;  ****************
;
N_PUTFILE:   DD      8
        DB      "PUT-FILE"
PUTFILE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    GETFILE-(CW*(C_HOFFSET))
        DD    N_PUTFILE
    DD    0

        DD      ZERO
        DD      CREATEF, THROW
        DD      LDUP, TOR
        DD      WFILE, THROW
        DD      FROMR, CFILE, THROW
        DD      SEMIS
;

;  ****************
;  *   INCLUDED   *
;  ****************
;
N_INCLUD:   DD      8
        DB      "INCLUDED"
INCLUD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PUTFILE-(CW*(C_HOFFSET))
        DD    N_INCLUD
    DD    0

        DD      HERE, TOR
        DD      LIT, GETFILE, CATCH
        DD      LDUP
        DD      ZBRAN
        DD      INCLUD1-$-CW
        DD      FROMR, LDP, STORE
        DD      THROW
        DD      BRAN
        DD      INCLUD2-$-CW
INCLUD1:
        DD      RDROP, DROP
INCLUD2:
        DD      EVALUATE
        DD      SEMIS
;

;  ******************
;  *   REFILL-TIB   *
;  ******************
;
N_REFTIB:   DD      10
        DB      "REFILL-TIB"
REFTIB:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    INCLUD-(CW*(C_HOFFSET))
        DD    N_REFTIB
    DD    0

        DD      REMAIND, FETCH, TOR
        DD      TIB, FETCH, RR, PLUS
        DD      LIT, RTS/2, RR, LSUB
        DD      ZERO, RFILE
        DD      QERRUR
        DD      LDUP, ZEQU, LIT, -32, LAND ; Presumably end of pipe.
        DD      QERRUR
        DD      TIB, FETCH, SWAP, FROMR, PLUS
        DD      REMAIND, TSTOR
        DD      SEMIS
;
;

; _SUPPRESSED_  ; 
;
;
;
;


;  **************
;  *   ACCEPT   *
;  **************
;
N_ACCEP:   DD      6
        DB      "ACCEPT"
ACCEP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    REFTIB-(CW*(C_HOFFSET))
        DD    N_ACCEP
    DD    0

        DD      PACCEP
        DD      TSWAP, ROT, MIN
        DD      LDUP, TOR, LMOVE, FROMR
        DD      SEMIS
;
;
;
;
;

        ;
;------------------------------------
;       SYSTEM DEPENDANT DISK I/O
;------------------------------------


;  ******************
;  *   DISK-ERROR   *
;  ******************
;
N_DERR:   DD      10
        DB      "DISK-ERROR"
DERR:        DD    DOVAR
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ACCEP-(CW*(C_HOFFSET))
        DD    N_DERR
    DD    0

        DD      -1
;


;  ******************
;  *   BLOCK-FILE   *
;  ******************
;
N_BLFL:   DD      10
        DB      "BLOCK-FILE"
BLFL:        DD    DOVAR
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DERR-(CW*(C_HOFFSET))
        DD    N_BLFL
    DD    0

        DD      9
        DB      "forth.lab"
        RESB    254 -9               ; Allow for some path

;  ********************
;  *   BLOCK-HANDLE   *
;  ********************
;
N_BHAN:   DD      12
        DB      "BLOCK-HANDLE"
BHAN:        DD    DOVAR
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BLFL-(CW*(C_HOFFSET))
        DD    N_BHAN
    DD    0

        DD      -1
;

;  *******************
;  *   ?DISK-ERROR   *
;  *******************
;
N_QDSKER:   DD      11
        DB      "?DISK-ERROR"
QDSKER:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BHAN-(CW*(C_HOFFSET))
        DD    N_QDSKER
    DD    0

        DD      LIT, 8, QERR
        DD      SEMIS
;
;


;  ******************
;  *   BLOCK-INIT   *
;  ******************
;
N_BLINI:   DD      10
        DB      "BLOCK-INIT"
BLINI:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QDSKER-(CW*(C_HOFFSET))
        DD    N_BLINI
    DD    0

        DD      BLFL, SFET
        DD      ROT
        DD      OFILE
        DD      ZEQU, NEGATE  ; 0 if disk problems, 1 if not.
        DD      LWARN, FETCH, MIN ; AND but WARNING is 0/1.
        DD      LWARN, STORE
        DD      BHAN, STORE
        DD      SEMIS
;

;  ******************
;  *   BLOCK-EXIT   *
;  ******************
;
N_BLEXI:   DD      10
        DB      "BLOCK-EXIT"
BLEXI:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BLINI-(CW*(C_HOFFSET))
        DD    N_BLEXI
    DD    0

        DD      FLUSH
        DD      BHAN, FETCH
        DD      CFILE
        DD      ZERO, LWARN, STORE
        DD      LIT, -1, BHAN, STORE    ;Regardless of close errors.
        DD      QDSKER
        DD      SEMIS
;

;  ************
;  *   SEEK   *
;  ************
;
N_SEEK:   DD      4
        DB      "SEEK"
SEEK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BLEXI-(CW*(C_HOFFSET))
        DD    N_SEEK
    DD    0

        DD      BBUF
        DD      USTAR
        DD      BHAN, FETCH
        DD      PFILE           ; Disk position.
        DD      QDSKER
        DD      SEMIS
;

;  ***********
;  *   R\W   *
;  ***********
;
N_RSLW:   DD      3
        DB      "R\W"
RSLW:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SEEK-(CW*(C_HOFFSET))
        DD    N_RSLW
    DD    0

        DD      TOR ; blk on top
        DD      SEEK ; That's done
        DD      BBUF
        DD      BHAN, FETCH
        DD      FROMR
        DD      ZBRAN
        DD      RSLW1-$-CW
        DD      RFILE           ; Disk read 
        DD      SWAP, DROP
        DD      BRAN
        DD      RSLW2-$-CW
RSLW1:  DD      WFILE           ; Disk write
RSLW2:
        DD      QDSKER
        DD      SEMIS
;
;

;  *************
;  *   SHELL   *
;  *************
;
N_SHELL:   DD      5
        DB      "SHELL"
SHELL:        DD    DOVAR
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    RSLW-(CW*(C_HOFFSET))
        DD    N_SHELL
    DD    0

         
                DD      14
        DB      "C:\COMMAND.COM"
        RESB    254 -9               ; Allow for some path
;

;

;  **************
;  *   SYSTEM   *
;  **************
;
N_SYSTEM:   DD      6
        DB      "SYSTEM"
SYSTEM:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SHELL-(CW*(C_HOFFSET))
        DD    N_SYSTEM
    DD    0

        DD      LIT, COMBUF, TOR
        DD      ZERO, SHELL, CHAPP, LIT, -1, SHELL, PSTORE
        DD      SKIP
         DD      5
SB5: DB      "X /c "
       
        DD      LIT, SB5
        DD      LIT, 5
        DD      RR, SSTOR
        DD      RR, SADD, LIT, ACR, RR, CHAPP
        DD      FROMR, SFET, ONEM, SWAP, CSTOR ;Fill in (BD) count at X.
       DD      ZERO, LIT, COMBUF + CW
        DD      LIT, Save_DS_PR, FETCH, OVER
        DD      LIT, 256
        DD      FMOVE                            
        DD      SHELL, CELLP, X, LIT, LOADEXEC
        DD      LIT, 4B00H, BDOSN
        DD      SWAP, QERR
        DD      SEMIS
LOADEXEC:   DW  0       ; The 0 are filled in at boot with DS.
        DW      COMBUF + CW  ;Allow it to be a counted string.
        DW      0
        DW      6CH
        DW      0
        DW      7CH
        DW      0
COMBUF:  RESB    CW+256  ;One cell for high level string manipulation.
 ; 
;
; 
;
;
;
; 
; 
;


;  *********
;  *   '   *
;  *********
;
N_ITICK:   DD      1
        DB      "'"
ITICK:        DD    DOCOL 
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SYSTEM-(CW*(C_HOFFSET))
        DD    N_ITICK
    DD    0

        DD      LPWORD, PRESENT
        DD      LDUP, ZEQU
        DD      LIT, 11, QERR
        DD      SEMIS
;

;  ***********
;  *   [']   *
;  ***********
;
N_BTICK:   DD      3
        DB      "[']"
BTICK:        DD    DOCOL
        DD    (TICK+(CW*(PH_OFFSET-C_HOFFSET)))
        DD    B_IMMED
        DD    ITICK-(CW*(C_HOFFSET))
        DD    N_BTICK
    DD    0

;
;

;  ******************
;  *   FORGET-VOC   *
;  ******************
;
N_FORGV:   DD      10
        DB      "FORGET-VOC"
FORGV:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BTICK-(CW*(C_HOFFSET))
        DD    N_FORGV
    DD    0

        DD      TDUP
        DD      SWAP
        DD      ULESS
        DD      ZBRAN
        DD      FORGV1-$-CW
;  Forget part of contents.
        DD      SWAP
        DD      TOR
        DD      TWID
        DD      LDUP
FORGV3:
        DD      TLFA,FETCH    ; Next voc
        DD      LDUP
        DD      RR
        DD      ULESS
        DD      ZBRAN
        DD      FORGV3-$-CW
        DD      SWAP
        DD      TLFA
        DD      STORE
        DD      FROMR
        DD      BRAN
        DD      FORGV2-$-CW
FORGV1:
;        Vocabulary itself is also forgotten.
        DD      TVFA
        DD      FETCH     ; Unlink by linking next vocabulary.
        DD      VOCL
        DD      STORE
        DD      ONLY, FORTH
        DD      DEFIN
FORGV2: DD      SEMIS
;

;  **************
;  *   FORGET   *
;  **************
;
N_FORG:   DD      6
        DB      "FORGET"
FORG:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FORGV-(CW*(C_HOFFSET))
        DD    N_FORG
    DD    0

        DD      TICK
        DD      LDUP
        DD      FENCE
        DD      FETCH
        DD      LESS
        DD      LIT, 21, QERR
        DD      LIT,FORGV
        DD      FORV
        DD      TNFA, FETCH, LDP, STORE
        DD      SEMIS
;

;  *************
;  *   (BACK   *
;  *************
;
N_PBACK:   DD      5
        DB      "(BACK"
PBACK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FORG-(CW*(C_HOFFSET))
        DD    N_PBACK
    DD    0

        DD      HERE
        DD      SEMIS
;

;  *************
;  *   BACK)   *
;  *************
;
N_BACKP:   DD      5
        DB      "BACK)"
BACKP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PBACK-(CW*(C_HOFFSET))
        DD    N_BACKP
    DD    0

        DD      HERE
        DD      CELLP
        DD      LSUB
        DD      COMMA
        DD      SEMIS
;

;  ****************
;  *   (FORWARD   *
;  ****************
;
N_PFORWARD:   DD      8
        DB      "(FORWARD"
PFORWARD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BACKP-(CW*(C_HOFFSET))
        DD    N_PFORWARD
    DD    0

        DD      HERE
        DD      X
        DD      COMMA
        DD      SEMIS
;

;  ****************
;  *   FORWARD)   *
;  ****************
;
N_FORWARDP:   DD      8
        DB      "FORWARD)"
FORWARDP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PFORWARD-(CW*(C_HOFFSET))
        DD    N_FORWARDP
    DD    0

        DD      HERE
        DD      OVER
        DD      CELLP
        DD      LSUB
        DD      SWAP
        DD      STORE
        DD      SEMIS
;

;  *************
;  *   BEGIN   *
;  *************
;
N_BEGIN:   DD      5
        DB      "BEGIN"
BEGIN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    FORWARDP-(CW*(C_HOFFSET))
        DD    N_BEGIN
    DD    0

        DD      PBACK
        DD      QCOMP, ONE
        DD      SEMIS
;

;  ************
;  *   THEN   *
;  ************
;
N_THEN:   DD      4
        DB      "THEN"
THEN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    BEGIN-(CW*(C_HOFFSET))
        DD    N_THEN
    DD    0

        DD      QCOMP, TWO, QPAIR
        DD      FORWARDP
        DD      SEMIS
;

;  **********
;  *   DO   *
;  **********
;
N_DO:   DD      2
        DB      "DO"
DO:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    THEN-(CW*(C_HOFFSET))
        DD    N_DO
    DD    0

         DD      LIT, XDO, COMMA, PFORWARD, PBACK
        DD      LIT,3    ; Magic number
        DD      SEMIS
;

;  ***********
;  *   ?DO   *
;  ***********
;
N_QDO:   DD      3
        DB      "?DO"
QDO:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    DO-(CW*(C_HOFFSET))
        DD    N_QDO
    DD    0

         DD      LIT, XQDO, COMMA, PFORWARD, PBACK
        DD      LIT,3    ; Magic number
        DD      SEMIS
;

;  ************
;  *   LOOP   *
;  ************
;
N_LLOOP:   DD      4
        DB      "LOOP"
LLOOP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    QDO-(CW*(C_HOFFSET))
        DD    N_LLOOP
    DD    0

        DD      LIT, 3, QPAIR
        DD      LIT, XLOOP, COMMA, BACKP
        DD      FORWARDP ; For DO to push the leave address.
        DD      SEMIS
;

;  *************
;  *   +LOOP   *
;  *************
;
N_PLOOP:   DD      5
        DB      "+LOOP"
PLOOP:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    LLOOP-(CW*(C_HOFFSET))
        DD    N_PLOOP
    DD    0

        DD      LIT, 3, QPAIR
        DD      LIT, XPLOO, COMMA, BACKP
        DD      FORWARDP ; For DO to push the leave address.
        DD      SEMIS
;

;  *************
;  *   UNTIL   *
;  *************
;
N_UNTIL:   DD      5
        DB      "UNTIL"
UNTIL:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    PLOOP-(CW*(C_HOFFSET))
        DD    N_UNTIL
    DD    0

        DD      ONE, QPAIR
        DD      LIT, ZBRAN, COMMA, BACKP
        DD      SEMIS
;

;  *************
;  *   AGAIN   *
;  *************
;
N_AGAIN:   DD      5
        DB      "AGAIN"
AGAIN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    UNTIL-(CW*(C_HOFFSET))
        DD    N_AGAIN
    DD    0

        DD      ONE, QPAIR
        DD      LIT, BRAN, COMMA, BACKP
        DD      SEMIS
;

;  **************
;  *   REPEAT   *
;  **************
;
N_REPEA:   DD      6
        DB      "REPEAT"
REPEA:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    AGAIN-(CW*(C_HOFFSET))
        DD    N_REPEA
    DD    0

        DD      ONE, QPAIR   ; Matches BEGIN ?
        DD      LIT, BRAN, COMMA, BACKP
        DD      QCOMP, LIT, 4, QPAIR ; Matches WHILE ?
        DD      FORWARDP ; WHILE target. 
        DD      SEMIS
;

;  **********
;  *   IF   *
;  **********
;
N_LIF:   DD      2
        DB      "IF"
LIF:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    REPEA-(CW*(C_HOFFSET))
        DD    N_LIF
    DD    0

        DD      LIT, ZBRAN, COMMA, PFORWARD
        DD      TWO     ; Magic number
        DD      SEMIS
;

;  ************
;  *   ELSE   *
;  ************
;
N_LELSE:   DD      4
        DB      "ELSE"
LELSE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    LIF-(CW*(C_HOFFSET))
        DD    N_LELSE
    DD    0

        DD      QCOMP, TWO, QPAIR
        DD      LIT, BRAN, COMMA, PFORWARD
        DD      SWAP
        DD      FORWARDP
        DD      TWO     ; Magic number
        DD      SEMIS
;

;  *************
;  *   WHILE   *
;  *************
;
N_LWHILE:   DD      5
        DB      "WHILE"
LWHILE:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    B_IMMED
        DD    LELSE-(CW*(C_HOFFSET))
        DD    N_LWHILE
    DD    0

        DD      TOR    ;  Save backward target. 
        DD      TOR
        DD      LIT, ZBRAN, COMMA, PFORWARD
        DD      LIT, 4 ; Magic number
        DD      FROMR
        DD      FROMR
        DD      SEMIS
;

;  **************
;  *   SPACES   *
;  **************
;
N_SPACES:   DD      6
        DB      "SPACES"
SPACES:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LWHILE-(CW*(C_HOFFSET))
        DD    N_SPACES
    DD    0

        DD      ZERO
        DD      MAX
        DD      ZERO
        DD     XQDO
        DD      SPAX1-$-CW
SPAX2:  DD      SPACE
        DD     XLOOP
        DD      SPAX2-$-CW    ;LOOP
SPAX1:
        DD      SEMIS
;

;  **********
;  *   <#   *
;  **********
;
N_BDIGS:   DD      2
        DB      "<#"
BDIGS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SPACES-(CW*(C_HOFFSET))
        DD    N_BDIGS
    DD    0

        DD      PAD
        DD      HLD
        DD      STORE
        DD      SEMIS
;

;  **********
;  *   #>   *
;  **********
;
N_EDIGS:   DD      2
        DB      "#>"
EDIGS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BDIGS-(CW*(C_HOFFSET))
        DD    N_EDIGS
    DD    0

        DD      DROP
        DD      DROP
        DD      HLD
        DD      FETCH
        DD      PAD
        DD      OVER
        DD      LSUB
        DD      SEMIS
;

;  ************
;  *   SIGN   *
;  ************
;
N_SIGN:   DD      4
        DB      "SIGN"
SIGN:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    EDIGS-(CW*(C_HOFFSET))
        DD    N_SIGN
    DD    0

        DD      ZLESS
        DD      ZBRAN
        DD      SIGN1-$-CW ;IF
        DD      LIT,2DH
        DD      HOLD    ;THEN
SIGN1:  DD      SEMIS
;

;  *********
;  *   #   *
;  *********
;
N_DIG:   DD      1
        DB      "#"
DIG:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    SIGN-(CW*(C_HOFFSET))
        DD    N_DIG
    DD    0

        DD      BASE
        DD      FETCH
        DD      MSMOD
        DD      ROT
        DD      LIT,9
        DD      OVER
        DD      LESS
        DD      ZBRAN
        DD      DIG1-$-CW  ;IF
        DD      LIT,7
        DD      PLUS    ;THEN
DIG1:   DD      LIT,30H
        DD      PLUS
        DD      HOLD
        DD      SEMIS
;

;  **********
;  *   #S   *
;  **********
;
N_DIGS:   DD      2
        DB      "#S"
DIGS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DIG-(CW*(C_HOFFSET))
        DD    N_DIGS
    DD    0

DIGS1:  DD      DIG     ;BEGIN
        DD      OVER
        DD      OVER
        DD      LOR
        DD      ZEQU
        DD      ZBRAN
        DD      DIGS1-$-CW ;UNTIL
        DD      SEMIS
;

;  *************
;  *   (D.R)   *
;  *************
;
N_PDDOTR:   DD      5
        DB      "(D.R)"
PDDOTR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DIGS-(CW*(C_HOFFSET))
        DD    N_PDDOTR
    DD    0

        DD      TOR
        DD      SWAP
        DD      OVER
        DD      DABS
        DD      BDIGS
        DD      DIGS
        DD      ROT
        DD      SIGN
        DD      EDIGS
        DD      FROMR
        DD      OVER
        DD      LSUB
        DD      SPACES
        DD      SEMIS
;

;  ***********
;  *   D.R   *
;  ***********
;
N_DDOTR:   DD      3
        DB      "D.R"
DDOTR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    PDDOTR-(CW*(C_HOFFSET))
        DD    N_DDOTR
    DD    0

        DD      PDDOTR
        DD      LTYPE
        DD      SEMIS
;

;  **********
;  *   .R   *
;  **********
;
N_DOTR:   DD      2
        DB      ".R"
DOTR:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DDOTR-(CW*(C_HOFFSET))
        DD    N_DOTR
    DD    0

        DD      TOR
        DD      STOD
        DD      FROMR
        DD      DDOTR
        DD      SEMIS
;

;  **********
;  *   D.   *
;  **********
;
N_DDOT:   DD      2
        DB      "D."
DDOT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DOTR-(CW*(C_HOFFSET))
        DD    N_DDOT
    DD    0

        DD      ZERO
        DD      DDOTR
        DD      SPACE
        DD      SEMIS
;

;  *********
;  *   .   *
;  *********
;
N_DOT:   DD      1
        DB      "."
DOT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DDOT-(CW*(C_HOFFSET))
        DD    N_DOT
    DD    0

        DD      STOD
        DD      DDOT
        DD      SEMIS
;

;  *********
;  *   ?   *
;  *********
;
N_QUES:   DD      1
        DB      "?"
QUES:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DOT-(CW*(C_HOFFSET))
        DD    N_QUES
    DD    0

        DD      FETCH
        DD      DOT
        DD      SEMIS
;

;  **********
;  *   U.   *
;  **********
;
N_UDOT:   DD      2
        DB      "U."
UDOT:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    QUES-(CW*(C_HOFFSET))
        DD    N_UDOT
    DD    0

        DD      ZERO
        DD      DDOT
        DD      SEMIS
;

;  *****************
;  *   FOR-WORDS   *
;  *****************
;
N_FORW:   DD      9
        DB      "FOR-WORDS"
FORW:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    UDOT-(CW*(C_HOFFSET))
        DD    N_FORW
    DD    0

        DD      SWAP
        DD      TOR
        DD      TOR
FORW1:  DD      FROMR
        DD      RR
        DD      OVER
        DD      TLFA
        DD      FETCH
        DD      TOR
        DD      EXEC
        DD      RR
        DD      ZEQU
        DD      ZBRAN
        DD      FORW1-$-CW
        DD      RDROP
        DD      RDROP
        DD      SEMIS
;

;  ****************
;  *   FOR-VOCS   *
;  ****************
;
N_FORV:   DD      8
        DB      "FOR-VOCS"
FORV:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FORW-(CW*(C_HOFFSET))
        DD    N_FORV
    DD    0

        DD      TOR
        DD      VOCL
        DD      FETCH
        DD      TOR
FORV1:  DD      FROMR
        DD      RR
        DD      OVER
        DD      TVFA
        DD      FETCH
        DD      TOR
        DD      EXEC
        DD      RR
        DD      ZEQU
        DD      ZBRAN
        DD      FORV1-$-CW
        DD      RDROP
        DD      RDROP
        DD      SEMIS
;

;  *************
;  *   WORDS   *
;  *************
;
N_WORDS:   DD      5
        DB      "WORDS"
WORDS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    FORV-(CW*(C_HOFFSET))
        DD    N_WORDS
    DD    0

        DD      CSLL
        DD      LOUT
        DD      STORE
        DD      LIT, IDDOT
        DD      SEARCH
        DD      FETCH
        DD      FORW
        DD      SEMIS
;
; 


;  ***********
;  *   BYE   *
;  ***********
;
N_BYE:   DD      3
        DB      "BYE"
BYE:        DD    $+(CW*(PH_OFFSET-C_HOFFSET))
        DD    $+(CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    WORDS-(CW*(C_HOFFSET))
        DD    N_BYE
    DD    0

; EXIT TO PC-DOS, if run from PC-DOS, otherwise hang or whatever.
        MOV     EBX,[(XCODE+(CW*(PH_OFFSET-C_HOFFSET)))]
        
RETDOSV: JMP 0:0        ; Filled in during boot
        BITS   32 

; 

;  *****************
;  *   EXIT-CODE   *
;  *****************
;
N_XCODE:   DD      9
        DB      "EXIT-CODE"
XCODE:        DD    DOVAR
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    BYE-(CW*(C_HOFFSET))
        DD    N_XCODE
    DD    0

        DD      0
;
; 
;

;  ************
;  *   LIST   *
;  ************
;
N_LLIST:   DD      4
        DB      "LIST"
LLIST:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    XCODE-(CW*(C_HOFFSET))
        DD    N_LLIST
    DD    0

        DD      SCR,STORE
        DD      SKIP
         DD      6
SB6: DB      "SCR # "
       
        DD      LIT, SB6
        DD      LIT, 6
        DD      LTYPE
        DD      BASE, FETCH
        DD      DECA
        DD      SCR, FETCH, DOT
        DD      BASE, STORE
        DD      SCR, FETCH, BLOCK
        DD      LIT,1024
LLIST1: DD      LIT, ALF, SSPLIT
        DD      CR, LTYPE
        DD      OVER,ZEQU ;DUP would not show a last empty line!
        DD      ZBRAN
        DD      LLIST1-$-CW
        DD      TDROP
        DD      SEMIS
;

;  *************
;  *   INDEX   *
;  *************
;
N_INDEX:   DD      5
        DB      "INDEX"
INDEX:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LLIST-(CW*(C_HOFFSET))
        DD    N_INDEX
    DD    0

        DD      LIT,AFF
        DD      EMIT,CR
        DD      ONEP,SWAP
        DD     XDO
        DD      INDE9-$-CW
INDE1:  DD      CR,IDO
        DD      LIT,3
        DD      DOTR,SPACE
        DD      ZERO,IDO
        DD      PLINE, LTYPE, KEYQ
        DD      ZBRAN
        DD      INDE2-$-CW
        DD      LLEAV
INDE2:  DD     XLOOP
        DD      INDE1-$-CW
INDE9:
        DD      SEMIS
;

;  **********
;  *   .S   *
;  **********
;
N_DOTS:   DD      2
        DB      ".S"
DOTS:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    INDEX-(CW*(C_HOFFSET))
        DD    N_DOTS
    DD    0

        DD      CR
        DD      LIT, 'S', EMIT
        DD      LIT, ASO, EMIT
        DD      SPACE
        DD      SPFET, SZERO, FETCH
DOC2:   DD      OVER, OVER,  EQUAL, ZEQU
        DD      ZBRAN
        DD      DOC1-$-CW
        DD      ZERO, CELLP, LSUB, LDUP, FETCH, DOT
        DD      BRAN
        DD      DOC2-$-CW
DOC1:    DD DROP, DROP
        DD      LIT, ASC, EMIT
        DD SEMIS
;

;  ********************
;  *   ENVIRONMENT?   *
;  ********************
;
N_ENVQ:   DD      12
        DB      "ENVIRONMENT?"
ENVQ:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    DOTS-(CW*(C_HOFFSET))
        DD    N_ENVQ
    DD    0

        DD      LIT, ENV, TWID, PFIND
        DD      TOR, TDROP, FROMR
        DD      LDUP
        DD      ZBRAN
        DD      ENVQ1-$-CW
        DD      EXEC
        DD      LIT, -1
ENVQ1:
        DD      SEMIS
;


;  *************
;  *   TRIAD   *
;  *************
;
N_TRIAD:   DD      5
        DB      "TRIAD"
TRIAD:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    ENVQ-(CW*(C_HOFFSET))
        DD    N_TRIAD
    DD    0

        DD      LIT,AFF
        DD      EMIT
        DD      LIT,3
        DD      SLASH
        DD      LIT,3
        DD      STAR
        DD      LIT,3
        DD      OVER,PLUS
        DD      SWAP
        DD     XDO
        DD      TRIA9-$-CW
TRIA1:  DD      CR,IDO
        DD      LLIST
        DD      KEYQ
        DD      ZBRAN
        DD      TRIA2-$-CW
        DD      LLEAV   ;LEAVE
TRIA2:  DD     XLOOP
        DD      TRIA1-$-CW    ;THEN
TRIA9:
        DD      CR
        DD      ZERO, MESS
        DD      SEMIS
;
;
; This word is not even fig!

;  ***************
;  *   .SIGNON   *
;  ***************
;
N_SIGNON:   DD      7
        DB      ".SIGNON"
SIGNON:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    TRIAD-(CW*(C_HOFFSET))
        DD    N_SIGNON
    DD    0

; PRINT CPU TYPE (8088)
        DD      CR
        DD      BASE,FETCH
        DD      LIT,36, BASE,STORE
        DD      LCPU, DDOT
        DD      BASE,STORE
;
        DD      LNAME, LTYPE, SPACE
        DD      LVERSION, LTYPE, SPACE
        DD      CR
        DD      SEMIS
;

;

;  **************
;  *   LOW-DP   *
;  **************
;
N_LOWDP:   DD      6
        DB      "LOW-DP"
LOWDP:        DD    DOUSE
        DD    (CW*(16))
        DD    0H
        DD    SIGNON-(CW*(C_HOFFSET))
        DD    N_LOWDP
    DD    0

;

;  **************
;  *   LOW-EM   *
;  **************
;
N_LOWEM:   DD      6
        DB      "LOW-EM"
LOWEM:        DD    DOUSE
        DD    (CW*(17))
        DD    0H
        DD    LOWDP-(CW*(C_HOFFSET))
        DD    N_LOWEM
    DD    0

;
; 
;
;**** LAST DICTIONARY WORD ****

;  ************
;  *   TASK   *
;  ************
;
N_TASK:   DD      4
        DB      "TASK"
TASK:        DD    DOCOL
        DD    $ + (CW*(PH_OFFSET-D_HOFFSET))
        DD    0H
        DD    LOWEM-(CW*(C_HOFFSET))
        DD    N_TASK
    DD    0

        DD      SEMIS
;

TEXTEND  EQU     $       ; Show end of dictionary.
INITDP   EQU     $ ;Where we want new words.
ACTUAL_EM EQU    EM  ; Different for relocatable code only.
 ;  

%if 0

The remaining memory ( up to 'EM' ) is
used for:

        1. EXTENSION DICTIONARY
        2. PARAMETER STACK
        3. TERMINAL INPUT BUFFER
        4. RETURN STACK
        5. USER VARIABLE AREA
        6. DISK BUFFERS (UNLESS REQUIRED <1 MBYTE)


%endif

; 
;

 ;    ENDS
        ;
%if 0

  MISC. NOTES AND SCATTERED THOUGHTS

- Remember that all the FORTH words in this version are
  upper case letters.  Use <CAPS LOCK> when in FORTH.

; 

- Subscribe to FORTH Dimensions.  It is a valuable source
  of system and application ideas.  Talking with fellow
  FORTH programmers is sure to stir up some exciting ideas.
  Consider joining a FIG chapter.  See the back of FORTH
  Dimensions for more info.

%endif

; Define the entry point, not valid for auto booting.
        ;     ORIG

























;




