/* search.c - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.09.14. JWi
 *  */
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <stdio.h>
#include "flokecore.h"
char dirparter[]="\\";
char dot[]=".";

BOOL my_findfiles(char searchdir[MAX_PATH], char searchpattern[SEARCHPATTERNLENGHT])  //Function to find files in a dir (No dir extraction)
{
	WIN32_FIND_DATA curfindData;
	HANDLE searchHandel;
	char cur_search[MAX_PATH];
	unsigned int i,j;
	BOOL dir;


	j=0;
	i=0;

			while (searchdir[i]!=NIL)
				{
					cur_search[i]=searchdir[i];
					i++;
				}
			while (j<SEARCHPATTERNLENGHT)
				{
					cur_search[i]=searchpattern[j];
					j++;
					i++;
				}
			cur_search[i]=NIL;

	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELTHREE)
		{
			fprintf(errverboseout,"my_findfiles cur_search %s \n",cur_search);
		}
	#endif
	searchHandel=FindFirstFile(cur_search,&curfindData); // Find first file
	if(searchHandel==INVALID_HANDLE_VALUE)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"my_findfiles searchHandel==INVALID_HANDLE_VALUE\n");
				}
			#endif
			return FALSE;
		}

	if(curfindData.cFileName[0]==CR[0])
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"my_findfiles curfindData.cFileName[0]==CR\n");
				}
			#endif
			return FALSE;
		}
	dir=TRUE;
	if(curfindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) //If dir then make DIR=FALSE
		{
			dir=FALSE;
		}

	if (dir==TRUE)
		{
			//temp=curfileentry;
			proccessfile(curfindData.cFileName,searchdir); // Call function to handel file
			if (memcurfile==NULL)
				{
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELONE)
						{
							fprintf(errverboseout,"my_findfiles I memcurfile : Memory allocation error\n");
						}
					#endif
					FindClose(searchHandel);
					return(FALSE);
				}
		}

	while (FindNextFile(searchHandel,&curfindData)==TRUE)
		{
			dir=TRUE;
			if(curfindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) //If dir then make DIR=FALSE
				{
					dir=FALSE;
				}

			if (dir==TRUE)
				{
					proccessfile(curfindData.cFileName,searchdir); // Call function to handel file
						if (memcurfile==NULL)
							{
								#ifdef DEBUGHELPERS
								if (verbose>ERRVERBOSELEVELONE)
									{
										fprintf(errverboseout,"my_findfiles I memcurfile : Memory allocation error\n");
									}
								#endif
								FindClose(searchHandel);
								return(FALSE);
							}

				}
		}
	FindClose(searchHandel);
	return(TRUE);
}

BOOL my_finddirs(char basedir[MAX_PATH])  //Function to find dirs
{
	WIN32_FIND_DATA curfindData;
	HANDLE searchHandel;
	char searchdir[MAX_PATH];
	char totalpath[MAX_PATH];
	char cur_search[MAX_PATH];
	char searchpattern[]="*.* "; // All dirs
	unsigned int i,j;

	searchpattern[3]=NIL;
	j=0;
	i=0;

			while (basedir[i]!=NIL)
				{
					cur_search[i]=basedir[i];
					i++;
				}
			while (j<4)
				{
					cur_search[i]=searchpattern[j];
					j++;
					i++;
				}
			cur_search[i]=NIL;

	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELTHREE)
		{
			fprintf(errverboseout,"my_finddirs cur_search %s \n",cur_search);
		}
	#endif
	searchHandel=FindFirstFile(cur_search,&curfindData); // Find first file
	if (curfindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) //Former ==FILE_ATTRIBUTE_DIRECTORY
		{
			if(curfindData.cFileName[0]!=dot[0])
				{

					i=0;
					j=0;
					while (basedir[i]!=NIL)
						{
							totalpath[i]=basedir[i];
							i++;
						}
					while (curfindData.cFileName[j]!=NIL)
						{
							totalpath[i]=curfindData.cFileName[j];
							j++;
							i++;
						}

					totalpath[i]=dirparter[0];
					i++;
					totalpath[i]=NIL;

					proccessdir(totalpath); // Call function to handel dir
				}
		}

	while (FindNextFile(searchHandel,&curfindData)==TRUE)
		{
			if (curfindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
				{
					if(curfindData.cFileName[0]!=dot[0])
						{
							i=0;
							j=0;
							while (basedir[i]!=NIL)
								{
									totalpath[i]=basedir[i];
									i++;
								}
							while (curfindData.cFileName[j]!=NIL)
								{
									totalpath[i]=curfindData.cFileName[j];
									j++;
									i++;
								}
							totalpath[i]=dirparter[0];
							i++;
							totalpath[i]=NIL;
							proccessdir(totalpath); // Call function to handel dir
						}
				}
		}
	FindClose(searchHandel);
	memcurdir->dirname[0]=NIL;
	return(TRUE);

}

