/*
 * Decompiled with CFR 0.152.
 */
package com.speech4j.ant;

import com.speech4j.speech.SpeechException;
import com.speech4j.speech.TTSEnum;
import com.speech4j.speech.TTSMode;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;

public class VoiceBuildListener
implements BuildListener {
    private TTSMode mode;
    private int msgLevel = 2;
    private boolean buildStartedEnabled = false;
    private boolean buildFinishedEnabled = false;
    private boolean targetStartedEnabled = false;
    private boolean targetFinishedEnabled = false;
    private boolean taskStartedEnabled = false;
    private boolean taskFinishedEnabled = false;
    private boolean messageLoggedEnabled = false;
    static /* synthetic */ Class class$com$speech4j$ant$VoiceBuildListener;

    public VoiceBuildListener() {
        Object object;
        Object object2;
        String string;
        if (System.getProperty("os.name") == null || !System.getProperty("os.name").startsWith("Windows")) {
            System.err.println("Not Windows OS, the voice listener deactivated");
            return;
        }
        String string2 = this.getProperty("modeId", null);
        try {
            this.mode = new TTSMode();
            this.mode.create();
            if (string2 == null) {
                string = this.getProperty("modeName", null);
                if (string != null) {
                    object2 = new TTSEnum();
                    object = ((TTSEnum)object2).findByModeName(string);
                    this.mode.init(object.getModeId());
                    ((TTSEnum)object2).destroy();
                } else {
                    this.mode.init();
                }
            } else {
                this.mode.init(string2);
            }
        }
        catch (SpeechException speechException) {
            System.err.println("Speech exception in voice listener constructor, the voice listener deactivated");
            speechException.printStackTrace();
            return;
        }
        string = this.getProperty("messageLevel", "INFO");
        if ("ERR".equals(string)) {
            this.msgLevel = 0;
        } else if ("WARN".equals(string)) {
            this.msgLevel = 1;
        } else if ("INFO".equals(string)) {
            this.msgLevel = 2;
        } else if ("VERBOSE".equals(string)) {
            this.msgLevel = 3;
        } else if ("DEBUG".equals(string)) {
            this.msgLevel = 4;
        } else {
            this.msgLevel = 2;
            System.err.println("Invalid message level: " + string + ", using INFO. Valid values: ERR, WARN, INFO, VERBOSE, DEBUG.");
        }
        object2 = this.getProperty("events", "buildStarted, buildFinished, targetStarted, targetFinished");
        object = new StringTokenizer((String)object2, ",");
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string3 = ((StringTokenizer)object).nextToken();
            if ("buildStarted".equals(string3.trim())) {
                this.buildStartedEnabled = true;
                continue;
            }
            if ("buildFinished".equals(string3.trim())) {
                this.buildFinishedEnabled = true;
                continue;
            }
            if ("targetStarted".equals(string3.trim())) {
                this.targetStartedEnabled = true;
                continue;
            }
            if ("targetFinished".equals(string3.trim())) {
                this.targetFinishedEnabled = true;
                continue;
            }
            if ("taskStarted".equals(string3.trim())) {
                this.taskStartedEnabled = true;
                continue;
            }
            if ("taskFinished".equals(string3.trim())) {
                this.taskFinishedEnabled = true;
                continue;
            }
            if ("messageLogged".equals(string3.trim())) {
                this.messageLoggedEnabled = true;
                continue;
            }
            System.err.println("Invalid event: " + string3);
        }
    }

    private void speak(String string, BuildEvent buildEvent) {
        block4: {
            if (this.mode == null) break block4;
            try {
                this.mode.speakAndWait(string, false);
            }
            catch (SpeechException speechException) {
                if (buildEvent != null) {
                    buildEvent.getProject().log("Speech exception occured, voice listener deactivated", 1);
                } else {
                    System.err.println("Speech exception occured, voice listener deactivated");
                }
                speechException.printStackTrace();
                this.mode.destroy();
                this.mode = null;
            }
        }
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (this.buildFinishedEnabled) {
            if (buildEvent.getException() == null) {
                this.speak(MessageFormat.format(this.getProperty("buildSuccessfulMessage", "Build successful"), buildEvent.getProject().getName(), buildEvent.getProject().getDescription()), buildEvent);
            } else {
                this.speak(MessageFormat.format(this.getProperty("buildFailedMessage", "Build failed"), buildEvent.getProject().getName(), buildEvent.getProject().getDescription(), buildEvent.getException().getClass().getName(), buildEvent.getException().getMessage()), buildEvent);
            }
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        if (this.buildStartedEnabled) {
            this.speak(MessageFormat.format(this.getProperty("buildStartedMessage", "Build started"), buildEvent.getProject().getName(), buildEvent.getProject().getDescription()), buildEvent);
        }
    }

    public void messageLogged(BuildEvent buildEvent) {
        if (this.messageLoggedEnabled && buildEvent.getMessage() != null && buildEvent.getPriority() <= this.msgLevel) {
            this.speak(buildEvent.getMessage(), buildEvent);
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
        if (!this.targetFinishedEnabled) {
            return;
        }
        if (buildEvent.getTarget() == null) {
            this.speak(this.getProperty("unknownTargetFinishedMessage", "Unknown target finished"), buildEvent);
        } else {
            this.speak(MessageFormat.format(this.getProperty("targetFinishedMessage", "Target {0} finished"), buildEvent.getTarget().getName(), buildEvent.getTarget().getDescription()), buildEvent);
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
        if (!this.targetStartedEnabled) {
            return;
        }
        if (buildEvent.getTarget() == null) {
            this.speak(this.getProperty("unknownTargetStartedMessage", "Unknown target started"), buildEvent);
        } else {
            this.speak(MessageFormat.format(this.getProperty("targetFinishedMessage", "Target {0} finished"), buildEvent.getTarget().getName(), buildEvent.getTarget().getDescription()), buildEvent);
        }
    }

    public void taskFinished(BuildEvent buildEvent) {
        if (this.taskFinishedEnabled) {
            if (buildEvent.getTask() == null) {
                this.speak(this.getProperty("unknownTaskFinishedMessage", "Unknown task finished"), buildEvent);
            } else {
                this.speak(MessageFormat.format(this.getProperty("taskFinishedMessage", "Task {0} finished"), buildEvent.getTask().getTaskName(), buildEvent.getTask().getDescription()), buildEvent);
            }
        }
    }

    public void taskStarted(BuildEvent buildEvent) {
        if (this.taskStartedEnabled) {
            if (buildEvent.getTask() == null) {
                this.speak(this.getProperty("unknownTaskStartedMessage", "Unknown task started"), buildEvent);
            } else {
                this.speak(MessageFormat.format(this.getProperty("taskStartedMessage", "Task {0} started"), buildEvent.getTask().getTaskName(), buildEvent.getTask().getDescription()), buildEvent);
            }
        }
    }

    private String getProperty(String string, String string2) {
        String string3 = System.getProperty((class$com$speech4j$ant$VoiceBuildListener == null ? (class$com$speech4j$ant$VoiceBuildListener = VoiceBuildListener.class$("com.speech4j.ant.VoiceBuildListener")) : class$com$speech4j$ant$VoiceBuildListener).getName() + "." + string);
        return string3 == null ? string2 : string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

