/*
 * Decompiled with CFR 0.152.
 */
package com.speech4j.ant;

import com.speech4j.sound.Util;
import com.speech4j.speech.Audio;
import com.speech4j.speech.AudioDest;
import com.speech4j.speech.AudioDestFile;
import com.speech4j.speech.NativeObject;
import com.speech4j.speech.SpeechException;
import com.speech4j.speech.TTSEnum;
import com.speech4j.speech.TTSMode;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class VoiceMessageTask
extends Task {
    private String modeId;
    private String modeName;
    private String message = "";
    private File file;
    private boolean failOnError = false;

    public void setModeId(String string) {
        this.modeId = string;
    }

    public void setModeName(String string) {
        this.modeName = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public void addText(String string) {
        this.message = this.message + this.project.replaceProperties(string);
    }

    public void execute() throws BuildException {
        block11: {
            if (System.getProperty("os.name") == null || !System.getProperty("os.name").startsWith("Windows")) {
                this.project.log("Not Windows OS!", 3);
                return;
            }
            if (this.message.trim().length() == 0) {
                return;
            }
            if (this.modeId != null && this.modeName != null) {
                throw new BuildException("modeId and modeName are mutually exclusive");
            }
            try {
                Object object;
                NativeObject nativeObject;
                NativeObject nativeObject2;
                String string = this.modeId;
                if (this.modeName != null) {
                    nativeObject2 = new TTSEnum();
                    string = Util.bytes2String(((TTSEnum)nativeObject2).findByModeName(this.modeName).getModeId());
                }
                if (this.file == null) {
                    nativeObject2 = new TTSMode();
                    ((TTSMode)nativeObject2).create();
                    if (string == null) {
                        ((TTSMode)nativeObject2).init();
                    } else {
                        ((TTSMode)nativeObject2).init(string);
                    }
                    ((TTSMode)nativeObject2).speakAndWait(this.message, false);
                    ((TTSMode)nativeObject2).destroy();
                    break block11;
                }
                nativeObject2 = new AudioDestFile(this.file.getAbsolutePath());
                if (string == null) {
                    nativeObject = new TTSMode();
                    ((TTSMode)nativeObject).create();
                    ((TTSMode)nativeObject).init();
                    object = ((TTSMode)nativeObject).getMode();
                    string = Util.bytes2String(object.getModeId());
                }
                nativeObject = new TTSEnum();
                object = ((TTSEnum)nativeObject).select(string, (AudioDest)nativeObject2);
                ((TTSMode)object).speakAndWait(this.message, false);
                ((TTSMode)object).destroy();
                ((TTSEnum)nativeObject).destroy();
                ((Audio)nativeObject2).flush();
                ((AudioDestFile)nativeObject2).destroy();
            }
            catch (SpeechException speechException) {
                if (this.failOnError) {
                    throw new BuildException((Throwable)speechException);
                }
                this.project.log("VoiceMessageTask failed: " + speechException, 1);
            }
        }
    }
}

