/*
 * Decompiled with CFR 0.152.
 */
package com.speech4j.sound;

import com.speech4j.sound.SoundException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioBuffer {
    private AudioFormat format;
    private byte[] data;

    public AudioFormat getFormat() {
        return this.format;
    }

    public void setFormat(AudioFormat audioFormat) {
        this.format = audioFormat;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void load(String string) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new File(string));
        this.format = audioInputStream.getFormat();
        this.data = new byte[audioInputStream.available()];
        audioInputStream.read(this.data);
        audioInputStream.close();
    }

    public void save(String string) throws FileNotFoundException, IOException {
        int n = this.data.length;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write("RIFF".getBytes());
        int n2 = n + 44 - 8;
        fileOutputStream.write(n2 & 0xFF);
        fileOutputStream.write(n2 >> 8 & 0xFF);
        fileOutputStream.write(n2 >> 16 & 0xFF);
        fileOutputStream.write(n2 >> 24 & 0xFF);
        fileOutputStream.write("WAVEfmt ".getBytes());
        fileOutputStream.write(16);
        fileOutputStream.write(0);
        fileOutputStream.write(0);
        fileOutputStream.write(0);
        fileOutputStream.write(1);
        fileOutputStream.write(0);
        fileOutputStream.write(this.format.getChannels());
        fileOutputStream.write(0);
        int n3 = (int)this.format.getSampleRate();
        fileOutputStream.write(n3 & 0xFF);
        fileOutputStream.write(n3 >> 8 & 0xFF);
        fileOutputStream.write(n3 >> 16 & 0xFF);
        fileOutputStream.write(n3 >> 24 & 0xFF);
        int n4 = n3 * this.format.getSampleSizeInBits() * this.format.getChannels() / 8;
        fileOutputStream.write(n4 & 0xFF);
        fileOutputStream.write(n4 >> 8 & 0xFF);
        fileOutputStream.write(n4 >> 16 & 0xFF);
        fileOutputStream.write(n4 >> 24 & 0xFF);
        int n5 = this.format.getSampleSizeInBits() * this.format.getChannels() / 8;
        fileOutputStream.write(n5 & 0xFF);
        fileOutputStream.write(n5 >> 8 & 0xFF);
        int n6 = this.format.getSampleSizeInBits();
        fileOutputStream.write(n6 & 0xFF);
        fileOutputStream.write(n6 >> 8 & 0xFF);
        fileOutputStream.write("data".getBytes());
        fileOutputStream.write(n & 0xFF);
        fileOutputStream.write(n >> 8 & 0xFF);
        fileOutputStream.write(n >> 16 & 0xFF);
        fileOutputStream.write(n >> 24 & 0xFF);
        fileOutputStream.write(this.data);
        fileOutputStream.close();
    }

    public AudioBuffer convert(AudioFormat audioFormat) throws SoundException {
        if (this.format.matches(audioFormat)) {
            return this;
        }
        AudioBuffer audioBuffer = new AudioBuffer();
        double d = (float)audioFormat.getChannels() * audioFormat.getSampleRate() * (float)audioFormat.getSampleSizeInBits() / ((float)this.format.getChannels() * this.format.getSampleRate() * (float)this.format.getSampleSizeInBits());
        audioBuffer.data = new byte[(int)((double)this.data.length * d)];
        audioBuffer.format = audioFormat;
        int n = this.format.getChannels() * this.format.getSampleSizeInBits() / 8;
        int n2 = this.data.length / n;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            int n5 = 0;
            int n6 = this.format.getSampleSizeInBits() / 8;
            block0 : switch (this.format.getChannels()) {
                case 2: {
                    switch (this.format.getSampleSizeInBits()) {
                        case 16: {
                            n5 = (short)(this.data[n3 * n + 1 + n6] << 8 & 0xFF00);
                        }
                        case 8: {
                            n5 |= this.data[n3 * n + n6] & 0xFF;
                            break;
                        }
                        default: {
                            throw new SoundException("Unsupported sample size: " + this.format.getSampleSizeInBits());
                        }
                    }
                }
                case 1: {
                    switch (this.format.getSampleSizeInBits()) {
                        case 16: {
                            n4 = (short)(this.data[n3 * n + 1] << 8 & 0xFF00);
                        }
                        case 8: {
                            n4 |= this.data[n3 * n] & 0xFF;
                            break block0;
                        }
                    }
                    throw new SoundException("Unsupported sample size: " + this.format.getSampleSizeInBits());
                }
                default: {
                    throw new SoundException("Unsupported number of channels: " + this.format.getChannels());
                }
            }
            if (this.format.getChannels() == 1 && audioFormat.getChannels() == 2) {
                n5 = n4;
            }
            switch (audioFormat.getSampleSizeInBits() - this.format.getSampleSizeInBits()) {
                case -8: {
                    n5 = n5 >> 8 & 0xFF;
                    n4 = n4 >> 8 & 0xFF;
                    break;
                }
                case 0: {
                    break;
                }
                case 8: {
                    n5 = n5 << 8 & 0xFF00;
                    n4 = n4 << 8 & 0xFF00;
                    break;
                }
                default: {
                    throw new SoundException("Unsupported sample size: " + this.format.getSampleSizeInBits());
                }
            }
            int n7 = audioFormat.getSampleSizeInBits() * audioFormat.getChannels() / 8;
            int n8 = (int)((float)n3 * audioFormat.getSampleRate() / this.format.getSampleRate());
            int n9 = (int)((float)(n3 + 1) * audioFormat.getSampleRate() / this.format.getSampleRate());
            int n10 = n8;
            while (n10 < n9) {
                int n11 = n10 * n7;
                block17 : switch (audioFormat.getChannels()) {
                    case 2: {
                        switch (audioFormat.getSampleSizeInBits()) {
                            case 16: {
                                if (audioFormat.isBigEndian()) {
                                    audioBuffer.data[n11 + 2] = (byte)(n5 >> 8 & 0xFF);
                                    audioBuffer.data[n11 + 3] = (byte)(n5 & 0xFF);
                                    break;
                                }
                                audioBuffer.data[n11 + 2] = (byte)(n5 & 0xFF);
                                audioBuffer.data[n11 + 3] = (byte)(n5 >> 8 & 0xFF);
                                break;
                            }
                            case 8: {
                                audioBuffer.data[n11 + 1] = (byte)(n5 & 0xFF);
                                break;
                            }
                            default: {
                                throw new SoundException("Unsupported sample size: " + audioFormat.getSampleSizeInBits());
                            }
                        }
                    }
                    case 1: {
                        switch (audioFormat.getSampleSizeInBits()) {
                            case 16: {
                                if (audioFormat.isBigEndian()) {
                                    audioBuffer.data[n11] = (byte)(n4 >> 8 & 0xFF);
                                    audioBuffer.data[n11 + 1] = (byte)(n4 & 0xFF);
                                    break block17;
                                }
                                audioBuffer.data[n11] = (byte)(n4 & 0xFF);
                                audioBuffer.data[n11 + 1] = (byte)(n4 >> 8 & 0xFF);
                                break block17;
                            }
                            case 8: {
                                audioBuffer.data[n11] = (byte)(n4 & 0xFF);
                                break block17;
                            }
                        }
                        throw new SoundException("Unsupported sample size: " + audioFormat.getSampleSizeInBits());
                    }
                    default: {
                        throw new SoundException("Unsupported number of channels: " + audioFormat.getChannels());
                    }
                }
                ++n10;
            }
            ++n3;
        }
        return audioBuffer;
    }
}

