Attribute VB_Name = "Module1"

Option Explicit

Public Declare Function GetVersion Lib "kernel32" () As Long

Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long

Global Const MAXLines = 1  '   there must be one text control for each line
Global Const MAXEntryErrorCount = 2
Global Const MAXSuccessiveErrors = 5
Global Const KEY_ESCAPE = &H1B
Global Const SR_6KHZ_4BITS = 0

'   Application DDE Status
Global Const READY = 0
Global Const COMMAND = 1
Global Const NOTIFIED = 2
Global Const STATUS_RETURNED = 3
Global Const NOP = 4

'   SVServer Function Status
Global Const STATUS_FUNCTION_NONE = 0
Global Const STATUS_FUNCTION_READY = 1
Global Const STATUS_FUNCTION_RUNNING = 2
Global Const STATUS_FUNCTION_NOTIFIED = 3
Global Const STATUS_FUNCTION_COMPLETE = 4

'   Command Process
Global Const CMD_Open = 0
Global Const CMD_Start = 10
Global Const CMD_Main_Entry = 20
Global Const CMD_User_Records = 30
Global Const CMD_User_Plays = 40
Global Const CMD_User_Dials = 50
Global Const CMD_Connect_Type = 70
Global Const CMD_Error_Message = 80
Global Const CMD_Exit_Message = 99
Global Const CMD_Hang_Up = 100
Global Const CMD_Close = 1000
Global Const CMD_Abort = -1

Global Const DV_TPT_TYPE = 1
Global Const DX_IOTT_TYPE = 2
Global Const DX_CAP_TYPE = 3
Global Const TN_GEN_TYPE = 4

'   Application user save area
Type UserDataType
    SavePhoneNo As String * 32
    SaveFileName As String * 32
    SaveResponse As Integer
    CallAnalysis As Integer
    PerfectCallAnalysis As Integer
End Type

Type DDELinkType
    LineNo As Integer
    Function As Integer
    Status As Integer
    Error As Integer
    Return As Long
    Result As String * 128  '   enlarge this if needed
End Type

Type LineDataType
    Process As Integer
    NextStep As Integer
    JumpStep As Integer
    RetryCount As Integer
    TimeOutCount As Integer
    EntryErrorCount As Integer
    LineVolumeAdjust As Integer
    LineSpeedAdjust As Integer
    DeviceHandle As Integer
    LineString As String * 16
    SuccessiveErrors As Integer
    AbortProcess As Integer
    ExitProcess As Integer
End Type

Type CFGFileDataType
    CFGAutoStartSampleApp As Integer
    CFGDialogicFilePath As String * 128
    CFGSVServerFilePath As String * 128
    CFGSystemMessages As String * 128
    CFGNumberMessages As String * 128
    CFGMessagesDirectory As String * 128
    CFGDatabaseFilePath As String * 128
    CFGCaptureTextToFile As Integer
    CFGSamplingRate As Integer
    CFGVolumeAdjust As Integer
    CFGSpeedAdjust As Integer
End Type

Global Const ChAddresses = "dxxxB1C1,dxxxB1C2,dxxxB1C3,dxxxB1C4,dxxxB2C1,dxxxB2C2,dxxxB2C3,dxxxB2C4"

Global WS1 As Workspace
Global DB1 As Database
Global RS1 As Recordset

Global NewFile As Integer

Global StartUpDirPath As String * 128
Global TimeCount2 As Long

Global LineAvailableCount As Long
Global LineAvailablePerSecond As Integer
    
Global UserData(MAXLines) As UserDataType

Global LineData(MAXLines) As LineDataType
Global LinkResult(MAXLines) As DDELinkType

Global PassFilePath As String * 128
Global PassFilePattern As String * 16
Global PassAccept As Integer
    
Global CFGFileNo As Integer
Global CFGFileName As String
Global CFGFilePath As String

Global CFGFileData As CFGFileDataType
Global CFGTempData As CFGFileDataType

Global TXTFileNo As Integer
Global TXTFileName As String
Global TXTFilePath As String

Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const IDYES = 6
Global Const IDNO = 7


Function LoadFileData() As Integer

    On Error Resume Next

    '   Load Confiuration File

    Err = 0
    LoadFileData = True
    Open CFGFilePath For Random Access Read Write As CFGFileNo Len = Len(CFGFileData)
    If Err = 0 Then
        If LOF(CFGFileNo) > 0 Then
            Get #CFGFileNo, 1, CFGFileData
            CFGTempData = CFGFileData
            NewFile = False
        Else
            NewFile = True
            CFGTempData.CFGAutoStartSampleApp = False
            If GetVersion > 0 Then
                If FileExists("c:\program files\dialogic\bin\ncm.exe") Then
                    CFGTempData.CFGDialogicFilePath = "c:\program files\dialogic\bin\ncm.exe"
                Else
                    CFGTempData.CFGDialogicFilePath = "..\dialogic\bin\ncm.exe"
                End If
                CFGTempData.CFGSVServerFilePath = Trim$(StartUpDirPath) & "\svserverNT.exe"
            Else
                If FileExists("c:\users\dialogic\bin\startcfg.exe") Then
                    CFGTempData.CFGDialogicFilePath = "c:\users\dialogic\bin\startcfg.exe"
                Else
                    CFGTempData.CFGDialogicFilePath = "..\users\dialogic\bin\startcfg.exe"
                End If
                CFGTempData.CFGSVServerFilePath = Trim$(StartUpDirPath) & "\svserver95.exe"
            End If
            CFGTempData.CFGSystemMessages = LCase$(Trim$(StartUpDirPath) & "\svsample\systemsg")
            CFGTempData.CFGNumberMessages = LCase$(Trim$(StartUpDirPath) & "\svsample\numbers")
            CFGTempData.CFGMessagesDirectory = LCase$(Trim$(StartUpDirPath) & "\svsample\messages")
            CFGTempData.CFGDatabaseFilePath = LCase$(Trim$(StartUpDirPath) & "\svsample\svserver.mdb")
            CFGTempData.CFGCaptureTextToFile = True
            CFGTempData.CFGSamplingRate = SR_6KHZ_4BITS
            CFGTempData.CFGVolumeAdjust = 2
            CFGTempData.CFGSpeedAdjust = 2
        End If
        Close CFGFileNo
    Else
        MsgBox "OPEN ERROR " & Str$(Err) & " , CONFIGURATION FILE PATH = " & CFGFilePath
        LoadFileData = False
    End If
End Function


Sub CenterForm(TheForm As Form)

    On Error Resume Next

    TheForm.Left = (Screen.Width - TheForm.Width) / 2
    TheForm.Top = (Screen.Height - TheForm.Height) / 2
    
    DoEvents
    
End Sub

Public Sub SaveFileData()

    On Error Resume Next

    Open CFGFilePath For Random Access Write As CFGFileNo Len = Len(CFGFileData)
    CFGFileData = CFGTempData
    Put #CFGFileNo, 1, CFGFileData
    Close CFGFileNo
End Sub

Public Function ShellDialogic(AppFilePath As String) As Integer
    Dim Result
    
    On Error Resume Next
    
    '   Launch maximized with focus
    
    Err = 0
    Result = Shell(AppFilePath, 1)
    ShellDialogic = Err
    
End Function

Public Function ShellSVServer(AppFilePath As String) As Integer
    Dim Result
    
    On Error Resume Next
    
    Err.Clear

    '   To limit the number of lines use MaxLines nn in the Declaration section
    '   For Global Call initialization place the keywords "Global Call" in the command line as:
    '   Result = Shell(Trim$(AppFilePath) & " Global Call, MaxLines " & Trim$(Str(MAXLines)), 1)
    Result = Shell(Trim$(AppFilePath) & " MaxLines " & Trim$(Str(MAXLines)), 1)

    '   For troubleshooting the SVServer application add the following code:
    '   & " Debug=" & Trim$(StartUpDirPath), 1) as below, creates a log file svsdebug.doc in the svserver folder
    '   Result = Shell(Trim$(AppFilePath) & " MaxLines " & Trim$(Str(MAXLines)) & " Debug=" & Trim$(StartUpDirPath), 1)

    ShellSVServer = Err.Number
    
End Function

Public Function CopyText() As Integer
    Dim Result As Integer
    Dim EditString As String

    On Error Resume Next

    Result = False

    If TypeOf Screen.ActiveControl Is TextBox Then Result = True
    If TypeOf Screen.ActiveControl Is ComboBox Then
        If Screen.ActiveControl.Style <> 2 Then Result = True
    End If
    If Result = True Then
        EditString = Trim$(Mid$(Screen.ActiveControl.Text, Screen.ActiveControl.SelStart + 1, Screen.ActiveControl.SelLength))
        Clipboard.SetText EditString
    End If
    CopyText = Result

End Function

Public Function CutText() As Integer
    Dim Result As Integer
    Dim EditString As String, String1 As String, String2 As String
    Dim LenEditString As Integer, LenString1 As Integer, LenString2 As Integer

    On Error Resume Next

    Result = CopyText()
    If Result = True Then
        LenEditString = Len(Trim$(Screen.ActiveControl.Text))
        EditString = Trim$(Screen.ActiveControl.Text)

        LenString1 = Screen.ActiveControl.SelStart
        String1 = Trim$(Left$(Screen.ActiveControl.Text, LenString1))
        
        LenString2 = LenEditString - (LenString1 + Screen.ActiveControl.SelLength)
        String2 = Trim$(Right$(EditString, LenString2))

        Screen.ActiveControl.Text = Trim$(String1) & Trim$(String2)
    Else
        Result = False
    End If
    CutText = Result

End Function


Public Sub EditMenuDisable()

    On Error Resume Next

    Screen.ActiveForm.CutItem.Enabled = False
    Screen.ActiveForm.CopyItem.Enabled = False
    
End Sub

Public Sub EditMenuEnable()

    On Error Resume Next

    Screen.ActiveForm.CutItem.Enabled = True
    Screen.ActiveForm.CopyItem.Enabled = True
    Screen.ActiveForm.PasteItem.Enabled = True

End Sub

Public Function PasteText()
    Dim Result As Integer
    Dim EditString As String, String1 As String, String2 As String, String3 As String
    Dim LenEditString As Integer, LenString1 As Integer, LenString2 As Integer, LenString3 As Integer

    On Error Resume Next

    Result = False

    If TypeOf Screen.ActiveControl Is TextBox Then Result = True
    If TypeOf Screen.ActiveControl Is ComboBox Then
        If Screen.ActiveControl.Style <> 2 Then Result = True
    End If
    If Result = True Then
        LenEditString = Len(Trim$(Screen.ActiveControl.Text))
        EditString = Trim$(Screen.ActiveControl.Text)

        LenString1 = Screen.ActiveControl.SelStart
        String1 = Trim$(Left$(Screen.ActiveControl.Text, LenString1))
        
        String2 = Trim$(Clipboard.GetText(1))
        LenString2 = Len(String2)

        LenString3 = LenEditString - (LenString1 + Screen.ActiveControl.SelLength)
        String3 = Trim$(Right$(EditString, LenString3))

        Screen.ActiveControl.Text = Trim$(String1) & Trim$(String2) & Trim$(String3)
    Else
        Result = False
    End If
    PasteText = Result
    
End Function

Public Sub ShellTextFile(TheFilePath As String)
    Dim Result As Variant
    Dim FilePath As String * 128

    On Error Resume Next

    FilePath = Trim$("notepad.exe " & Trim$(TheFilePath))
    Result = Shell(Trim$(FilePath), 1)
    SendKeys "%(EW)", True
    DoEvents
    
End Sub

Public Function ClearLinkStatus(TheLine As Integer)

    On Error Resume Next
    
    LinkResult(TheLine).Function = 0
    LinkResult(TheLine).Status = 0
    LinkResult(TheLine).Error = 0
    LinkResult(TheLine).Return = 0
    LinkResult(TheLine).Result = ""
    LinkResult(TheLine).LineNo = TheLine
        
End Function

Public Function StripNumber(InString As String, OutString As String) As Integer
    Dim Ndx As Integer, Max As Integer, Cnt As Integer

    Cnt = 0:
    Max = Len(Trim$(InString))
    For Ndx = 1 To Max Step 1
        If (StrComp(Mid$(InString, Ndx, 1), "0", 1) >= 0 And StrComp(Mid$(InString, Ndx, 1), "9", 1) <= 0) Then
            Cnt = Cnt + 1
            Mid$(OutString, Cnt, 1) = Mid$(InString, Ndx, 1)
        End If
    Next Ndx
    StripNumber = Cnt

End Function


Public Function FileExists(FilePath As String) As Integer

    If Dir$(FilePath) = "" Then
        FileExists = False
    Else
        FileExists = True
    End If

End Function
Public Sub ShellFunctionSet()
    Dim Result As Variant
    Dim FilePath As String * 128

    On Error Resume Next
    
    FilePath = "write.exe " & Trim$(StartUpDirPath) & "\functset.doc"
    Result = Shell(FilePath, 3)
    DoEvents
    
End Sub

Public Sub ShellOrderForm()
    Dim Result As Variant
    Dim FilePath As String * 128

    On Error Resume Next
    
    FilePath = "write.exe " & Trim$(StartUpDirPath) & "\svsorder.doc"
    Result = Shell(FilePath, 3)
    DoEvents
    
End Sub

Public Sub ShellDocument(FilePath As String)

    Dim Result As Variant

    On Error Resume Next
    
    FilePath = "write.exe " & Trim$(FilePath)
    Result = Shell(FilePath, 3)
    Sleep (1000)
    DoEvents
    
End Sub


