// ------------------------------------------------------------------------
// System       : Win9X/NT
// Program      : longtext.c
// Description  : Remove word wrap (hard returns) from text files prior
//                to importing into windows word processors like msword.
//                This is helpful if text is created in a normal editor
//                then formatted and printed in windows.
//                Handles long filenames under Win9X/NT
// Written by   : Bill Buckels
// Date Written : 1995
// Revision     : 2.0 Second Release - March 2000
//                Added Support for Soft Returns in MSWord Files
//                Added Support for Long FileNames
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <string.h>

int nocr(char *ptr)
{
  int i;
  
  i = 0;
  for(;;)
  {
    if(ptr[i] == 10 || ptr[i] == 13 || ptr[i] == '\x1a')ptr[i] = 0;
    if(ptr[i] == 0)break;
    i++;
  }
  
  return i;
  
}

char infile[_MAX_PATH], outfile[_MAX_PATH];

#define INBUF_SIZE    2048
#define INBUF_LEN     (INBUF_SIZE - 1)

unsigned char buffer[INBUF_SIZE];

int main(int argc, char **argv)
{
  FILE *fp, *fp2;
  int len, links, ctr, msword = 0;
  unsigned char c;
  
  puts("Longtext(C) v2.0 CopyLeft Bill Buckels 1995-2000.");
  puts("All Rights Reversed.");
  puts("=================================================");
  if(argc>1)strcpy(infile,argv[1]);
  if(argc>2)strcpy(outfile,argv[2]);
  if(argc>3) {
    if (strcmpi("msword", argv[3]))
      msword = 1;
  }
    
  if(argc<3)
  {
    puts("This Utility Reformats and Removes Hard Returns from text files.");
    puts("Commandline Usage is : \"longtext [infile.txt] [outfile.txt] [msword]\"");
    puts("                 But : You may manually enter filename(s) Now...");
    puts("                 Or  : Enter a \"BLANK\" filename to exit Now...");
    puts("================================================================");
    if(argc == 1)
    {
      printf("Enter Input  Filename: ");gets(infile);
      if(infile[0] == 0)return 1;
    }
    printf("Enter Output Filename: ");gets(outfile);
    if(outfile[0] == 0)return 1;
    printf("MSWORD (soft returns) : (Y/N) ");
    c = toupper(getch());
    if(c == 0)getch();
    if(c == 'Y')
      msword = 1;
    else
      c = 'N';
    printf("%c\n", c);
    puts("================================================================");
  }

  if((fp2=fopen(outfile, "r"))!=NULL)
  {
    fclose(fp2);
    printf("%cOutput File %s already exists! Overwrite? (Y/N) ", 7, outfile);
    if((c = toupper(getch())) == 0)getch();
    else printf("%c", c);
    puts("");
    if(c != 'Y')return 1;
    puts("================================================================");
  }

  if((fp=fopen(infile, "r"))==NULL)
  {
    perror(infile);
    return 1;
  }

  if((fp2=fopen(outfile, "wb"))==NULL)
  {
    perror(outfile);
    fclose(fp);
    return 1;
  }

  printf("Infile  : %s\n", infile);
  printf("Outfile : %s\n", outfile);
  printf("        < Line");

  links=0;
  ctr=0;
  while(fgets(buffer, INBUF_LEN, fp)!=NULL)
  {
    if(buffer[0] == '\x1a')break;
    printf("\r%d", ctr + 1);
    ctr++;
    len = nocr(buffer);
    if(buffer[0] == 0)
    {
      if(msword)
      {
        fputc(11, fp2);                  // soft return for msword
      }
      else
      {
        fputc(13, fp2);
        fputc(10, fp2);
      }
    
      if(links > 0)
      {
        // shove an extra line between paragraphs
        fputc(13, fp2);
        fputc(10, fp2);
      }
      links = 0;
      continue;
    }
    if(buffer[0] == '.' || (buffer[0] > 47 && buffer[0] < 58) ||
       buffer[0] == '#')
    {
      if(links != 0)
      {
        if(msword)
        {
          fputc(11, fp2);
        }
        else
        {
          // start a new line if a period is found
          // or line begins with a number
          fputc(13, fp2);
          fputc(10, fp2);
        }
      }
      // if a line begins with a pound sign
      //   strip it.
      if(buffer[0] == '#')fwrite((char *)&buffer[1], len - 1, 1, fp2);
      else fwrite(buffer, len, 1, fp2);
      links = 1;
      continue;
    }
  
    links++;
    if(links > 1)fputc(32, fp2);
    fwrite(buffer, len, 1, fp2);
  }

  fclose(fp);
  fclose(fp2);
  puts("\nDone!");

return 0;
}
