// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : trim.c
// Description  : A filter that trims whitespace from the end of
//                each line in a stream.
//
//                Useful for trimming a flatfile with trailing blanks
//                or for trimming trailing blanks from text files
//                before re-formatting and word-wrapping etc.
//
// Written by   : Bill Buckels
// Date Written : March 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>

#define BUF_MAX  8192
#define BUF_SIZE (BUF_MAX + 1)

char cbuf[BUF_SIZE] = "\0";

// trim trailing blanks
void trim(char *ptr)
{
  int len;

  len = strlen(ptr);
  if (len > 0) {
    while (len > 0) {
      len--;
      if (ptr[len] != ' ')break;  // if no longer a whitespace, done
      ptr[len] = 0;               // backfill with asciiz's
    }
  }
}

void main(int argc, char **argv)
{
    int c, cnt = 0, idx;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "r");

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;
      if (c=='\r')continue;
      if (c==0)c = ' ';

      if (c == '\n' || cnt >= BUF_MAX) {
        if (c == '\n')
          trim(cbuf);
        for (idx = 0; cbuf[idx] != 0; idx++)
          putchar(cbuf[idx]);

        // setup for next pass...
        if (c == '\n') {
          putchar('\n');
          cbuf[0] = cnt = 0;
        }
        else {
          cbuf[0] = c;
          cbuf[1] = 0;
          cnt = 1;
        }
        continue;
      }

      cbuf[cnt] = c;
      cnt++;          // advance counter
      cbuf[cnt] = 0;
    }
    if (cnt > 0) {
      trim(cbuf);
      for (idx = 0; cbuf[idx] != 0; idx++)
        putchar(cbuf[idx]);
      putchar('\n');
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
