// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : ucase.c
// Description  : Lowercase to Uppercase filter.
//
//                This program is a filter that translates all lowercase
//                characters to uppercase.  It will optionally accept a
//                filename to read input from.  All output goes to the
//                standard output device unless redirected.
//
//                Examples:
//                  Ucase abc.txt
//                      read input from abc.txt,
//                      output goes to screen.
//                  Ucase abc.txt >abcnew.txt
//                      read input from abc.txt,
//                      output goes to abcnew.txt.
//                  Ucase <abc.txt >abcnew.txt
//                      same as previous example
//                  Ucase abc.txt | find "ABC"
//                      translates abc.txt to uppercase
//                      and then searches the result
//                      for the string "ABC".
//                      Output goes to screen.
//                  find "abc" abc.txt | Ucase | sort
//                      Search abc.txt for all lines that
//                      contain "abc".  Translate all lines
//                      selected and sort them, sending output
//                      to the screen.
//
// Written by   : Bill Buckels
// Based On     : upper.asm
//                used with permission
// Date Written : March 2000
// Revision     : 2.0 Second Release
// ------------------------------------------------------------------------
#include <stdio.h>

void main(int argc, char **argv)
{
    int c;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "r");

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;

      if(c>96 && c<123)c-=32;

      putchar(c);
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
