// WMVFileDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WMVFile.h"
#include "WMVFileDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWMVFileDlg dialog

CWMVFileDlg::CWMVFileDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWMVFileDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWMVFileDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CWMVFileDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWMVFileDlg)
	DDX_Control(pDX, IDC_EDIT1, m_EditDesc);
	DDX_Control(pDX, IDC_CBOPROFILE, m_CboProfile);
	DDX_Control(pDX, IDC_VIDEOCAPCTRL1, m_VideoCap);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWMVFileDlg, CDialog)
	//{{AFX_MSG_MAP(CWMVFileDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_CBN_SELCHANGE(IDC_CBOPROFILE, OnSelchangeCboprofile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWMVFileDlg message handlers

BOOL CWMVFileDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	int iProfileCount =m_VideoCap.GetWMVProfiles().GetCount();

	for(int i=0; i < iProfileCount; i++)
		m_CboProfile.AddString(m_VideoCap.GetWMVProfiles().FindWMVProfileName(i));


	if(m_CboProfile.GetCount() != 0)
		m_CboProfile.SetCurSel(0);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWMVFileDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CWMVFileDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CWMVFileDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CWMVFileDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	m_VideoCap.Start();
	
}

void CWMVFileDlg::OnButton2() 
{
	// TODO: Add your control notification handler code here
	
		char szFilter[]="wmv file(*.wmv)|*.wmv|All Files(*.*)|*.*|| ";
	
	CFileDialog dlg(FALSE,"wmv","*.wmv",OFN_FILEMUSTEXIST,szFilter,this);
	
	if(dlg.DoModal()==IDOK)
	{

		
		m_VideoCap.SetWMVProfile(m_CboProfile.GetCurSel());
		m_VideoCap.SetCaptureFileName(dlg.GetPathName());
		m_VideoCap.SetOutputWMV(TRUE);
		m_VideoCap.SetCaptureMode(TRUE);
		m_VideoCap.Start();
	}
}

void CWMVFileDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
		m_VideoCap.SetCaptureMode(FALSE);
		m_VideoCap.Start();
	
}

void CWMVFileDlg::OnSelchangeCboprofile() 
{
	// TODO: Add your control notification handler code here
	
	int iSel=m_CboProfile.GetCurSel();
	
	m_EditDesc.SetWindowText(m_VideoCap.GetWMVProfiles().FindWMVProfileDesc(iSel));
		
}
