VERSION 5.00
Begin VB.Form frmSample 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "CT INIFile ActiveX Library Sample"
   ClientHeight    =   3270
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7005
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   3270
   ScaleWidth      =   7005
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame fraRight 
      Height          =   3015
      Left            =   3600
      TabIndex        =   3
      Top             =   90
      Width           =   3255
      Begin VB.CommandButton cmdRight 
         Caption         =   "Read"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   1920
         TabIndex        =   4
         Top             =   240
         Width           =   1215
      End
      Begin VB.TextBox txtRight 
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   2175
         Left            =   120
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         TabIndex        =   5
         TabStop         =   0   'False
         Top             =   720
         Width           =   3015
      End
   End
   Begin VB.Frame fraLeft 
      Height          =   3015
      Left            =   150
      TabIndex        =   0
      Top             =   90
      Width           =   3255
      Begin VB.TextBox txtLeft 
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   2175
         Left            =   120
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         TabIndex        =   2
         TabStop         =   0   'False
         Top             =   720
         Width           =   3015
      End
      Begin VB.CommandButton cmdLeft 
         Caption         =   "Write"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   1920
         TabIndex        =   1
         Top             =   240
         Width           =   1215
      End
   End
End
Attribute VB_Name = "frmSample"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'**********************************************************
'
'This is an example of how to use properties and methods
'exposed by CT INIFile ActiveX Library file.
'
'Properties and methods can be invoked as if they were
'simply global functions. Its not necessary to explicitly
'create an instance of the class first, because one will
'automatically be created.
'
'Properties and methods
'that has been used in this example
'   Properties
'       INIFile
'   Methods
'       INIQuerySetting
'       INIWriteSetting
'
'**********************************************************
'
'CT INIFile ActiveX Library allows you to read from
'and write to initialization/INI files from Visual
'Basic applications.
'
'This library file is specifically designed for Visual
'Basic, but may work in any environment that supports
'ActiveX technology.
'
'CT INIFile ActiveX Library
'Copyright  1999-2000, Cezar Botez
'All rights reserved
'
'CT INIFile ActiveX Library is freeware and may be
'distributed and used freely, in any commercial purpose
'or not, as long as it is distributed in its entirety.
'
'The author will not be responsible for any kind of loss
'occuring due to the use of this software.
'
'Reference for further information
'http://softrunner.homestead.com
'
'Comments, suggestions or bugs reports
'cbotez@homestead.com
'
'**********************************************************

Private vByte As Byte
Private vInteger As Integer
Private vLong As Long
Private vSingle As Single
Private vDouble As Double
Private vCurrency As Currency
Private vDate As Date
Private vString As String
Private vBoolean As Boolean

Private Sub cmdLeft_Click()
    vByte = 64
    vInteger = -512
    vLong = -6553600
    vSingle = -3.402823E+32
    vDouble = -1.79769313486232E+302
    vCurrency = -922337203685477#
    vDate = Now
    vString = "This is an example."
    vBoolean = True

    CTINI.INIWriteSetting "Data Types", "Byte", vByte
    CTINI.INIWriteSetting "Data Types", "Integer", vInteger
    CTINI.INIWriteSetting "Data Types", "Long", vLong
    CTINI.INIWriteSetting "Data Types", "Single", vSingle
    CTINI.INIWriteSetting "Data Types", "Double", vDouble
    CTINI.INIWriteSetting "Data Types", "Currency", vCurrency
    CTINI.INIWriteSetting "Data Types", "Date", vDate
    CTINI.INIWriteSetting "Data Types", "String", vString
    CTINI.INIWriteSetting "Data Types", "Boolean", vBoolean

    With txtLeft
        .Text = "Byte: " & vByte & vbCrLf
        .Text = .Text & "Integer: " & vInteger & vbCrLf
        .Text = .Text & "Long: " & vLong & vbCrLf
        .Text = .Text & "Single: " & vSingle & vbCrLf
        .Text = .Text & "Double: " & vDouble & vbCrLf
        .Text = .Text & "Currency: " & vCurrency & vbCrLf
        .Text = .Text & "Date: " & vDate & vbCrLf
        .Text = .Text & "String: " & vString & vbCrLf
        .Text = .Text & "Boolean: " & vBoolean & vbCrLf
    End With
End Sub

Private Sub cmdRight_Click()
    vByte = 0
    vInteger = 0
    vLong = 0
    vSingle = 0
    vDouble = 0
    vCurrency = 0
    vDate = Now
    vString = ""
    vBoolean = False

    CTINI.INIQuerySetting "Data Types", "Byte", vByte
    CTINI.INIQuerySetting "Data Types", "Integer", vInteger
    CTINI.INIQuerySetting "Data Types", "Long", vLong
    CTINI.INIQuerySetting "Data Types", "Single", vSingle
    CTINI.INIQuerySetting "Data Types", "Double", vDouble
    CTINI.INIQuerySetting "Data Types", "Currency", vCurrency
    CTINI.INIQuerySetting "Data Types", "Date", vDate
    CTINI.INIQuerySetting "Data Types", "String", vString
    CTINI.INIQuerySetting "Data Types", "Boolean", vBoolean

    With txtRight
        .Text = "Byte: " & vByte & vbCrLf
        .Text = .Text & "Integer: " & vInteger & vbCrLf
        .Text = .Text & "Long: " & vLong & vbCrLf
        .Text = .Text & "Single: " & vSingle & vbCrLf
        .Text = .Text & "Double: " & vDouble & vbCrLf
        .Text = .Text & "Currency: " & vCurrency & vbCrLf
        .Text = .Text & "Date: " & vDate & vbCrLf
        .Text = .Text & "String: " & vString & vbCrLf
        .Text = .Text & "Boolean: " & vBoolean & vbCrLf
    End With
End Sub

Private Sub Form_Load()
    If Right(App.Path, 1) = "\" Then
        CTINI.INIFile = App.Path & App.EXEName & ".ini"
    Else
        CTINI.INIFile = App.Path & "\" & App.EXEName & ".ini"
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    On Error Resume Next
    Kill CTINI.INIFile
End Sub
