VERSION 5.00
Begin VB.Form fmMain 
   Caption         =   "PatternPro rxRegex Demo"
   ClientHeight    =   6360
   ClientLeft      =   1155
   ClientTop       =   1905
   ClientWidth     =   10455
   Icon            =   "fmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6360
   ScaleWidth      =   10455
   Begin VB.CommandButton cmdSubAll 
      Caption         =   "Sub All"
      Height          =   495
      Left            =   7680
      TabIndex        =   13
      ToolTipText     =   "Type substitute text above, then press here!"
      Top             =   5760
      Width           =   1215
   End
   Begin VB.CommandButton cmdSub 
      Caption         =   "Substitute"
      Height          =   495
      Left            =   6360
      TabIndex        =   12
      ToolTipText     =   "Type substitute text above, then press here!"
      Top             =   5760
      Width           =   1215
   End
   Begin VB.CheckBox chkMatchEnd 
      Caption         =   "$ matches string end"
      Height          =   255
      Left            =   3120
      TabIndex        =   9
      ToolTipText     =   "Check this box if you want $ to match the end of your text."
      Top             =   6000
      Width           =   1935
   End
   Begin VB.CheckBox chkMatchBeg 
      Caption         =   "^ matches string start"
      Height          =   255
      Left            =   3120
      TabIndex        =   8
      ToolTipText     =   "Check this box if you want ^ to match the start of your text."
      Top             =   5760
      Width           =   1935
   End
   Begin VB.CommandButton cmdFirst 
      Caption         =   "Find First"
      Height          =   495
      Left            =   120
      TabIndex        =   7
      ToolTipText     =   "Locate the first occurrence of the current expression."
      Top             =   5760
      Width           =   1455
   End
   Begin VB.Frame frText 
      Caption         =   "Search Text"
      Height          =   4815
      Left            =   120
      TabIndex        =   5
      Top             =   840
      Width           =   10215
      Begin VB.TextBox txtSearch 
         BeginProperty Font 
            Name            =   "System"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   4455
         Left            =   120
         MultiLine       =   -1  'True
         TabIndex        =   6
         Text            =   "fmMain.frx":0442
         ToolTipText     =   "Text to be searched goes here!"
         Top             =   240
         Width           =   9975
      End
   End
   Begin VB.Frame frExpr 
      Caption         =   "Regular Expression / Substitute Text"
      Height          =   735
      Left            =   120
      TabIndex        =   2
      Top             =   0
      Width           =   10215
      Begin VB.CommandButton cmdCompile 
         Caption         =   "Compile"
         Default         =   -1  'True
         Height          =   375
         Left            =   9000
         TabIndex        =   4
         ToolTipText     =   "Press here to compile your expression."
         Top             =   240
         Width           =   1080
      End
      Begin VB.TextBox txtTest 
         BeginProperty Font 
            Name            =   "System"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   120
         TabIndex        =   3
         Text            =   "[-+]?(([0-9]+)|([0-9]*\.[0-9]+)([eE][-+]?[0-9]+)?)"
         ToolTipText     =   "Place your regular expression here then compile it."
         Top             =   270
         Width           =   8775
      End
   End
   Begin VB.CommandButton cmdNext 
      Caption         =   "Find  Next"
      Height          =   495
      Left            =   1680
      TabIndex        =   1
      ToolTipText     =   "Locate the next occurrence of the current expression."
      Top             =   5760
      Width           =   1335
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   9000
      TabIndex        =   0
      ToolTipText     =   "Exit the demo program."
      Top             =   5760
      Width           =   1335
   End
   Begin VB.Label lblLength 
      Caption         =   "Length ="
      Height          =   255
      Left            =   5040
      TabIndex        =   11
      Top             =   6000
      Width           =   1215
   End
   Begin VB.Label lblOffset 
      Caption         =   "Offset ="
      Height          =   255
      Left            =   5040
      TabIndex        =   10
      Top             =   5760
      Width           =   1215
   End
End
Attribute VB_Name = "fmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' instance of the regular expression
Dim rgx As New rxRegex

Private Sub cmdCompile_Click()
    ImBusy True
    On Error GoTo Fatal
    
    lblOffset.Caption = "Offset = "
    lblLength.Caption = "Length = "
    
    ' * * * NEW & IMPORTANT * * *
    rgx.BOLmatchesBeg = (chkMatchBeg.Value = vbChecked)
    rgx.EOLmatchesEnd = (chkMatchEnd.Value = vbChecked)
    rgx.Pattern = txtTest.Text
    
    ImBusy False
    Exit Sub
Fatal:
    MsgBox Err.Description, vbOKOnly, "Compiler Error"
    ImBusy False
End Sub

Private Sub cmdExit_Click()
    Unload Me
End Sub

Private Sub cmdFirst_Click()
    ImBusy True
    On Error GoTo BadRegex
    
    If rgx.FindFirst(txtSearch.Text) Then
        
        ImBusy False
        txtSearch.SelStart = rgx.MatchOffset - 1
        txtSearch.SelLength = rgx.MatchLength
        txtSearch.SetFocus
        
        lblOffset.Caption = "Offset = " & rgx.MatchOffset
        lblLength.Caption = "Length = " & rgx.MatchLength
    
    Else
        lblOffset.Caption = "Offset = "
        lblLength.Caption = "Length = "
        ImBusy False
        
        txtSearch.SelStart = 0
    
        MsgBox "No matches", vbInformation, "Regex Results"
    End If
    Exit Sub

BadRegex:
    MsgBox "Invalid Expression", vbCritical, "Error"
    ImBusy False
End Sub

Private Sub cmdNext_Click()
    ImBusy True
    On Error GoTo BadRegex
    
    If rgx.FindNext Then
        txtSearch.SelStart = rgx.MatchOffset - 1
        txtSearch.SelLength = rgx.MatchLength
        ImBusy False
        txtSearch.SetFocus
    
        lblOffset.Caption = "Offset = " & rgx.MatchOffset
        lblLength.Caption = "Length = " & rgx.MatchLength
    
    Else
        
        ImBusy False
        lblOffset.Caption = "Offset = "
        lblLength.Caption = "Length = "
        
        MsgBox "No more matches", vbInformation, "Regex Results"

    End If
    Exit Sub

BadRegex:
    MsgBox "Invalid Expression", vbCritical, "Error"
    ImBusy False
End Sub

Private Sub cmdSub_Click()
    ImBusy True
    If rgx.Substitute(txtTest.Text) Then
        txtSearch.Text = rgx.Text
    
        txtSearch.SelStart = rgx.MatchOffset - 1
        txtSearch.SelLength = rgx.MatchLength
    
        lblOffset.Caption = "Offset = " & rgx.MatchOffset
        lblLength.Caption = "Length = " & rgx.MatchLength
        ImBusy False
        txtSearch.SetFocus
    Else
        ImBusy False
    End If
End Sub

Private Sub cmdSubAll_Click()
    ImBusy True
    
    If rgx.FindFirst(txtSearch.Text) Then
        Call rgx.Substitute(txtTest.Text)
        While rgx.FindNext
            Call rgx.Substitute(txtTest.Text)
        Wend
    End If

    txtSearch.Text = rgx.Text

    txtSearch.SelStart = 0
    txtSearch.SelLength = 0
    ImBusy False
    txtSearch.SetFocus

    lblOffset.Caption = "Offset = " & 1
    lblLength.Caption = "Length = " & 0
End Sub

Private Sub ImBusy(B As Boolean)
    cmdFirst.Enabled = Not B
    cmdNext.Enabled = Not B
    cmdSub.Enabled = Not B
    cmdSubAll.Enabled = Not B
    txtSearch.Enabled = Not B
    txtTest.Enabled = Not B
    cmdCompile.Enabled = Not B
    chkMatchBeg.Enabled = Not B
    chkMatchEnd.Enabled = Not B
    If B Then
        Me.MousePointer = vbHourglass
    Else
         Me.MousePointer = vbNormal
    End If
End Sub

Private Sub Form_Load()
    chkMatchBeg.Value = vbChecked
    chkMatchEnd.Value = vbChecked
End Sub
