VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "VarScope"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
'----------------------------------------------------------------------
' VarScope.cls
'
' Author : Andrew F. Friedl @ BlackBox Software & Consulting
' Created: 1997.04.10
' Purpose: provide methodology for variable inheritance
' Related:
' Revised: 2000.03.15 - implemented to new event model
'----------------------------------------------------------------------
Option Explicit

Private mVars() As Variables

Private Sub Class_Initialize()
    ReDim mVars(0)
End Sub

Public Property Get Count() As Integer
    Count = UBound(mVars)
End Property

Public Sub Push(Var As Variables)
    ReDim Preserve mVars(UBound(mVars) + 1)
    Set mVars(UBound(mVars)) = Var
End Sub

Public Sub Pop()
    If UBound(mVars) > 0 Then
        ReDim Preserve mVars(UBound(mVars) - 1)
    End If
End Sub

Public Function Peek(Optional Index As Variant) As Variables
    If IsMissing(Index) Then
        Set Peek = mVars(UBound(mVars))
    Else
        Set Peek = mVars(Index)
    End If
End Function

Public Function Search(Name As String, Value As Variable) As Boolean
    Dim Index As Integer
    For Index = UBound(mVars) To 1 Step -1
        If mVars(Index).Search(Name, Value) Then
            Search = True
            Exit Function
        End If
    Next Index
    Search = False
End Function

Public Function SearchBkwd(Name As String, Value As Variable) As Boolean
    Dim Index As Integer
    For Index = 1 To UBound(mVars)
        If mVars(Index).Search(Name, Value) Then
            SearchBkwd = True
            Exit Function
        End If
    Next Index
    SearchBkwd = False
End Function
