
#ifndef __sgRegExp_H_
#define __sgRegExp_H_

#include "resource.h"
#include "clsRegExp.h"
#include "Substrings.h"



class ATL_NO_VTABLE sgRegExp : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<sgRegExp, &CLSID_RegExp>,
	public ISupportErrorInfo,
	public IDispatchImpl<IsgRegExp, &IID_IsgRegExp, &LIBID_sgRegExp>
{
public:
	sgRegExp();
	~sgRegExp();

DECLARE_REGISTRY_RESOURCEID(IDR_SGREGEXP)

BEGIN_COM_MAP(sgRegExp)
	COM_INTERFACE_ENTRY(IsgRegExp)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

	// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

	// IsgRegExp
	STDMETHOD(put_Expression)(/*[in]*/ BSTR expr);
	STDMETHOD(get_Expression)(/*[out, retval]*/ BSTR* expr);
	STDMETHOD(put_IgnoreCase)(/*[in]*/ VARIANT_BOOL ignoreCase);
	STDMETHOD(get_IgnoreCase)(/*[out, retval]*/ VARIANT_BOOL* ignoreCase);
	STDMETHOD(Match)(/*[in]*/ BSTR data, /*[in, optional, defaultvalue(-1)]*/ VARIANT startPos, /*[out, retval]*/ VARIANT_BOOL* res);
	STDMETHOD(get_ReplaceString)(/*[in]*/ BSTR source, /*[out, retval]*/ BSTR* res);
	STDMETHOD(get_CompiledOK)(/*[out, retval]*/ VARIANT_BOOL* res);
	STDMETHOD(get_Substrings)(/*[out, retval]*/ ISubstrings** res);

private:
	str_t		m_sRegExpr;		// Current regular expression
	str_t		m_sData;			// Parsed data
	bool		m_bCase;			// Current case sensitivity state
	Regexp*	m_RegExp;		// Regular expression object
};

#endif //__sgRegExp_H_
