	On Error Resume next
	Dim sLine, sExpr, sText, sSuccess, sReplace, sReplaced, arrLine
	Dim sTab

	' Create object and initialize variables
	sTab   = Chr(9)
	set re = CreateObject("sgRegExp.RegExp")
	Set fs = CreateObject("Scripting.FileSystemObject")
	Set ts = fs.OpenTextFile("tests.txt", 1, False)	

	' For each line in the test file
	do while not ts.AtEndOfStream

		' Get next line and ensure that it has valid syntax
		nLine = ts.Line
		sLine = ts.ReadLine
		arrLine = Split(sLine, sTab, 5)
		if (UBound(arrLine) <> 4) then
			WScript.Echo "Error at line(" + CStr(nLine) + "): match that supposed to succeed has failed"
			WScript.Quit(0)
		end if
		sExpr     = arrLine(0)
		sText     = arrLine(1)
		sSuccess  = arrLine(2)
		sReplace  = arrLine(3)
		sReplaced = arrLine(4)

		if sText = "-" then sText = ""
		if sReplace = "-" then sReplace = ""
		if sReplaced = "-" then sReplaced = ""

		' Test regular expression
		re.Expression = sExpr
		bMatched = re.Match(sText)
		if bMatched then
			if sSuccess = "n" then
				ErrorEcho "Error at line(" + CStr(nLine) + "): match that supposed to fail has succeeded"
				WScript.Quit(0)
			end if

			s = re.ReplaceString(sReplace)
			if (s <> sReplaced) then
				ErrorEcho  "Error at line(" + CStr(nLine) + "): ReplaceString returned '" + s + "' and expected replacement was '" + sReplace + "'"
				WScript.Quit(0)
			end if
		else
			if sSuccess = "y" then
				ErrorEcho  "Error at line(" + CStr(nLine) + "): match that supposed to succeed has failed"
				WScript.Quit(0)
			end if
		end if
		WScript.Echo "Passed test at line(" + CStr(nLine) + "): " + sLine
	loop
	WScript.Echo ""
	WScript.Echo "ALL TESTS PASSED!"

	set re = Nothing
	Set fs = Nothing
	Set ts = Nothing
	WScript.Quit(0)

public sub ErrorEcho(sErr)
	WScript.Echo sErr
	for i = 0 to UBound(arrLine)
		WScript.Echo "|" + arrLine(i) + "|"
	next

end sub
