//******************************************************
// SPRINT - Print & Preview engine for Delphi
// WWW.SMART.CO.YU
//******************************************************

unit report1;

interface

procedure Report_1(show:Boolean);

implementation

uses Main,Sprint,Graphics,SysUtils,Classes,Printers;

procedure Report_1(show:Boolean);
var
   i,i1,x,x1,y,y1,pictw,picth:integer;
   Sp:TSprint;
   s:string;
begin
   randomize;
   pictw:=form1.Image1.Picture.Graphic.Width*3;
   picth:=form1.Image1.Picture.Graphic.Height*3;
   Sp:=form1.SPrint1;
   //IMPORTANT NOTES:
   //1..Keep in mind that any coordinate, distance or size
   //   is measured in 0.254 inch (or 0.1 mm) units
   //2..SPrint.Canv (TSPrintCanvas) offers you ALL canvas methods

   //1..initialize sprint
   Sp.BeginDoc;
   Sp.KEY:='When you purchase SPRINT you will insert received KEY here';
   Sp.ShowFooter:=False; {we don't want to print footer this time}
   //2..relative distance from any paper edge can be calculated with
   //   topm,leftm,rightm and bottomm functions
   x :=Sp.leftm(200);    {20 mm from left paper edge}
   x1:=Sp.rightm(200);   {20 mm from right paper edge}
   y :=Sp.topm(200);     {20 mm from top paper edge}
   y1:=Sp.bottomm(200);  {20 mm from bottom paper edge}
   //3..let's draw some random lines
   Sp.Canv.Pen.Color:=clBlack;
   Sp.Canv.Pen.Width:=1; {Hairline}
   Sp.Canv.MoveTo(x,y);
   Sp.Canv.LineTo((x1-pictw)-100,y);
   Sp.Canv.LineTo((x1-pictw)-100,y+450);
   Sp.Canv.LineTo(x,y+450);
   Sp.Canv.LineTo(x,y);
   for i:=1 to 150 do begin
      Sp.Canv.MoveTo(x+(random(x1-pictw-100-x)),y+random(450));
      Sp.Canv.LineTo(x+(random(x1-pictw-100-x)),y+random(450));
   end;
   Sp.Canv.Pen.Width:=1;
   //3..and also some grayed areas
   Sp.Canv.Brush.Color:=$00FFFFFF; {gray colors}
   for i:=0 to 9 do begin
      Sp.Canv.Brush.color:=Sp.Canv.Brush.color-$000F0F0F;
      Sp.Canv.Rectangle(
         (i*170)+(((x1+x)div 2)-(1680 div 2)),
         y+550,
         (i*170)+(((x1+x)div 2)-(1680 div 2))+150,
         y+700);
   end;
   //4..random rectangles
   Sp.Canv.Brush.color:=clWhite;
   Sp.Canv.Pen.color:=clBlack;
   Sp.Canv.Pen.Width:=1;
   for i:=1 to 500 do begin
      Sp.Canv.Brush.color:=random($FFFFFF);
      Sp.Canv.Rectangle(
         x+random(x1-x),
         y+850+random((y1-1150)-(y+850)),
         x+random(x1-x),
         y+850+random((y1-1150)-(y+850)));
   end;
   Sp.Canv.Brush.Color:=clWhite;
   //5..it is time for some text now
   Sp.Canv.Font.Name:='Times New Roman';
   Sp.Canv.Font.Size:=-22;
   Sp.Canv.Font.Style:=[fsBold];
   s:='Print in graytones...';
   Sp.Canv.TextOut(
      (((x1+x)div 2)-(Sp.Canv.TextWidth(s) div 2)),
      y+710,
      s);
   s:='...Or use ANY color!';
   Sp.Canv.TextOut(
      (((x1+x)div 2)-(Sp.Canv.TextWidth(s) div 2)),
      y1-1140,
      s);
   //6..look at TFont help
   i1:=y1-1000;
   for i:=5 to 24 do begin
      Sp.Canv.Font.Name:='Times New Roman';
      Sp.Canv.Font.Size:=-i;
      s:=Sp.Canv.Font.Name+inttostr(i)+'pt (ABCDEFabcdef)';
      Sp.Canv.TextOut(
         (((x1+x)div 2)-(Sp.Canv.TextWidth(s) div 2)),
         i1,
         s);
      i1:=i1+Sp.Canv.TextHeight(s);
   end;
   //7.this example shows how picture can be printed
   Sp.Canv.StretchDraw(rect(x1-pictw,y,x1,y+picth),form1.Image1.Picture.Graphic);
   //8..Preview or print?
   if show then Sp.ShowPreview else Sp.PrintAll;
   Sp.EndDoc;
end;

end.
