#include "win\errlist.hh"
#include "h.h"
#include "win\h2.h"
#include "win\listview.hh"
#ifndef __MINGW32__
#include <commctrl.h>
#endif

const int LIST_TEXT = 0;
const int LIST_URL = 1;
const int LIST_DESC = 2;

void ErrListInitialize()
{
   herrlst = CreateWindow(WC_LISTVIEW, "list",
		       WS_VISIBLE | WS_CHILD | WS_VSCROLL | 
		       LVS_NOLABELWRAP | LVS_SINGLESEL | LVS_REPORT,
		       0, 0, 400, 300,
		       hwnd, NULL, hInstance, NULL);
   
   HIMAGELIST hil = ImageList_Create(GetSystemMetrics(SM_CXSMICON),
				     GetSystemMetrics(SM_CYSMICON),
				     TRUE, 1, 1);
   // we are using only 4xx and 5xx messsages now   
   HICON hi = LoadIcon(NULL, IDI_WINLOGO); // 0xx messsages
   ImageList_AddIcon(hil, hi);
   DeleteObject(hi);
   hi = LoadIcon(NULL, IDI_QUESTION); // 1xx messages
   ImageList_AddIcon(hil, hi);
   DeleteObject(hi);
   hi = LoadIcon(NULL, IDI_ASTERISK); // 2xx messages (ok)
   ImageList_AddIcon(hil, hi);
   DeleteObject(hi);
   hi = LoadIcon(NULL, IDI_APPLICATION); // 3xx messages (redirect)
   ImageList_AddIcon(hil, hi);
   DeleteObject(hi);
   hi = LoadIcon(NULL, IDI_EXCLAMATION); // 4xx messages (error)
   ImageList_AddIcon(hil, hi);
   DeleteObject(hi);
   hi = LoadIcon(NULL, IDI_HAND); // 5xx messages (fatal error)
   ImageList_AddIcon(hil, hi);
   DeleteObject(hi);
   ListView_SetImageList(herrlst, hil, LVSIL_SMALL);
   
   LV_COLUMN lvc;
   lvc.mask = LVCF_FMT | LVCF_TEXT | LVCF_SUBITEM | LVCF_WIDTH;
   lvc.fmt = LVCFMT_LEFT;
   lvc.cx = GetSystemMetrics(SM_CXSMICON)+3;

   lvc.pszText = "Text";
   lvc.iSubItem = LIST_TEXT;
   ListView_InsertColumn(herrlst, 0, &lvc);
   lvc.cx = 1;
   lvc.fmt = LVCFMT_LEFT;   
   lvc.iSubItem = LIST_URL;
   lvc.pszText = "URL";
   ListView_InsertColumn(herrlst, LIST_URL, &lvc);
   lvc.cx = 1;
   lvc.fmt = LVCFMT_LEFT;   
   lvc.iSubItem = LIST_DESC;
   lvc.pszText = "Description";
   ListView_InsertColumn(herrlst, LIST_DESC, &lvc);
   
   set_fullrow(herrlst);   
}

void ErrListAddItem(const char *text, const char *title, const char *url)
{
   LV_ITEM lvi;
   lvi.mask = LVIF_TEXT | LVIF_STATE | LVIF_IMAGE;
   lvi.iItem = 0;
   lvi.state = 0;
   lvi.stateMask = 0;
   lvi.iSubItem = LIST_TEXT;
   lvi.iImage = *text - '0';
   lvi.pszText = (char *) title;
   ListView_InsertItem(herrlst, &lvi); 
   
   lvi.mask = LVIF_TEXT | LVIF_STATE;
   
   lvi.pszText = (char *) url;
   lvi.iSubItem = LIST_URL;
   ListView_SetItem(herrlst, &lvi);
   
   lvi.iSubItem = LIST_DESC;
   lvi.pszText = (char *) text;
   ListView_SetItem(herrlst, &lvi);
}

void ErrListResize()
{
   for (int i = 0; i <= LIST_DESC; i++) {
      ListView_SetColumnWidth(herrlst, i, LVSCW_AUTOSIZE);
      int c1 = ListView_GetColumnWidth(herrlst, i);
      ListView_SetColumnWidth(herrlst, i, LVSCW_AUTOSIZE_USEHEADER);
      int c2 = ListView_GetColumnWidth(herrlst, i);
      if (c2 < c1)
	 ListView_SetColumnWidth(herrlst, i, c1);
   }
}

void ErrListFlush()
{
   ListView_DeleteAllItems(herrlst);
}
