
###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
###########################################################################
# setup script for internet explorer
###########################################################################

namespace eval setupie {
    set ieroot key_current_user
    set iepath "Software/Microsoft/Windows/CurrentVersion/Internet Settings"
    set backuppath "Software/WebSmacker/MSIE/BackupRegistry"    
    set bookmark {[InternetShortcut]
URL=http://configurewebsmacker
}
    set bookmarkFile "Web Smacker Configuration.url"
}

proc setupie::SetupInternetExplorer {} {
    variable iepath
    variable ieroot
    variable backuppath

    # first try in multi-user registry setup
    set ieroot key_current_user
    set iepath "Software/Microsoft/Windows/CurrentVersion/Internet Settings"
    set backuppath "Software/WebSmacker/MSIE/BackupRegistry"    
    set r1 [SetupInternetExplorerUser]
    # now try default user registry setup
    set ieroot key_users
    set iepath ".Default/Software/Microsoft/Windows/CurrentVersion/Internet Settings"
    set backuppath ".Default/Software/WebSmacker/MSIE/BackupRegistry"
    set r2 [SetupInternetExplorerUser]
    # return
    expr { $r1 || $r2 }
}

proc setupie::SetupInternetExplorerUser {} {
    set result 1
    if [catch {
	array set defs [eval [setupgui::GetDefaults]]
	if [catch { 
	    #modify the registry
	    set oldProxy \
		    [EditRegistry "localhost" $defs(port)]
	    dbg::puts setup "oldProxy: $oldProxy"
	} err ] {
	    #if there was an error while modifying the user's preferences
	    error "Could not edit ie registry: $err"
	} else {
	    setupgui::UpdateDefaultsWithOldProxy $oldProxy
	}
	AddBookmark
    } err] {
	catch { close $f }
	dbg::puts setup "Internet explorer setup failed: $err"
	set result 0
    }
    set result
}

proc setupie::BinaryToBool { listValue } {
    set result 0
    set bin [lindex $listValue 1]
    set type [lindex $listValue 0]
    if { $type == "dword" } {
	set result $bin
    } else {
	# it's a hex binary
	binary scan $bin i result
    }
    set result
}

###########################################################################
# returns old proxyhost, proxyport
proc setupie::EditRegistry { proxyHost proxyPort } {
    set oldProxyHost ""
    set oldProxyPort ""
    variable iepath
    variable ieroot
    set httpFormat {http=([^:]*):([^;$]*)}
    set oldOneProxy 0
    
    if [ catch {
	set k [reg_openkey $ieroot $iepath -access [list read write]]
	# puts "ProxyEnable: [reg_getvalue $k ProxyEnable]"
	set usedOldProxy [BinaryToBool \
		[reg_getvalue $k ProxyEnable]]
	set szOldProxy [lindex [reg_getvalue $k ProxyServer] 1]
	# get old http server, if in multiproxyserver format
	if { $usedOldProxy && [regexp -nocase $httpFormat \
		$szOldProxy x host port] } {
	    set oldProxyHost $host
	    set oldProxyPort $port
	# get it if it's in single proxyserver format
	} elseif { $usedOldProxy && ![regexp = $szOldProxy] } {
	    set listOldProxy [split $szOldProxy :]
	    set oldProxyHost [lindex $listOldProxy 0]
	    set oldProxyPort [lindex $listOldProxy 1]
	    set oldOneProxy 1
	}
	
	#now do the substitutions
	if !$usedOldProxy {
	    # there was no previous proxyserver, so just stick in ours
	    set szNewProxy "http=$proxyHost:$proxyPort"	    
	# first try the multi-proxyserver format with http
	} elseif [regsub -nocase $httpFormat $szOldProxy \
		"http=$proxyHost:$proxyPort" szNewProxy] {
	#ok, so try the multi-proxyserver format without http
	} elseif [regexp = $szOldProxy] {
	    set listProxies [split $szOldProxy ";"]
	    lappend listProxies "http=$proxyHost:$proxyPort"
	    set szNewProxy [join [lsort -ascii $listProxies] ";"]
	#it must be in must be in single proxy format
	} elseif $oldOneProxy {
	    #there was only one proxy server before, so we have to set it
	    #up so all the other protocols besides http still use the old
	    #server
	    set otherProtocols [list https gopher ftp socks]
	    set listProxies [list "http=$proxyHost:$proxyPort"]
	    foreach protocol $otherProtocols {
		lappend listProxies "$protocol=$oldProxyHost:$oldProxyPort"
	    }
	    set szNewProxy [join [lsort -ascii $listProxies] ";"]	    
	} else {
	    # there was no previous proxyserver, so just stick in ours
	    set szNewProxy "http=$proxyHost:$proxyPort"
	}

	# now actually set the values
	SetProxyEnable $k
	reg_setvalue $k ProxyHttp1.1 dword 1
	reg_setvalue $k ProxyServer sz $szNewProxy
	reg_closekey $k
    } err ] {
	catch { reg_closekey $k }
	error "Couldn't modify registry: $err"
    }
    list $oldProxyHost $oldProxyPort
}

proc setupie::SetProxyEnable { k } {
    # this gets a little tricky because it could be binary or dword
    if { [lindex [reg_getvalue $k ProxyEnable] 0] == "dword" } {
	reg_setvalue $k ProxyEnable dword 1
    } else {
	reg_setvalue $k ProxyEnable binary [binary format i 1]
    }
}
    

proc setupie::Uninstall { } {
    # first try in multi-user registry setup
    set ieroot key_current_user
    set iepath "Software/Microsoft/Windows/CurrentVersion/Internet Settings"
    set backuppath "Software/WebSmacker/MSIE/BackupRegistry"    
    UninstallUser
    # now try default user registry setup
    set ieroot key_users
    set iepath ".Default/Software/Microsoft/Windows/CurrentVersion/Internet Settings"
    set backuppath ".Default/Software/WebSmacker/MSIE/BackupRegistry"
    UninstallUser
}

proc setupie::UninstallUser { } {
    global registryDllLoaded
    if { ![info exists registryDllLoaded] } {
	load registry.dll
	set registryDllLoaded 1
    }
    variable iepath
    variable ieroot
    variable backuppath
    
    if [catch { 
	set k [reg_openkey $ieroot $iepath -access write]
	set kSource [reg_openkey $ieroot $backuppath -access read]
	set backupValues [list ProxyEnable ProxyHttp1.1 ProxyServer]
	foreach valuename $backupValues {
	    set val [reg_getvalue $kSource $valuename]
	    reg_setvalue $k $valuename [lindex $val 0] [lindex $val 1]
	}
	reg_closekey $k
	reg_closekey $kSource
    } err ] {
	catch { reg_closekey $k }
	catch { reg_closekey $kSource }
	dbg::puts setup "Could not uninstall Internet explorer:\n$err"
    }
}

proc setupie::BackupRegistry { } {
    global registryDllLoaded
    if { ![info exists registryDllLoaded] } {
	load registry.dll
	set registryDllLoaded 1
    }
    variable iepath
    variable ieroot
    variable backuppath

    if [catch { set k [reg_openkey $ieroot $backuppath] } ] {
	# the key does'nt exist yet so we need to backup
	if [catch { 
	    set k [reg_openkey $ieroot $backuppath -create 1 \
		    -access write]
	    set kSource [reg_openkey $ieroot $iepath -access read]
	    set backupValues [list ProxyEnable ProxyHttp1.1 ProxyServer]
	    foreach valuename $backupValues {
		set val [reg_getvalue $kSource $valuename]
		reg_setvalue $k $valuename [lindex $val 0] [lindex $val 1]
	    }
	    reg_closekey $k
	    reg_closekey $kSource
	} err ] {
	    catch { reg_closekey $k }
	    catch { reg_closekey $kSource }
	    error "Could not backup registry: $err"
	}
    } else {
	catch { reg_closekey $k }
    }
}

proc setupie::AddBookmark { } {
    variable bookmark
    variable bookmarkFile

    if [catch {
	set bmfile [file join [setupgui::GetUserProfilePath] \
		Favorites $bookmarkFile]    
	set f [open $bmfile w]
	puts $f $bookmark
	close $f
    } err] {
	catch { close $f }
	error "Could not add bookmark to Internet Explorer:\n$err"
    }
}
###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
