<%@ page language="java" import="com.kplab.webeasy.Util, com.kplab.webeasy.CategoryBean.*"
    contentType="text/html" %>

<jsp:useBean id="CategoryBean" scope="session" class="com.kplab.webeasy.CategoryBean" />

<%
    response.setHeader("Pragma", "no-cache");
    response.setHeader("Cache-Control", "no-cache");
    response.setHeader("Expires", "0");
%>

<html>
<head>
<title>123-WebEasy Category Management</title>
<meta http-equiv="Content-Type" content="text/html">
</head>


<body background="../images/bg.gif" bgcolor="white" marginheight="0" marginwidth="0"
      topmargin="5" leftmargin="5">

<center>
<image src="../images/header.gif">
<br>

<font color="#800080" size="5" face="Arial"><strong>Add Category</strong></font>
<br><br>


<%
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    int new_level=0, last_catid=0;
    try {
      if (request.getParameter("NewLevel") != null)
      {
        new_level  = Integer.parseInt(request.getParameter("NewLevel"));
        last_catid = Integer.parseInt(request.getParameter(
                     "Cat" + Integer.toString(new_level)));
      }
    }
    catch (Exception e) {
      %>The page you selected does not exist.<%
      return;
    }

    String return_code = request.getParameter("ReturnCode");

    String admin_servlet = new String(Util.getServletRoot() + 
                              "/com.kplab.webeasy.CategoryAdminServlet");
%>


<table width="75%" border="0">                        
<%
    /********************************************/
    /*** Show messsage for the last operation ***/
    /********************************************/

    if (return_code != null)
    {
%>
  <tr><td valign="top" align="left" colspan="2">
<%
      if (return_code.equals("OK"))
      {
%>
    <font color="blue"><b>The operation completed successfully.</b></font><br>
<%
      }

      if (return_code.equals("FAILED"))
      {
%>
    <font color="red"><b>The operation failed !! Please check log file.</b></font><br>
<%
      }
%>
  </td></tr>
<%
    }
%>    


<%
    /**********************************************************************/
    /*** Call this jsp if select sub-category (last_catid = parent_id). ***/
    /*** Call admin servlet if add category (last_catid = -1).          ***/
    /*** new_level = level of the category to be selected or added.     ***/
    /**********************************************************************/

    if (last_catid != -1)
    {
      new_level++;
%>
  <form action="AddCategory.jsp" method="post">
<%
    } else {
%>
  <form action="<%= admin_servlet %>" method="post" ENCTYPE="multipart/form-data">
<%
    }
%>
  <input type="hidden" name="NewLevel" value="<%= Integer.toString(new_level) %>">



<%
    /************************************/
    /***** Show Selected Categories *****/
    /************************************/

    for (int level=1; level<new_level; level++)
    {
      int cat_id=0;
      String cat_alias = "Cat" + Integer.toString(level);
      try {
        cat_id = Integer.parseInt(request.getParameter(cat_alias));
      }
      catch (Exception e) {
        %>The page you selected does not exist.<%
        return;
      }

      Category cat = CategoryBean.getCategory(cat_id, 1);
      String cat_name = cat.getCatName();
%>
  <tr>
    <td valign="top" align="left" width="30%" nowrap>
      <b>Level <%= Integer.toString(level) %> Category:</b>
    </td>
    <td valign="top" align="left" width="70%"><%= cat_name %></td>
    <input type="hidden" name="<%= cat_alias %>" value="<%= Integer.toString(cat_id) %>">
  </tr>
<%
    }
%>


<%
    /**********************************/
    /***** Show Category List Box *****/
    /**********************************/

    if (last_catid != -1)
    {
      CategoryBean.refreshList(last_catid, 1);
      int list_size = CategoryBean.getListSize();
      String cat_alias = "Cat" + Integer.toString(new_level);
%>

  <tr>
    <td valign="top" align="left" width="30%" nowrap>
      <b>Level <%= Integer.toString(new_level) %> Category:</b>
    </td>
    <td valign="top" align="left" width="70%">
      <select size="1" name="<%= cat_alias %>">
      <option value="-1">New Category</option> 
<%
      for (int i=0; i<list_size; i++)
      {
        Category cat = CategoryBean.getCategoryAt(i);
        int cat_id = cat.getCatID();
        String cat_name = cat.getCatName();
        String leaf_cat = cat.getLeafCat();
        /* Only show non-leaf category. */
        if (! (leaf_cat != null && leaf_cat.equals("Y")))
        {
%>
      <option value="<%= Integer.toString(cat_id) %>"><%= cat_name %></option> 
<%
        }
      }
%>
      </select>
      <input type="submit" value="Submit">
      <a href="index.html">Exit</a>
    </td>
  </tr>
<%
    }
%>


<%
    /****************************/
    /******* New Category *******/
    /****************************/

    if (last_catid == -1)
    {
      int parent_id=0;
      if (new_level > 1)
      {
        try {
          parent_id = Integer.parseInt(request.getParameter(
                      "Cat" + Integer.toString(new_level-1)));
        }
        catch (Exception e) {
          %>Invalid parent CatID.<%
          return;
        }
      }
%>
  <tr>
    <td width="30%" valign="top" align="left" nowrap><b>Category name:</b></td>
    <td width="70%" valign="top" align="left"><textarea name="CatName"
        wrap="physical" rows="1" cols="50"></textarea></td>
  </tr>

  <tr>
    <td valign="top" align="left" width="30%" nowrap><b>Description:</b></td>
    <td valign="top" align="left" width="70%"><textarea name="CatDes"
        wrap="physical" rows="10" cols="50"></textarea></td>
  </tr>

  <tr>
    <td valign="top" align="left" width="30%" nowrap><b>Image 1 (optional):</b></td>
    <td valign="top" align="left"><input type=FILE name="CatImage1"></td>
  </tr>

  <tr>
    <td valign="top" align="left" width="30%" nowrap><b>Image 2 (optional):</b></td>
    <td valign="top" align="left"><input type=FILE name="CatImage2"></td>
  </tr>

  <tr>
    <td valign="top" align="left" width="30%" nowrap><b>Leaf Category:</b></td>
    <td valign="top" align="left" width="70%"><input name="LeafCat" type="checkbox"></td>
  </tr>

  <tr>
    <td valign="top" align="left"></td>
    <input type="hidden" name="Action" value="ADD">
    <input type="hidden" name="ParentID" value="<%= Integer.toString(parent_id) %>">
    <td valign="top" align="left"><input type="submit" value="Submit"><input type="reset"
      value="Clear All">&nbsp;<a href="index.html">Exit</a>
    </td>
  </tr>
<%
    }
%>


</form>                                                                                                                                               
</table>
</center>
</body>                                                                                                                                               
</html>                                                                                                                                               
