var ImagePath = "../Images/";
function OnToolbarClick(button){
	switch(button.name){
		case "info":
			var info = WebGrid.GetInfo("mygrid");
			document.getElementById("info").innerHTML = info;
			break;
		case "summary":
			var summary = WebGrid.GetSummary("mygrid");
			document.getElementById("info").innerHTML = summary;
			break;
		case "exit":
			if (window.confirm("Exit demo?")) { window.close();}
			break;
	}
}
function Query_Menu()
{
    var menu;
    var style = new WebControls.ContainerStyle("silver","silver","outset",1);
    var itemStyle = new WebControls.ControlStyle();
    itemStyle.textAlign="left";
    itemStyle.borderWidth=1;
    itemStyle.SetStyle(State.RELEASED,"black","silver");
    itemStyle.SetStyle(State.OVER,"black","lavender","solid","black");
    menu = new WebControls.Menu("Query_Menu",style,200,20,16,16);
    menu.items.style = itemStyle;
    menu.items.Add("1995","Product Sales for 1995", ImagePath + "Products.gif");
    menu.items.Add("expensive","Ten Most Expensive Products", ImagePath + "Products.gif");
    menu.items.Add("above","Products Above Average Price", ImagePath + "Products.gif");
    menu.OnClick = OnContents;
}
function Application_Toolbar()
{
    var item;
    var toolBar;
    var style = new WebControls.ContainerStyle("silver","silver");//,"outset",1);
    var itemStyle = new WebControls.ControlStyle();
    itemStyle.borderWidth=1;
    itemStyle.textAlign = "left";
    itemStyle.SetStyle(State.RELEASED,"black","silver");
    itemStyle.SetStyle(State.OVER,"black","lavender","solid","black");
    itemStyle.SetStyle(State.PRESSED,"black","silver","inset");
    toolBar = new WebControls.Toolbar("Application_Toolbar",style,120,25,16,16);
    toolBar.items.style = itemStyle;
    toolBar.SetDropDownImage(ImagePath + "DownArrow.gif",7,7);
    toolBar.items.Add("queries","Queries",ImagePath + "Products.gif","Query_Menu");
    toolBar.items.Add("info","Information",ImagePath + "Products.gif");
    toolBar.items.Add("summary","Summary",ImagePath + "Orders.gif");
    toolBar.items.Add("exit","Exit",ImagePath + "Exit.gif");
    toolBar.OnClick = OnToolbarClick;
}
function Contents(){
	var item,item1,item2,helper;
	var contents;
	var style = new WebControls.ContainerStyle("white","silver","inset",2);
	var itemStyle = new WebControls.ControlStyle();
	itemStyle.SetStyle(State.RELEASED,"black","white");
	itemStyle.SetStyle(State.OVER,"white","navy");
	itemStyle.SetFont("Arial","normal","10");
	var contents = new WebControls.Treeview("Contents",style, 145, 18, 16,16);
	contents.SetFixedSize(150, 345);
	contents.OnClick = OnContents;
	contents.items.style = itemStyle;
	contents.indent = 10;
	item = contents.items.Add("tables","Tables",ImagePath + "close.gif", ImagePath + "open.gif");
		item.Expand(true);
		item.items.Add("categories","Categories",ImagePath + "item.gif");
		item.items.Add("customers","Customers",ImagePath + "item.gif");
		item.items.Add("orders","Orders",ImagePath + "item.gif");
		item.items.Add("products","Products",ImagePath + "item.gif");
		item.items.Add("shippers","Shippers",ImagePath + "item.gif");
		item.items.Add("suppliers","Suppliers",ImagePath + "item.gif");
	item = contents.items.Add("views","Views",ImagePath + "close.gif", ImagePath + "open.gif");
		item.Expand(true);
		item.items.Add("invoices","Invoices",ImagePath + "item.gif");
		item.items.Add("subtotal","Orders subtotal",ImagePath + "item.gif");
		item.items.Add("quaterly","Quaterly orders",ImagePath + "item.gif");
		item.items.Add("sales","Sales by category",ImagePath + "item.gif");
}
function OnContents(button){
	var url;
	if (button.parent != null && button.parent.name == "tables"){
		url = "../Grids/data.aspx?layout=true&query=" + escape("select * from " + button.name);
		WebGrid.LoadGrid("mygrid",url);
	}
	else {
		url = "../Grids/data.aspx?layout=true&query=" + escape(GetSelect(button.name));
		WebGrid.LoadGrid("mygrid",url);
	}
	document.getElementById("info").innerHTML = "&nbsp;";
}
function GetSelect(c){
	var select = "";
	switch(c){
		case "invoices":
			select = "SELECT DISTINCTROW Orders.ShipName, Orders.ShipAddress, Orders.ShipCity, Orders.ShipRegion, Orders.ShipPostalCode, Orders.ShipCountry, Orders.CustomerID, Customers.CompanyName, Customers.Address, Customers.City, Customers.Region, Customers.PostalCode, Customers.Country, [FirstName] & \" \" & [LastName] AS Salesperson, Orders.OrderID, Orders.OrderDate, Orders.RequiredDate, Orders.ShippedDate, Shippers.CompanyName, [Order Details].ProductID, Products.ProductName, [Order Details].UnitPrice, [Order Details].Quantity, [Order Details].Discount, CCur([Order Details].[UnitPrice]*[Quantity]*(1-[Discount])/100)*100 AS ExtendedPrice, Orders.Freight FROM Shippers INNER JOIN (Products INNER JOIN ((Employees INNER JOIN (Customers INNER JOIN Orders ON Customers.CustomerID = Orders.CustomerID) ON Employees.EmployeeID = Orders.EmployeeID) INNER JOIN [Order Details] ON Orders.OrderID = [Order Details].OrderID) ON Products.ProductID = [Order Details].ProductID) ON Shippers.ShipperID = Orders.ShipVia";
		break;
		case "subtotal":
			select = "SELECT DISTINCTROW [Order Details].OrderID, Sum(CCur([UnitPrice]*[Quantity]*(1-[Discount])/100)*100) AS Subtotal FROM [Order Details] GROUP BY [Order Details].OrderID";
		break;
		case "quaterly":
			select = "SELECT DISTINCTROW Customers.CustomerID, Customers.CompanyName, Customers.City, Customers.Country FROM Customers RIGHT JOIN Orders ON Customers.CustomerID = Orders.CustomerID WHERE (((Orders.OrderDate) Between #1/1/95# And #12/31/95#))";
		break;
		case "sales":
			select = "SELECT DISTINCTROW Categories.CategoryID, Categories.CategoryName, Products.ProductName, Sum([Order Details Extended].ExtendedPrice) AS ProductSales FROM Categories INNER JOIN (Products INNER JOIN (Orders INNER JOIN [Order Details Extended] ON Orders.OrderID = [Order Details Extended].OrderID) ON Products.ProductID = [Order Details Extended].ProductID) ON Categories.CategoryID = Products.CategoryID WHERE (((Orders.OrderDate) Between #1/1/95# And #12/31/95#)) GROUP BY Categories.CategoryID, Categories.CategoryName, Products.ProductName ORDER BY Products.ProductName";
		break;
		case "1995":
			select = "SELECT DISTINCTROW [Product Sales for 1995].CategoryName, Sum([Product Sales for 1995].ProductSales) AS CategorySales FROM [Product Sales for 1995] GROUP BY [Product Sales for 1995].CategoryName"
		break;
		case "expensive":
			select = "SELECT DISTINCTROW TOP 10 Products.ProductName AS TenMostExpensiveProducts, Products.UnitPrice FROM Products ORDER BY Products.UnitPrice DESC";
		break;
		case "above":
			select = "SELECT DISTINCTROW Products.ProductName, Products.UnitPrice FROM Products WHERE (((Products.UnitPrice)>(SELECT AVG([UnitPrice]) From Products))) ORDER BY Products.UnitPrice DESC";
		break;
	}
	return select;
}
function Begin(){
		Query_Menu();
		Application_Toolbar();
		Contents();
		var url = "../Grids/data.aspx?layout=true&query=" + escape("select * from categories");
		WebGrid.Load(url);
}
function Init(){
	WebControls.Init();
	WebGrid.Init();
}
