package WebGridJSP;
import java.sql.*;
import sun.jdbc.odbc.*;
import java.util.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import javax.servlet.*;
import UOL.WebGrid10.*;

public class JSPWebGrid implements WebGridEventListener
{
    Connection conn =  null;
    String [] tableColumns  = new String [] {"Address","City","Region","PostalCode","Country","Notes","US"};
    String table = "Em";
    WebGrid wg;
    String output = "";
    public JSPWebGrid(HttpSession session, HttpServletRequest request) 
    {
      try
      {
        wg = new WebGrid(session, request);
        wg.addQueryEventListener(this);
        wg.addLoadEventListener(this);
        wg.addUpdateEventListener(this);
        this.output = wg.Execute();
      }
      catch(Exception e) 
      {
        System.out.print(e.getMessage());
      }
    }
    public String getOutput()
    {
      return this.output;
    }
    public void OpenConnection() throws Exception
    {
      try
      {
        Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        conn =  DriverManager.getConnection("jdbc:odbc:NWIND");
      }
      catch(Exception e)
      {
        throw new Exception(e.getMessage());
      }
    }
    public void CloseConnection() throws Exception
    {
      try 
      {
        if (conn != null) conn.close();
      }
      catch(Exception e)
      {
        throw new Exception(e.getMessage());
      }
    }
    public void OnQuery(WebGridQueryEventArgs args)
    {
        args.DataSource = GetData();
    }
    public void OnUpdate(WebGridUpdateEventArgs args)
    {
      try
      {
        OpenConnection();
        if (args.updateAllColumn != -1) UpdateAll(args.updateAllColumn,args.updateAllValue);
        if (args.Updates != null) Update(args.Updates);
        if (args.Deletes != null) Delete(args.Deletes);
        if (args.Inserts != null) Insert(args.Inserts);
        CloseConnection();
      }
      catch(Exception e) 
      {
        System.out.print(e.getMessage());
      }
    }
    public void OnLoad(WebGridQueryEventArgs args)
    {
      try
      {
        CloseConnection();
      }
      catch(Exception e) 
      {
        System.out.print(e.getMessage());
      }
    }
    private Object GetData()
    {
        Object result = null;
        conn = null;
        try
        {
            OpenConnection();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select Address,City,Region,PostalCode,Country,Notes,US from Em");
            result = (Object)rs;
        }
        catch(Exception e)
        {
            System.out.print(e.getMessage());
        }
        return result;
    }
    private void UpdateAll(int column, String value) throws Exception
    {
        conn = null;
        try
        {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("UPDATE " + this.table + " SET " + this.tableColumns[column] + "='" + value + "'");
        }
        catch(Exception e)
        {
            throw new Exception(e.getMessage());
        }
    }
    private void Update(Object [] rows) throws Exception
    {
        conn = null;
        try
        {
            int whereColumn = 1;
            for(int j = 0; j < rows.length; ++j)
            {
            String [] values = (String [])rows[j];
            StringBuffer query = new StringBuffer("UPDATE " + this.table + " SET ");
            for (int i = 0; i < this.tableColumns.length - 1; ++i)
            {
                query.append(this.tableColumns[i] + "='" + values[i] + "', ");
            }
            query.append(this.tableColumns[this.tableColumns.length - 1] + "='" + values[this.tableColumns.length - 1] + " ");
            query.append("WHERE " + this.tableColumns[whereColumn] + "='" + values[whereColumn] + "'");
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(query.toString());
            }
        }
        catch(Exception e)
        {
            throw new Exception(e.getMessage());
        }
    }
    private void Delete(Object [] rows) throws Exception
    {
        conn = null;
        try
        {
            int whereColumn = 1;
            for(int j = 0; j < rows.length; ++j)
            {
            String [] values = (String [])rows[j];
            StringBuffer query = new StringBuffer("DELETE FROM " + this.table + " WHERE ");
            query.append("WHERE " + this.tableColumns[whereColumn] + "='" + values[whereColumn] + "'");
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(query.toString());
            }
        }
        catch(Exception e)
        {
            throw new Exception(e.getMessage());
        }
    }
    private void Insert(Object [] rows) throws Exception
    {
        try
        {
            for(int j = 0; j < rows.length; ++j)
            {
            String [] values = (String [])rows[j];
            StringBuffer query = new StringBuffer("INSERT INTO " + this.table + " (");
            for (int i = 0; i < this.tableColumns.length - 1; ++i)
            {
                query.append(this.tableColumns[i] + ", ");
            }
            query.append(this.tableColumns[this.tableColumns.length - 1] + ") VALUES (");
            for (int i = 0; i < this.tableColumns.length - 1; ++i)
            {
                query.append("'" + values[i] + "',");
            }
            query.append("'" + values[this.tableColumns.length - 1] + "')");
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(query.toString());
            }
        }
        catch(Exception e)
        {
            throw new Exception(e.getMessage());
        }
    }
}