set root     d:/mytcls/webpages
set default  index.htm
set port     80




set peerCount 0




proc peer {socketChannel} {
global peerCount

set info [fconfigure $socketChannel -peername]
set peerName [lindex $info 1]
incr peerCount
set when [clock format [clock seconds] ]
puts stdout "$peerCount  $peerName  $when"
}




set mimeType(htm)  text/html
set mimeType(html) text/html
set mimeType(gif)  image/gif
set mimeType(jpg)  image/jpeg
set mimeType(jpe)  image/jpeg
set mimeType(jpeg) image/jpeg
set mimeType(txt)  text/plain
set mimeType(text) text/plain
set mimeType(tru)  text/plain
set mimeType(tcl)  text/plain




proc mime {name channel} {
global mimeType

set wordList [split $name .]
set ell [llength $wordList]
set suffix [lindex $wordList [expr $ell-1] ]
set suffix [string tolower $suffix]

if { [info exists mimeType($suffix)] } then {
puts $channel "Content-type: $mimeType($suffix)"
} elseif { [string length $suffix]==1 } then {
puts $channel "Content-type: text/plain"
} else {
puts $channel "Content-type: application/$suffix"
}

}




proc bgerror {trouble} {puts stdout "bgerror: $trouble"}




proc answer {socketChannel host2 port2} {
global gotLine

peer $socketChannel

if { [info exists gotLine($socketChannel)] } then {
unset gotLine($socketChannel)
}

fconfigure $socketChannel -buffering line -blocking 0
fileevent $socketChannel readable [list readIt $socketChannel]
}




proc readIt {socketChannel} {
global gotLine

gets $socketChannel line
if { [fblocked $socketChannel] } then {return}

if {[eof $socketChannel] || $line=="" } then {
fileevent $socketChannel readable ""
writeIt $socketChannel
} else {
puts stdout "          $line"

if {![info exists gotLine($socketChannel)]} then {
set gotLine($socketChannel) $line
}

}

}




proc writeIt {socketChannel} {
global root default gotLine

set shortName "/"
regexp {/[^ ]*} $gotLine($socketChannel) shortName
set many [string length $shortName]
set last [string index $shortName [expr $many-1] ]
if {$last=="/"} then {set shortName $shortName$default }
set wholeName $root$shortName

if [catch {set fileChannel [open $wholeName RDONLY] } ] then {
puts $socketChannel "HTTP/0.9 404 Not found"
puts $socketChannel "Content-type: text/html"
puts $socketChannel ""
puts $socketChannel "<html><head><title><No such URL.></title></head>"
puts $socketChannel "<body><center>"
puts $socketChannel "The URL you requested does not exist on this site."
puts $socketChannel "</center></body></html>"
} else {
fconfigure $fileChannel -translation binary
fconfigure $socketChannel -translation binary -buffering full
puts $socketChannel "HTTP/0.9 200 OK"
mime $shortName $socketChannel
puts $socketChannel ""
set work [read $fileChannel]
puts -nonewline $socketChannel $work
close $fileChannel
}

close $socketChannel
}




socket -server answer $port
# vwait forEver
