/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class JTextPane
extends JEditorPane {
    private static final String uiClassID = "TextPaneUI";

    public JTextPane() {
        this.setEditorKit(new StyledEditorKit());
    }

    public JTextPane(StyledDocument styledDocument) {
        this();
        this.setStyledDocument(styledDocument);
    }

    public Style addStyle(String string, Style style) {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.addStyle(string, style);
    }

    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit();
    }

    public AttributeSet getCharacterAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getCharacterElement(this.getCaretPosition());
        if (element != null) {
            return element.getAttributes();
        }
        return null;
    }

    public MutableAttributeSet getInputAttributes() {
        return this.getStyledEditorKit().getInputAttributes();
    }

    public Style getLogicalStyle() {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.getLogicalStyle(this.getCaretPosition());
    }

    public AttributeSet getParagraphAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getParagraphElement(this.getCaretPosition());
        if (element != null) {
            return element.getAttributes();
        }
        return null;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Style getStyle(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.getStyle(string);
    }

    public StyledDocument getStyledDocument() {
        return (StyledDocument)this.getDocument();
    }

    protected final StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void insertComponent(Component component) {
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        StyleConstants.setComponent(mutableAttributeSet, component);
        this.replaceSelection(" ");
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
    }

    public void insertIcon(Icon icon) {
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        StyleConstants.setIcon(mutableAttributeSet, icon);
        this.replaceSelection(" ");
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
    }

    protected String paramString() {
        return super.paramString();
    }

    public void removeStyle(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.removeStyle(string);
    }

    public void replaceSelection(String string) {
        block5: {
            if (!this.isEditable()) {
                this.getToolkit().beep();
                return;
            }
            StyledDocument styledDocument = this.getStyledDocument();
            if (styledDocument == null) break block5;
            try {
                Caret caret = this.getCaret();
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                if (n != n2) {
                    styledDocument.remove(n, n2 - n);
                }
                if (string != null && string.length() > 0) {
                    styledDocument.insertString(n, string, this.getInputAttributes());
                }
            }
            catch (BadLocationException badLocationException) {
                this.getToolkit().beep();
            }
        }
    }

    public void setCharacterAttributes(AttributeSet attributeSet, boolean bl) {
        int n;
        int n2 = this.getSelectionStart();
        if (n2 != (n = this.getSelectionEnd())) {
            StyledDocument styledDocument = this.getStyledDocument();
            styledDocument.setCharacterAttributes(n2, n - n2, attributeSet, bl);
        } else {
            MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
            if (bl) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(attributeSet);
        }
    }

    public void setDocument(Document document) {
        if (!(document instanceof StyledDocument)) {
            throw new IllegalArgumentException("Model must be StyledDocument");
        }
        super.setDocument(document);
    }

    public final void setEditorKit(EditorKit editorKit) {
        if (!(editorKit instanceof StyledEditorKit)) {
            throw new IllegalArgumentException("Must be StyledEditorKit");
        }
        super.setEditorKit(editorKit);
    }

    public void setLogicalStyle(Style style) {
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.setLogicalStyle(this.getCaretPosition(), style);
    }

    public void setParagraphAttributes(AttributeSet attributeSet, boolean bl) {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.setParagraphAttributes(n, n2 - n, attributeSet, bl);
    }

    public void setStyledDocument(StyledDocument styledDocument) {
        super.setDocument(styledDocument);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }
}

