/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;

public class PasswordView
extends FieldView {
    static char[] ONE = new char[1];

    public PasswordView(Element element) {
        super(element);
    }

    protected int drawEchoCharacter(Graphics graphics, int n, int n2, char c) {
        PasswordView.ONE[0] = c;
        graphics.drawChars(ONE, 0, 1, n, n2);
        return n + graphics.getFontMetrics().charWidth(c);
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        graphics.setColor(this.selected);
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            graphics.setColor(jPasswordField.getSelectedTextColor());
            char c = jPasswordField.getEchoChar();
            int n5 = n4 - n3;
            int n6 = 0;
            while (n6 < n5) {
                n = this.drawEchoCharacter(graphics, n, n2, c);
                ++n6;
            }
        }
        return n;
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            graphics.setColor(jPasswordField.getForeground());
            char c = jPasswordField.getEchoChar();
            int n5 = n4 - n3;
            int n6 = 0;
            while (n6 < n5) {
                n = this.drawEchoCharacter(graphics, n, n2, c);
                ++n6;
            }
        }
        return n;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            char c = jPasswordField.getEchoChar();
            FontMetrics fontMetrics = jPasswordField.getFontMetrics(jPasswordField.getFont());
            Rectangle rectangle = this.adjustAllocation(shape).getBounds();
            int n2 = (n - this.getStartOffset()) * fontMetrics.charWidth(c);
            rectangle.x += n2;
            rectangle.width = 1;
            return rectangle;
        }
        return null;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        int n = 0;
        Container container = this.getContainer();
        if (container instanceof JPasswordField) {
            JPasswordField jPasswordField = (JPasswordField)container;
            char c = jPasswordField.getEchoChar();
            FontMetrics fontMetrics = jPasswordField.getFontMetrics(jPasswordField.getFont());
            Rectangle rectangle = (shape = this.adjustAllocation(shape)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            n = ((int)f - rectangle.x) / fontMetrics.charWidth(c);
            if (n < 0) {
                n = 0;
            } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                n = this.getDocument().getLength() - this.getStartOffset();
            }
        }
        return this.getStartOffset() + n;
    }
}

