// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "socktest.h"
#include "doc.h"
#include "view.h"
#include "sendview.h"

#include "mainfrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_UPDATE_COMMAND_UI(ID_CLOSECONN, OnUpdateCloseconn)
	ON_UPDATE_COMMAND_UI(ID_CONNECT, OnUpdateConnect)
	ON_WM_NCLBUTTONDOWN()
	//}}AFX_MSG_MAP
	// Global help commands
	ON_MESSAGE(WM_WINSOCK_EVENT,OnWinsockEvent)
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_MYSBPANE
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction
CMainFrame::CMainFrame()
{
	m_pWinsock = NULL;
}

CMainFrame::~CMainFrame()
{
	if( m_pWinsock != NULL )
	{
		delete m_pWinsock; 
	}	
}

/////////////////////////////////////////////////////////////////////////////
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// fix the caption
	DWORD x = 0;
	x |= FWS_ADDTOTITLE;
	cs.style &= ~x;
	
	// set the position
	float fClientWidth = (float)0.75;       // think of this as a percentage  of the screen that the
													// client will consume
	int hr = ::GetSystemMetrics( SM_CXSCREEN );
	int vr = ::GetSystemMetrics( SM_CYSCREEN );
	cs.cx = (int)((float)hr * fClientWidth);  // consume fClientWidth% of the x pixels
	cs.cy = (int)((float)vr * fClientWidth);  // consume fClientWidth% of the y pixels
	cs.x  = (hr - cs.cx)/2;  // centers the window
	cs.y  = (vr - cs.cy)/2;  // centers the window
	
	// call the base class and return
	BOOL b = CFrameWnd::PreCreateWindow(cs);
	return(b);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
BOOL CMainFrame::OnCreateClient( LPCREATESTRUCT /*lpcs*/,
	CCreateContext* pContext)
{
	if (m_wndSplitter.CreateStatic(this,2,1))
	{
		CRect rect;
		GetClientRect(&rect);
		CSize size = rect.Size();
		size.cy-=100;
		if (m_wndSplitter.CreateView(0,0,RUNTIME_CLASS(CSocktestView),size,pContext))
		{
			if (m_wndSplitter.CreateView(1,0,RUNTIME_CLASS(CSendView),CSize(0,0),pContext))
			{
				SetActiveView((CView*)m_wndSplitter.GetPane(0,0));
				return TRUE;	
			}
		}
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::MakeSockObj(void)
{
	// make the winsock object
	ASSERT(m_pWinsock == NULL );
	m_pWinsock = new CWinsock(this);
	ASSERT( m_pWinsock != NULL);

	// update status bar pane
	m_wndStatusBar.SetPaneText( 1, "Connected"); 
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::KillSockObj(void)
{
	// make the winsock object
	ASSERT(m_pWinsock != NULL );
	// its a window so destroy it first
	m_pWinsock->DestroyWindow();
	delete m_pWinsock;
	m_pWinsock = NULL;

	// set the upper window active so the menu picks work right
	SetActiveView((CView*)m_wndSplitter.GetPane(0,0));

	// update status bar pane
	m_wndStatusBar.SetPaneText( 1, "No connection"); 
}

/////////////////////////////////////////////////////////////////////////////
LONG CMainFrame::OnWinsockEvent (WPARAM wParam, LPARAM lParam)
{
	CSocktestView * p = (CSocktestView *)m_wndSplitter.GetPane(0,0);
	p->SendMessage(WM_WINSOCK_EVENT,wParam,lParam);

	return 0L;
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateCloseconn(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_pWinsock != NULL);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateConnect(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable( m_pWinsock == NULL);
}

/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnNcLButtonDown(UINT nHitTest, CPoint point) 
{
	// set the upper window active so the menu picks work right
	SetActiveView((CView*)m_wndSplitter.GetPane(0,0));
	CFrameWnd::OnNcLButtonDown(nHitTest, point);
}
