// file tun_util.h
//(C) 1996 Alessandro Mordacci  mordacci@xtreme.it
//(C) 1996 SMC Sistemi di Misura e Controllo
//    Via Caduti del Lavoro, 26 - Pisa (Italy)
//    Tel. +39 50 525484
#ifndef __TUN_UTIL_H
#define __TUN_UTIL_H

// Some implementations of winsock.h are broken when compiling for WIN16.
// I include the winsock.h from the 1.1 specification (renamed wsk_orig.h
// to avoid conflicts). It MUST go, as any winsock comliant application
// have to work with ANY winsock.dll!
// We have to check C++ ourself either...
#ifdef   __cplusplus
extern "C" {
#endif //__cplusplus
#include "wsk_orig.h"
#ifdef   __cplusplus
}
#endif //__cplusplus

#include <windows.h>
#ifndef _INC_WINDOWS
#   define _INC_WINDOWS //windows 3.0 do not #define it
#endif

#include <stdlib.h>     // I always
#include <string.h>     // include
#include <fstream.h>    // this three files ...

// This macro may not be available
#ifndef MAKEWORD
#define MAKEWORD(a, b)                                     \
	 ((WORD)(                                               \
			((BYTE)(a))  |  ( ((WORD)((BYTE)(b)))<<8 )        \
	 ))
#endif

#define GetSocketError() WSAGetLastError() //here we use only winsock calls

// Now our stuff

struct sock_pair {
	SOCKET from;
   SOCKET to;
};

#define BUFFER_SIZE 3000

char *GetSocketErrorText(int nCode, char *szSkErrBuf, int iLen);
char *GetSocketErrorText(char *szSkErrBuf, int iLen);
void socketErrorExit(char *msg);
void initWinsockLib(void);
int bindMySocket(SOCKET s);
int sendAllBytes ( SOCKET s, const char * buf, int len, int flags );
void waitThread(unsigned long ulID, DWORD dwTimeout);
void mySleep(int iSec);

#endif // __TUN_UTIL_H

