<%
' These variables will be available to all scripts.

Dim strMailboxURL, strInboxURL, strSentItemsURL, strDeletedItemsURL, strContactsURL
Dim strMailboxFileURL, strInboxFileURL, strSentItemsFileURL, strDeletedItemsFileURL, strContactsFileURL

Dim objSession, mb, objFolder, objTopPublicFolder
Dim objRenderApplication, objRenderer
Dim fn, mi
Dim mn, pg
Dim mt
Dim re, ry, rt, rc, rb
Dim mdy, hm
Dim mp ' Miscellaneous parameter
Dim errorCode, noLineBreaks

CONST OPWFN = 1 : CONST OPWMN = 2 : CONST OPWMI = 4
CONST OPWMT = 8 : CONST OPWRE = 16 : CONST OPWRY = 32
CONST OPWRT = 64 : CONST OPWRC = 128 : CONST OPWRB = 256
CONST OPWMDY = 512 : CONST OPWHM = 1024
CONST OPWPG = 4096
CONST OPWMP = 8192

CONST OPWDFILTER = 16384
CONST OPWBOLD = 32768

CONST OPWCMN = 1 : CONST OPWCMR = 2 : CONST OPWCMF = 8
CONST OPWFRMB = 16 : CONST OPWFRFO = 32 : CONST OPWFRMR = 64

Dim bTopFolderFound

Function checkTopFolder(inFolder, inDefaultFolder)

  bTopFolderFound = False
  If inFolder.ID = objSession.GetDefaultFolder(inDefaultFolder).ID Then bTopFolderFound = True
  If inFolder.FolderID <> objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder.ID Then
    checkTopFolder objSession.GetFolder(inFolder.FolderID), inDefaultFolder
  End If
  checkTopFolder = bTopFolderFound

End Function

Sub clearMessage

  Dim filename, sh, key, profileDirectory, fso, f

  re = "" : ry = "" : rt = "" : rc = "" : rb = ""
  Session("attachment") = ""
  filename = Session("filename")
  If filename <> "" Then

    ' Get working directory from registry
    Set sh = Server.CreateObject("WScript.Shell")
    key = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows Messaging Subsystem\ProfileDirectory"
    profileDirectory = sh.RegRead(key) & "\"
    Set sh = Nothing

    Set fso = Server.CreateObject("Scripting.FilesystemObject")
    Set f = fso.GetFile(profileDirectory & filename)
    f.Delete
    Set fso = Nothing
    Set f = Nothing

    Session("filename") = ""

  End If

End Sub

Sub clearObjects

  Set objSession = Nothing
  Set objFolders = Nothing
  Set objFolder = Nothing
  Set objFolder2 = Nothing
  Set objMessage = Nothing
  Set objMessage2 = Nothing
  Set objMessages = Nothing
  Set objOneRecip = Nothing

End Sub

Function compressID(inID)

  inID = Replace(inID, "00000000", "g")
  inID = Replace(inID, "000000", "h")
  inID = Replace(inID, "0000", "i")
  inID = Replace(inID, "00", "j")
  inID = Replace(inID, "11", "k")
  inID = Replace(inID, "22", "l")
  inID = Replace(inID, "33", "m")
  inID = Replace(inID, "44", "n")
  inID = Replace(inID, "55", "o")
  inID = Replace(inID, "66", "p")
  inID = Replace(inID, "77", "q")
  inID = Replace(inID, "88", "r")
  inID = Replace(inID, "99", "s")
  inID = Replace(inID, "AA", "t")
  inID = Replace(inID, "BB", "u")
  inID = Replace(inID, "CC", "v")
  inID = Replace(inID, "DD", "w")
  inID = Replace(inID, "EE", "x")
  inID = Replace(inID, "FFFF", "y")
  inID = Replace(inID, "FF", "z")
  compressID = inID

End Function

Function displayEncode(textIn)

  ' Not doing &nbsp; to save page space.
  textIn = Server.HTMLEncode(textIn)
  textIn = Replace(textIn, "'", "&apos;")
  textIn = Replace(textIn, "$", "$$")
  textIn = Replace(textIn, vbCrLf, "<br/>" & vbCrLf)
  displayEncode = textIn

End Function

Function expandID(inID)

  inID = Replace(inID, "g", "00000000")
  inID = Replace(inID, "h", "000000")
  inID = Replace(inID, "i", "0000")
  inID = Replace(inID, "j", "00")
  inID = Replace(inID, "k", "11")
  inID = Replace(inID, "l", "22")
  inID = Replace(inID, "m", "33")
  inID = Replace(inID, "n", "44")
  inID = Replace(inID, "o", "55")
  inID = Replace(inID, "p", "66")
  inID = Replace(inID, "q", "77")
  inID = Replace(inID, "r", "88")
  inID = Replace(inID, "s", "99")
  inID = Replace(inID, "t", "AA")
  inID = Replace(inID, "u", "BB")
  inID = Replace(inID, "v", "CC")
  inID = Replace(inID, "w", "DD")
  inID = Replace(inID, "x", "EE")
  inID = Replace(inID, "y", "FFFF")
  inID = Replace(inID, "z", "FF")
  expandID = inID

End Function

Dim locFolderCounter

Sub findFolder

  Dim locObjFolders, locObjFolder

  locFolderCounter = 0
  Set locObjFolders = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder.Folders
  For Each locObjFolder In locObjFolders
    findFolder2(locObjFolder)
  Next
  Set locObjFolders = Nothing
  Set locObjFolder = Nothing

End Sub

Sub findFolder2(objFolderIn)

  Dim objFolder2

  locFolderCounter = locFolderCounter + 1
  If locFolderCounter = fn Then Set objFolder = objFolderIn
  For Each objFolder2 In objFolderIn.Folders
    findFolder2(objFolder2)
  Next
  Set objFolder2 = Nothing

End Sub

Dim locFolderNumber

Function findFolderNumber(inFolderID)

  Dim locObjFolders, locObjFolder

  If inFolderID = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder.ID Then
    locFolderNumber = 0
  Else
    locFolderCounter = 0
    Set locObjFolders = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder.Folders
    For Each locObjFolder In locObjFolders
      findFolderNumber2 locObjFolder, inFolderID
    Next
    Set locObjFolders = Nothing
    Set locObjFolder = Nothing
  End If

  findFolderNumber = locFolderNumber

End Function

Sub findFolderNumber2(inFolder, inFolderID)

  Dim objFolder2

  locFolderCounter = locFolderCounter + 1
  If inFolder.ID = inFolderID Then locFolderNumber = locFolderCounter
  For Each objFolder2 In inFolder.Folders
    findFolderNumber2 objFolder2, inFolderID
  Next
  Set objFolder2 = Nothing

End Sub

Sub findPFolder

  Dim locObjFolders, locObjFolder

  On Error Resume Next

  If USELONGPFOLDERIDS Then

    Set objFolder = objSession.GetFolder(fn)
    If objFolder Is Nothing Then Set objFolder = objSession.GetFolder(fn, objTopPublicFolder)
    If objFolder.IsSameAs(objTopPublicFolder) Then Set objFolder = objTopPublicFolder

  Else

    locFolderCounter = 0

    Set locObjFolders = objTopPublicFolder.Folders
    For Each locObjFolder In locObjFolders

      findFolder2(locObjFolder)

    Next
    Set locObjFolders = Nothing
    Set locObjFolder = Nothing

  End If

End Sub

Function findPFolderNumber(inFolderID)

  Dim locObjFolders, locObjFolder

  If USELONGPFOLDERIDS Then

    findPFolderNumber = inFolderID

  Else

    locFolderNumber = 0 ' Sometimes can't find a match!
    If inFolderID = objTopPublicFolder.ID Then
      locFolderNumber = 0
    Else
      locFolderCounter = 0
      Set locObjFolders = objTopPublicFolder.Folders
      For Each locObjFolder In locObjFolders
        findFolderNumber2 locObjFolder, inFolderID
      Next
      Set locObjFolders = Nothing
    End If

    findPFolderNumber = locFolderNumber

  End If

End Function

Sub findTopPublicFolder

  Dim locObjInfoStores, locObjInfoStore, locStrRootID

  Set locObjInfoStores = objSession.InfoStores
  For Each locObjInfoStore In locObjInfoStores
    Err.Clear
    locStrRootID = locObjInfoStore.Fields(&H66310102).Value
    If Err.Number = 0 Then

      ' Get root folder
      Set objTopPublicFolder = objSession.GetFolder(locStrRootID, locObjInfoStore.ID)
      Exit For
    End If
  Next
  Set locObjInfoStores = Nothing

End Sub

Function getMessage(inMessageID)

  Dim locObjMessage, locObjMessage2

  On Error Resume Next

  Set locObjMessage = objSession.GetMessage(inMessageID)
  If locObjMessage Is Nothing Then
    findTopPublicFolder
    Set locObjMessage = objSession.GetMessage(inMessageID, objFolder)
  End If
  If locObjMessage Is Nothing Then
    Set locObjMessage = objSession.GetMessage(inMessageID, objTopPublicFolder)
  End If
  If Err.Number <> 0 Then
    findFolder
    For Each locObjMessage2 In objFolder.Messages
      If locObjMessage2.ID = inMessageID Then
        Set locObjMessage = locObjMessage2
        Exit For
      End If
    Next
  End If
  Set getMessage = locObjMessage

End Function

Function getMessageRecipient(inMessage)

  If USERENDERER Then
    objRenderer.DataSource = inMessage
    getMessageRecipient = objRenderer.RenderProperty(&H0E04001E, 0)
  Else
    getMessageRecipient = inMessage.Fields(&H0E04001E)
  End If

End Function

Function getMessageSender(inMessage)

  If USERENDERER Then
    objRenderer.DataSource = inMessage
    getMessageSender = objRenderer.RenderProperty(&H0C1A001E, 0)
  Else
    getMessageSender = inMessage.Fields(&H0C1A001E)
  End If

End Function

Function getMessageText(inMessage)

  Dim strLocMessageText, strLocMessageText2, blnLocAddChar, intLocX, intLocN, chrLocT

  On Error Resume Next

  Err.Clear
  strLocMessageText = inMessage.Text
  If Err.Number <> 0 And USERENDERER Then
    objRenderer.DataSource = inMessage
    strLocMessageText2 = objRenderer.RenderProperty(&H10090102, 0)
    blnLocAddChar = True
    intLocX = Len(strLocMessageText2)
    For intLocN = 1 To intLocX
      chrLocT = Mid(strLocMessageText2, intLocN, 1)
      If chrLocT = "<" Then
        blnLocAddChar = False
      ElseIf chrLocT = ">" Then
        blnLocAddChar = True
      Else
        If blnLocAddChar Then
          strLocMessageText = strLocMessageText & chrLocT
        End If
      End If
    Next
    strLocMessageText = Replace(strLocMessageText, "&nbsp;", " ")
    strLocMessageText = Replace(strLocMessageText, "&lt;", "<")
    strLocMessageText = Replace(strLocMessageText, "&gt;", ">")
    strLocMessageText = Replace(strLocMessageText, "&quot;", """")
  End If
  getMessageText = strLocMessageText

End Function

Sub getQueryParams

  mb = Request.QueryString("mb")
  If mb = "" Then mb = Request.Form("mb")
  fn = Request.QueryString("fn")
  If fn = "" Then fn = Request.Form("fn")
  mn = Int(Request.QueryString("mn"))
  If mn = "" Then mn = Request.Form("mn")
  If mn = 0 Then mn = 1
  pg = Request.QueryString("pg")
  If pg = "" Then pg = Request.Form("pg")
  If Int(pg) < 1 Then pg = 1
  mi = Request.QueryString("mi")
  If mi = "" Then mi = Request.Form("mi")
  mt = Request.QueryString("mt")
  If mt = "" Then mt = Request.Form("mt")
  If Int(mt) < 1 Then mt = 1
  re = Request.QueryString("re")
  If re = "" Then re = Request.Form("re")
  ry = Request.QueryString("ry")
  If ry = "" Then ry = Request.Form("ry")
  If Int(ry) = 0 Then ry = 1
  rt = Request.QueryString("rt")
  If rt = "" Then rt = Request.Form("rt")
  rc = Request.QueryString("rc")
  If rc = "" Then rc = Request.Form("rc")
  rb = Request.QueryString("rb")
  If rb = "" Then rb = Request.Form("rb")
  mdy = Request.QueryString("mdy")
  If mdy = "" Then mdy = Request.Form("mdy")
  mp = Request.QueryString("mp")
  If mp = "" Then mp = Request.Form("mp")

  If fn <> "" Then fn = expandID(fn)
  If IsNumeric(fn) Then fn = CInt(fn)
  If fn = "" Then fn = 0

  If mi <> "" Then mi = expandID(mi)

End Sub

Function getTimeZoneOffset

  timeZones = Array(24, 19, 14, 46, 38, 7, 9, _
   29, 26, 22, 45, 4, 35, 23, 18, 32, 49, _
   33, 11, 44, 10, 5, 39, 40, 1, 43, 50, _
   15, 42, 21, 34, 47, 27, 48, 2, 41, 52, _
   37, 30, 16, 31, 51, 12, 28, 0, 13, 3, _
   6, 8, 36, 25, 20, 16385, 17)

  offsets = Array(4, 9.5, -9, 6, -7, 2, -4, _
   -1, 3, 7, 8, 1, -5, 5.5, 10, -3, 2, _
   -4, -6, 9.5, -5, 2, -12, 12, 0, 10, 2, _
   -10, 10, 8, -5, 5, 2, 4.5, 0, 11, 0, _
   -6, -2, -11, 0, 3, -7, -3.5, 12, -8, 1, _
   1, -3, -6, 3.5, 9, 0, 12)

  locT = objSession.GetOption("TimeZone")
  locT = locT And Not(&H00004000)

  For locN = 0 To UBound(timeZones) - 1
    If locT = timeZones(locN) Then
      locT2 = offsets(locN)
      Exit For
    End If
  Next

  getTimeZoneOffset = locT2

End Function

Sub login

  Dim lstrProfile, lobjFolder

  Set objSession = Server.CreateObject("MAPI.Session")
  lstrProfile = SERVERNAME & vbLf & mb
  objSession.Logon "", "", False, True, 0, True, lstrProfile
  On Error Resume Next
  Err.Clear
  Set lobjFolder = objSession.Inbox
  errorCode = Err.Number
  If errorCode <> 0 Then
    rwbc UNABLETOOPENMAILBOXTEXT & COLONSPACETEXT & mb
    rwbc ERRORTEXT & COLONSPACETEXT & Err.Description
    rwbc EXCHANGESERVERNAMETEXT & COLONSPACETEXT & SERVERNAME
    rwbc USERNAMETEXT & COLONSPACETEXT & Request.ServerVariables("LOGON_USER")
  End If
  On Error Goto 0
  Set lobjFolder = Nothing

  ' Check if HTTP protocol is disabled for the current mailbox
  On Error Resume Next
  blnHTTPDisabled = False
  protocols = objSession.CurrentUser.Fields(&H81B6101F)
  For Each strProtocol in protocols
    If Instr(1, strProtocol, "HTTP", vbTextCompare) Then
      If "0" = Mid(strProtocol, 6, 1) Then blnHTTPDisabled = True
      Exit For
    End If
  Next
  On Error Goto 0
  If blnHTTPDisabled Then
    rwbc HTTPDISABLEDFORMAILBOXTEXT

    ' Bypass the remaining page output
    errorCode = 1
  End If

  If USERENDERER Then
    Set objRenderApplication = Application("RenderingApplication")
    Set objRenderer = objRenderApplication.CreateRenderer(2)
  End If

End Sub

Sub loginE2K

  Set info = createobject("adsysteminfo")
  Set infoNT = CreateObject("WinNTSystemInfo")
  strMailboxURL = "http://" & lcase(infoNT.ComputerName) & "." & Info.domaindnsname & "/exchange/" & mb
  strMailboxFileURL = "file://./backofficestorage/" & Info.domaindnsname & "/MBX/" & mb
  Set info = Nothing : Set infoNT = Nothing

  Set conn = CreateObject("ADODB.Connection")
  Set rec = CreateObject("ADODB.Record")
  conn.Provider =  "ExOLEDB.DataSource"
  conn.Open strMailboxURL
  rec.Open strMailboxURL, conn
  strInboxURL = Rec.Fields("urn:schemas:httpmail:inbox")
  strSentItemsURL = Rec.Fields("urn:schemas:httpmail:sentitems")
  strDeletedItemsURL = Rec.Fields("urn:schemas:httpmail:deleteditems")
  strContactsURL = Rec.Fields("urn:schemas:httpmail:contacts")
  strContacts = Right(strContactsURL, Len(strContactsURL) - InstrRev(strContactsURL, "/"))
  strContactsFileURL = strMailboxFileURL & "/" & strContacts
   
  rec.Close : Set rec = Nothing
  conn.Close : Set rec = Nothing

End Sub

Sub logoff

  If USERENDERER Then
    Set objRenderApplication = Nothing
    Set objRenderer = Nothing
  End If

  objSession.Logoff
  Set objSession = Nothing

End Sub

Sub rw(inText)

  Response.Write inText

End Sub

Sub rwbc(inText)

  rwc inText & "<br/>"

End Sub

Sub rwc(inText)

  rw inText & vbCrLf

End Sub

Function validDate(inDay, inMonth, inYear)

  Dim lBlnValid

  lBlnValid = True
  Select Case inMonth
    Case 4, 6, 9, 11
      If inDay > 30 Then lBlnValid = False
    Case 1, 3, 5, 7, 8, 10, 12
      If inDay > 31 Then lBlnValid = False
    Case 2
      If inYear/4 = Int(inYear / 4) Then
        If inDay > 29 Then lBlnValid = False
      Else
        If inDay > 28 Then lBlnValid = False
      End If
  End Select
  validDate = lBlnValid

End Function

Sub writeLink(inTarget, inTitle, inFlags)

  Dim lfn, lmi

  If fn <> "" Then lfn = fn : lfn = compressID(lfn)
  If mi <> "" Then lmi = mi : lmi = compressID(lmi)

  rw "<a href='" & inTarget
  rw "?mb=" & Server.URLEncode(mb)
  If inFlags And OPWFN Then rw AMPCHARS & "fn=" & Server.URLEncode(lfn)
  If inFlags And OPWMN Then rw AMPCHARS & "mn=" & Server.URLEncode(mn)
  If inFlags And OPWMI Then rw AMPCHARS & "mi=" & Server.URLEncode(lmi)
  If inFlags And OPWMT Then rw AMPCHARS & "mt=" & Server.URLEncode(mt)
  If inFlags And OPWRE Then rw AMPCHARS & "re=" & Server.URLEncode(re)
  If inFlags And OPWRY Then rw AMPCHARS & "ry=" & Server.URLEncode(ry)
  If inFlags And OPWRT Then rw AMPCHARS & "rt=" & Server.URLEncode(rt)
  If inFlags And OPWRC Then rw AMPCHARS & "rc=" & Server.URLEncode(rc)
  If inFlags And OPWRB Then rw AMPCHARS & "rb=" & Server.URLEncode(rb)
  If inFlags And OPWMDY Then rw AMPCHARS & "mdy=" & Server.URLEncode(mdy)
  If inFlags And OPWHM Then rw AMPCHARS & "hm=" & Server.URLEncode(hm)
  If inFlags And OPWPG Then rw AMPCHARS & "pg=" & Server.URLEncode(pg)
  If inFlags And OPWMP Then rw AMPCHARS & "mp=" & Server.URLEncode(mp)
  If inFlags And OPWDFILTER Then rw AMPCHARS & "filter=$(filter)"
  If RANDOMURLPARAM Then
    Randomize
    rw AMPCHARS & "r=" & Int(100000 * Rnd)
  End If
  rw "'>"
  rw displayEncode(inTitle)
  rw "</a>"
  If Not noLineBreaks Then
    rwbc ""
  Else
    rwc " "
  End If

End Sub

Sub writeMailboxLink

  writeLink "MBX.asp", BACKTOMAILBOXTEXT, 0

End Sub

Sub writePageEnd

  rwc "</p>" & vbCrLf & "</card>" & vbCrLf & "</wml>"

End Sub

Sub writePageStart(inTitle)

  Response.ContentType = "text/vnd.wap.wml"
  Response.Buffer = True
  Response.AddHeader "Cache-control", "no-cache, must-revalidate"
  rwc "<?xml version='1.0'?>"
  rwc "<!DOCTYPE wml PUBLIC '-//WAPFORUM//DTD WML 1.1//EN' 'http://www.wapforum.org/DTD/wml_1_1.xml'>"
  rwc "<wml>"
  rwc "<card title='" & inTitle & "' newcontext='true'>"
  If centred Then
    rwc "<p align='center'>"
  Else
    rwc "<p>"
  End If

End Sub

Sub writePostfields

  Dim lfn, lmi

  If fn <> "" Then lfn = fn : lfn = compressID(lfn)
  If mi <> "" Then lmi = mi : lmi = compressID(lmi)

  rwc "<postfield name='mb' value='" & mb & "'/>"
  rwc "<postfield name='fn' value='" & Server.URLEncode(lfn) & "'/>"
  rwc "<postfield name='mi' value='" & Server.URLEncode(lmi) & "'/>"
  If Int(mt) > 1 Then rwc "<postfield name='mt' value='" & Server.URLEncode(mt) & "'/>"

End Sub

Sub writeTitle(title)

 rwbc title

End Sub

Sub writeUnderline

 rwbc "---------------"

End Sub

' Common Form Output

Sub displayAppointment(inMessage)

  On Error Resume Next

  writeTitle DATETEXT & "/" & TIMETEXT & COLONSPACETEXT
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongDate)
  rwbc FormatDateTime(inMessage.Fields("{0220060000000000C000000000000046}0x820D"), vbLongTime)
  writeTitle DURATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8213")) & " " & MINTEXT
  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)
  writeTitle LOCATIONTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("{0220060000000000C000000000000046}0x8208"))
  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub

Sub displayContact(inMessage)

  On Error Resume Next

  writeTitle NAMETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)

  writeTitle TITLETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A17001F))

  writeTitle COMPANYTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A16001F))

  writeTitle EMAILTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8084", "0420060000000000C000000000000046"))

  writeTitle BUSINESSPHONETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A08001F))

  writeTitle MOBILETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H3A1C001F))

  writeTitle BUSINESSADDRESSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8045", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8046", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8047", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8048", "0420060000000000C000000000000046"))
  rwbc displayEncode(inMessage.Fields("0x8049", "0420060000000000C000000000000046"))

End Sub

Sub displayNote(inMessage)

  writeTitle NOTETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields(&H1000001F))

End Sub

Sub displayTask(inMessage)

  On Error Resume Next

  writeTitle SUBJECTTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Subject)

  writeTitle IMPORTANCETEXT & COLONSPACETEXT
  lImportance = inMessage.Fields(&H00170003)
  Select Case lImportance
    Case 0
      rwbc displayEncode(LOWTEXT)
    Case 1
      rwbc displayEncode(NORMALTEXT)
    Case 2
      rwbc displayEncode(HIGHTEXT)
  End Select

  writeTitle STATUSTEXT & COLONSPACETEXT
  lStatus = inMessage.Fields("0x8101", "0320060000000000C000000000000046")
  Select Case lStatus
    Case 0
      rwbc displayEncode(OPENTEXT)
    Case 1
      rwbc displayEncode(INPROGRESSTEXT)
    Case 2
      rwbc displayEncode(COMPLETEDTEXT)
    Case 3
      rwbc displayEncode(WAITINGONSOMEONEELSETEXT)
    Case 4
      rwbc displayEncode(DEFERREDTEXT)
  End Select

  writeTitle PERCENTCOMPLETETEXT & COLONSPACETEXT
  lPercentComplete = inMessage.Fields("0x8102", "0320060000000000C000000000000046")
  rwbc 100 * lPercentComplete & "%"

  writeTitle STARTDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8104", "0320060000000000C000000000000046"))

  writeTitle DUEDATETEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Fields("0x8105", "0320060000000000C000000000000046"))

  writeTitle DETAILSTEXT & COLONSPACETEXT
  rwbc displayEncode(inMessage.Text)

End Sub

Sub listAppointments(inReadPage)

  Dim lStrPageName

  On Error Resume Next

  lStrPageName = Request.ServerVariables("URL")
  p = InstrRev(lStrPageName, "/")
  If p <> 0 Then lStrPageName = Right(lStrPageName, Len(lStrPageName) - p)

  dy = Mid(mdy, 4, 2)
  mo = Left(mdy, 2)
  yr = Right(mdy, 4)

  If (dy = "") Or (mo = "") Or (yr = "") Then
    dy = Day(Date) : mo = Month(Date) : yr = Year(Date)
    mdy = Right("0" & mo, 2) & "/" & Right("0" & dy, 2) & "/" & yr
  End If

  rwbc MMDDYYYYTEXT & COLONSPACETEXT

  rwbc "<input type='text' name='mdy' format='NN\/NN\/NNNN' value='" & displayEncode(mdy) & "' emptyok='true'/>"

  rwc "<do type='accept' label='" & GOTEXT & "'>"

    rwc "<go href='" & lStrPageName & "' method='get'>"

      rwc "<postfield name='mb' value='" & mb & "'/>"
      rwc "<postfield name='fn' value='" & fn & "'/>"
      rwc "<postfield name='mdy' value='$(mdy)'/>"

    rwc "</go>"

  rwc "</do>"

  If validDate(dy, mo, yr) Then

    Set objMessages = objFolder.Messages

    objMessages.Sort 1, &H00610040

    Set myFilter = objMessages.Filter

    myStartDate = DateSerial(yr, mo, dy) + TimeSerial(0, 0, 1)

    writeTitle APPOINTMENTSTEXT & COLONSPACETEXT
    writeTitle FormatDateTime(myStartDate, vbLongDate)

    'Starting Date = CDO's ends on or after date
    myFilter.Fields.Add &H00610040, myStartDate

    'Ending Date = CDO's starts on or before date
    myEndDate = myStartDate - TimeSerial(0, 0, 1) + TimeSerial(23, 59, 59)
    myFilter.Fields.Add &H00600040, myEndDate

    numberOfMessages = 0
    For Each objMessage In objMessages
      numberOfMessages = numberOfMessages + 1
    Next

    If mn > numberOfMessages Then mn = ((Int(numberOfMessages / APPOINTMENTSPERPAGE) - 1) * APPOINTMENTSPERPAGE) + 1
    If mn < 1 Then mn = 1

    firstMessage = mn
    If mn + (APPOINTMENTSPERPAGE - 1) > numberOfMessages Then
      lastMessage = numberOfMessages
    Else
      lastMessage = mn + (APPOINTMENTSPERPAGE - 1)
    End If

    If numberOfMessages > 0 Then
      writeTitle firstMessage & "-" & lastMessage & " " & OFTEXT & " " & numberOfMessages
    End If

    noLineBreaks = True
    t = False

    If mn > 1 Then
      oldmn = mn : mn = 1
      writeLink lStrPageName, TOPTEXT, OPWMDY + OPWFN + OPWMN
      mn = oldmn
      t = True
    End If

    If mn > APPOINTMENTSPERPAGE Then
      oldmn = mn : mn = mn - APPOINTMENTSPERPAGE
      writeLink lStrPageName, PREVIOUSTEXT & " " & APPOINTMENTSPERPAGE, OPWMDY + OPWFN + OPWMN
      mn = oldmn
      t = True
    End If

    If mn <= (numberOfMessages - APPOINTMENTSPERPAGE) Then
      oldmn = mn : mn = mn + APPOINTMENTSPERPAGE
      writeLink lStrPageName, NEXTTEXT & " " & APPOINTMENTSPERPAGE, OPWMDY + OPWFN + OPWMN
      mn = oldmn
      t = True
    End If

    If t Then rwbc ""
    noLineBreaks = False

    writeUnderline

    messageCounter = 0
    messagesDisplayed = 0
    For Each objMessage In objMessages

      If (messageCounter >= firstMessage - 1) And (messageCounter <= lastMessage - 1) Then

        display = FormatDateTime(objMessage.Fields("{0220060000000000C000000000000046}0x820D"), 3)
        display = display & "_"
        subject = objMessage.Subject
        If subject = "" Then subject = NONETEXT
        display = display & Left(subject & "        ", FOLDERSUBJECTWIDTH)
        display = displayEncode(display)
        mi = objMessage.ID
        writeLink inReadPage, display, OPWFN + OPWMN + OPWMI + OPWMDY
        messagesDisplayed = messagesDisplayed + 1
        If messagesDisplayed >= APPOINTMENTSPERPAGE Then Exit For

      End If

      messageCounter = messageCounter + 1

    Next

    Set myFilter = Nothing
    Set objMessages = Nothing

    If messageCounter = 0 Then
      rwbc NOAPPOINTMENTSFORSELECTEDDAYTEXT
    End If

  Else
    rwbc INVALIDDATETEXT
  End If

End Sub

Sub listContacts(inReadPage)

  Dim lStrPageName

  On Error Resume Next

  lStrPageName = Request.ServerVariables("URL")
  p = InstrRev(lStrPageName, "/")
  If p <> 0 Then lStrPageName = Right(lStrPageName, Len(lStrPageName) - p)

  myFilter = Request.QueryString("filter")

  writeTitle FILTERTEXT & COLONSPACETEXT

  rwbc "<input type='text' name='filter' value='" & myFilter & "' emptyok='true'/>"

  writeLink lStrPageName, OKTEXT, OPWFN + OPWDFILTER

  Set objMessages = objFolder.Messages

  If myFilter <> "" Then

    Set objFilter = objMessages.Filter

    ' Add a filter for Name
    objFilter.Fields(&H0E1D001F) = myFilter

  End If

  objMessages.Sort 1, &H0E1D001F

  n = 0
  For Each objMessage In objMessages

    mi = objMessage.ID
    writeLink inReadPage, objMessage.Subject, OPWFN + OPWMI
    n = n + 1
    If n >= ADDRESSESPERPAGE Then Exit For

  Next

  If n >= ADDRESSESPERPAGE Then

    rwbc ""
    rwbc DISPLAYLIMITEDTOTEXT & " " & ADDRESSESPERPAGE & " " & ENTRIESTEXT

  End If

End Sub

Sub listTasks(inReadPage)

  Dim lStrPageName

  On Error Resume Next

  lStrPageName = Request.ServerVariables("URL")
  p = InstrRev(lStrPageName, "/")
  If p <> 0 Then lStrPageName = Right(lStrPageName, Len(lStrPageName) - p)

  oldmp = mp
  If mp = "" Then
    mp = 1
    writeLink lStrPageName, LISTALLTASKSTEXT, OPWFN + OPWMP
    blnShowAllTasks = False
  Else
    mp = ""
    writeLink lStrPageName, LISTOPENTASKSTEXT, OPWFN + OPWMP
    blnShowAllTasks = True
  End If
  mp = oldmp

  Set objMessages = objFolder.Messages

  ' Are we showing ALL Tasks, or only the incomplete ones?
  If Not blnShowAllTasks Then
    Set locObjFilter = objMessages.Filter
    locObjFilter.Fields.Add "{0320060000000000C000000000000046}0x811C", vbBoolean, False
  End If

  ' Get GUID-based Due Date property ID
  Set objTaskMessage = objFolder.Messages.GetFirst()

  ' Can't attempt to sort if there are no Tasks
  If Not(objTaskMessage Is Nothing) Then
    Set objFields = objTaskMessage.Fields
    If SHOWERRORS Then On Error Resume Next
    Set objDueDateField = objFields.Item("{0320060000000000C000000000000046}0x8105")
    If Err.Number <> 0 Then
      objTaskMessage.Fields.Add "{0320060000000000C000000000000046}0x8105", vbLong, 0
      Set objDueDateField = objFields.Item("{0320060000000000C000000000000046}0x8105")
    End If
    If SHOWERRORS Then On Error Goto 0
    strDueDateField =  objDueDateField.ID
    Set objDueDateField = Nothing
    Set objFields = Nothing
    Set objTaskMessage = Nothing

    ' Sort Tasks in descending order of Due Date
    objMessages.Sort 2, strDueDateField
  End If

  numberOfMessages = 0
  For Each objMessage In objMessages
    numberOfMessages = numberOfMessages + 1
  Next

  If mn > numberOfMessages Then mn = ((Int(numberOfMessages / TASKSPERPAGE) - 1) * TASKSPERPAGE) + 1
  If mn < 1 Then mn = 1

  firstMessage = mn
  If mn + (TASKSPERPAGE - 1) > numberOfMessages Then
    lastMessage = numberOfMessages
  Else
    lastMessage = mn + (TASKSPERPAGE - 1)
  End If

  If numberOfMessages > 0 Then
    writeTitle firstMessage & "-" & lastMessage & " " & OFTEXT & " " & numberOfMessages
  End If

  noLineBreaks = True
  t = False

  If mn > 1 Then
    oldmn = mn : mn = 1
    writeLink lStrPageName, TOPTEXT, OPWFN + OPWMN + OPWMP
    mn = oldmn
    t = True
  End If

  If mn > TASKSPERPAGE Then
    oldmn = mn : mn = mn - TASKSPERPAGE
    writeLink lStrPageName, PREVIOUSTEXT & " " & TASKSPERPAGE, OPWFN + OPWMN + OPWMP
    mn = oldmn
    t = True
  End If

  If mn <= (numberOfMessages - TASKSPERPAGE) Then
    oldmn = mn : mn = mn + TASKSPERPAGE
    writeLink lStrPageName, NEXTTEXT & " " & TASKSPERPAGE, OPWFN + OPWMN + OPWMP
    mn = oldmn
    t = True
  End If

  If t Then rwbc ""
  noLineBreaks = False

  writeUnderline

  messageCounter = 0
  messagesDisplayed = 0
  For Each objMessage In objMessages
    If (messageCounter >= firstMessage - 1) And (messageCounter <= lastMessage - 1) Then

      display = ""
      display = objMessage.Subject
      If display = "" Then display = NONETEXT
      mi = objMessage.ID
      writeLink inReadPage, display, OPWFN + OPWMI + OPWMN + OPWMP
      messagesDisplayed = messagesDisplayed + 1
      If messagesDisplayed >= TASKSPERPAGE Then Exit For

    End If
    messageCounter = messageCounter + 1
  Next

  Set objMessages = Nothing

  If messageCounter = 0 Then
    writeUnderline
    rwbc NONETEXT
  End If

End Sub
%>
