#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <time.h>

#define VERSION_STRING "0.11"

struct {
  int size;
  char rule[16];
  int color0,color1;
} param={127,"12359",0,0xffffff};

struct {
  int size;
  char *S,*D;
  char *I; // source state,destination state,image 
  char rule[16];
  int  step;
  double steps;
  int noblt;
} state;


void *StateAlloc(int size) {
  int size2=size/2+1;
  int msize=(size2*size2+9*size2+8)/2+10;
  void *m;

  m=malloc(msize);
  memset(m,0,msize);
  return m;
}

// copy image octets 
void State2Image(char *image,char *src,int size)  { 
  register int size2=size/2+1;
  //register int *ih,*ih2,*ih3,*ih4;
  register char *ih,*ih2,*ih3,*ih4;
  register unsigned char *sh;
  register int x,y;
  int bpl=(size+3)&~3;

  ih4=ih3=ih2=ih=image+(size2-1)*(bpl+1);
  sh=src+4;
  // bottom half
  for(y=1;y<=size2;y++) {
    for(x=0;x<y;x++) {
      *ih4=*ih3--=*ih2=*ih++=*sh++;
      ih4+=bpl,ih2+=bpl;
    }
    sh+=3;
    ih+=bpl-y;
    ih2+=1-y*bpl;
    ih3+=bpl+y;
    ih4+=-1-y*bpl;
  }

  ih2=ih=image+(size2-1)*bpl;
  for(y=1;y<size2;y++) 
    memcpy((ih2-=bpl),(ih+=bpl),bpl);
}

// Faster octet step
void State2State(char *dst,char *src,int size,char *rule) {
  register unsigned char *h,*g;
  register int s0,s1,s2;
  register int x,y,size2;
  
  size2=size/2+1;
  // fill boundary
  h=src;
  h[0]=h[2]=h[9];
  h[1]=h[3]=h[8];
  h+=4;
  for(y=1;y<=size2;y++) {
    h+=y;
    *h++=h[3];
    *h++=h[y+2];
    *h++=h[2];//h[2*y+6];
  }
  // perform step
  h=src+3,g=dst+4;
  for(y=1;y<=size2;y++) {
    s0=h[-y-2]+h[0]+h[y+3];h++;
    s1=h[-y-2]+h[0]+h[y+3];h++;
    s2=h[-y-2]+h[0]+h[y+3];h++;
    for(x=0;x<y;x++) {
      *g++=rule[s0+s1+s2];
      s0=s1,s1=s2;
      s2=h[-y-2]+h[0]+h[y+3];h++;
    }
    g+=3;
  }
}

void StateDuality(char *dst,char *src,int size) {
  register int i,j,sd;
  register char *s;
  
  size=size/2+1;
  dst+=4;
  src+=3+size*(size+1)/2+3*size-3;
  for(j=1;j<=size;j++) {
    s=src;
    sd=size+2;
    for(s=src,i=1;i<=j;i++) {
      *dst++=*s;
      s-=sd--;
    }
    dst+=3;
    src--;
  }
}


void StateRandomize(char *dst,int size) {
  register int i,j;
  static char init=1;
 
  if(init) {
    srand(time(NULL));
    init=0;
  }
  
  size=size/2+1;
  dst+=4;
  for(j=1;j<=size;j++) {
    for(i=1;i<=j;i++) 
      *dst++=rand()&1;
    dst+=3;
  }
}

void StateInverse(char *dst,int size) {
  register int i,j;
 
  size=size/2+1;
  dst+=4;
  for(j=1;j<=size;j++) {
    for(i=1;i<=j;i++) 
      *dst++^=1;
    dst+=3;
  }
}

void SetRule(const char *rule) {
  register const char *h;
  
  memset(state.rule,0,sizeof(state.rule));
  for(h=rule;*h;h++)
    if(*h>='0'&&*h<='9')
      state.rule[*h-'0']=1;
}

#include <windows.h>
#include "define.h"

int SwapRgb(int c) {
  register char cr,*cp=(char*)&c;
  cr=cp[0],cp[0]=cp[2],cp[2]=cr;
  return c;
}

int ChangeColor(int *color) {
  CHOOSECOLOR chc;
  static COLORREF cust[16];
 
  memset(&chc,0,sizeof(chc));
  chc.lStructSize=sizeof(chc);
  chc.rgbResult=SwapRgb(*color);
  chc.lpCustColors=cust;
  chc.Flags=CC_FULLOPEN|CC_RGBINIT;

  if(ChooseColor(&chc)) {
    *color=SwapRgb(chc.rgbResult)&0xffffff;  
    return 1;
  }
  return 0;
}

HDC dc;
HWND hWnd;
HINSTANCE hInstance=NULL;
BITMAPINFO *bi;
volatile int DlgRule=0;
HWND hWndRule=NULL;

int CreateBIH8(BITMAPINFO **bi,int width,int height
    ,COLORREF color0,COLORREF color1,char **bits) {
  BITMAPINFOHEADER *bih;
  COLORREF *c;
  int bpl=(width+3)&~3;

  if(!*bi) *bi=malloc(sizeof(BITMAPINFOHEADER)+2*sizeof(RGBQUAD));
  bih=&(*bi)->bmiHeader;
  bih->biSize=sizeof(*bih);
  bih->biWidth=width;
  bih->biHeight=height;
  bih->biPlanes=1;
  bih->biBitCount=8;
  bih->biCompression=BI_RGB;
  bih->biSizeImage=width*height;
  bih->biXPelsPerMeter=0;
  bih->biYPelsPerMeter=0;
  bih->biClrUsed=2;
  bih->biClrImportant=0;
  if(*bits) free(*bits);
  *bits=malloc(bpl*height);
  c=(COLORREF*)(*bi)->bmiColors;
  c[0]=color0;
  c[1]=color1;
  return 0;
}

void Redraw(HWND hwnd) {
  int i;
  i=SetDIBitsToDevice(dc,0,0,state.size,state.size
    ,0,0,0,state.size,state.I,bi,DIB_RGB_COLORS
  );
}

char *fn_file(char *fullname) { // vrati ukazatel na jmeno souboru (odrizne disk a adresar)
  char *p,*q;
  for(q=p=fullname;*p;p++)
    if(*p=='\\'||*p==':')
      q=p+1;
  return q;
}

int AskSaveFilename(char *file,char *title,char *filter) {
  char *fs,filename[256],dir[256];
  OPENFILENAME of;
  int r;

  memset(&of,0,sizeof(of));
  of.lStructSize=sizeof(of);
  of.hwndOwner=hWnd;
  of.Flags=OFN_LONGNAMES|OFN_OVERWRITEPROMPT|OFN_HIDEREADONLY;

  strcpy(filename,file);
  of.lpstrTitle=title;
  of.lpstrFilter=filter;
  fs=fn_file(filename);
  if(fs>filename) {
    fs[-1]=0;
    strcpy(dir,filename);
    strcpy(filename,fs);
    of.lpstrInitialDir=dir;
  } else {
    GetCurrentDirectory(sizeof(dir),dir);
    of.lpstrInitialDir=dir;
  }
  of.lpstrFile=filename;
  of.nMaxFile=sizeof(filename);

  if((r=GetSaveFileName(&of))) strcpy(file,filename);
  return r;
}

int writebmp() {
  BITMAPFILEHEADER bfh;
  int s1,s2,s3,bpl;
  static char filename[256]="out.bmp";
  FILE *f;

  if(!AskSaveFilename(filename,"Export BMP","Bitmaps (*.bmp)\0*.bmp\0All files (*.*)\0*.*\0"))
    return -1;

  if(!(f=fopen(filename,"wb")))
    return -2;
  s1=sizeof(bfh);
  s2=sizeof(bi->bmiHeader)+2*sizeof(RGBQUAD);
  bpl=(bi->bmiHeader.biWidth+3)&~3;
  s3=bpl*(bi->bmiHeader.biHeight);
  bfh.bfType='B'|('M'<<8);
  bfh.bfSize=s1+s2+s3;
  bfh.bfReserved1=0;
  bfh.bfReserved2=0;
  bfh.bfOffBits=s1+s2;
  fwrite(&bfh,s1,1,f);
  fwrite(bi,s2,1,f);
  fwrite(state.I,s3,1,f);
  fclose(f);
  return 0;
}

void do_command(int cmd) {
}

void printhelp();

BOOL CALLBACK DialogRuleCallBack(HWND wnd,UINT uMsg,WPARAM wParam, LPARAM lParam) {
  register int i,b;

  switch(uMsg) {
//   case WM_INITDIALOG:return 0;
   case WM_COMMAND: {
      switch(LOWORD(wParam)) {
       case UM_DlgRuleSum0:
       case UM_DlgRuleSum1:
       case UM_DlgRuleSum2:
       case UM_DlgRuleSum3:
       case UM_DlgRuleSum4:
       case UM_DlgRuleSum5:
       case UM_DlgRuleSum6:
       case UM_DlgRuleSum7:
       case UM_DlgRuleSum8:
       case UM_DlgRuleSum9:
        b=IsDlgButtonChecked(wnd,wParam)?0:1;
        CheckDlgButton(wnd,wParam,b);
        i=LOWORD(wParam)-UM_DlgRuleSum0;
        state.rule[i]=b;
        break;
       case IDCANCEL:
       case IDOK:
        DlgRule=0;
        hWndRule=NULL;
        EndDialog(wnd,0);
        break;
      }
    } break;
   case WM_INITDIALOG:{
     hWndRule=wnd;
     for(i=0;i<=9;i++)
       CheckDlgButton(wnd,UM_DlgRuleSum0+i,state.rule[i]?1:0);
    } break;
  }
  return 0;
}

long FAR PASCAL WndProc (HWND hWnd, UINT iMessage,
    WPARAM wParam, LPARAM lParam) {
  switch(iMessage)  {
        case WM_PAINT: {
         PAINTSTRUCT ps;
         BeginPaint(hWnd,&ps);
         Redraw(hWnd);
         // repaint(ps.hdc);
         EndPaint(hWnd,&ps);
        } break;
        case WM_COMMAND:
         do_command(LOWORD(wParam));
         break;
	case WM_SIZE:{
          Redraw(hWnd);
	} break;
	case WM_DESTROY:
        quit:
	 PostQuitMessage(0);
	 return 0;
        case WM_KEYDOWN:
         switch(wParam) {
          case 'H':
          case VK_F1:
           printhelp();
           break;
          case 'B':
           if(ChangeColor(&param.color0))
             ((COLORREF*)bi->bmiColors)[0]=param.color0;
           Redraw(hWnd);
           break;
          case 'F':
           if(ChangeColor(&param.color1))
             ((COLORREF*)bi->bmiColors)[1]=param.color1;
           Redraw(hWnd);
           break;
          case 'C':
           state.S[4]=!state.S[4];
           goto updateimage;
          case 'D': {
             void *r;
             StateDuality(state.D,state.S,state.size);
             r=state.S,state.S=state.D,state.D=r;
           }
           goto updateimage;
          case 'I':
           StateInverse(state.S,state.size);
           goto updateimage;
          case 'X':
           StateRandomize(state.S,state.size);
          updateimage:
           State2Image(state.I,state.S,state.size);
           Redraw(hWnd);
           break;
          case 'R':
           if(!DlgRule) {
             DlgRule=1;
             CreateDialog(hInstance,"DialogRule",hWnd,DialogRuleCallBack);
           } else if(hWndRule)
             SetForegroundWindow(hWndRule);
           //DialogBox(hInstance,"DialogRule",hWnd,DialogRuleCallBack);
           break;
          case 'W':
           writebmp();
           break;
          case 'Q':
           goto quit;
         }
         break;
        case WM_LBUTTONDBLCLK:
         break;
 	case WM_LBUTTONDOWN:
         if(state.step) state.noblt=!state.noblt;
         state.step=~1;
         SetWindowText(hWnd,"Stepping");
         break;
	case WM_RBUTTONDOWN:
         state.step=1;
         state.noblt=0;
         break;
//	case WM_MOUSEMOVE:
          //SetFocus(hWnd);
          if(wParam&MK_RBUTTON) {
          }
          if(wParam&MK_LBUTTON) {
          }
	 break;
	default:
	 return(DefWindowProc(hWnd, iMessage, wParam, lParam));
  }
  return 0;
}

void printhelp() {
  static const char *Help=
   "cellscop [-s size] [-r rule] [-0 color0] [-1 color1]\n\n"
   "  -s size  : set half of window (for example: -s 127)\n"
   "  -r rule  : rule, sequence of digits for one in next step (-r123789)\n"
   "  -0 color : set color 0, decimal number or 0x prefix for hexadecimal (-0 0)\n"
   "  -1 color : set color 1 (-1 0x44ccff)\n"
   "\nGood rules : -r123459 -r1357 -r1234567 -r123 -r1235 -r9870\n"
   "\nLeft Click : start automat / disable or enable window update\n"
   "Right Click: stop automat / one step\n"
   "F,B        : change foreground,background color\n"
   "W          : write bmp\n"
   "R          : change rule\n"
   "C          : invert central cell\n"
   "X          : randomize\n"
   "D          : duality\n"
   "I          : inverse\n"
   "<F1>,H     : this help\n"
  ;
  MessageBox(NULL,Help,"CellScop " VERSION_STRING " Help",MB_OK);
}

char *StrWord(char *str,int wlen,char *word) {
  while(*str>0&&*str<=' ') str++;
  while(*str<0||*str>' ') {
    if(wlen>1) 
      wlen--,*word++=*str;
    str++;
  }
  if(wlen>0) 
    *word=0;
  return str;
}

int PASCAL WinMain(HINSTANCE hCurInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow) {
  MSG Message;
//  HMENU hmenu;
  WNDCLASS WndClass;
  char *h;

  for(h=lpCmdLine;*h;) {
    while(*h&&(*h==' '||*h=='\t')) h++;
    if(*h!='-')
      break;
    h++;
    puts(h);
    while(*h&&*h!=' '&&*h!='\t') {
      switch(*h++) {
       case 's':param.size=strtol(h,&h,0)|1;break;
       case 'r':h=StrWord(h,sizeof(param.rule),param.rule);break;
       case '0':param.color0=strtol(h,&h,0);break;
       case '1':param.color1=strtol(h,&h,0);break;
       case 'h':
       default:
        printhelp();
        return h[-1]!='h';
        break;
      }
    }
  }


  WndClass.cbClsExtra = 0;
  WndClass.cbWndExtra = 0;
  WndClass.hbrBackground = GetStockObject(WHITE_BRUSH);
  WndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
  WndClass.hIcon = LoadIcon (hCurInstance, "main_icon");
  WndClass.hInstance = hCurInstance;
  WndClass.lpfnWndProc = WndProc;
  WndClass.lpszClassName = "CellScop";
  WndClass.lpszMenuName = NULL;//"menu_main";
  WndClass.style = CS_HREDRAW | CS_VREDRAW;
  RegisterClass(&WndClass);

  //hInstance=hCurInstance;
  state.size=param.size;
  state.S=StateAlloc(state.size);
  state.D=StateAlloc(state.size);
  
  
  SetRule(param.rule);

  state.step=state.size/2;
  ((char*)state.S)[4]=1;

  bi=NULL;
  CreateBIH8(&bi,state.size,state.size,param.color0,param.color1,&state.I);

  { int wx,wy;
    RECT r;
 
    //rx=GetSystemMetrics(SM_CXFRAME);
    //ry=GetSystemMetrics(SM_CYFRAME);
    hWnd = CreateWindow ("CellScop","Cell Scope",WS_CAPTION|WS_SYSMENU
       ,100,100,state.size,state.size,
       NULL,NULL,hCurInstance,NULL);
    dc=GetDC(hWnd);

    GetClientRect(hWnd,&r);
    wx=2*state.size-r.right;
    wy=2*state.size-r.bottom;
    MoveWindow(hWnd,100,100,wx,wy,0);

    ShowWindow (hWnd, SW_NORMAL);
  }

  UpdateWindow(hWnd);

  for(;;) {
   peek:
    if(state.step) {
      if(!PeekMessage (&Message, 0, 0, 0,PM_REMOVE))
        goto step;
      else
        if(Message.message==WM_QUIT) 
          break;
    } else
      if(!GetMessage(&Message,0,0,0))
        break;
    TranslateMessage(&Message);
    DispatchMessage(&Message);
    goto peek;
   step:
    { void *r;
      State2State(state.D,state.S,state.size,state.rule);
      r=state.S,state.S=state.D,state.D=r;
      if(!state.noblt) { 
        State2Image(state.I,state.S,state.size);
        Redraw(hWnd);
      }
    }
    state.step--;
    state.steps++;
    if(!state.step) {
      char buf[32];
      sprintf(buf,"%.0f",state.steps);
      SetWindowText(hWnd,buf);
    }

  }

  free(state.S);
  free(state.D);
  free(bi);
  free(state.I);

  return Message.wParam;
}

