/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;

class ReadConfig {
    private loadbalanced m;
    private boolean LOGGING;
    public Vector services;
    public Vector virtuals;

    public ReadConfig(loadbalanced loadbalanced2, String string) throws Exception {
        File file = new File(string);
        int n = 0;
        this.virtuals = new Vector(10);
        this.services = new Vector(10);
        this.m = loadbalanced2;
        this.LOGGING = loadbalanced.LOGGING;
        if (file.exists()) {
            n = (int)file.length();
            System.out.println("Found " + n + " byte configuration file: " + string);
            if (this.LOGGING) {
                loadbalanced2.logEvent("Found " + n + " byte configuration file: " + string);
            }
        } else {
            System.out.println("No configuration file found");
            if (this.LOGGING) {
                loadbalanced2.logEvent("No configuration file found");
            }
            throw new Exception("ReadConfig Error: No configuration file found");
        }
        char[] cArray = new char[n];
        try {
            FileReader fileReader = new FileReader(string);
            ((Reader)fileReader).read(cArray, 0, n);
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            loadbalanced2.logEvent("Configuration File Error");
            throw new Exception("ReadConfig Exception: " + exception);
        }
        this.processconfig(new String(cArray));
    }

    private void processconfig(String string) throws Exception {
        Object object;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        VirtualClass virtualClass = null;
        ServiceClass serviceClass = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        if (this.LOGGING) {
            this.m.logEvent("Processing");
        }
        try {
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2;
                string2 = stringTokenizer.nextToken();
                string2 = string2.trim();
                ++n;
                if (string2.length() == 0 || string2.startsWith("#")) continue;
                if (string2.startsWith("LOGGING")) {
                    stringTokenizer2 = new StringTokenizer(string2);
                    object = stringTokenizer2.nextToken();
                    String string3 = stringTokenizer2.nextToken();
                    object = ((String)object).trim();
                    string3 = string3.trim();
                    if (!((String)object).equals("LOGGING")) continue;
                    if (string3.equals("false")) {
                        loadbalanced.LOGGING = false;
                        continue;
                    }
                    loadbalanced.LOGGING = true;
                    continue;
                }
                if (string2.startsWith("THREAD_LOGGING")) {
                    stringTokenizer2 = new StringTokenizer(string2);
                    object = stringTokenizer2.nextToken();
                    String string4 = stringTokenizer2.nextToken();
                    object = ((String)object).trim();
                    string4 = string4.trim();
                    if (!((String)object).equals("THREAD_LOGGING")) continue;
                    if (string4.equals("false")) {
                        loadbalanced.THREAD_LOGGING = false;
                        continue;
                    }
                    loadbalanced.THREAD_LOGGING = true;
                    continue;
                }
                if (string2.startsWith("VERBOSE")) continue;
                if (string2.startsWith("PASSWORD")) {
                    stringTokenizer2 = new StringTokenizer(string2);
                    object = stringTokenizer2.nextToken();
                    String string5 = stringTokenizer2.nextToken();
                    object = ((String)object).trim();
                    string5 = string5.trim();
                    if (!((String)object).equals("PASSWORD")) continue;
                    this.m.setCommandPassword(string5);
                    continue;
                }
                if (string2.startsWith("COMMAND_PORT")) {
                    stringTokenizer2 = new StringTokenizer(string2);
                    object = stringTokenizer2.nextToken();
                    String string6 = stringTokenizer2.nextToken();
                    object = ((String)object).trim();
                    string6 = string6.trim();
                    if (!((String)object).equals("COMMAND_PORT")) continue;
                    this.m.setCommandPort(Integer.parseInt(string6));
                    continue;
                }
                if (string2.startsWith("COMMAND_TIMEOUT")) {
                    stringTokenizer2 = new StringTokenizer(string2);
                    object = stringTokenizer2.nextToken();
                    String string7 = stringTokenizer2.nextToken();
                    object = ((String)object).trim();
                    string7 = string7.trim();
                    if (!((String)object).equals("COMMAND_TIMEOUT")) continue;
                    this.m.setCommandTimeout(Integer.parseInt(string7));
                    continue;
                }
                if (string2.startsWith("PROMPT")) {
                    stringTokenizer2 = new StringTokenizer(string2);
                    object = stringTokenizer2.nextToken();
                    String string8 = stringTokenizer2.nextToken();
                    object = ((String)object).trim();
                    string8 = string8.trim();
                    if (!((String)object).equals("PROMPT")) continue;
                    this.m.setCommandPrompt(string8);
                    continue;
                }
                if (string2.startsWith("service")) {
                    stringTokenizer2 = new StringTokenizer(string2, " ");
                    stringTokenizer2.nextToken();
                    serviceClass = new ServiceClass(this.m);
                    serviceClass.setName(stringTokenizer2.nextToken());
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (string2.startsWith("virtual")) {
                    stringTokenizer2 = new StringTokenizer(string2, " ");
                    stringTokenizer2.nextToken();
                    virtualClass = new VirtualClass(this.m);
                    virtualClass.setVirtualName(stringTokenizer2.nextToken());
                    bl2 = true;
                    bl = false;
                    continue;
                }
                if (string2.startsWith("}")) {
                    if (bl2) {
                        bl2 = false;
                        this.virtuals.add(virtualClass);
                    }
                    if (bl) {
                        bl = false;
                        this.services.add(serviceClass);
                    }
                    bl = false;
                    continue;
                }
                if (string2.equals("shutdown")) {
                    if (bl2) {
                        virtualClass.setStatus(string2);
                    }
                    if (!bl) continue;
                    serviceClass.setStatus(string2);
                    continue;
                }
                if (string2.indexOf("sticky") != -1 && bl2) {
                    stringTokenizer2 = new StringTokenizer(string2, " ");
                    stringTokenizer2.nextToken();
                    virtualClass.setStickyTime(Integer.valueOf(stringTokenizer2.nextToken()));
                    continue;
                }
                if (string2.indexOf("address") != -1) {
                    if (bl2) {
                        stringTokenizer2 = new StringTokenizer(string2, " ");
                        stringTokenizer2.nextToken();
                        virtualClass.setAddress(stringTokenizer2.nextToken());
                    }
                    if (!bl) continue;
                    stringTokenizer2 = new StringTokenizer(string2, " ");
                    stringTokenizer2.nextToken();
                    serviceClass.setAddress(stringTokenizer2.nextToken());
                    continue;
                }
                if (string2.indexOf("port") != -1) {
                    if (bl2) {
                        stringTokenizer2 = new StringTokenizer(string2, " ");
                        stringTokenizer2.nextToken();
                        virtualClass.setPort(Integer.valueOf(stringTokenizer2.nextToken()));
                    }
                    if (!bl) continue;
                    stringTokenizer2 = new StringTokenizer(string2, " ");
                    stringTokenizer2.nextToken();
                    serviceClass.setPort(Integer.valueOf(stringTokenizer2.nextToken()));
                    continue;
                }
                if (string2.indexOf("add") != -1) {
                    if (!bl2) continue;
                    stringTokenizer2 = new StringTokenizer(string2, " ");
                    stringTokenizer2.nextToken();
                    object = stringTokenizer2.nextToken();
                    int n2 = 0;
                    while (n2 < this.services.size()) {
                        ServiceClass serviceClass2 = (ServiceClass)this.services.elementAt(n2);
                        if (serviceClass2.getName().equals(object)) {
                            virtualClass.addService(serviceClass2);
                        }
                        ++n2;
                    }
                    continue;
                }
                if (string2.indexOf("keepalive_timeout") != -1) {
                    if (!bl) continue;
                    stringTokenizer2 = new StringTokenizer(string2, " ");
                    stringTokenizer2.nextToken();
                    serviceClass.setKeepAliveTimeOut(Integer.valueOf(stringTokenizer2.nextToken()));
                    continue;
                }
                if (string2.indexOf("keepalive_frequency") != -1) {
                    if (!bl) continue;
                    stringTokenizer2 = new StringTokenizer(string2, " ");
                    stringTokenizer2.nextToken();
                    object = stringTokenizer2.nextToken();
                    serviceClass.setKeepAliveFrequency(Integer.valueOf((String)object));
                    continue;
                }
                if (string2.indexOf("keepalive_maxfails") != -1) {
                    if (!bl) continue;
                    stringTokenizer2 = new StringTokenizer(string2, " ");
                    stringTokenizer2.nextToken();
                    object = stringTokenizer2.nextToken();
                    serviceClass.setKeepAliveMaxFailure(Integer.valueOf((String)object));
                    continue;
                }
                throw new Exception("Unknown Configuration Error Line " + n + " -- " + string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            System.out.println("Error Processing Configuration File Line " + n + " -- " + string2);
            if (this.LOGGING) {
                this.m.logEvent("Error Processing Configuration File " + n + " -- " + string2);
            }
            throw new Exception("Error Processing Configuration File " + n + " -- " + string2);
        }
        this.m.logEvent("Completed");
        int n3 = 0;
        while (n3 < this.virtuals.size()) {
            object = (VirtualClass)this.virtuals.elementAt(n3);
            if (this.LOGGING) {
                this.m.logEvent("Virtual: " + ((VirtualClass)object).getVirtualName() + " " + ((VirtualClass)object).getAddress() + ":" + ((VirtualClass)object).getPort() + " Status: " + ((VirtualClass)object).getStatus());
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.services.size()) {
            ServiceClass serviceClass3 = (ServiceClass)this.services.elementAt(n4);
            if (this.LOGGING) {
                this.m.logEvent("Service: " + serviceClass3.getName() + " " + serviceClass3.getAddress() + ":" + serviceClass3.getPort() + " Status: " + serviceClass3.getStatus());
            }
            ++n4;
        }
    }
}

