/*
 * Decompiled with CFR 0.152.
 */
package javazoom.download;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javazoom.download.DownloadSource;
import javazoom.download.util.Config;
import javazoom.download.util.DatabaseConfig;
import javazoom.download.util.Debug;
import javazoom.download.util.FileInfo;

public class DownloadDatabaseSource
extends DownloadSource {
    public static int BUFFERSIZE = 4096;

    public DownloadDatabaseSource(Config config) {
        super(config);
        try {
            Class.forName(((DatabaseConfig)config).getDriver());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._$544(0, "Class not found : ".concat(String.valueOf(String.valueOf(classNotFoundException.getMessage()))));
        }
    }

    public int getDataLength(FileInfo fileInfo) {
        DatabaseConfig databaseConfig = (DatabaseConfig)super.getConfig();
        String string = databaseConfig.getSchema().getProperty("TABLE");
        String string2 = databaseConfig.getSchema().getProperty("FILENAMECOLUMN");
        String string3 = databaseConfig.getSchema().getProperty("DATACOLUMN");
        try {
            Connection connection = DriverManager.getConnection(databaseConfig.getUrl(), databaseConfig.getCredentials());
            String string4 = String.valueOf(String.valueOf(new StringBuffer("SELECT ").append(string3).append(" FROM ").append(string).append(" WHERE ").append(string2).append("='").append(fileInfo.getFilename()).append("'")));
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string4);
            int n = -1;
            while (resultSet.next()) {
                Blob blob = resultSet.getBlob(string3);
                if (blob == null) continue;
                n = (int)blob.length();
            }
            resultSet.close();
            statement.close();
            connection.close();
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            this._$544(0, sQLException.getMessage());
            int n = -1;
            return n;
        }
    }

    public void download(FileInfo fileInfo, OutputStream outputStream) throws IOException {
        Object object;
        int n;
        Object object2;
        DatabaseConfig databaseConfig = (DatabaseConfig)super.getConfig();
        String string = databaseConfig.getSchema().getProperty("TABLE");
        String string2 = databaseConfig.getSchema().getProperty("FILENAMECOLUMN");
        String string3 = databaseConfig.getSchema().getProperty("DATACOLUMN");
        InputStream inputStream = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = DriverManager.getConnection(databaseConfig.getUrl(), databaseConfig.getCredentials());
            object2 = String.valueOf(String.valueOf(new StringBuffer("SELECT ").append(string3).append(" FROM ").append(string).append(" WHERE ").append(string2).append("='").append(fileInfo.getFilename()).append("'")));
            statement = connection.createStatement();
            resultSet = statement.executeQuery((String)object2);
            n = 0;
            while (resultSet.next()) {
                object = resultSet.getBlob(string3);
                inputStream = object.getBinaryStream();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        if (inputStream != null) {
            if (!fileInfo.isZipEnabled()) {
                object2 = new BufferedInputStream(inputStream);
                n = 0;
                object = new byte[BUFFERSIZE];
                while ((n = ((FilterInputStream)object2).read((byte[])object)) != -1) {
                    outputStream.write((byte[])object, 0, n);
                }
                outputStream.flush();
                outputStream.close();
                ((BufferedInputStream)object2).close();
            } else {
                object2 = new BufferedInputStream(inputStream);
                n = 0;
                object = new byte[BUFFERSIZE];
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                ZipEntry zipEntry = new ZipEntry(fileInfo.getFilename());
                zipOutputStream.putNextEntry(zipEntry);
                while ((n = ((FilterInputStream)object2).read((byte[])object)) != -1) {
                    zipOutputStream.write((byte[])object, 0, n);
                }
                zipOutputStream.closeEntry();
                ((FilterOutputStream)zipOutputStream).flush();
                zipOutputStream.close();
                ((BufferedInputStream)object2).close();
            }
        }
        try {
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    private void _$544(int n, String string) {
        Debug.getInstance().trace(n, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getClass().getName()))).append(": ").append(string))));
    }
}

